/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.filters.DescriptorProcessFilter;
import org.eclipse.epf.authoring.ui.filters.ProcessSpecificWorkProductFilter;
import org.eclipse.epf.authoring.ui.filters.ProcessWorkProductFilter;
import org.eclipse.epf.authoring.ui.properties.DescriptorGeneralSection;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.process.command.AssignWPToDeliverable;
import org.eclipse.epf.library.edit.process.command.LinkMethodElementCommand;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class WorkProductDescriptorGeneralSection
extends DescriptorGeneralSection {
    protected WorkProductDescriptor element;
    private Text ctrl_method_element;
    private Text ctrl_workProduct_type;
    private Text activityEntryState;
    private Text activityExitState;
    private Button linkButton;
    private Button clearButton;
    private Table ctrl_table_1;
    private TableViewer viewer_1;
    private Button ctrl_add_1;
    private Button ctrl_add_proc_1;
    private Button ctrl_remove_1;
    private Section deliverableSection;
    private MethodElementEditor.ModifyListener wpModelModifyListener;

    protected void init() {
        super.init();
        this.element = (WorkProductDescriptor)this.getElement();
    }

    public void createControls(Composite composite, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(composite, tabbedPropertySheetPage);
    }

    private void toggleSection() {
        if (!(this.element.getWorkProduct() instanceof Deliverable)) {
            if (this.deliverableSection.isExpanded()) {
                this.deliverableSection.setExpanded(false);
            }
            if (this.deliverableSection.isVisible()) {
                this.deliverableSection.setVisible(false);
            }
        } else {
            if (!this.deliverableSection.isExpanded()) {
                this.deliverableSection.setExpanded(true);
            }
            if (!this.deliverableSection.isVisible()) {
                this.deliverableSection.setVisible(true);
            }
        }
    }

    private void createDeliverableSection(Composite composite) {
        String string = PropertiesResources.WPDescriptor_DeliverablePart_SectionTitle;
        String string2 = PropertiesResources.WPDescriptor_DeliverablePart_SectionDescription;
        String string3 = PropertiesResources.WPDescriptor_DeliverablePart_Table1;
        Section section = FormUI.createSection(this.toolkit, composite, string, string2);
        Composite composite2 = FormUI.createComposite(this.toolkit, section, 2, false);
        Composite composite3 = FormUI.createComposite(this.toolkit, composite2, 1808);
        FormUI.createLabel(this.toolkit, composite3, string3);
        int n = 80;
        this.ctrl_table_1 = FormUI.createTable(this.toolkit, composite3, n);
        this.viewer_1 = new TableViewer(this.ctrl_table_1);
        AdapterFactoryContentProvider adapterFactoryContentProvider = new AdapterFactoryContentProvider(this.getAdapterFactory()){

            public Object[] getElements(Object object) {
                ArrayList<WorkProductDescriptor> arrayList = new ArrayList<WorkProductDescriptor>();
                List list = WorkProductDescriptorGeneralSection.this.element.getDeliverableParts();
                for (WorkProductDescriptor workProductDescriptor : list) {
                    if (workProductDescriptor.getSuperActivities() != null && workProductDescriptor.getSuperActivities() != null) continue;
                    arrayList.add(workProductDescriptor);
                }
                return WorkProductDescriptorGeneralSection.this.getFilteredList(arrayList).toArray();
            }
        };
        AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory());
        this.viewer_1.setContentProvider((IContentProvider)adapterFactoryContentProvider);
        this.viewer_1.setLabelProvider((IBaseLabelProvider)adapterFactoryLabelProvider);
        this.viewer_1.setInput((Object)this.element);
        Composite composite4 = FormUI.createComposite(this.toolkit, composite2, 68);
        this.ctrl_add_1 = FormUI.createButton(this.toolkit, composite4, PropertiesResources.Process_Add);
        this.ctrl_add_proc_1 = FormUI.createButton(this.toolkit, composite4, PropertiesResources.Process_AddFromProcess);
        this.ctrl_remove_1 = FormUI.createButton(this.toolkit, composite4, PropertiesResources.Process_Remove);
        this.toolkit.paintBordersFor(composite3);
        this.deliverableSection = section;
    }

    public void dispose() {
        super.dispose();
    }

    protected void createGeneralSection(Composite composite) {
        super.createGeneralSection(composite);
        FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.Process_Type_WorkProduct);
        this.ctrl_method_element = FormUI.createText(this.toolkit, this.generalComposite, -1, 1);
        this.ctrl_method_element.setText(this.getMethodElementName(this.element));
        this.ctrl_method_element.setEnabled(false);
        Composite composite2 = FormUI.createComposite(this.toolkit, this.generalComposite, 0, 2, true);
        this.linkButton = FormUI.createButton(this.toolkit, composite2, 8, 1);
        this.linkButton.setText(PropertiesResources.Process_Button_LinkMethodElement);
        this.clearButton = FormUI.createButton(this.toolkit, composite2, 8, 1);
        this.clearButton.setText(PropertiesResources.Process_Button_ClearMethodElement);
        FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.WorkProduct_Type);
        this.ctrl_workProduct_type = FormUI.createText(this.toolkit, this.generalComposite, -1, this.horizontalSpan);
        this.ctrl_workProduct_type.setText(this.getMethodElementType(this.element));
        this.ctrl_workProduct_type.setEnabled(false);
        FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.WorkProductDescriptor_ActivityEntryState);
        this.activityEntryState = FormUI.createText(this.toolkit, this.generalComposite, -1, this.horizontalSpan);
        FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.WorkProductDescriptor_ActivityExitState);
        this.activityExitState = FormUI.createText(this.toolkit, this.generalComposite, -1, this.horizontalSpan);
        this.createDeliverableSection(composite);
        this.toggleSection();
    }

    private String getMethodElementName(WorkProductDescriptor workProductDescriptor) {
        String string = PropertiesResources.Process_None;
        if (workProductDescriptor.getWorkProduct() != null) {
            string = workProductDescriptor.getWorkProduct().getName();
        }
        return string;
    }

    private String getMethodElementType(WorkProductDescriptor workProductDescriptor) {
        String string = PropertiesResources.Process_None;
        if (workProductDescriptor.getWorkProduct() != null) {
            string = workProductDescriptor.getWorkProduct().getType().getName();
        }
        return string;
    }

    protected void addListeners() {
        super.addListeners();
        this.activityEntryState.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                WorkProductDescriptorGeneralSection.this.getEditor().setCurrentFeatureEditor(focusEvent.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_ActivityEntryState());
            }

            public void focusLost(FocusEvent focusEvent) {
                boolean bl;
                WorkProductDescriptor workProductDescriptor = (WorkProductDescriptor)WorkProductDescriptorGeneralSection.this.getElement();
                String string = workProductDescriptor.getActivityEntryState();
                if (WorkProductDescriptorGeneralSection.this.getEditor().mustRestoreValue(WorkProductDescriptorGeneralSection.this.activityEntryState, string)) {
                    return;
                }
                String string2 = StrUtil.getPlainText((String)WorkProductDescriptorGeneralSection.this.activityEntryState.getText());
                if (!string2.equals(string) && (bl = WorkProductDescriptorGeneralSection.this.actionMgr.doAction(1, (EObject)workProductDescriptor, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_ActivityEntryState(), (Object)string2, -1))) {
                    WorkProductDescriptorGeneralSection.this.activityEntryState.setText(string2);
                }
            }
        });
        this.activityExitState.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                WorkProductDescriptorGeneralSection.this.getEditor().setCurrentFeatureEditor(focusEvent.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_ActivityExitState());
            }

            public void focusLost(FocusEvent focusEvent) {
                boolean bl;
                WorkProductDescriptor workProductDescriptor = (WorkProductDescriptor)WorkProductDescriptorGeneralSection.this.getElement();
                String string = workProductDescriptor.getActivityExitState();
                if (WorkProductDescriptorGeneralSection.this.getEditor().mustRestoreValue(WorkProductDescriptorGeneralSection.this.activityExitState, string)) {
                    return;
                }
                String string2 = StrUtil.getPlainText((String)WorkProductDescriptorGeneralSection.this.activityExitState.getText());
                if (!string2.equals(string) && (bl = WorkProductDescriptorGeneralSection.this.actionMgr.doAction(1, (EObject)workProductDescriptor, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_ActivityExitState(), (Object)string2, -1))) {
                    WorkProductDescriptorGeneralSection.this.activityExitState.setText(string2);
                }
            }
        });
        this.ctrl_table_1.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)WorkProductDescriptorGeneralSection.this.viewer_1.getSelection();
                if (iStructuredSelection.size() > 0) {
                    WorkProductDescriptorGeneralSection.this.ctrl_remove_1.setEnabled(true);
                }
            }
        });
        this.ctrl_add_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProcessWorkProductFilter processWorkProductFilter = new ProcessWorkProductFilter(WorkProductDescriptorGeneralSection.this.getConfiguration(), null, FilterConstants.WORKPRODUCTS);
                ArrayList<MethodElement> arrayList = new ArrayList<MethodElement>();
                arrayList.addAll(ProcessUtil.getAssociatedElementList((List)WorkProductDescriptorGeneralSection.this.element.getDeliverableParts()));
                arrayList.add(ProcessUtil.getAssociatedElement((Descriptor)WorkProductDescriptorGeneralSection.this.element));
                arrayList.addAll((Collection)WorkProductDescriptorGeneralSection.this.getParentWorkProducts((BreakdownElement)WorkProductDescriptorGeneralSection.this.element));
                ItemsFilterDialog itemsFilterDialog = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IFilter)processWorkProductFilter, WorkProductDescriptorGeneralSection.this.element, FilterConstants.WORKPRODUCTS, arrayList);
                itemsFilterDialog.setBlockOnOpen(true);
                itemsFilterDialog.setTitle(FilterConstants.WORKPRODUCTS);
                itemsFilterDialog.open();
                WorkProductDescriptorGeneralSection.this.addItems(itemsFilterDialog.getSelectedItems());
                WorkProductDescriptorGeneralSection.this.viewer_1.refresh();
            }
        });
        this.ctrl_add_proc_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = FilterConstants.WORK_PRODUCT_DESCRIPTORS;
                ArrayList<WorkProductDescriptor> arrayList = new ArrayList<WorkProductDescriptor>();
                arrayList.addAll(WorkProductDescriptorGeneralSection.this.element.getDeliverableParts());
                arrayList.add(WorkProductDescriptorGeneralSection.this.element);
                arrayList.addAll(WorkProductDescriptorGeneralSection.this.getParentDeliverables((BreakdownElement)WorkProductDescriptorGeneralSection.this.element));
                Process process = TngUtil.getOwningProcess((BreakdownElement)WorkProductDescriptorGeneralSection.this.element);
                IFilter iFilter = WorkProductDescriptorGeneralSection.this.getDescriptorFilter();
                if (iFilter != null && process != null) {
                    ItemsFilterDialog itemsFilterDialog = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), iFilter, process, string, arrayList);
                    itemsFilterDialog.setBlockOnOpen(true);
                    itemsFilterDialog.setTitle(string);
                    itemsFilterDialog.open();
                    WorkProductDescriptorGeneralSection.this.addFromProcessItems(itemsFilterDialog.getSelectedItems());
                    WorkProductDescriptorGeneralSection.this.viewer_1.refresh();
                }
            }
        });
        this.ctrl_remove_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)WorkProductDescriptorGeneralSection.this.viewer_1.getSelection();
                if (iStructuredSelection.size() > 0) {
                    ArrayList arrayList = new ArrayList();
                    arrayList.addAll(iStructuredSelection.toList());
                    WorkProductDescriptorGeneralSection.this.removeItems(arrayList);
                    WorkProductDescriptorGeneralSection.this.viewer_1.refresh();
                    WorkProductDescriptorGeneralSection.this.viewer_1.setSelection(null, true);
                }
            }
        });
        this.linkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object;
                Object object2;
                Object object3;
                String string = FilterConstants.WORKPRODUCTS;
                Class<?> clazz = null;
                if (WorkProductDescriptorGeneralSection.this.element.getWorkProduct() != null) {
                    clazz = WorkProductDescriptorGeneralSection.this.element.getWorkProduct().getClass();
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if (WorkProductDescriptorGeneralSection.this.element.getWorkProduct() != null) {
                    object3 = WorkProductDescriptorGeneralSection.this.element.getWorkProduct();
                    arrayList.add(object3);
                    if (object3 instanceof Artifact) {
                        object2 = new ArrayList();
                        WorkProductDescriptorGeneralSection.this.getAllSubArtifacts((Artifact)object3, (List)object2, ((Artifact)object3).getContainedArtifacts());
                        arrayList.addAll((Collection<Object>)object2);
                    }
                }
                object3 = ProcessUtil.getSiblings((AdapterFactory)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory(), (ItemProviderAdapter)WorkProductDescriptorGeneralSection.this.getAdapter(), (Object)WorkProductDescriptorGeneralSection.this.element);
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    WorkProduct workProduct;
                    WorkProductDescriptor workProductDescriptor;
                    object = object2.next();
                    if (!(object instanceof WorkProductDescriptor) || (workProductDescriptor = (WorkProductDescriptor)object).equals(WorkProductDescriptorGeneralSection.this.element) || workProductDescriptor.getSuppressed().booleanValue() || (workProduct = workProductDescriptor.getWorkProduct()) == null) continue;
                    arrayList.add(workProduct);
                    if (!(workProduct instanceof Artifact)) continue;
                    ArrayList arrayList2 = new ArrayList();
                    WorkProductDescriptorGeneralSection.this.getAllSubArtifacts((Artifact)workProduct, arrayList2, ((Artifact)workProduct).getContainedArtifacts());
                    arrayList.addAll(arrayList2);
                }
                object2 = new ProcessSpecificWorkProductFilter(WorkProductDescriptorGeneralSection.this.getConfiguration(), null, string, clazz);
                object = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IFilter)object2, WorkProductDescriptorGeneralSection.this.element, string, arrayList);
                object.setBlockOnOpen(true);
                ((ItemsFilterDialog)((Object)object)).setViewerSelectionSingle(true);
                ((ItemsFilterDialog)((Object)object)).setTitle(string);
                object.open();
                WorkProductDescriptorGeneralSection.this.setMethodElement(((ItemsFilterDialog)((Object)object)).getSelectedItems());
                WorkProductDescriptorGeneralSection.this.ctrl_method_element.setText(WorkProductDescriptorGeneralSection.this.getMethodElementName(WorkProductDescriptorGeneralSection.this.element));
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkProductDescriptorGeneralSection.this.actionMgr.doAction(1, (EObject)WorkProductDescriptorGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_WorkProduct(), null, -1);
                WorkProductDescriptorGeneralSection.this.ctrl_method_element.setText(WorkProductDescriptorGeneralSection.this.getMethodElementName(WorkProductDescriptorGeneralSection.this.element));
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
    }

    private void getAllSubArtifacts(Artifact artifact, List list, List list2) {
        for (Object e : list2) {
            if (!(e instanceof Artifact)) continue;
            if (!list.contains(e)) {
                list.add(e);
            }
            this.getAllSubArtifacts((Artifact)e, list, ((Artifact)e).getContainedArtifacts());
        }
    }

    protected void updateControls() {
        super.updateControls();
        this.activityEntryState.setEditable(this.editable);
        this.activityExitState.setEditable(this.editable);
        this.linkButton.setEnabled(this.editable);
        this.clearButton.setEnabled(this.editable);
        this.activityEntryState.setEnabled(this.editable);
        this.activityExitState.setEnabled(this.editable);
        if (this.ctrl_add_1 != null) {
            this.ctrl_add_1.setEnabled(this.editable);
        }
        if (this.ctrl_add_proc_1 != null) {
            this.ctrl_add_proc_1.setEnabled(this.editable);
        }
        if (this.ctrl_remove_1 != null) {
            this.ctrl_remove_1.setEnabled(this.editable);
        }
    }

    public void refresh() {
        try {
            if (this.getElement() instanceof WorkProductDescriptor) {
                this.element = (WorkProductDescriptor)this.getElement();
                super.refresh();
                if (this.wpModelModifyListener != null) {
                    this.activityEntryState.removeModifyListener((ModifyListener)this.wpModelModifyListener);
                    this.activityExitState.removeModifyListener((ModifyListener)this.wpModelModifyListener);
                }
                this.wpModelModifyListener = this.getEditor().createModifyListener((EObject)this.element);
                if (this.wpModelModifyListener instanceof MethodElementEditor.ModifyListener) {
                    this.wpModelModifyListener.setElement((EObject)this.element);
                    this.wpModelModifyListener.setDisable(true);
                }
                this.ctrl_method_element.setText(this.getMethodElementName(this.element));
                this.ctrl_workProduct_type.setText(this.getMethodElementType(this.element));
                this.activityEntryState.setText(this.element.getActivityEntryState());
                this.activityExitState.setText(this.element.getActivityExitState());
                if (this.wpModelModifyListener instanceof MethodElementEditor.ModifyListener) {
                    this.wpModelModifyListener.setDisable(false);
                }
                this.activityEntryState.addModifyListener((ModifyListener)this.wpModelModifyListener);
                this.activityExitState.addModifyListener((ModifyListener)this.wpModelModifyListener);
                if (this.viewer_1 != null) {
                    this.viewer_1.refresh();
                }
                this.toggleSection();
            }
        }
        catch (Exception exception) {
            this.logger.logError("Error refreshing WorkProductDescriptor general section : " + this.element, (Throwable)exception);
        }
    }

    private void addItems(List list) {
        if (list != null) {
            ArrayList<WorkProduct> arrayList = new ArrayList<WorkProduct>();
            for (Object e : list) {
                if (!(e instanceof WorkProduct) || this.isPartOfDeliverable((WorkProduct)e, this.element)) continue;
                arrayList.add((WorkProduct)e);
            }
            if (!arrayList.isEmpty()) {
                AssignWPToDeliverable assignWPToDeliverable = new AssignWPToDeliverable(this.element, arrayList);
                this.actionMgr.execute((IResourceAwareCommand)assignWPToDeliverable);
            }
        }
        this.viewer_1.refresh();
    }

    protected IFilter getDescriptorFilter() {
        return new DescriptorProcessFilter(this.getConfiguration()){

            protected boolean childAccept(Object object) {
                if (object instanceof Activity) {
                    ArrayList arrayList = new ArrayList();
                    this.getActivitiesInScope((AdapterFactory)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory(), (BreakdownElement)WorkProductDescriptorGeneralSection.this.element, arrayList);
                    return arrayList.contains(object);
                }
                return object instanceof WorkProductDescriptor;
            }
        };
    }

    private void addFromProcessItems(List list) {
        if (list != null) {
            for (Object e : list) {
                MessageFormat messageFormat;
                if (!(e instanceof WorkProductDescriptor)) continue;
                WorkProduct workProduct = ((WorkProductDescriptor)e).getWorkProduct();
                if (workProduct != null) {
                    if (!this.isPartOfDeliverable(workProduct, this.element)) {
                        messageFormat = ProcessUtil.createWorkProductDescriptor((WorkProduct)workProduct);
                        this.actionMgr.doAction(3, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_DeliverableParts(), (Object)messageFormat, -1);
                    }
                    this.actionMgr.doAction(3, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_DeliverableParts(), e, -1);
                    continue;
                }
                messageFormat = new MessageFormat(PropertiesResources.Process_DeliverableAssignError);
                Object[] objectArray = new Object[]{((WorkProductDescriptor)e).getName(), this.element.getName()};
                AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(PropertiesResources.Process_AssignmentInfoTitle, messageFormat.format(objectArray));
            }
        }
    }

    private void removeItems(List list) {
        if (!list.isEmpty()) {
            for (Object e : list) {
                if (e instanceof WorkProductDescriptor) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_DeliverableParts(), (Object)((WorkProductDescriptor)e), -1);
                }
                Object object = this.findDeliverableParts(e);
                this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_DeliverableParts(), object, -1);
            }
        }
    }

    private Object findDeliverableParts(Object object) {
        List list = this.element.getDeliverableParts();
        for (Object e : list) {
            WorkProduct workProduct;
            WorkProduct workProduct2;
            if (!(object instanceof WorkProductDescriptor) || !(e instanceof WorkProductDescriptor) || !(workProduct2 = ((WorkProductDescriptor)object).getWorkProduct()).equals(workProduct = ((WorkProductDescriptor)e).getWorkProduct())) continue;
            return e;
        }
        return null;
    }

    protected Object getProcess(BreakdownElement breakdownElement) {
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
        ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)composedAdapterFactory.adapt((Notifier)breakdownElement, ITreeItemContentProvider.class);
        Object object = itemProviderAdapter.getParent((Object)breakdownElement);
        while (!(object instanceof Process)) {
            breakdownElement = (BreakdownElement)object;
            itemProviderAdapter = (ItemProviderAdapter)composedAdapterFactory.adapt((Notifier)breakdownElement, ITreeItemContentProvider.class);
            object = itemProviderAdapter.getParent((Object)breakdownElement);
        }
        return object;
    }

    private List getParentDeliverables(BreakdownElement breakdownElement) {
        ArrayList<WorkProductDescriptor> arrayList = new ArrayList<WorkProductDescriptor>();
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
        ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)composedAdapterFactory.adapt((Notifier)breakdownElement, ITreeItemContentProvider.class);
        Object object = itemProviderAdapter.getParent((Object)breakdownElement);
        while (!(object instanceof Activity)) {
            WorkProductDescriptor workProductDescriptor;
            breakdownElement = (BreakdownElement)object;
            if (object instanceof WorkProductDescriptor && (workProductDescriptor = (WorkProductDescriptor)object).getWorkProduct() instanceof Deliverable) {
                arrayList.add(workProductDescriptor);
            }
            itemProviderAdapter = (ItemProviderAdapter)composedAdapterFactory.adapt((Notifier)breakdownElement, ITreeItemContentProvider.class);
            object = itemProviderAdapter.getParent((Object)breakdownElement);
        }
        return arrayList;
    }

    private Object getParentWorkProducts(BreakdownElement breakdownElement) {
        List list;
        HashSet<WorkProduct> hashSet = new HashSet<WorkProduct>();
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
        ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)composedAdapterFactory.adapt((Notifier)breakdownElement, ITreeItemContentProvider.class);
        Object object = itemProviderAdapter.getParent((Object)breakdownElement);
        while (!(object instanceof Activity)) {
            breakdownElement = (BreakdownElement)object;
            if (object instanceof WorkProductDescriptor && (list = (WorkProductDescriptor)object).getWorkProduct() instanceof Deliverable) {
                hashSet.add(list.getWorkProduct());
            }
            itemProviderAdapter = (ItemProviderAdapter)composedAdapterFactory.adapt((Notifier)breakdownElement, ITreeItemContentProvider.class);
            object = itemProviderAdapter.getParent((Object)breakdownElement);
        }
        if (object instanceof Activity) {
            list = ((Activity)object).getBreakdownElements();
            for (Object e : list) {
                WorkProduct workProduct;
                if (!(e instanceof WorkProductDescriptor) || (workProduct = ((WorkProductDescriptor)e).getWorkProduct()) == null) continue;
                hashSet.add(workProduct);
            }
        }
        return hashSet;
    }

    public String getNamePrefix() {
        return String.valueOf(LibraryUIText.TEXT_WORK_PRODUCT_DESCRIPTOR) + ": ";
    }

    private void setMethodElement(List list) {
        if (list != null && list.size() >= 1 && list.get(0) instanceof WorkProduct) {
            WorkProduct workProduct = (WorkProduct)list.get(0);
            boolean bl = true;
            if (bl) {
                LinkMethodElementCommand linkMethodElementCommand = new LinkMethodElementCommand((Descriptor)this.element, (Object)workProduct, 22);
                this.actionMgr.execute((IResourceAwareCommand)linkMethodElementCommand);
                this.getEditor().setSelection(this.getSelection());
            } else {
                MessageFormat messageFormat = new MessageFormat(PropertiesResources.Process_InvalidLinkMethodElement);
                Object[] objectArray = new Object[]{workProduct.getName()};
                AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(PropertiesResources.Process_LinkMethodElementTitle, messageFormat.format(objectArray));
            }
        }
    }

    private boolean isPartOfDeliverable(WorkProduct workProduct, WorkProductDescriptor workProductDescriptor) {
        List list = ProcessUtil.getAssociatedElementList((List)workProductDescriptor.getDeliverableParts());
        return list.contains(workProduct);
    }
}

