/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.providers;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.epf.authoring.gef.figures.Colors;
import org.eclipse.epf.authoring.ui.providers.VariabilityElementLabelProvider;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.FeatureValueWrapperItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class ConfigurationLabelProvider
extends VariabilityElementLabelProvider
implements IColorProvider {
    MethodConfiguration config = null;

    public ConfigurationLabelProvider(MethodConfiguration methodConfiguration, AdapterFactory adapterFactory) {
        super(adapterFactory);
        this.config = methodConfiguration;
    }

    public Image getImage(Object object) {
        return super.getImage(object);
    }

    public String getText(Object object) {
        String string = null;
        Object object2 = null;
        if (object instanceof MethodElement) {
            object2 = ConfigurationHelper.getCalculatedElement((MethodElement)((MethodElement)object), (MethodConfiguration)this.config);
        } else if (object instanceof FeatureValueWrapperItemProvider) {
            object2 = ((FeatureValueWrapperItemProvider)object).getValue();
        }
        if (object instanceof IWrapperItemProvider) {
            object2 = TngUtil.unwrap((Object)object);
        }
        if (object2 != null) {
            string = object2 instanceof BreakdownElement ? ProcessUtil.getPresentationName((BreakdownElement)((BreakdownElement)object2)) : TngUtil.getPresentationName((Object)object2);
        }
        if (string == null) {
            string = super.getText(object);
        }
        return string;
    }

    public String getColumnText(Object object, int n) {
        return this.getText(object);
    }

    public Image getColumnImage(Object object, int n) {
        return this.getImage(object);
    }

    public void dispose() {
        this.config = null;
        super.dispose();
    }

    public Color getForeground(Object object) {
        if (this.isSuppressed(object)) {
            return Colors.SUPRESSED_ELEMENT_LABEL;
        }
        if (this.isExternal(object)) {
            return Colors.INHERITED_ELEMENT_LABEL;
        }
        return null;
    }

    private boolean isSuppressed(Object object) {
        Object object2;
        if (object instanceof BreakdownElement) {
            Process process = TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)object));
            if (process != null) {
                return Suppression.getSuppression((Process)process).isSuppressed(object);
            }
        } else if (object instanceof BreakdownElementWrapperItemProvider && (object2 = ((BreakdownElementWrapperItemProvider)object).getTopItem()) instanceof Process) {
            return Suppression.getSuppression((Process)((Process)object2)).isSuppressed(object);
        }
        return false;
    }

    public Color getBackground(Object object) {
        return null;
    }

    public boolean isExternal(Object object) {
        return ProcessUtil.isInherited((Object)object) || ProcessUtil.isContributed((Object)object);
    }

    public Font getFont(Object object) {
        if (ProcessUtil.isInherited((Object)object)) {
            return italicFont;
        }
        if (ProcessUtil.isContributed((Object)object)) {
            return boldItalicFont;
        }
        return regularFont;
    }
}

