/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.views.GrayingCheckboxTreeViewerWrapper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryTreeViewerWrapper
extends GrayingCheckboxTreeViewerWrapper {
    protected List<Object> fUserCheckedStateStore = new ArrayList<Object>();
    protected Text textWidget;
    protected MethodConfiguration config;

    public CategoryTreeViewerWrapper(Composite composite, int n, Object object, AdapterFactoryContentProvider adapterFactoryContentProvider, AdapterFactoryLabelProvider adapterFactoryLabelProvider, MethodConfiguration methodConfiguration) {
        super(composite, n, object, adapterFactoryContentProvider, adapterFactoryLabelProvider);
        this.config = methodConfiguration;
    }

    @Override
    protected boolean determineShouldBeWhiteChecked(Object object) {
        return this.fUserCheckedStateStore.contains(object);
    }

    @Override
    protected boolean determineShouldBeAtLeastGrayChecked(Object object) {
        Object[] objectArray = this.getTreeChildren(object);
        int n = 0;
        while (n < objectArray.length) {
            if (this.fCheckedStateStore.contains(objectArray[n]) || this.fUserCheckedStateStore.contains(objectArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    protected void setTreeChecked(Object object, boolean bl) {
        if (bl) {
            this.fUserCheckedStateStore.add(object);
        } else {
            this.fUserCheckedStateStore.remove(object);
        }
        super.setTreeChecked(object, bl);
    }

    private Set<TreeItem> getAllTreeItems(TreeItem treeItem) {
        HashSet<TreeItem> hashSet = new HashSet<TreeItem>();
        if (treeItem != null) {
            hashSet.add(treeItem);
            TreeItem[] treeItemArray = treeItem.getItems();
            int n = 0;
            while (n < treeItemArray.length) {
                hashSet.addAll(this.getAllTreeItems(treeItemArray[n]));
                ++n;
            }
        } else {
            TreeItem[] treeItemArray = this.fTreeViewer.getTree().getItems();
            int n = 0;
            while (n < treeItemArray.length) {
                hashSet.addAll(this.getAllTreeItems(treeItemArray[n]));
                ++n;
            }
        }
        return hashSet;
    }

    @Override
    protected void handleUpdateSelection(List list) {
        Set<TreeItem> set = this.getAllTreeItems(null);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (TreeItem object : set) {
            Object object2;
            Object object3 = object.getData();
            if (!list.contains(TngUtil.unwrap((Object)object3))) continue;
            arrayList.add(object3);
            if (!this.fUserCheckedStateStore.contains(object3)) {
                this.fUserCheckedStateStore.add(object3);
            }
            if (!this.fCheckedStateStore.contains(object3)) {
                this.fCheckedStateStore.add(object3);
            }
            if ((object2 = this.fTreeContentProvider.getParent(object3)) == null) continue;
            this.addToHierarchyToCheckedStore(object2);
        }
        for (Object e : arrayList) {
            this.updateHierarchy(e);
        }
    }

    public Set<ContentCategory> getCheckedContentCategories() {
        HashSet<ContentCategory> hashSet = new HashSet<ContentCategory>();
        Set<Object> set = this.getWhiteCheckedTreeItems();
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object = TngUtil.unwrap((Object)iterator.next());
            if (!(object instanceof ContentCategory) || !this.config.getMethodPluginSelection().contains(LibraryUtil.getMethodPlugin((EObject)((ContentCategory)object)))) continue;
            hashSet.add((ContentCategory)object);
        }
        return hashSet;
    }

    @Override
    public void selectionChanged(final SelectionChangedEvent selectionChangedEvent) {
        BusyIndicator.showWhile((Display)this.getTree().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                Object object = iStructuredSelection.getFirstElement();
                if ((object = TngUtil.unwrap((Object)object)) == null) {
                    return;
                }
                if (CategoryTreeViewerWrapper.this.textWidget != null && object instanceof MethodElement) {
                    String string = ((MethodElement)object).getBriefDescription();
                    CategoryTreeViewerWrapper.this.textWidget.setText(string != null ? string : "");
                }
            }
        });
    }

    public void setTextWidget(Text text) {
        this.textWidget = text;
    }

    @Override
    protected void treeItemChecked(Object object, boolean bl) {
        Collection<Object> collection;
        if (!bl && (collection = this.fTreeContentProvider.getParent(object)) != null) {
            this.fUserCheckedStateStore.remove(collection);
        }
        super.treeItemChecked(object, bl);
        collection = this.getAllTreeItems(object);
        Iterator<Object> iterator = collection.iterator();
        while (iterator.hasNext()) {
            super.treeItemChecked(iterator.next(), bl);
        }
    }

    private Collection<Object> getAllTreeItems(Object object) {
        if (object == null) {
            return Collections.emptyList();
        }
        Set<TreeItem> set = this.getAllTreeItems(null);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (TreeItem treeItem : set) {
            Object object2 = treeItem.getData();
            if (object2 == object || !TngUtil.unwrap((Object)object).equals(TngUtil.unwrap((Object)object2))) continue;
            arrayList.add(object2);
        }
        return arrayList;
    }
}

