/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.UIActionDispatcher;
import org.eclipse.epf.authoring.ui.actions.CreateMethodElementCommand;
import org.eclipse.epf.authoring.ui.actions.ILibraryActionBarContributor;
import org.eclipse.epf.authoring.ui.actions.LayoutActionGroup;
import org.eclipse.epf.authoring.ui.actions.LibraryActionBarContributor;
import org.eclipse.epf.authoring.ui.actions.LibraryViewCopyAction;
import org.eclipse.epf.authoring.ui.actions.LibraryViewCutAction;
import org.eclipse.epf.authoring.ui.actions.LibraryViewDeleteAction;
import org.eclipse.epf.authoring.ui.actions.LibraryViewPasteAction;
import org.eclipse.epf.authoring.ui.actions.NewPluginAction;
import org.eclipse.epf.authoring.ui.actions.RenameAction;
import org.eclipse.epf.authoring.ui.dialogs.MoveDialog;
import org.eclipse.epf.authoring.ui.dialogs.SwitchConfigDialog;
import org.eclipse.epf.authoring.ui.dialogs.VariabilitySelection;
import org.eclipse.epf.authoring.ui.dnd.LibraryViewerDragAdapter;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.editors.IEditorKeeper;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.authoring.ui.preferences.ApplicationPreferenceConstants;
import org.eclipse.epf.authoring.ui.preferences.AuthoringUIPreferences;
import org.eclipse.epf.authoring.ui.providers.MethodElementLabelDecorator;
import org.eclipse.epf.authoring.ui.util.RefreshHandler;
import org.eclipse.epf.authoring.ui.util.UIHelper;
import org.eclipse.epf.authoring.ui.views.AbstractBaseView;
import org.eclipse.epf.authoring.ui.views.ConfigurationView;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceException;
import org.eclipse.epf.library.edit.FeatureValueWrapperItemProvider;
import org.eclipse.epf.library.edit.PluginUIPackageContext;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.navigator.MethodLibraryItemProvider;
import org.eclipse.epf.library.edit.navigator.PluginUIPackagesItemProvider;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.persistence.ILibraryResource;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.persistence.PersistenceService;
import org.eclipse.epf.library.project.MethodLibraryProject;
import org.eclipse.epf.library.project.MethodLibraryProjectNature;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.library.ui.actions.LibraryLockingOperationRunner;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.util.ImportExportUtil;
import org.eclipse.epf.library.xmi.XMILibraryManager;
import org.eclipse.epf.library.xmi.XMILibraryUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.refresh.IRefreshEvent;
import org.eclipse.epf.persistence.refresh.IRefreshHandler;
import org.eclipse.epf.persistence.refresh.IRefreshListener;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.LibrarySchedulingRule;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.DisciplineGrouping;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.RoleSetGrouping;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.edit.domain.TraceableAdapterFactoryEditingDomain;
import org.eclipse.epf.uma.provider.MethodPluginItemProvider;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.MessageException;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.views.markers.internal.MarkerAdapter;
import org.eclipse.ui.views.navigator.ResourceNavigator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryView
extends AbstractBaseView
implements IRefreshHandler,
IShowInTarget {
    public static final String VIEW_ID = LibraryView.class.getName();
    private static boolean DEBUG = AuthoringUIPlugin.getDefault().isDebugging();
    protected TreeViewer treeViewer;
    protected IDoubleClickListener doubleClickListener = null;
    private ISelection selection;
    private LayoutActionGroup fLayoutActionSet;
    private String PERFORM_ID = "org.eclipse.epf.authoring.view.LibraryView.performValidatorAction";
    private IAction performLibraryValidationAction = new Action(AuthoringUIResources.Validate_method_library, AuthoringUIPlugin.getDefault().getImageDescriptor("full/etool16/validate_method_lib.gif")){

        public void run() {
            try {
                ViewHelper.checkLibraryHealth();
            }
            catch (Exception exception) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
            }
        }
    };
    private IPartListener editorPartListener = new IPartListener(){

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        }

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart instanceof IEditorPart) {
                SwitchConfigDialog.run(Display.getCurrent().getActiveShell(), (IEditorPart)iWorkbenchPart);
            }
        }
    };
    private long lastRefreshTimeStamp;
    private IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            if (iResourceChangeEvent.getType() == 2 || iResourceChangeEvent.getType() == 4) {
                IProject iProject = (IProject)iResourceChangeEvent.getResource();
                try {
                    if (iProject.exists() && iProject.isOpen() && iProject.hasNature(MethodLibraryProjectNature.NATURE_ID)) {
                        EditorChooser.getInstance().closeAllMethodEditors();
                        IProject iProject2 = MethodLibraryProject.findProject((String)LibraryService.getInstance().getCurrentMethodLibraryLocation());
                        if (iProject == iProject2) {
                            LibraryService.getInstance().closeCurrentMethodLibrary();
                        }
                    }
                }
                catch (CoreException coreException) {
                    LibraryPlugin.getDefault().getLogger().logError((Throwable)coreException);
                }
                catch (LibraryServiceException libraryServiceException) {
                    LibraryPlugin.getDefault().getLogger().logError((Throwable)libraryServiceException);
                }
                return;
            }
            IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
            if (iResourceDelta == null) {
                return;
            }
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    ResourceDeltaVisitor() {
                    }

                    public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
                        if ((iResourceDelta.getFlags() & 0x20000) == 131072) {
                            switch (iResourceDelta.getKind()) {
                                case 1: 
                                case 4: {
                                    UIHelper.showProblemsView();
                                    return false;
                                }
                            }
                        } else if (iResourceDelta.getResource().getType() == 4 && iResourceDelta.getKind() == 4) {
                            IProject iProject;
                            if ((iResourceDelta.getFlags() & 0x40000) == 0 && (iResourceDelta.getFlags() & 0x80000) != 0) {
                                XMILibraryManager xMILibraryManager;
                                IProject iProject2 = (IProject)iResourceDelta.getResource();
                                ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
                                if (iLibraryManager instanceof XMILibraryManager && iProject2.equals((Object)(xMILibraryManager = (XMILibraryManager)iLibraryManager).getMethodLibraryProject())) {
                                    System.out.println();
                                    xMILibraryManager.handleLibraryMoved();
                                    return false;
                                }
                            } else if ((iResourceDelta.getFlags() & 0x4000) != 0 && (iProject = (IProject)iResourceDelta.getResource()).isOpen() && iProject.hasNature(MethodLibraryProjectNature.NATURE_ID) && LibraryService.getInstance().getCurrentMethodLibrary() == null) {
                                java.net.URI uRI = iProject.getLocationURI();
                                try {
                                    LibraryService.getInstance().openMethodLibrary("xmi", uRI);
                                }
                                catch (Exception exception) {
                                    LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
                                }
                                return false;
                            }
                        }
                        return true;
                    }
                }
                ResourceDeltaVisitor resourceDeltaVisitor = new ResourceDeltaVisitor();
                iResourceDelta.accept((IResourceDeltaVisitor)resourceDeltaVisitor);
            }
            catch (CoreException coreException) {
                CommonPlugin.INSTANCE.log((Object)coreException);
            }
        }
    };
    private IRefreshListener refreshListener = new IRefreshListener(){

        public void notifyRefreshed(IRefreshEvent iRefreshEvent) {
            if (iRefreshEvent.getRefreshedObjects() != null && !iRefreshEvent.getRefreshedObjects().isEmpty()) {
                Control control = LibraryView.this.getViewer().getControl();
                if (control == null || control.isDisposed()) {
                    return;
                }
                if (control.getDisplay().getThread() == Thread.currentThread()) {
                    LibraryView.this.doRefresh(LibraryView.this.getSite().getShell());
                } else {
                    control.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            LibraryView.this.doRefresh(null);
                        }
                    });
                }
            }
        }
    };

    public LibraryView() {
        if ("flat".equals(ApplicationPreferenceConstants.getLayout())) {
            PluginUIPackageContext.INSTANCE.setLayoutFlat();
        } else if ("hierarchical".equals(ApplicationPreferenceConstants.getLayout())) {
            PluginUIPackageContext.INSTANCE.setLayoutHierarchical();
        }
    }

    @Override
    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        this.makeActions();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, AuthoringUIHelpContexts.LIBRARY_NAVIGATOR_VIEW_CONTEXT);
        RefreshJob.getInstance().setRefreshHandler((IRefreshHandler)this);
    }

    private void makeActions() {
        this.fLayoutActionSet = new LayoutActionGroup(this);
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fLayoutActionSet.fillActionBars(iActionBars);
    }

    @Override
    public void setFocus() {
        this.actionBarContributor.setActiveView((IViewPart)this);
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getSelection();
        if (iStructuredSelection.isEmpty()) {
            this.actionBarContributor.disableGlobalEditMenu();
        } else {
            this.actionBarContributor.enableGlobalEditMenu();
        }
        if (this.treeViewer != null) {
            this.treeViewer.getControl().setFocus();
        }
    }

    @Override
    public Viewer getViewer() {
        return this.treeViewer;
    }

    @Override
    public void createViewer(Composite composite) {
        this.treeViewer = new TreeViewer(composite){

            protected void handleLabelProviderChanged(LabelProviderChangedEvent labelProviderChangedEvent) {
                if (labelProviderChangedEvent.getElement() instanceof IResource && labelProviderChangedEvent.getSource() instanceof ILabelDecorator) {
                    this.refresh();
                    return;
                }
                super.handleLabelProviderChanged(labelProviderChangedEvent);
            }
        };
        this.adapterFactory = TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory();
        BasicCommandStack basicCommandStack = new BasicCommandStack();
        basicCommandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject eventObject) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        LibraryView.this.firePropertyChange(257);
                        Command command = ((CommandStack)eventObject.getSource()).getMostRecentCommand();
                        if (command != null) {
                            Viewer viewer;
                            LibraryView.this.setSelectionToViewer(command.getAffectedObjects());
                            if (command instanceof CreateMethodElementCommand && (viewer = LibraryView.this.getViewer()) instanceof StructuredViewer) {
                                Object[] objectArray = command.getAffectedObjects().toArray();
                                ((StructuredViewer)viewer).update(objectArray, null);
                            }
                        }
                        if ((this).LibraryView.this.propertySheetPage != null && (this).LibraryView.this.propertySheetPage.getControl() != null && !(this).LibraryView.this.propertySheetPage.getControl().isDisposed() && (this).LibraryView.this.propertySheetPage.getControl().isVisible()) {
                            (this).LibraryView.this.propertySheetPage.refresh();
                        }
                    }
                };
                if (Display.getCurrent() != null) {
                    Display.getCurrent().asyncExec(runnable);
                } else {
                    runnable.run();
                }
            }
        });
        ILibraryResourceSet iLibraryResourceSet = PersistenceService.INSTANCE.createResourceSet(Services.getDefaultLibraryPersistenceType());
        this.editingDomain = new TraceableAdapterFactoryEditingDomain(this.adapterFactory, (CommandStack)basicCommandStack, (ResourceSet)iLibraryResourceSet);
        this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.adapterFactory));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory), (ILabelDecorator)new MethodElementLabelDecorator()));
        this.doubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                UIActionDispatcher.getInstance().handleDoubleClickEvent(doubleClickEvent);
            }
        };
        this.treeViewer.addDoubleClickListener(this.doubleClickListener);
        this.getSite().getPage().addPartListener(this.editorPartListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
        this.createContextMenuFor((StructuredViewer)this.treeViewer);
    }

    @Override
    public void setInputForViewer(Object object) {
        Control control = this.getViewer().getControl();
        if (control.isDisposed()) {
            return;
        }
        if (object == null || object instanceof MethodLibrary) {
            StructuredSelection structuredSelection = new StructuredSelection();
            this.actionDispatcher.setSelection((ISelection)structuredSelection);
            UIActionDispatcher.getInstance().setSelection((ISelection)structuredSelection);
            this.getViewer().setInput(object);
            this.updateLastRefreshTimestamp();
        } else {
            AuthoringUIPlugin.getDefault().getLogger().logError("Library viewer input is not a MethodLibrary object: " + object);
        }
    }

    private void updateLastRefreshTimestamp() {
        this.lastRefreshTimeStamp = System.currentTimeMillis();
    }

    public static LibraryView getView() {
        boolean bl = ViewHelper.isViewInCurrentPerspective(VIEW_ID);
        return (LibraryView)ViewHelper.findView(VIEW_ID, bl);
    }

    @Override
    public void setSelection(ISelection iSelection) {
        ((LibraryViewActionBarContributor)this.actionBarContributor).updateSelection(iSelection);
        super.setSelection(iSelection);
        this.selection = iSelection;
        IStatusLineManager iStatusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        if (iStatusLineManager != null) {
            URI uRI;
            Resource resource;
            Object object;
            IStructuredSelection iStructuredSelection;
            String string = "";
            if (iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1 && (object = TngUtil.unwrap((Object)iStructuredSelection.getFirstElement())) instanceof EObject && (resource = ((EObject)object).eResource()) != null && (uRI = resource.getURI()) != null && uRI.isFile()) {
                URI uRI2;
                ContentDescription contentDescription;
                string = uRI.toFileString();
                if (object instanceof ContentElement && (contentDescription = ((ContentElement)object).getPresentation()) != null && (resource = contentDescription.eResource()) != null && (uRI2 = resource.getURI()) != null) {
                    string = String.valueOf(string) + ",." + File.separatorChar + uRI2.deresolve(uRI).toFileString();
                }
            }
            iStatusLineManager.setMessage(string);
        }
    }

    @Override
    public void libraryReopened(MethodLibrary methodLibrary) {
        this.refreshViews();
    }

    @Override
    public void librarySet(MethodLibrary methodLibrary) {
        super.librarySet(methodLibrary);
        ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
        if (iLibraryManager != null) {
            iLibraryManager.registerEditingDomain(this.editingDomain);
            iLibraryManager.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object object, int n) {
                    if (n == 1) {
                        LibraryView.this.firePropertyChange(257);
                    }
                }
            });
        }
    }

    @Override
    public ILibraryActionBarContributor createActionBarContributor() {
        LibraryViewActionBarContributor libraryViewActionBarContributor = new LibraryViewActionBarContributor((EditingDomain)this.editingDomain);
        return libraryViewActionBarContributor;
    }

    @Override
    public void createContextMenuFor(StructuredViewer structuredViewer) {
        super.createContextMenuFor(structuredViewer);
        int n = 7;
        Transfer[] transferArray = new Transfer[]{HTMLTransfer.getInstance(), TextTransfer.getInstance(), LocalTransfer.getInstance()};
        structuredViewer.addDragSupport(n, transferArray, (DragSourceListener)new LibraryViewerDragAdapter((Viewer)structuredViewer));
    }

    @Override
    public void menuAboutToShow(IMenuManager iMenuManager) {
        super.menuAboutToShow(iMenuManager);
    }

    public void init(IViewSite iViewSite) throws PartInitException {
        super.init(iViewSite);
        AuthoringUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("enabledLibraryValidation")) {
                    Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    IToolBarManager iToolBarManager = LibraryView.this.getViewSite().getActionBars().getToolBarManager();
                    if (bl != null && bl.booleanValue()) {
                        LibraryView.this.performLibraryValidationAction.setId(LibraryView.this.PERFORM_ID);
                        iToolBarManager.insertAfter("additions", LibraryView.this.performLibraryValidationAction);
                    } else {
                        IContributionItem[] iContributionItemArray = iToolBarManager.getItems();
                        int n = 0;
                        while (n < iContributionItemArray.length) {
                            IContributionItem iContributionItem = iContributionItemArray[n];
                            if (iContributionItem.getId().equals(LibraryView.this.PERFORM_ID)) {
                                iToolBarManager.remove(iContributionItem);
                            }
                            ++n;
                        }
                    }
                    iToolBarManager.update(true);
                }
            }
        });
    }

    @Override
    public void dispose() {
        RefreshJob.getInstance().setRefreshHandler(null);
        if (this.fLayoutActionSet != null) {
            this.fLayoutActionSet.dispose();
        }
        super.dispose();
        if (this.doubleClickListener != null) {
            this.treeViewer.removeDoubleClickListener(this.doubleClickListener);
        }
    }

    public ProcessComponent getProcessComponent(Object object) {
        Object object2 = object;
        while (object2 != null && !(object2 instanceof ProcessComponent)) {
            ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)this.adapterFactory.adapt(object2, ITreeItemContentProvider.class);
            object2 = itemProviderAdapter.getParent(object2);
        }
        return (ProcessComponent)object2;
    }

    public void openLibrary(final String string) {
        StatusWorkspaceModifyOperation statusWorkspaceModifyOperation = new StatusWorkspaceModifyOperation(){

            public void execute(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask(AuthoringUIResources.openingLibraryTask_name, 2);
                try {
                    try {
                        iProgressMonitor.worked(1);
                        LibraryService.getInstance().closeCurrentMethodLibrary();
                        MethodLibrary methodLibrary = XMILibraryUtil.openMethodLibrary((String)string);
                        LibraryService.getInstance().setCurrentMethodLibrary(methodLibrary);
                        LibraryUIPreferences.setSavedLibraryPath((String)string);
                    }
                    catch (Exception exception) {
                        if (exception instanceof IOException) {
                            String string4 = exception.getMessage();
                            if (string4.startsWith("###")) {
                                String string2 = string4.substring(3);
                                String string3 = AuthoringUIResources.bind((String)AuthoringUIResources.ElementsView_35, (Object[])new Object[]{string2});
                                if (MsgBox.prompt((String)string3, (int)1280) == 1024) {
                                    LibraryView.this.openLibrary(string);
                                }
                            }
                        } else {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.errorDialog_title, AuthoringUIResources.openLibraryError_msg, (Throwable)exception);
                        }
                        iProgressMonitor.done();
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)statusWorkspaceModifyOperation);
            if (statusWorkspaceModifyOperation.getErrorMessage() == null) {
                this.getSite().getPage().closeAllEditors(false);
            }
        }
        catch (Exception exception) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
        }
    }

    @Override
    protected void handleActivate(IWorkbenchPart iWorkbenchPart) {
        super.handleActivate(iWorkbenchPart);
        XMILibraryUtil.openMethodLibraryProject((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (IProgressMonitor)this.getViewSite().getActionBars().getStatusLineManager().getProgressMonitor());
    }

    @Override
    public boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    public void doSaveAs() {
    }

    public void setSelectionToViewer(Object object) {
        Object object2;
        Object object3;
        MethodPlugin methodPlugin;
        Object object4 = TngUtil.unwrap((Object)object);
        if (!(object4 instanceof MethodElement)) {
            return;
        }
        if (object4 instanceof MethodConfiguration) {
            super.setSelectionToViewer(Arrays.asList(object4));
            return;
        }
        try {
            Process process;
            methodPlugin = UmaUtil.getMethodPlugin((EObject)((MethodElement)object4));
            object3 = (MethodPluginItemProvider)TngUtil.getAdapter((EObject)methodPlugin, MethodPluginItemProvider.class);
            object2 = (MethodLibraryItemProvider)TngUtil.getAdapter((EObject)LibraryService.getInstance().getCurrentMethodLibrary(), MethodLibraryItemProvider.class);
            ItemProviderAdapter itemProviderAdapter = object2.getPluginItemProvider(methodPlugin);
            while (itemProviderAdapter instanceof PluginUIPackagesItemProvider) {
                this.treeViewer.setExpandedState((Object)itemProviderAdapter, true);
                itemProviderAdapter = ((PluginUIPackagesItemProvider)itemProviderAdapter).getPluginItemProvider(methodPlugin);
            }
            this.treeViewer.setExpandedState((Object)methodPlugin, true);
            if (object4 instanceof BreakdownElement && (process = TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)object4))) != null) {
                object4 = process.eContainer();
            }
            if (object4 instanceof ProcessComponent || object4 instanceof ProcessPackage) {
                this.treeViewer.setExpandedState(object3.getChildren((Object)methodPlugin).toArray()[1], true);
                this.expandTreeViewerPackages(((MethodElement)object4).eContainer());
            } else {
                process = (ITreeItemContentProvider)object3.getChildren((Object)methodPlugin).toArray()[0];
                this.treeViewer.setExpandedState((Object)process, true);
                if (object4 instanceof CustomCategory) {
                    CustomCategory customCategory = TngUtil.getRootCustomCategory((MethodPlugin)methodPlugin);
                    ArrayList<CustomCategory> arrayList = new ArrayList<CustomCategory>();
                    CustomCategory customCategory2 = (CustomCategory)object4;
                    while (customCategory2 != customCategory) {
                        arrayList.add(0, customCategory2);
                        customCategory2 = (CustomCategory)AssociationHelper.getCustomCategories((DescribableElement)customCategory2).get(0);
                    }
                    object4 = this.expandTree(customCategory, arrayList);
                } else if (object4 instanceof ContentCategory) {
                    Object object5 = process.getChildren(object4).toArray()[1];
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    if (object4 instanceof Discipline) {
                        List list;
                        Object object6 = object4;
                        while (true) {
                            arrayList.add(0, object6);
                            list = AssociationHelper.getDiscipline((Discipline)((Discipline)object6));
                            if (list.isEmpty()) break;
                            object6 = list.get(0);
                        }
                        if (!AssociationHelper.getDisciplineGroups((Discipline)((Discipline)object6)).isEmpty()) {
                            list = (DisciplineGrouping)AssociationHelper.getDisciplineGroups((Discipline)((Discipline)object6)).get(0);
                            arrayList.add(0, list);
                        }
                        arrayList.add(0, TngUtil.getDisciplineCategoriesItemProvider((MethodPlugin)methodPlugin));
                        object4 = this.expandTree(object5, arrayList);
                    } else if (object4 instanceof RoleSet) {
                        arrayList.add(0, object4);
                        RoleSetGrouping roleSetGrouping = (RoleSetGrouping)AssociationHelper.getRoleSetGroups((RoleSet)((RoleSet)object4)).get(0);
                        arrayList.add(0, roleSetGrouping);
                        arrayList.add(0, TngUtil.getRoleSetsItemProvider((MethodPlugin)methodPlugin));
                        object4 = this.expandTree(object5, arrayList);
                    } else {
                        this.treeViewer.setExpandedState(object5, true);
                    }
                } else {
                    Object object7 = process.getChildren(object4).toArray()[0];
                    this.treeViewer.setExpandedState(object7, true);
                    this.expandTreeViewerPackages(((MethodElement)object4).eContainer());
                }
            }
        }
        catch (Exception exception) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
        }
        super.setSelectionToViewer(Arrays.asList(object4));
        if (object4 instanceof ProcessComponent && object instanceof BreakdownElement) {
            IEditorKeeper.REFERENCE.getEditorKeeper().openEditor(object4);
            methodPlugin = this.getSite().getPage().findEditor((IEditorInput)new MethodElementEditorInput((MethodElement)object4));
            if (methodPlugin instanceof ProcessEditor) {
                object3 = (ProcessEditor)methodPlugin;
                object2 = object instanceof RoleDescriptor || object instanceof TeamProfile ? "tbs" : (object instanceof WorkProductDescriptor ? "wpbs" : "wbs");
                ((ProcessEditor)((Object)object3)).setActivePage((String)object2);
                ((ProcessEditor)((Object)object3)).setSelectionToViewer(Collections.singletonList(object));
            }
        }
    }

    private Object expandTree(Object object, List list) {
        Object object2 = object;
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = list.get(n2);
            this.treeViewer.setExpandedState(object2, true);
            List list2 = TngUtil.getNotifyChangedListeners((AdapterFactory)this.adapterFactory, e);
            if (!list2.isEmpty()) {
                for (Object e2 : list2) {
                    if (!(e2 instanceof FeatureValueWrapperItemProvider) || TngUtil.unwrap(e2) != e) continue;
                    FeatureValueWrapperItemProvider featureValueWrapperItemProvider = (FeatureValueWrapperItemProvider)e2;
                    while (featureValueWrapperItemProvider != null && featureValueWrapperItemProvider.getOwner() != object2) {
                        featureValueWrapperItemProvider = TngUtil.getWrapper((Collection)featureValueWrapperItemProvider.getNotifyChangedListeners(), e);
                    }
                    if (featureValueWrapperItemProvider == null) continue;
                    object2 = featureValueWrapperItemProvider;
                    break;
                }
            } else {
                object2 = e;
            }
            ++n2;
        }
        return object2;
    }

    private void expandTreeViewerPackages(EObject eObject) {
        if (eObject == null) {
            return;
        }
        if (eObject instanceof ContentPackage || eObject instanceof ProcessPackage) {
            this.expandTreeViewerPackages(eObject.eContainer());
            this.treeViewer.setExpandedState((Object)eObject, true);
        }
    }

    public void refresh(IProgressMonitor iProgressMonitor) {
        Control control = this.getViewer().getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        if (control.getDisplay().getThread() == Thread.currentThread()) {
            this.doRefresh(this.getSite().getShell());
        } else {
            control.getDisplay().syncExec(new Runnable(){

                public void run() {
                    LibraryView.this.doRefresh(null);
                }
            });
        }
    }

    private void blockingRefresh(final ArrayList arrayList, final ArrayList arrayList2, final Collection collection, final boolean bl, Shell shell) {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                iProgressMonitor.beginTask("", -1);
                iProgressMonitor.subTask(AuthoringUIResources._UI_RefreshViewer_menu_item);
                iProgressMonitor.worked(1);
                try {
                    LibraryView.this.doRefresh(arrayList, arrayList2, collection, bl);
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
        try {
            this.getSite().getWorkbenchWindow().getWorkbench().getProgressService().runInUI((IRunnableContext)progressMonitorDialog, iRunnableWithProgress, (ISchedulingRule)new LibrarySchedulingRule(LibraryService.getInstance().getCurrentMethodLibrary()));
        }
        catch (Exception exception) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
            String string = AuthoringUIResources.ProcessEditor_refreshErrorTitle;
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(string, exception.toString(), (Throwable)exception);
        }
    }

    private synchronized void doRefresh(Collection collection, Collection collection2, Collection collection3, boolean bl) {
        Object object;
        ILibraryManager iLibraryManager;
        HashSet hashSet = new HashSet();
        if (!collection.isEmpty()) {
            this.handleRemovedResources(collection, hashSet);
            bl = true;
        }
        if (!collection2.isEmpty()) {
            this.handleChangedResources(collection2, hashSet, bl);
        } else {
            if (bl) {
                this.refreshViews();
            }
            if (!hashSet.isEmpty()) {
                iLibraryManager = hashSet.iterator();
                while (iLibraryManager.hasNext()) {
                    object = iLibraryManager.next();
                    if (!(object instanceof MethodElementEditor)) continue;
                    ((MethodElementEditor)((Object)object)).refresh();
                }
            }
        }
        if (collection3 != null && !collection3.isEmpty() && (iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager()) != null && (object = iLibraryManager.getEditingDomain().getResourceSet()) instanceof MultiFileResourceSetImpl) {
            ((MultiFileResourceSetImpl)object).loadNewResources(collection3);
            ((MultiFileResourceSetImpl)object).getUnresolvedProxyMarkerManager().validateAllMarkers();
        }
    }

    private boolean isViewObject(Object object) {
        return object instanceof MethodElement && !(object instanceof ContentDescription) && !(object instanceof ProcessElement) && (!(object instanceof ProcessPackage) || UmaUtil.getProcessComponent((MethodElement)((MethodElement)object)) != null);
    }

    private void doRefresh(IRefreshEvent iRefreshEvent, Shell shell) {
        if (DEBUG) {
            System.out.println("Refreshed objects: " + iRefreshEvent.getRefreshedObjects());
        }
        boolean bl = false;
        for (Object e : iRefreshEvent.getRefreshedObjects()) {
            if (!this.isViewObject(e)) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.refreshViews();
        }
    }

    private void doRefresh(Shell shell) {
        boolean bl = !RefreshJob.getInstance().getReloadedBeforeRefreshResources().isEmpty() || !RefreshJob.getInstance().getAddedResources().isEmpty();
        ArrayList arrayList = new ArrayList(RefreshJob.getInstance().getRemovedResources());
        ArrayList arrayList2 = new ArrayList(RefreshJob.getInstance().getChangedResources());
        ArrayList arrayList3 = new ArrayList(RefreshJob.getInstance().getAddedWorkspaceResources());
        if (!arrayList.isEmpty() || !arrayList2.isEmpty() || !arrayList3.isEmpty() || bl) {
            this.blockingRefresh(arrayList, arrayList2, arrayList3, bl, shell);
        }
        if (!arrayList.isEmpty()) {
            RefreshJob.getInstance().getRemovedResources().removeAll(arrayList);
        }
        if (!arrayList2.isEmpty()) {
            RefreshJob.getInstance().getChangedResources().removeAll(arrayList2);
        }
        if (!arrayList3.isEmpty()) {
            RefreshJob.getInstance().getAddedWorkspaceResources().removeAll(arrayList3);
        }
        if (bl) {
            RefreshJob.getInstance().getReloadedBeforeRefreshResources().clear();
            RefreshJob.getInstance().getAddedResources().clear();
        }
    }

    private Collection handleRemovedResources(Collection collection, Collection arrayList) {
        Resource resource;
        Object object;
        IEditorPart iEditorPart;
        IEditorReference iEditorReference;
        IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
        IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
        ArrayList<IEditorPart> arrayList2 = new ArrayList<IEditorPart>();
        ArrayList arrayList3 = new ArrayList(collection);
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
        }
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            iEditorReference = iEditorReferenceArray[n];
            iEditorPart = iEditorReference.getEditor(true);
            if (iEditorPart instanceof MethodElementEditor && iEditorPart.isDirty()) {
                Resource resource2;
                object = (MethodElementEditorInput)iEditorPart.getEditorInput();
                Resource resource3 = resource2 = ((MethodElementEditorInput)object).getMethodElement() != null ? ((MethodElementEditorInput)object).getMethodElement().eResource() : null;
                if (!collection.contains(resource2)) {
                    resource = ((MethodElementEditor)iEditorPart).getUsedResources();
                    int n2 = 0;
                    while (n2 < arrayList3.size()) {
                        resource2 = (Resource)arrayList3.get(n2);
                        if (resource.contains(resource2)) {
                            arrayList2.add(iEditorPart);
                            break;
                        }
                        ++n2;
                    }
                } else {
                    arrayList.add(iEditorPart);
                }
            }
            ++n;
        }
        if (!arrayList2.isEmpty()) {
            Object[] objectArray = this.selectDirtyEditors(arrayList2);
            int n3 = 0;
            while (n3 < objectArray.length) {
                arrayList.add(objectArray[n3]);
                ++n3;
            }
        }
        PersistenceUtil.unload((Collection)collection);
        int n4 = 0;
        while (n4 < iEditorReferenceArray.length) {
            iEditorReference = iEditorReferenceArray[n4];
            iEditorPart = iEditorReference.getEditor(true);
            if (iEditorPart instanceof MethodElementEditor && !iEditorPart.isDirty()) {
                object = ((MethodElementEditor)iEditorPart).getUsedResources();
                int n5 = 0;
                while (n5 < arrayList3.size()) {
                    resource = (Resource)arrayList3.get(n5);
                    if (object.contains(resource)) {
                        arrayList.add(iEditorPart);
                        break;
                    }
                    ++n5;
                }
            }
            ++n4;
        }
        return collection;
    }

    private Collection handleChangedResources(Collection collection, Collection collection2, boolean bl) {
        if (!bl) {
            for (Resource resource : collection) {
                if (!(resource instanceof ILibraryResource) || ((ILibraryResource)resource).getLoadStamp() <= this.lastRefreshTimeStamp) continue;
                bl = true;
                break;
            }
        }
        return this.handleChangedResources(collection, null, bl, collection2);
    }

    public Collection handleChangedResources(Collection collection, Collection collection2, boolean bl, Collection collection3) {
        Object object;
        Object object2;
        IEditorPart iEditorPart;
        Object[] objectArray;
        Control control = this.getViewer().getControl();
        if (control == null || control.isDisposed()) {
            return Collections.EMPTY_LIST;
        }
        IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
        IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
        ArrayList<IEditorPart> arrayList = new ArrayList<IEditorPart>();
        ArrayList arrayList2 = new ArrayList(collection);
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            objectArray = iEditorReferenceArray[n];
            iEditorPart = objectArray.getEditor(true);
            if (iEditorPart instanceof MethodElementEditor && iEditorPart.isDirty()) {
                object2 = ((MethodElementEditor)iEditorPart).getUsedResources();
                int n2 = 0;
                while (n2 < arrayList2.size()) {
                    object = (Resource)arrayList2.get(n2);
                    if (object2.contains(object)) {
                        arrayList.add(iEditorPart);
                        break;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        if (collection3 != null) {
            arrayList3.addAll(collection3);
        }
        if (!arrayList.isEmpty()) {
            objectArray = this.selectDirtyEditors(arrayList);
            if (objectArray != null) {
                int n3 = 0;
                while (n3 < objectArray.length) {
                    object2 = objectArray[n3];
                    if (!(collection2 != null && collection2.contains(object2) || collection3 != null && collection3.contains(object2))) {
                        arrayList3.add(object2);
                        arrayList.remove(object2);
                    }
                    ++n3;
                }
            }
            int n4 = 0;
            while (n4 < arrayList.size()) {
                object2 = (MethodElementEditor)((Object)arrayList.get(n4));
                Collection<Resource> collection4 = ((MethodElementEditor)((Object)object2)).getUsedResources();
                collection4.retainAll(arrayList2);
                ((MethodElementEditor)((Object)object2)).updateResourceInfos(collection4);
                ((MethodElementEditor)((Object)object2)).ovewriteResources(collection4);
                arrayList2.removeAll(collection4);
                ++n4;
            }
        }
        boolean bl2 = false;
        if (!arrayList2.isEmpty()) {
            int n5 = 0;
            while (n5 < iEditorReferenceArray.length) {
                object2 = iEditorReferenceArray[n5];
                IEditorPart iEditorPart2 = object2.getEditor(true);
                if (iEditorPart2 instanceof MethodElementEditor && !iEditorPart2.isDirty()) {
                    object = ((MethodElementEditor)iEditorPart2).getUsedResources();
                    int n6 = 0;
                    while (n6 < arrayList2.size()) {
                        Resource resource = (Resource)arrayList2.get(n6);
                        if (object.contains(resource)) {
                            arrayList3.add(iEditorPart2);
                            break;
                        }
                        ++n6;
                    }
                }
                ++n5;
            }
            iEditorPart = LibraryService.getInstance().getCurrentLibraryManager();
            if (iEditorPart != null) {
                object2 = iEditorPart.reloadResources(arrayList2);
                boolean bl3 = bl2 = !object2.isEmpty();
            }
        }
        if (bl || bl2) {
            this.refreshViews();
        }
        if (!arrayList3.isEmpty()) {
            int n7 = 0;
            while (n7 < arrayList3.size()) {
                object2 = (MethodElementEditor)((Object)arrayList3.get(n7));
                try {
                    ((MethodElementEditor)((Object)object2)).refresh();
                }
                catch (Exception exception) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
                ++n7;
            }
        }
        return arrayList2;
    }

    public synchronized void refreshViews() {
        Object object;
        Control control;
        ConfigurationView configurationView;
        EObject eObject = (EObject)this.getViewer().getInput();
        if (eObject != null) {
            if (eObject.eIsProxy()) {
                this.setInputForViewer(RefreshJob.getInstance().resolve(eObject));
            } else {
                configurationView = this.getViewer().getSelection();
                this.getViewer().refresh();
                this.updateLastRefreshTimestamp();
                if (configurationView instanceof IStructuredSelection) {
                    control = (IStructuredSelection)configurationView;
                    object = null;
                    if (control.size() == 1 && (object = control.getFirstElement()) instanceof EObject && ((EObject)object).eIsProxy()) {
                        object = RefreshJob.getInstance().resolve((EObject)object);
                        try {
                            this.setSelectionToViewer(object);
                        }
                        catch (Exception exception) {
                            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                        }
                    } else {
                        ViewHelper.restoreSelection(this.getViewer(), (ISelection)configurationView);
                    }
                }
            }
        }
        if ((configurationView = ConfigurationView.getView()) != null && (control = configurationView.getViewer().getControl()) != null && !control.isDisposed() && (eObject = (EObject)configurationView.getViewer().getInput()) != null) {
            if (eObject.eIsProxy()) {
                configurationView.setInputForViewer(RefreshJob.getInstance().resolve(eObject));
            } else {
                object = configurationView.getViewer().getSelection();
                configurationView.getViewer().refresh();
                ViewHelper.restoreSelection(configurationView.getViewer(), object);
            }
        }
    }

    private Object[] selectDirtyEditors(List<?> list) {
        return RefreshHandler.selectDirtyEditors(list, this.getSite().getShell());
    }

    public static void runRename(final NamedElement namedElement, final String string) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                RenameAction.doRename(namedElement, string);
            }
        });
    }

    public boolean show(ShowInContext showInContext) {
        IResource iResource;
        String string;
        IMarker iMarker;
        ISelection iSelection;
        ISelectionProvider iSelectionProvider;
        Object object;
        Object object2;
        if (showInContext.getInput() instanceof MarkerAdapter && (object2 = (object = (StructuredSelection)(iSelectionProvider = (iSelection = this.getViewSite().getPage().findView("org.eclipse.ui.views.ProblemView")).getViewSite().getSelectionProvider()).getSelection()).getFirstElement()) instanceof IMarker) {
            iMarker = (IMarker)object2;
            try {
                string = (String)iMarker.getAttribute("guid");
                if (string != null) {
                    iResource = iMarker.getResource();
                    ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
                    Resource resource = iLibraryManager.getEditingDomain().getResourceSet().getResource(URI.createFileURI((String)iResource.getLocation().toString()), false);
                    Object object3 = resource != null ? resource.getEObject(string) : iLibraryManager.getMethodElement(string);
                    if (object3 != null) {
                        this.setSelectionToViewer(object3);
                        return true;
                    }
                }
            }
            catch (CoreException coreException) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)coreException);
            }
        }
        iSelection = showInContext.getSelection();
        if (showInContext.getSelection() instanceof TreeSelection) {
            iSelectionProvider = (TreeSelection)showInContext.getSelection();
            this.setSelectionToViewer(iSelectionProvider.getFirstElement());
        } else if (iSelection instanceof StructuredSelection && (object = (iSelectionProvider = (StructuredSelection)iSelection).getFirstElement()) instanceof IResource) {
            object2 = (IResource)object;
            iMarker = LibraryService.getInstance().getCurrentLibraryManager();
            string = iMarker.getEditingDomain().getResourceSet().getResource(URI.createFileURI((String)object2.getLocation().toString()), false);
            iResource = PersistenceUtil.getMethodElement((Resource)string);
            if (iResource != null) {
                this.setSelectionToViewer(iResource);
                return true;
            }
        }
        return false;
    }

    @Override
    public String getViewId() {
        return VIEW_ID;
    }

    class LibraryViewActionBarContributor
    extends LibraryActionBarContributor {
        private IAction newPluginAction;
        private IAction moveAction;
        private RenameAction renameAction;
        private IAction replaceAction;
        private IAction openVariabilityDialogAction;
        private boolean locked;
        private boolean canMove;
        private IAction showInResourceNavigatorAction;
        private boolean canRename;

        public LibraryViewActionBarContributor(EditingDomain editingDomain) {
            super(editingDomain);
            this.newPluginAction = new NewPluginAction(AuthoringUIResources.new_plugin);
            this.moveAction = new Action(AuthoringUIResources.move){

                private void doMove() {
                    ArrayList arrayList = new ArrayList();
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)LibraryView.this.selection;
                    for (Object object2 : iStructuredSelection) {
                        if (!(object2 instanceof MethodElement) && !((object2 = TngUtil.unwrap(object2)) instanceof CustomCategory)) continue;
                        EObject eObject = ((EObject)object2).eContainer();
                        IStatus iStatus = UserInteractionHelper.checkModify((EObject)eObject, (Shell)LibraryView.this.getSite().getShell());
                        if (eObject != null && !iStatus.isOK()) {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.errorDialog_title, AuthoringUIResources.errorDialog_moveError, iStatus);
                            return;
                        }
                        arrayList.add(object2);
                    }
                    Object object = arrayList.iterator();
                    while (object.hasNext()) {
                        Object object2;
                        object2 = (EObject)object.next();
                        boolean bl = false;
                        for (Object e : arrayList) {
                            if (!UmaUtil.isContainedBy(object2, e)) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) continue;
                        object.remove();
                    }
                    object = new MoveDialog(LibraryView.this.getSite().getShell(), arrayList, (EditingDomain)((LibraryViewActionBarContributor)LibraryViewActionBarContributor.this).LibraryView.this.editingDomain);
                    object.open();
                }

                public void run() {
                    LibraryLockingOperationRunner libraryLockingOperationRunner = new LibraryLockingOperationRunner();
                    libraryLockingOperationRunner.setProgressMonitor(LibraryViewActionBarContributor.this.getActionBars().getStatusLineManager().getProgressMonitor());
                    libraryLockingOperationRunner.run(new IRunnableWithProgress(){

                        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                            this.doMove();
                        }
                    });
                }
            };
            this.renameAction = new RenameAction();
            this.replaceAction = new Action(AuthoringUIResources.ElementsView_replaceAction_text){

                public void run() {
                    if (!LibraryViewActionBarContributor.this.getPage().closeAllEditors(true)) {
                        return;
                    }
                    final ProcessComponent processComponent = (ProcessComponent)((IStructuredSelection)LibraryView.this.selection).getFirstElement();
                    Process process = processComponent.getProcess();
                    String string = process instanceof CapabilityPattern ? AuthoringUIResources.ElementsView_20 : (process instanceof DeliveryProcess ? AuthoringUIResources.ElementsView_21 : AuthoringUIResources.ElementsView_22);
                    DirectoryDialog directoryDialog = new DirectoryDialog(LibraryView.this.getSite().getShell());
                    directoryDialog.setText(AuthoringUIResources.ElementsView_replace_text);
                    directoryDialog.setMessage(MessageFormat.format(AuthoringUIResources.ElementsView_migration_dir_dlg_description_text, string));
                    final String string2 = directoryDialog.open();
                    if (string2 == null) {
                        return;
                    }
                    boolean bl = UserInteractionHelper.runWithProgress((IRunnableWithProgress)new IRunnableWithProgress(){

                        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                            try {
                                ImportExportUtil.replace((ProcessComponent)processComponent, (String)string2);
                            }
                            catch (Exception exception) {
                                throw new WrappedException(exception);
                            }
                        }
                    }, (String)MessageFormat.format(AuthoringUIResources.ElementsView_replaceingwithformat_text, string));
                    if (bl) {
                        LibraryUIManager.getInstance().openLibrary(LibraryService.getInstance().getCurrentMethodLibraryLocation());
                    }
                }
            };
            this.openVariabilityDialogAction = new Action(AuthoringUIResources.ElementsView_openVariabilityDialogAction_text){

                public void run() {
                    VariabilityElement variabilityElement;
                    VariabilitySelection variabilitySelection;
                    Object object;
                    Object object2 = TngUtil.unwrap((Object)((IStructuredSelection)LibraryView.this.selection).getFirstElement());
                    if (object2 instanceof VariabilityElement && (object = (variabilitySelection = new VariabilitySelection()).getSelectedVariability(variabilityElement = (VariabilityElement)object2)) != null) {
                        EditorChooser.getInstance().openEditor(object);
                    }
                }
            };
            this.showInResourceNavigatorAction = new Action(AuthoringUIResources.showInResourceNavigatorAction_label){

                public void run() {
                    try {
                        ResourceNavigator resourceNavigator = (ResourceNavigator)LibraryViewActionBarContributor.this.getPage().showView("org.eclipse.ui.views.ResourceNavigator");
                        Object object = TngUtil.unwrap((Object)((IStructuredSelection)LibraryView.this.selection).getFirstElement());
                        IResource iResource = PersistenceUtil.getWorkspaceResource((Object)object);
                        if (iResource != null) {
                            resourceNavigator.getViewer().setSelection((ISelection)new StructuredSelection((Object)iResource), true);
                        }
                    }
                    catch (PartInitException partInitException) {
                        AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)partInitException);
                    }
                }
            };
        }

        protected DeleteAction createDeleteAction() {
            LibraryViewDeleteAction libraryViewDeleteAction = new LibraryViewDeleteAction(){

                public boolean updateSelection(IStructuredSelection iStructuredSelection) {
                    if (LibraryViewActionBarContributor.this.locked) {
                        return false;
                    }
                    return super.updateSelection(iStructuredSelection);
                }

                public void run() {
                    String string = AuthoringUIResources.actions_LibraryActionBarContributor_deleteErrorTitle;
                    try {
                        super.run();
                    }
                    catch (MessageException messageException) {
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(string, messageException.getMessage());
                    }
                    catch (Exception exception) {
                        String string2 = TngUtil.toStackTraceString((Throwable)exception);
                        String string3 = AuthoringUIResources.actions_LibraryActionBarContributor_deleteErrorMessage;
                        String string4 = AuthoringUIResources.actions_LibraryActionBarContributor_deleteErrorReason;
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(string, string3, string4, string2, (Throwable)exception);
                    }
                }

                protected void deleteFailed() {
                    ViewHelper.reloadCurrentLibrary(LibraryView.this.getSite().getShell(), AuthoringUIResources.msg_reloadLibrary);
                    if (LibraryViewActionBarContributor.this.activeViewPart instanceof IViewerProvider) {
                        ArrayList<MethodElement> arrayList = new ArrayList<MethodElement>();
                        for (Object e : this.selection) {
                            MethodElement methodElement;
                            if (!(e instanceof MethodElement)) continue;
                            String string = ((MethodElement)e).getGuid();
                            ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
                            if (iLibraryManager == null || (methodElement = iLibraryManager.getMethodElement(string)) == null) continue;
                            arrayList.add(methodElement);
                        }
                        if (!arrayList.isEmpty()) {
                            Viewer viewer = ((IViewerProvider)LibraryViewActionBarContributor.this.activeViewPart).getViewer();
                            viewer.setSelection((ISelection)new StructuredSelection(arrayList), true);
                        }
                    }
                }
            };
            libraryViewDeleteAction.setProgressMonitor(this.getActionBars().getStatusLineManager().getProgressMonitor());
            return libraryViewDeleteAction;
        }

        protected CutAction createCutAction() {
            return new LibraryViewCutAction(){

                public boolean updateSelection(IStructuredSelection iStructuredSelection) {
                    if (LibraryViewActionBarContributor.this.locked) {
                        return false;
                    }
                    return super.updateSelection(iStructuredSelection);
                }
            };
        }

        protected CopyAction createCopyAction() {
            return new LibraryViewCopyAction(){

                public boolean updateSelection(IStructuredSelection iStructuredSelection) {
                    if (ViewHelper.hasCustomizedLocker(iStructuredSelection) && LibraryViewActionBarContributor.this.locked) {
                        return false;
                    }
                    return super.updateSelection(iStructuredSelection);
                }
            };
        }

        protected PasteAction createPasteAction() {
            LibraryViewPasteAction libraryViewPasteAction = new LibraryViewPasteAction(){

                public boolean updateSelection(IStructuredSelection iStructuredSelection) {
                    if (LibraryViewActionBarContributor.this.locked) {
                        return false;
                    }
                    return super.updateSelection(iStructuredSelection);
                }
            };
            libraryViewPasteAction.setProgressMonitor(this.getActionBars().getStatusLineManager().getProgressMonitor());
            return libraryViewPasteAction;
        }

        private void checkLocked() {
            if (LibraryView.this.selection instanceof IStructuredSelection) {
                boolean bl = this.locked;
                this.locked = ViewHelper.hasCustomizedLocker((IStructuredSelection)LibraryView.this.selection) ? ViewHelper.isLockedWithCustomizedLocker((IStructuredSelection)LibraryView.this.selection) : ViewHelper.isLocked((IStructuredSelection)LibraryView.this.selection);
                if (bl != this.locked) {
                    this.deleteAction.setEnabled(this.deleteAction.updateSelection((IStructuredSelection)LibraryView.this.selection));
                    this.cutAction.setEnabled(this.cutAction.updateSelection((IStructuredSelection)LibraryView.this.selection));
                    this.pasteAction.setEnabled(this.pasteAction.updateSelection((IStructuredSelection)LibraryView.this.selection));
                    boolean bl2 = !this.locked;
                    this.renameAction.setEnabled(bl2);
                    this.moveAction.setEnabled(bl2);
                }
            }
        }

        void updateSelection(ISelection iSelection) {
            boolean bl;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            this.renameAction.setActiveWorkbenchPart((IWorkbenchPart)LibraryView.this);
            this.canRename = this.renameAction.updateSelection(iStructuredSelection);
            this.locked = ViewHelper.hasCustomizedLocker(iStructuredSelection) ? ViewHelper.isLockedWithCustomizedLocker(iStructuredSelection) : ViewHelper.isLocked(iStructuredSelection);
            boolean bl2 = bl = !this.locked;
            if (this.canRename && !bl) {
                this.renameAction.setEnabled(bl);
            }
            this.moveAction.setEnabled(bl);
            this.canMove = this.canMove(iStructuredSelection);
            if (!this.locked && iStructuredSelection.size() == 1 && iStructuredSelection.getFirstElement() instanceof ProcessComponent) {
                this.replaceAction.setEnabled(true);
            } else {
                this.replaceAction.setEnabled(false);
            }
            if (iStructuredSelection.size() == 1) {
                Object object = TngUtil.unwrap((Object)((IStructuredSelection)iSelection).getFirstElement());
                this.openVariabilityDialogAction.setEnabled(object instanceof VariabilityElement && !TngUtil.isPredefined((MethodElement)((MethodElement)object)));
                this.showInResourceNavigatorAction.setEnabled(object instanceof MethodElement);
            }
        }

        public void enableGlobalEditMenu() {
        }

        protected void addGlobalActions(IMenuManager iMenuManager) {
            super.addGlobalActions(iMenuManager);
            iMenuManager.insertAfter("fixed-additions", this.newPluginAction);
        }

        private boolean canMove(IStructuredSelection iStructuredSelection) {
            for (Object e : iStructuredSelection) {
                if (!(e instanceof MethodElement) || e instanceof ContentCategory || e instanceof MethodPlugin || e instanceof MethodConfiguration || TngUtil.isPredefined((MethodElement)((MethodElement)e))) continue;
                return true;
            }
            return false;
        }

        public void contributeToToolBar(IToolBarManager iToolBarManager) {
            LibraryView.this.performLibraryValidationAction.setId(LibraryView.this.PERFORM_ID);
            if (AuthoringUIPreferences.getEnableLibraryValidation()) {
                iToolBarManager.add(LibraryView.this.performLibraryValidationAction);
            }
        }

        public void menuAboutToShow(IMenuManager iMenuManager) {
            this.checkLocked();
            iMenuManager.add((IContributionItem)new Separator("fixed-additions"));
            iMenuManager.add((IContributionItem)new Separator("fixed-additions-end"));
            iMenuManager.add((IContributionItem)new Separator("edit"));
            iMenuManager.add((IContributionItem)new ActionContributionItem((IAction)this.libraryViewEditAction));
            iMenuManager.add((IContributionItem)new ActionContributionItem((IAction)this.copyAction));
            iMenuManager.add((IContributionItem)new ActionContributionItem((IAction)this.pasteAction));
            iMenuManager.add((IContributionItem)new Separator());
            iMenuManager.add((IContributionItem)new ActionContributionItem((IAction)this.deleteAction));
            if (this.canRename) {
                iMenuManager.add((IContributionItem)new ActionContributionItem((IAction)this.renameAction));
            }
            if (this.canMove) {
                iMenuManager.add((IContributionItem)new ActionContributionItem(this.moveAction));
            }
            iMenuManager.add((IContributionItem)new Separator("view"));
            if (this.openVariabilityDialogAction.isEnabled()) {
                iMenuManager.add((IContributionItem)new ActionContributionItem(this.openVariabilityDialogAction));
            }
            if (this.showInResourceNavigatorAction.isEnabled()) {
                iMenuManager.add((IContributionItem)new ActionContributionItem(this.showInResourceNavigatorAction));
            }
            iMenuManager.add((IContributionItem)new Separator());
            iMenuManager.add((IContributionItem)new Separator("additions"));
            iMenuManager.add((IContributionItem)new Separator("additions-end"));
            this.addGlobalActions(iMenuManager);
            if (!this.locked) {
                MenuManager menuManager = null;
                menuManager = new MenuManager(AuthoringUIResources._UI_CreateChild_menu_item);
                this.populateManager((IContributionManager)menuManager, this.createChildActions, null);
                iMenuManager.insertBefore("fixed-additions", (IContributionItem)menuManager);
            }
        }

        protected void refreshViewer(final Viewer viewer) {
            if (viewer == LibraryView.this.getViewer()) {
                IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                        iProgressMonitor.beginTask("", 3);
                        iProgressMonitor.subTask(AuthoringUIResources._UI_RefreshViewer_menu_item);
                        iProgressMonitor.worked(1);
                        try {
                            ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
                            if (iLibraryManager != null) {
                                ILibraryResourceSet iLibraryResourceSet;
                                ResourceSet resourceSet = iLibraryManager.getEditingDomain().getResourceSet();
                                if (resourceSet instanceof ILibraryResourceSet && (iLibraryResourceSet = (ILibraryResourceSet)resourceSet).getPersistenceType().equals("xmi")) {
                                    iLibraryResourceSet.loadNewResources();
                                    ArrayList<Resource> arrayList = new ArrayList<Resource>();
                                    ArrayList<Resource> arrayList2 = new ArrayList<Resource>();
                                    for (Resource resource : new ArrayList(resourceSet.getResources())) {
                                        String string = resource.getURI().toFileString();
                                        IResource iResource = FileManager.getResourceForLocation((String)string);
                                        if (iResource == null) {
                                            arrayList.add(resource);
                                            continue;
                                        }
                                        if (iResource.isSynchronized(0)) continue;
                                        arrayList2.add(resource);
                                    }
                                    iProgressMonitor.worked(2);
                                    if (arrayList.isEmpty() && arrayList2.isEmpty()) {
                                        viewer.refresh();
                                    } else {
                                        LibraryView.this.doRefresh(arrayList, arrayList2, null, false);
                                    }
                                } else {
                                    viewer.refresh();
                                }
                            }
                        }
                        finally {
                            iProgressMonitor.done();
                        }
                    }
                };
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(LibraryView.this.getSite().getShell());
                try {
                    LibraryView.this.getSite().getWorkbenchWindow().getWorkbench().getProgressService().runInUI((IRunnableContext)progressMonitorDialog, iRunnableWithProgress, null);
                }
                catch (Exception exception) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                    String string = AuthoringUIResources.ProcessEditor_refreshErrorTitle;
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(string, exception.toString(), (Throwable)exception);
                }
                return;
            }
            super.refreshViewer(viewer);
        }
    }

    private static abstract class StatusWorkspaceModifyOperation
    extends WorkspaceModifyOperation {
        protected String errMsg;

        private StatusWorkspaceModifyOperation() {
        }

        public String getErrorMessage() {
            return this.errMsg;
        }
    }
}

