/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.authoring.ui.views.AbstractLocker;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.osgi.framework.Bundle;

public class LockerFactory {
    public static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.epf.authoring.ui";
    public static final String EXTENSION_POINT_NAME = "CustomizedLocker";
    public static final String CLASS_ATTRIB_NAME = "class";
    public static final String ID_ATTRIB_NAME = "id";
    private static LockerFactory instance = null;
    private Map<String, LockerElement> lockerElements = new HashMap<String, LockerElement>();
    private Map<String, AbstractLocker> lockerMap = new HashMap<String, AbstractLocker>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LockerFactory getInstance() {
        if (instance != null) return instance;
        Class<LockerFactory> clazz = LockerFactory.class;
        synchronized (LockerFactory.class) {
            if (instance != null) return instance;
            instance = new LockerFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LockerFactory() {
        this.init();
    }

    protected void init() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(EXTENSION_POINT_NAMESPACE, EXTENSION_POINT_NAME);
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < iExtensionArray.length) {
                IExtension iExtension = iExtensionArray[n];
                String string = iExtension.getNamespaceIdentifier();
                Bundle bundle = Platform.getBundle((String)string);
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                    try {
                        LockerElement lockerElement;
                        String string2 = iConfigurationElement.getAttribute(CLASS_ATTRIB_NAME);
                        String string3 = iConfigurationElement.getAttribute(ID_ATTRIB_NAME);
                        if (string2 != null && string2.trim().length() > 0 && string3 != null && string3.trim().length() > 0 && (lockerElement = this.lockerElements.get(string3)) == null) {
                            lockerElement = new LockerElement(bundle, string2, string3);
                            this.lockerElements.put(string3, lockerElement);
                        }
                    }
                    catch (Exception exception) {
                        LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    public AbstractLocker getLocker(Object object) {
        List list;
        MethodElement methodElement;
        if (object instanceof MethodElement && (methodElement = (MethodElement)object) != null && (list = methodElement.getMethodElementProperty()) != null && list.size() > 0) {
            for (MethodElementProperty methodElementProperty : list) {
                String string = methodElementProperty.getName();
                AbstractLocker abstractLocker = this.getLocker(string);
                if (abstractLocker == null) continue;
                return abstractLocker;
            }
        }
        return null;
    }

    private AbstractLocker getLocker(String string) {
        if (!this.lockerElements.containsKey(string)) {
            return null;
        }
        if (this.lockerMap.containsKey(string)) {
            return this.lockerMap.get(string);
        }
        LockerElement lockerElement = this.lockerElements.get(string);
        try {
            Class clazz = lockerElement.bundle.loadClass(lockerElement.className);
            AbstractLocker abstractLocker = (AbstractLocker)clazz.newInstance();
            this.lockerMap.put(string, abstractLocker);
            return abstractLocker;
        }
        catch (Exception exception) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
            return null;
        }
    }

    private class LockerElement {
        Bundle bundle;
        String className;
        String id;

        private LockerElement(Bundle bundle, String string, String string2) {
            this.bundle = bundle;
            this.className = string;
            this.id = string2;
        }
    }
}

