/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.DiagramCoreResources;
import org.eclipse.epf.diagram.core.actions.ActionDelegate;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.bridge.NodeAdapter;
import org.eclipse.epf.diagram.core.services.DiagramHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.uml2.uml.Activity;

public class DeleteDiagramAction
extends ActionDelegate {
    private EditPart mySelectedElement;

    public DeleteDiagramAction() {
    }

    public DeleteDiagramAction(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        super(iAction, iWorkbenchPart);
    }

    public void run(IAction iAction) {
        Diagram diagram;
        if (DiagramCorePlugin.getDefault().getMsgDialog().displayPrompt(DiagramCoreResources.DeleteDiagram_text, DiagramCoreResources.DeleteDiagram_prompt) && this.mySelectedElement != null && (diagram = (Diagram)this.mySelectedElement.getModel()) != null) {
            try {
                DiagramHelper.deleteDiagram(diagram, true);
                this.targetPart.getSite().getPage().closeEditor(this.targetPart.getSite().getPage().getActiveEditor(), false);
            }
            catch (Exception exception) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)exception);
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        IStructuredSelection iStructuredSelection;
        this.dropMenuItems();
        this.mySelectedElement = null;
        if (iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1 && iStructuredSelection.getFirstElement() instanceof EditPart) {
            this.mySelectedElement = (EditPart)iStructuredSelection.getFirstElement();
        }
        if (this.mySelectedElement != null) {
            iAction.setChecked(false);
            if (this.mySelectedElement instanceof DiagramEditPart && !((DiagramEditPart)this.mySelectedElement).isEditModeEnabled()) {
                iAction.setEnabled(false);
                iStructuredSelection = this.getDiagramContextMenuProvider().find("editMenu");
                if (iStructuredSelection != null) {
                    iStructuredSelection.setVisible(false);
                }
            }
            if ((iStructuredSelection = (Diagram)this.mySelectedElement.getModel()) != null) {
                EObject eObject = iStructuredSelection.getElement();
                if (eObject instanceof Activity) {
                    NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter(eObject);
                    if (nodeAdapter != null && nodeAdapter.isTargetReadOnly()) {
                        iAction.setEnabled(false);
                        IContributionItem iContributionItem = this.getDiagramContextMenuProvider().find("editMenu");
                        if (iContributionItem != null) {
                            iContributionItem.setVisible(false);
                        }
                    }
                } else {
                    boolean cfr_ignored_0 = eObject instanceof org.eclipse.epf.diagram.model.Diagram;
                }
            }
        } else {
            iAction.setEnabled(false);
        }
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected Command getCommand() {
        return null;
    }
}

