/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.commands;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.services.DiagramHelper;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.core.services.DiagramService;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.gmf.runtime.common.ui.services.editor.EditorService;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class DeleteDiagramCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private Collection elementsToRemove;
    private Process targetProcess;
    private DiagramManager dMgr = null;

    public DeleteDiagramCommand(Collection collection, Process process) {
        this.elementsToRemove = collection;
        this.targetProcess = process;
    }

    public void execute() {
        DiagramService diagramService = new DiagramService();
        try {
            try {
                for (MethodElement methodElement : this.elementsToRemove) {
                    if (!(methodElement instanceof Activity)) continue;
                    Collection<Diagram> collection = diagramService.getDiagrams((Activity)methodElement);
                    for (Diagram diagram : collection) {
                        if (diagram == null) continue;
                        this.closeDiagramEditor(diagram);
                        DiagramHelper.deleteDiagram(diagram, true);
                    }
                }
            }
            catch (Exception exception) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)exception);
                diagramService.dispose();
            }
        }
        finally {
            diagramService.dispose();
        }
    }

    public void redo() {
        this.execute();
    }

    private DiagramManager getDiagramManager() {
        if (this.dMgr == null) {
            this.dMgr = DiagramManager.getInstance(this.targetProcess, (Object)this);
        }
        return this.dMgr;
    }

    public Collection getModifiedResources() {
        DiagramManager diagramManager = this.getDiagramManager();
        HashSet<Resource> hashSet = new HashSet<Resource>();
        boolean bl = true;
        try {
            if (diagramManager != null && diagramManager.getResource() != null && !diagramManager.getResource().getContents().isEmpty()) {
                File file = new File(FileManager.toFileString((URI)diagramManager.getResource().getURI()));
                if (!file.exists()) {
                    bl = false;
                }
                if (bl) {
                    hashSet.add(diagramManager.getResource());
                }
            }
        }
        catch (Exception exception) {
            DiagramCorePlugin.getDefault().getLogger().logError((Throwable)exception);
        }
        return hashSet;
    }

    public boolean canExecute() {
        return this.targetProcess != null;
    }

    public void dispose() {
        if (this.dMgr != null) {
            this.dMgr.removeConsumer((Object)this);
        }
        super.dispose();
    }

    private void closeDiagramEditor(Diagram diagram) {
        List list = EditorService.getInstance().getRegisteredEditorParts();
        for (Object e : list) {
            DiagramEditor diagramEditor;
            if (!(e instanceof DiagramEditor) || !(diagramEditor = (DiagramEditor)e).getDiagram().equals(diagram)) continue;
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)diagramEditor);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)diagramEditor, false);
        }
    }
}

