/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.epf.services.IAccessController;
import org.eclipse.epf.services.IFileManager;
import org.eclipse.epf.services.ILibraryPersister;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Services {
    public static final String XMI_PERSISTENCE_TYPE = "xmi";
    private static final String namespace = "org.eclipse.epf.services";
    private static final String extensionPointName = "serviceProviders";
    private static IAccessController accessController;
    private static IFileManager fileManager;
    private static List<PersisterDescriptor> persisterDescriptors;
    private static Map<String, PersisterDescriptor> typeToLibraryPersisterDescriptorMap;
    private static String defaultPersistenceType;

    static {
        persisterDescriptors = new ArrayList<PersisterDescriptor>();
    }

    private static Object getService(String string) {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(namespace, extensionPointName);
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            Bundle bundle = null;
            String string2 = null;
            int n = -1;
            int n2 = 0;
            while (n2 < iExtensionArray.length) {
                IExtension iExtension = iExtensionArray[n2];
                String string3 = iExtension.getNamespaceIdentifier();
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                int n3 = 0;
                while (n3 < iConfigurationElementArray.length) {
                    int n4;
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[n3];
                    if (string.equals(iConfigurationElement.getName()) && (n4 = Services.parseVersion(iConfigurationElement.getAttribute("version"))) > n) {
                        string2 = iConfigurationElement.getAttribute("class");
                        bundle = Platform.getBundle((String)string3);
                        n = n4;
                    }
                    ++n3;
                }
                ++n2;
            }
            if (string2 != null) {
                try {
                    return bundle.loadClass(string2).newInstance();
                }
                catch (Exception exception) {
                    CommonPlugin.INSTANCE.log((Object)exception);
                }
            }
        }
        return null;
    }

    public static int parseVersion(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static Map<String, PersisterDescriptor> getTypeToLibraryPersisterDescriptorMap() {
        HashMap<String, PersisterDescriptor> hashMap = new HashMap<String, PersisterDescriptor>();
        String string = "libraryPersister";
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(namespace, extensionPointName);
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < iExtensionArray.length) {
                IExtension iExtension = iExtensionArray[n];
                String string2 = iExtension.getNamespaceIdentifier();
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                    if (string.equals(iConfigurationElement.getName())) {
                        try {
                            PersisterDescriptor persisterDescriptor = new PersisterDescriptor();
                            persisterDescriptor.pluginId = string2;
                            persisterDescriptor.type = iConfigurationElement.getAttribute("type");
                            persisterDescriptor.className = iConfigurationElement.getAttribute("class");
                            persisterDescriptor.isDefault = Boolean.parseBoolean(iConfigurationElement.getAttribute("default"));
                            persisterDescriptor.version = Services.parseVersion(iConfigurationElement.getAttribute("version"));
                            persisterDescriptors.add(persisterDescriptor);
                            if (persisterDescriptor.type != null) {
                                PersisterDescriptor persisterDescriptor2 = (PersisterDescriptor)hashMap.get(persisterDescriptor.type);
                                if (persisterDescriptor2 != null) {
                                    if (persisterDescriptor2.version < persisterDescriptor.version) {
                                        hashMap.put(persisterDescriptor.type, persisterDescriptor);
                                        if (persisterDescriptor.isDefault) {
                                            defaultPersistenceType = persisterDescriptor.type;
                                        } else if (persisterDescriptor2.isDefault) {
                                            defaultPersistenceType = null;
                                        }
                                    }
                                } else {
                                    hashMap.put(persisterDescriptor.type, persisterDescriptor);
                                    if (persisterDescriptor.isDefault) {
                                        defaultPersistenceType = persisterDescriptor.type;
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            CommonPlugin.INSTANCE.log((Object)exception);
                        }
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return hashMap;
    }

    public static final IAccessController getAccessController() {
        if (accessController == null) {
            accessController = (IAccessController)Services.getService("accessController");
        }
        return accessController;
    }

    public static final ILibraryPersister getLibraryPersister(String string) {
        PersisterDescriptor persisterDescriptor;
        if (typeToLibraryPersisterDescriptorMap == null) {
            typeToLibraryPersisterDescriptorMap = Services.getTypeToLibraryPersisterDescriptorMap();
        }
        if ((persisterDescriptor = typeToLibraryPersisterDescriptorMap.get(string)) != null) {
            if (persisterDescriptor.persister == null) {
                Bundle bundle = Platform.getBundle((String)persisterDescriptor.pluginId);
                try {
                    persisterDescriptor.persister = (ILibraryPersister)bundle.loadClass(persisterDescriptor.className).newInstance();
                }
                catch (Exception exception) {
                    CommonPlugin.INSTANCE.log((Object)exception);
                }
            }
            return persisterDescriptor.persister;
        }
        return null;
    }

    public static final ILibraryPersister getDefaultLibraryPersister() {
        return Services.getLibraryPersister(Services.getDefaultLibraryPersistenceType());
    }

    public static final String getDefaultLibraryPersistenceType() {
        if (defaultPersistenceType == null) {
            Services.getTypeToLibraryPersisterDescriptorMap();
            if (defaultPersistenceType == null && Services.getLibraryPersister(XMI_PERSISTENCE_TYPE) != null) {
                defaultPersistenceType = XMI_PERSISTENCE_TYPE;
            }
        }
        return defaultPersistenceType;
    }

    public static final IFileManager getFileManager() {
        if (fileManager == null) {
            fileManager = (IFileManager)Services.getService("fileManager");
        }
        return fileManager;
    }

    private static class PersisterDescriptor {
        String pluginId;
        String type;
        String className;
        boolean isDefault;
        int version;
        ILibraryPersister persister;

        private PersisterDescriptor() {
        }
    }
}

