/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.ui;

import org.eclipse.epf.authoring.ui.AuthoringPerspective;
import org.eclipse.epf.authoring.ui.BrowsingPerspective;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.views.ContentView;
import org.eclipse.epf.common.utils.PerspectiveUtil;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceListener;
import org.eclipse.epf.search.ui.internal.MethodElementViewSorter;
import org.eclipse.epf.search.ui.internal.SearchResultLabelProvider;
import org.eclipse.epf.search.ui.internal.SearchResultTableContentProvider;
import org.eclipse.epf.search.ui.internal.SearchResultTreeContentProvider;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class MethodSearchResultPage
extends AbstractTextSearchViewPage
implements ISelectionChangedListener {
    private IStructuredContentProvider contentProvider;
    private SearchResultLabelProvider labelProvider = new SearchResultLabelProvider();

    public MethodSearchResultPage() {
        LibraryService.getInstance().addListener((ILibraryServiceListener)new LibraryServiceListener(){

            public void libraryClosed(MethodLibrary methodLibrary) {
                MethodSearchResultPage.this.getInput().removeAll();
            }
        });
    }

    public boolean isLayoutSupported(int n) {
        return (n & 1) != 0 || (n & 2) != 0;
    }

    protected void configureTreeViewer(TreeViewer treeViewer) {
        this.contentProvider = new SearchResultTreeContentProvider();
        treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        treeViewer.setSorter((ViewerSorter)new MethodElementViewSorter());
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected void configureTableViewer(TableViewer tableViewer) {
        this.contentProvider = new SearchResultTableContentProvider();
        tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        tableViewer.setSorter((ViewerSorter)new MethodElementViewSorter());
    }

    protected void elementsChanged(Object[] objectArray) {
        if (this.contentProvider != null) {
            if (this.contentProvider instanceof SearchResultTreeContentProvider) {
                ((SearchResultTreeContentProvider)this.contentProvider).elementsChanged(objectArray);
            } else if (this.contentProvider instanceof SearchResultTableContentProvider) {
                ((SearchResultTableContentProvider)this.contentProvider).elementsChanged(objectArray);
            }
        }
    }

    protected void clear() {
        if (this.contentProvider != null) {
            if (this.contentProvider instanceof SearchResultTreeContentProvider) {
                ((SearchResultTreeContentProvider)this.contentProvider).clear();
            } else if (this.contentProvider instanceof SearchResultTableContentProvider) {
                ((SearchResultTableContentProvider)this.contentProvider).clear();
            }
        }
    }

    protected void showMatch(Match match, int n, int n2, boolean bl) throws PartInitException {
        if (match.getElement() instanceof MethodElement && bl) {
            MethodElement methodElement = (MethodElement)match.getElement();
            if (PerspectiveUtil.isActivePerspective((String)BrowsingPerspective.PERSPECTIVE_ID)) {
                IViewPart iViewPart;
                PerspectiveUtil.openPerspective((String)AuthoringPerspective.PERSPECTIVE_ID);
                IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (iWorkbenchPage != null && (iViewPart = iWorkbenchPage.findView("org.eclipse.search.ui.views.SearchView")) != null) {
                    iWorkbenchPage.showView("org.eclipse.search.ui.views.SearchView");
                }
            }
            this.displayEditor(methodElement);
        }
    }

    protected void displayEditor(MethodElement methodElement) {
        if (methodElement instanceof ProcessElement) {
            EditorChooser.getInstance().openEditor((Object)UmaUtil.getProcessComponent((MethodElement)methodElement));
        } else {
            EditorChooser.getInstance().openEditor((Object)methodElement);
        }
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        IStructuredSelection iStructuredSelection;
        Object[] objectArray;
        ISelection iSelection;
        if (PerspectiveUtil.isActivePerspective((String)BrowsingPerspective.PERSPECTIVE_ID) && (iSelection = selectionChangedEvent.getSelection()) instanceof IStructuredSelection && (objectArray = (iStructuredSelection = (IStructuredSelection)iSelection).toArray()) != null && objectArray.length > 0 && objectArray[0] instanceof MethodElement) {
            try {
                this.displayHTMLPage((MethodElement)objectArray[0]);
            }
            catch (PartInitException partInitException) {}
        }
    }

    protected void displayHTMLPage(MethodElement methodElement) throws PartInitException {
        if (methodElement instanceof MethodPlugin || methodElement instanceof ContentPackage) {
            return;
        }
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (iWorkbenchPage != null) {
            IViewPart iViewPart = iWorkbenchPage.findView(ContentView.VIEW_ID);
            if (iViewPart == null) {
                iViewPart = iWorkbenchPage.showView(ContentView.VIEW_ID);
            }
            if (iViewPart != null) {
                ((ContentView)iViewPart).displayHTMLContentPage((Object)methodElement);
            }
        }
    }
}

