/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.wizards;

import java.io.File;
import org.eclipse.epf.authoring.gef.viewer.ActivityDiagramService;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.diagram.ui.service.DiagramImageService;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.diagram.IActivityDiagramService;
import org.eclipse.epf.publishing.services.AbstractViewBuilder;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PublishProgressMonitorDialog
extends ProgressMonitorDialog {
    private Composite diagramViewerHolder;
    private AbstractViewBuilder viewBuilder;

    public PublishProgressMonitorDialog(Shell shell, AbstractViewBuilder abstractViewBuilder) {
        super(shell);
        this.viewBuilder = abstractViewBuilder;
    }

    protected Control createDialogArea(Composite composite) {
        Control control = super.createDialogArea(composite);
        if (this.viewBuilder != null) {
            this.diagramViewerHolder = new Composite(composite, 0);
            this.diagramViewerHolder.setLayoutData((Object)new GridData(1, 1));
            this.diagramViewerHolder.setLayout((Layout)new GridLayout());
            this.diagramViewerHolder.setVisible(false);
            ElementLayoutManager elementLayoutManager = this.viewBuilder.getLayoutMgr();
            String string = AuthoringUIPlugin.getDefault().getPreferenceStore().getString("PUBLISH_NEW_DIAGRAM");
            Boolean bl = new Boolean(true);
            if (string != null && string.length() > 0) {
                bl = new Boolean(string);
            }
            if (bl.booleanValue()) {
                DiagramImageService diagramImageService = new DiagramImageService(this.diagramViewerHolder, new File(elementLayoutManager.getPublishDir()));
                diagramImageService.setConfig(elementLayoutManager.getConfiguration());
                diagramImageService.setPublishedUnCreatedADD(this.viewBuilder.getOptions().isPublishUnopenADD());
                diagramImageService.setPublishADForActivityExtension(this.viewBuilder.getOptions().isPublishBaseAD());
                elementLayoutManager.setActivityDiagramService((IActivityDiagramService)diagramImageService);
            } else {
                ActivityDiagramService activityDiagramService = new ActivityDiagramService(this.diagramViewerHolder, new File(elementLayoutManager.getPublishDir()));
                activityDiagramService.setPublishedUnCreatedADD(this.viewBuilder.getOptions().isPublishUnopenADD());
                activityDiagramService.setPublishADForActivityExtension(this.viewBuilder.getOptions().isPublishBaseAD());
                elementLayoutManager.setActivityDiagramService((IActivityDiagramService)activityDiagramService);
            }
        }
        return control;
    }

    public boolean close() {
        this.viewBuilder = null;
        return super.close();
    }
}

