/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.common.preferences.CommonPreferences;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.epf.publishing.ui.preferences.PublishingUIPreferences;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class SelectDestinationPage
extends BaseWizardPage {
    public static final String PAGE_NAME = SelectDestinationPage.class.getName();
    public static final String PREFERENCE_DELIMITER = "|";
    public static final String SPLIT_PREFERENCE_DELIMITER = "\\|";
    private String defaultPath = PublishingUIPreferences.getDefaultPublishPath();
    protected Shell shell;
    protected Combo dirCombo;
    protected Button browseButton;
    protected Group webAppGroup;
    protected Button staticWebSiteRadioButton;
    protected Composite staticWebSiteComposite;
    protected Button javaWebAppRadioButton;
    protected Composite javaWebAppComposite;
    protected Label webAppNameLabel;
    protected Combo webAppNameCombo;
    protected Button includeSearchCheckbox;
    protected MethodConfiguration config;
    protected List<MethodConfiguration> selectedConfigs = new ArrayList<MethodConfiguration>();

    public SelectDestinationPage(String string) {
        super(string, PublishingUIResources.selectDestinationWizardPage_title, PublishingUIResources.selectDestinationWizardPage_text, PublishingUIPlugin.getDefault().getImageDescriptor("full/wizban/PublishConfiguration.gif"));
    }

    public SelectDestinationPage() {
        this(PAGE_NAME);
    }

    public void createControl(Composite composite) {
        this.shell = composite.getShell();
        Composite composite2 = SelectDestinationPage.createGridLayoutComposite((Composite)composite, (int)1);
        Composite composite3 = SelectDestinationPage.createGridLayoutComposite((Composite)composite2, (int)3);
        SelectDestinationPage.createLabel((Composite)composite3, (String)PublishingUIResources.dirLabel_text);
        this.dirCombo = SelectDestinationPage.createCombobox((Composite)composite3);
        this.browseButton = SelectDestinationPage.createButton((Composite)composite3, (String)AuthoringUIText.BROWSE_BUTTON_TEXT);
        this.webAppGroup = BaseWizardPage.createGridLayoutGroup((Composite)composite2, (String)PublishingUIResources.webAppGroup_text, (int)1);
        this.staticWebSiteRadioButton = SelectDestinationPage.createRadioButton((Composite)this.webAppGroup, (String)PublishingUIResources.staticWebSiteRadioButton_text);
        this.staticWebSiteComposite = SelectDestinationPage.createChildGridLayoutComposite((Composite)this.webAppGroup, (int)1);
        this.javaWebAppRadioButton = SelectDestinationPage.createRadioButton((Composite)this.webAppGroup, (String)PublishingUIResources.dynamicWebAppRadioButton_text);
        this.javaWebAppComposite = SelectDestinationPage.createChildGridLayoutComposite((Composite)this.webAppGroup, (int)3);
        this.includeSearchCheckbox = SelectDestinationPage.createCheckbox((Composite)this.javaWebAppComposite, (String)PublishingUIResources.includeSearchCheckbox_text, (int)3);
        this.webAppNameLabel = SelectDestinationPage.createLabel((Composite)this.javaWebAppComposite, (String)PublishingUIResources.webApplicationNameLabel_text);
        this.webAppNameCombo = SelectDestinationPage.createCombobox((Composite)this.javaWebAppComposite, (int)2);
        this.initControls();
        this.addListeners();
        this.setControl((Control)composite2);
    }

    protected void initControls() {
        String string = this.config != null ? this.config.getGuid() : "";
        String string2 = PublishingUIPreferences.getPublishPath(string);
        if (string2 != null && string2.length() > 0) {
            this.dirCombo.setItems(this.subArray(this.coverStringToArray(string2)));
            this.dirCombo.select(0);
        }
        boolean bl = PublishingUIPreferences.getPublishStaticWebSite(string);
        this.staticWebSiteRadioButton.setSelection(bl);
        this.javaWebAppRadioButton.setSelection(!bl);
        this.includeSearchCheckbox.setSelection(PublishingUIPreferences.getIncludeSearch(string));
        String string3 = PublishingUIPreferences.getWebAppName(string);
        if (string3 != null && string3.length() > 0) {
            this.webAppNameCombo.setItems(new String[]{string3});
            this.webAppNameCombo.setText(string3);
        }
        this.updateControls();
    }

    protected void addListeners() {
        this.dirCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SelectDestinationPage.this.setPageComplete(SelectDestinationPage.this.isPageComplete());
            }
        });
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    DirectoryDialog directoryDialog = new DirectoryDialog(SelectDestinationPage.this.shell, 0);
                    String string = directoryDialog.open();
                    if (string != null) {
                        SelectDestinationPage.this.dirCombo.setText(string);
                    }
                }
                catch (Exception exception) {
                    PublishingUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
            }
        });
        this.staticWebSiteRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SelectDestinationPage.this.updateControls();
            }
        });
        this.javaWebAppRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SelectDestinationPage.this.updateControls();
            }
        });
        this.webAppNameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SelectDestinationPage.this.setPageComplete(SelectDestinationPage.this.isPageComplete());
            }
        });
    }

    protected String[] subArray(String[] stringArray) {
        int n;
        int n2 = CommonPreferences.getPreferenceHistorySize();
        if (n2 < 1) {
            n2 = CommonPreferences.getDefaultPreferenceHistorySize();
        }
        if ((n = stringArray.length) < n2 && stringArray[0].equals(this.defaultPath)) {
            return stringArray;
        }
        n2 = n >= n2 ? n2 : n + 1;
        String[] stringArray2 = new String[n2];
        int n3 = 0;
        while (n3 < n2 - 1) {
            stringArray2[n3] = stringArray[n3];
            ++n3;
        }
        stringArray2[n2 - 1] = stringArray[0].equals(this.defaultPath) ? stringArray[n2] : this.defaultPath;
        return stringArray2;
    }

    protected String[] coverStringToArray(String string) {
        return string.split(SPLIT_PREFERENCE_DELIMITER);
    }

    protected String convertArrayToString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray == null || stringArray.length == 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(PREFERENCE_DELIMITER);
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    protected void updateControls() {
        boolean bl = this.getStaticWebSiteSelection();
        this.webAppNameLabel.setEnabled(!bl);
        this.webAppNameCombo.setEnabled(!bl);
        this.includeSearchCheckbox.setEnabled(!bl);
        this.setPageComplete(this.isPageComplete());
    }

    public void onEnterPage(Object object) {
        if (object != null && object instanceof MethodConfiguration) {
            this.config = (MethodConfiguration)object;
            if (!this.selectedConfigs.contains(this.config)) {
                this.selectedConfigs.add(this.config);
                this.initControls();
            }
        }
    }

    public boolean isPageComplete() {
        String string = this.getPublishDirectory();
        IPath iPath = Path.fromOSString((String)string);
        boolean bl = iPath.isValidPath(string);
        if (!bl) {
            this.setErrorMessage(PublishingUIResources.invalidPathError_msg);
            return false;
        }
        if (!StrUtil.isValidPublishPath((String)string)) {
            this.setErrorMessage(PublishingUIResources.invalidPathCharsError_msg);
            return false;
        }
        this.setErrorMessage(null);
        if (string.length() == 0) {
            return false;
        }
        if (!this.getStaticWebSiteSelection()) {
            String string2 = this.getWebAppName();
            if (string2.length() == 0) {
                this.setErrorMessage(PublishingUIResources.webAppNameError_msg);
                return false;
            }
            if (!StrUtil.isValidName((String)string2)) {
                this.setErrorMessage(PublishingUIResources.webAppNameCharsError_msg);
                return false;
            }
            this.setErrorMessage(null);
        }
        return true;
    }

    public String getPublishDirectory() {
        String string = this.dirCombo.getText().trim();
        if (string.length() > 0) {
            File file = new File(this.dirCombo.getText().trim());
            return file.getAbsolutePath();
        }
        return string;
    }

    protected String[] getPublishDirectoryArray() {
        String string = this.dirCombo.getText();
        if (this.dirCombo.indexOf(string) > 0) {
            this.dirCombo.remove(string);
        }
        if (this.dirCombo.indexOf(string) < 0) {
            this.dirCombo.add(string, 0);
        }
        if (this.dirCombo.indexOf(this.defaultPath) > 0) {
            this.dirCombo.remove(this.defaultPath);
        }
        return this.dirCombo.getItems();
    }

    public boolean getStaticWebSiteSelection() {
        return this.staticWebSiteRadioButton.getSelection();
    }

    public boolean getIncludeSearchSelection() {
        return this.includeSearchCheckbox.getSelection();
    }

    public String getWebAppName() {
        return this.webAppNameCombo.getText().trim();
    }

    public void savePreferences() {
        if (this.config != null) {
            String string = this.config.getGuid();
            PublishingUIPreferences.setPublishPath(string, this.convertArrayToString(this.getPublishDirectoryArray()));
            PublishingUIPreferences.setPublishStaticWebSite(string, this.getStaticWebSiteSelection());
            PublishingUIPreferences.setIncludeSearch(string, this.getIncludeSearchSelection());
            PublishingUIPreferences.setWebAppName(string, this.getWebAppName());
        }
    }
}

