/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.publishing.services.PublishHTMLOptions;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.epf.publishing.ui.preferences.PublishingUIPreferences;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SelectPublishingOptionsPage
extends BaseWizardPage {
    public static final String PAGE_NAME = SelectPublishingOptionsPage.class.getName();
    protected Shell shell;
    protected Text titleText;
    protected Text aboutHTMLText;
    protected Text feedbackURLText;
    protected Button selectHTMLButton;
    protected Button publishGlossaryCheckbox;
    protected Button publishIndexCheckbox;
    protected Text bannerImageText;
    protected Button selectImageButton;
    protected Button checkExternalLinksCheckbox;
    protected Button convertBrokenLinksCheckbox;
    protected Button publishUnopenADDCheckbox;
    protected Button publishBaseADCheckbox;
    protected Button publishLightWeightTreeCheckbox;
    protected Button extraDescriptorInfoCtr;
    protected Button showRelatedDescriptors;
    protected Button showDescriptorsInNavigationTree;
    protected ComboViewer activityTabViewer;
    protected MethodConfiguration config;
    protected List<MethodConfiguration> selectedConfigs = new ArrayList<MethodConfiguration>();
    protected static Map<String, String> activityTabMap = new TreeMap<String, String>();

    static {
        activityTabMap.put("Description", AuthoringUIResources.descriptionPage_title);
        activityTabMap.put("WBS", AuthoringUIResources.ProcessEditor_WorkBreakdownStructure);
        activityTabMap.put("TBS", AuthoringUIResources.ProcessEditor_TeamAllocation);
        activityTabMap.put("WPBS", AuthoringUIResources.ProcessEditor_WorkProductUsage);
    }

    public SelectPublishingOptionsPage(String string) {
        super(string, PublishingUIResources.selectPublishingOptionsWizardPage_title, PublishingUIResources.selectPublishingOptionsWizardPage_text, PublishingUIPlugin.getDefault().getImageDescriptor("full/wizban/PublishConfiguration.gif"));
    }

    public SelectPublishingOptionsPage() {
        this(PAGE_NAME);
    }

    public void createControl(Composite composite) {
        this.shell = composite.getShell();
        Composite composite2 = SelectPublishingOptionsPage.createGridLayoutComposite((Composite)composite, (int)1);
        this.createTitleAndLinksGroup(composite2);
        this.createGlossaryAndIndexGroup(composite2);
        this.createLookAndFeelGroup(composite2);
        this.createValidation(composite2);
        this.createDiagramGenerationGroup(composite2);
        this.createLayoutGroup(composite2);
        this.initControls();
        this.addListeners();
        this.setControl((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, AuthoringUIHelpContexts.CONFIGURATION_PUBLISH_WIZARD_ALL_PAGES_CONTEXT);
    }

    protected Group createTitleAndLinksGroup(Composite composite) {
        Group group = SelectPublishingOptionsPage.createGridLayoutGroup((Composite)composite, (String)PublishingUIResources.titleAndLinksGroup_text, (int)3);
        SelectPublishingOptionsPage.createLabel((Composite)group, (String)PublishingUIResources.titleLabel_text);
        this.titleText = SelectPublishingOptionsPage.createEditableText((Composite)group, (String)"", (int)360, (int)1);
        SelectPublishingOptionsPage.createLabel((Composite)group, (String)"");
        SelectPublishingOptionsPage.createLabel((Composite)group, (String)PublishingUIResources.aboutHTMLLabel_text);
        this.aboutHTMLText = SelectPublishingOptionsPage.createEditableText((Composite)group, (String)"", (int)360, (int)1);
        this.selectHTMLButton = new Button((Composite)group, 0);
        this.selectHTMLButton.setText(AuthoringUIText.SELECT_BUTTON_TEXT);
        SelectPublishingOptionsPage.createLabel((Composite)group, (String)PublishingUIResources.feedbackURLLabel_text);
        this.feedbackURLText = SelectPublishingOptionsPage.createEditableText((Composite)group, (String)"", (int)360, (int)1);
        SelectPublishingOptionsPage.createLabel((Composite)group, (String)"");
        return group;
    }

    protected Group createLookAndFeelGroup(Composite composite) {
        Group group = SelectPublishingOptionsPage.createGridLayoutGroup((Composite)composite, (String)PublishingUIResources.lookAndFeelGroup_text, (int)3);
        SelectPublishingOptionsPage.createLabel((Composite)group, (String)PublishingUIResources.bannerImageLabel_text);
        this.bannerImageText = SelectPublishingOptionsPage.createEditableText((Composite)group, (String)"", (int)360, (int)1);
        this.selectImageButton = new Button((Composite)group, 0);
        this.selectImageButton.setText(AuthoringUIText.SELECT_BUTTON_TEXT);
        return group;
    }

    protected Group createGlossaryAndIndexGroup(Composite composite) {
        Group group = SelectPublishingOptionsPage.createGridLayoutGroup((Composite)composite, (String)PublishingUIResources.glossaryAndIndexGroup_text, (int)2);
        this.publishGlossaryCheckbox = SelectPublishingOptionsPage.createCheckbox((Composite)group, (String)PublishingUIResources.publishGlossaryLabel_text);
        this.publishIndexCheckbox = SelectPublishingOptionsPage.createCheckbox((Composite)group, (String)PublishingUIResources.publishIndexLabel_text);
        return group;
    }

    protected Group createValidation(Composite composite) {
        Group group = SelectPublishingOptionsPage.createGridLayoutGroup((Composite)composite, (String)PublishingUIResources.validationGroup_text, (int)2);
        this.checkExternalLinksCheckbox = SelectPublishingOptionsPage.createCheckbox((Composite)group, (String)PublishingUIResources.checkExternalLinksLabel_text);
        this.convertBrokenLinksCheckbox = SelectPublishingOptionsPage.createCheckbox((Composite)group, (String)PublishingUIResources.convertBrokenLinksLabel_text);
        return group;
    }

    protected Group createDiagramGenerationGroup(Composite composite) {
        Group group = SelectPublishingOptionsPage.createGridLayoutGroup((Composite)composite, (String)PublishingUIResources.diagramGroup_text, (int)1);
        this.publishUnopenADDCheckbox = SelectPublishingOptionsPage.createCheckbox((Composite)group, (String)PublishingUIResources.publishActivityDetailDiagramsLabel_text);
        this.publishBaseADCheckbox = SelectPublishingOptionsPage.createCheckbox((Composite)group, (String)PublishingUIResources.publishExtendedActivityDiagramsLabel_text);
        return group;
    }

    protected Group createLayoutGroup(Composite composite) {
        Group group = SelectPublishingOptionsPage.createGridLayoutGroup((Composite)composite, (String)PublishingUIResources.layoutGroup_text, (int)1);
        this.publishLightWeightTreeCheckbox = SelectPublishingOptionsPage.createCheckbox((Composite)group, (String)PublishingUIResources.publishLightWeightTreeLabel_text);
        this.showDescriptorsInNavigationTree = SelectPublishingOptionsPage.createCheckbox((Composite)group, (String)PublishingUIResources.showDescriptorsInNavigationTree_text);
        this.extraDescriptorInfoCtr = SelectPublishingOptionsPage.createCheckbox((Composite)group, (String)PublishingUIResources.publishExtraDescriptorInfoLabel_text);
        this.showRelatedDescriptors = SelectPublishingOptionsPage.createCheckbox((Composite)group, (String)PublishingUIResources.showRelatedDescriptors_text);
        Composite composite2 = SelectPublishingOptionsPage.createGridLayoutComposite((Composite)group, (int)2);
        ((GridLayout)composite2.getLayout()).marginTop = -5;
        ((GridLayout)composite2.getLayout()).marginLeft = -5;
        SelectPublishingOptionsPage.createLabel((Composite)composite2, (String)PublishingUIResources.selectDefaultActivityTab_text);
        this.activityTabViewer = new ComboViewer(composite2, 2056);
        GridData gridData = new GridData(769);
        this.activityTabViewer.getCombo().setLayoutData((Object)gridData);
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object object) {
                if (object instanceof Map.Entry) {
                    return (String)((Map.Entry)object).getValue();
                }
                return object.toString();
            }
        };
        this.activityTabViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        return group;
    }

    protected void includeAdditionalPublishingOptions(Composite composite) {
    }

    protected void createPublishingOptionsGroups(Composite composite) {
    }

    protected void initControls() {
        String string = this.config != null ? this.config.getGuid() : "";
        this.titleText.setText(PublishingUIPreferences.getTitle(string));
        this.bannerImageText.setText(PublishingUIPreferences.getBannerImage(string));
        this.aboutHTMLText.setText(PublishingUIPreferences.getAboutHTML(string));
        this.feedbackURLText.setText(PublishingUIPreferences.getFeedbackURL(string));
        this.publishGlossaryCheckbox.setSelection(PublishingUIPreferences.getIncludeGlossary(string));
        this.publishIndexCheckbox.setSelection(PublishingUIPreferences.getIncludeIndex(string));
        this.checkExternalLinksCheckbox.setSelection(PublishingUIPreferences.getCheckExternalLinks(string));
        this.convertBrokenLinksCheckbox.setSelection(PublishingUIPreferences.getConvertBrokenLinks(string));
        this.publishUnopenADDCheckbox.setSelection(PublishingUIPreferences.getPublishUnopenActivityDD(string));
        this.publishBaseADCheckbox.setSelection(PublishingUIPreferences.getPublishADForActivityExtension(string));
        this.publishLightWeightTreeCheckbox.setSelection(!PublishingUIPreferences.getLightWeightTree(string));
        this.extraDescriptorInfoCtr.setSelection(PublishingUIPreferences.getExtraDescriptorInfo(string));
        this.showRelatedDescriptors.setSelection(PublishingUIPreferences.getShowRelatedDescriptors(string));
        this.showDescriptorsInNavigationTree.setSelection(PublishingUIPreferences.getShowDescriptorsInNavigationTree(string));
        if (this.activityTabViewer.getCombo().getItemCount() == 0) {
            this.activityTabViewer.add(activityTabMap.entrySet().toArray());
        }
        this.activityTabViewer.getCombo().setText(activityTabMap.get(PublishingUIPreferences.getDefaultActivityTab(string)));
    }

    protected void addListeners() {
        this.selectImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    FileDialog fileDialog = new FileDialog(SelectPublishingOptionsPage.this.shell, 4096);
                    fileDialog.setFilterExtensions(new String[]{"*.gif", "*.jpg", "*.bmp"});
                    String string = fileDialog.open();
                    if (string != null) {
                        SelectPublishingOptionsPage.this.bannerImageText.setText(string);
                    }
                }
                catch (Exception exception) {
                    PublishingUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
            }
        });
        this.selectHTMLButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    FileDialog fileDialog = new FileDialog(SelectPublishingOptionsPage.this.shell, 4096);
                    fileDialog.setFilterExtensions(new String[]{"*.htm", "*.html"});
                    String string = fileDialog.open();
                    if (string != null) {
                        SelectPublishingOptionsPage.this.aboutHTMLText.setText(string);
                    }
                }
                catch (Exception exception) {
                    PublishingUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
            }
        });
        this.aboutHTMLText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SelectPublishingOptionsPage.this.setPageComplete(SelectPublishingOptionsPage.this.isPageComplete());
            }
        });
    }

    public void onEnterPage(Object object) {
        if (object != null && object instanceof MethodConfiguration) {
            MethodConfiguration methodConfiguration = (MethodConfiguration)object;
            if (!this.selectedConfigs.contains(methodConfiguration)) {
                this.selectedConfigs.add(methodConfiguration);
            }
            if (methodConfiguration != this.config) {
                this.config = methodConfiguration;
                this.initControls();
            }
        }
    }

    public boolean isPageComplete() {
        String string = this.aboutHTMLText.getText();
        IPath iPath = Path.fromOSString((String)string);
        boolean bl = iPath.isValidPath(string);
        if (!bl) {
            this.setErrorMessage(PublishingUIResources.invalidAboutPathError_msg);
            return false;
        }
        if (!StrUtil.isValidPublishPath((String)string)) {
            this.setErrorMessage(PublishingUIResources.invalidAboutPathCharsError_msg);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public Object getNextPageData() {
        return this.config;
    }

    public PublishOptions getPublishingOptions() {
        PublishHTMLOptions publishHTMLOptions = new PublishHTMLOptions();
        publishHTMLOptions.setTitle(this.getWebSiteTitle());
        publishHTMLOptions.setBannerImage(this.getBannerImagePath());
        publishHTMLOptions.setAboutHTML(this.getAboutHTMLPath());
        publishHTMLOptions.setFeedbackURL(this.getFeedbackURL());
        publishHTMLOptions.setPublishGlossary(this.getPublishGlossarySelection());
        publishHTMLOptions.setPublishIndex(this.getPublishIndexSelection());
        publishHTMLOptions.setCheckExternalLinks(this.getCheckExternalLinksSelection());
        publishHTMLOptions.setPublishUnopenADD(this.getPublishUnopenADDSelection());
        publishHTMLOptions.setPublishBaseAD(this.getPublishBaseADSelection());
        publishHTMLOptions.setConvertBrokenLinks(this.getConvertBrokenLinksSelection());
        publishHTMLOptions.setPublishLightWeightTree(this.getPublishLightWeightTreeSelection());
        publishHTMLOptions.setShowMethodContentInDescriptors(this.getShowExtraDescriptorInfoSelection());
        publishHTMLOptions.setShowRelatedDescriptors(this.showRelatedDescriptors.getSelection());
        publishHTMLOptions.setShowDescriptorsInNavigationTree(this.showDescriptorsInNavigationTree.getSelection());
        String string = this.getDefaultActivityTabSelection();
        if (string != null) {
            publishHTMLOptions.setDefaultActivityTab(string);
        }
        return publishHTMLOptions;
    }

    protected String getWebSiteTitle() {
        return this.titleText.getText().trim();
    }

    protected String getBannerImagePath() {
        return this.bannerImageText.getText().trim();
    }

    protected String getAboutHTMLPath() {
        return this.aboutHTMLText.getText().trim();
    }

    protected String getFeedbackURL() {
        return this.feedbackURLText.getText().trim();
    }

    protected boolean getPublishGlossarySelection() {
        return this.publishGlossaryCheckbox.getSelection();
    }

    protected boolean getPublishIndexSelection() {
        return this.publishIndexCheckbox.getSelection();
    }

    protected boolean getCheckExternalLinksSelection() {
        return this.checkExternalLinksCheckbox.getSelection();
    }

    protected boolean getConvertBrokenLinksSelection() {
        return this.convertBrokenLinksCheckbox.getSelection();
    }

    protected boolean getPublishUnopenADDSelection() {
        return this.publishUnopenADDCheckbox.getSelection();
    }

    protected boolean getPublishBaseADSelection() {
        return this.publishBaseADCheckbox.getSelection();
    }

    protected boolean getPublishLightWeightTreeSelection() {
        return !this.publishLightWeightTreeCheckbox.getSelection();
    }

    protected boolean getShowExtraDescriptorInfoSelection() {
        return this.extraDescriptorInfoCtr.getSelection();
    }

    protected boolean getShowRelatedDescriptorsSelection() {
        return this.showRelatedDescriptors.getSelection();
    }

    protected boolean getShowDescriptorsInNavigationTreeSelection() {
        return this.showDescriptorsInNavigationTree.getSelection();
    }

    protected String getDefaultActivityTabSelection() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.activityTabViewer.getSelection();
        Map.Entry entry = (Map.Entry)iStructuredSelection.getFirstElement();
        if (entry == null) {
            return null;
        }
        return (String)entry.getKey();
    }

    public void savePreferences() {
        if (this.config != null) {
            String string = this.config.getGuid();
            this.saveTitleAndLinksPreferences(string);
            this.saveGlossaryAndIndexPreferences(string);
            this.saveValidationPreferences(string);
            this.saveDiagramGenerationPreferences(string);
            this.saveLayoutPreferences(string);
        }
    }

    protected void saveTitleAndLinksPreferences(String string) {
        PublishingUIPreferences.setTitle(string, this.getWebSiteTitle());
        PublishingUIPreferences.setBannerImage(string, this.getBannerImagePath());
        PublishingUIPreferences.setAboutHTML(string, this.getAboutHTMLPath());
        PublishingUIPreferences.setFeedbackURL(string, this.getFeedbackURL());
    }

    protected void saveGlossaryAndIndexPreferences(String string) {
        PublishingUIPreferences.setIncludeGlossary(string, this.getPublishGlossarySelection());
        PublishingUIPreferences.setIncludeIndex(string, this.getPublishIndexSelection());
    }

    protected void saveValidationPreferences(String string) {
        PublishingUIPreferences.setCheckExternalLinks(string, this.getCheckExternalLinksSelection());
        PublishingUIPreferences.setConvertBrokenLinks(string, this.getConvertBrokenLinksSelection());
    }

    protected void saveDiagramGenerationPreferences(String string) {
        PublishingUIPreferences.setPublishUnopenActivityDD(string, this.getPublishUnopenADDSelection());
        PublishingUIPreferences.setPublishADForActivityExtension(string, this.getPublishBaseADSelection());
    }

    protected void saveLayoutPreferences(String string) {
        PublishingUIPreferences.setLightWeightTree(string, this.getPublishLightWeightTreeSelection());
        PublishingUIPreferences.setExtraDescriptorInfo(string, this.getShowExtraDescriptorInfoSelection());
        PublishingUIPreferences.setShowRelatedDescriptors(string, this.getShowRelatedDescriptorsSelection());
        PublishingUIPreferences.setShowDescriptorsInNavigationTree(string, this.getShowDescriptorsInNavigationTreeSelection());
        PublishingUIPreferences.setDefaultActivityTab(string, this.getDefaultActivityTabSelection());
    }
}

