/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class TabFolderDrawData
extends DrawData {
    public int tabsWidth;
    public int tabsHeight;
    public Rectangle tabsArea;
    public int selectedX;
    public int selectedWidth;
    public int spacing;

    public TabFolderDrawData() {
        this.state = new int[1];
        if (SWT.getPlatform().equals("gtk")) {
            this.spacing = -2;
        }
    }

    void draw(Theme theme, GC gc, Rectangle bounds) {
        int notebookHandle = theme.notebookHandle;
        int gtkStyle = OS.gtk_widget_get_style(notebookHandle);
        int drawable = gc.getGCData().drawable;
        theme.transferClipping(gc, gtkStyle);
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        int height = bounds.height;
        height -= this.tabsHeight;
        int gap_x = this.selectedX;
        int gap_width = this.selectedWidth;
        int gap_side = 2;
        if ((this.style & 0x400) != 0) {
            gap_side = 3;
        } else {
            y += this.tabsHeight;
        }
        byte[] detail = Converter.wcsToMbcs(null, "notebook", true);
        OS.gtk_paint_box_gap(gtkStyle, drawable, this.getStateType(0), 2, null, notebookHandle, detail, x, y, width, height, gap_side, gap_x, gap_width);
        if (this.tabsArea != null) {
            this.tabsArea.x = bounds.x;
            this.tabsArea.y = bounds.y;
            this.tabsArea.width = bounds.width;
            this.tabsArea.height = this.tabsHeight;
            if ((this.style & 0x400) != 0) {
                this.tabsArea.y += bounds.height - this.tabsHeight;
            }
        }
    }

    int getStateType(int part) {
        return 0;
    }

    int hit(Theme theme, Point position, Rectangle bounds) {
        return bounds.contains(position) ? 0 : -1;
    }
}

