/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.epf.library.edit.ILibraryItemProvider;
import org.eclipse.epf.library.edit.IStatefulItemProvider;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.util.Comparators;
import org.eclipse.epf.library.edit.util.PluginUIPackagesMap;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.provider.MethodPluginItemProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginUIPackagesItemProvider
extends ItemProviderAdapter
implements IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
ILibraryItemProvider,
IStatefulItemProvider {
    public static final String PACKAGE_SEPARATOR = ".";
    private Object parent;
    private String name;
    private Collection<MethodPlugin> plugins;
    private Map<String, PluginUIPackagesItemProvider> pluginPackagesItemProvidersMap = new HashMap<String, PluginUIPackagesItemProvider>();

    public PluginUIPackagesItemProvider(AdapterFactory adapterFactory, String string, Collection<MethodPlugin> collection) {
        super(adapterFactory);
        this.name = string;
        this.plugins = collection;
    }

    @Override
    public void setParent(Object object) {
        this.parent = object;
    }

    public Object getParent() {
        return this.parent;
    }

    @Override
    public Collection getChildrenFeatures(Object object) {
        return super.getChildrenFeatures(object);
    }

    public String getText(Object object) {
        return this.name;
    }

    public Object getImage(Object object) {
        return LibraryEditPlugin.INSTANCE.getImage("full/obj16/package_obj");
    }

    public static String getNameDelta(PluginUIPackagesItemProvider pluginUIPackagesItemProvider, Object object) {
        String string = pluginUIPackagesItemProvider.getFullName();
        String string2 = null;
        if (object instanceof PluginUIPackagesItemProvider) {
            string2 = ((PluginUIPackagesItemProvider)object).getFullName();
        } else if (object instanceof MethodPlugin) {
            string2 = ((MethodPlugin)object).getName();
        }
        if (string2 == null || string.equals(string2)) {
            return string;
        }
        try {
            String string3 = string2.substring(string.length() + 1);
            return string3;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return string2;
        }
    }

    public Collection<Object> getChildren(Object object) {
        return this.addChildren(this.plugins);
    }

    private Collection<Object> addChildren(Collection<MethodPlugin> collection) {
        Set set;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        PluginUIPackagesMap pluginUIPackagesMap = new PluginUIPackagesMap();
        for (MethodPlugin object : collection) {
            String string = PluginUIPackagesItemProvider.getNameDelta(this, object);
            int n = string.indexOf(PACKAGE_SEPARATOR);
            if (n != -1) {
                pluginUIPackagesMap.add(string.substring(0, n), object);
                continue;
            }
            arrayList.add(object);
            set = this.adapterFactory.adapt((Notifier)object, ITreeItemContentProvider.class);
            if (!(set instanceof ILibraryItemProvider)) continue;
            ((ILibraryItemProvider)((Object)set)).setParent(this);
        }
        HashSet hashSet = new HashSet();
        for (Map.Entry entry : pluginUIPackagesMap.entrySet()) {
            String string = (String)entry.getKey();
            set = (Set)entry.getValue();
            PluginUIPackagesItemProvider pluginUIPackagesItemProvider = this.pluginPackagesItemProvidersMap.get(String.valueOf(this.getFullName()) + PACKAGE_SEPARATOR + string);
            if (pluginUIPackagesItemProvider == null) {
                pluginUIPackagesItemProvider = new PluginUIPackagesItemProvider(this.adapterFactory, string, set);
                this.pluginPackagesItemProvidersMap.put(String.valueOf(this.getFullName()) + PACKAGE_SEPARATOR + string, pluginUIPackagesItemProvider);
            } else {
                pluginUIPackagesItemProvider.setPlugins(set);
            }
            hashSet.add(String.valueOf(this.getFullName()) + PACKAGE_SEPARATOR + string);
            pluginUIPackagesItemProvider.setParent(this);
            arrayList.add(pluginUIPackagesItemProvider);
        }
        this.retainPluginPackagesItemProviders(hashSet);
        Collections.sort(arrayList, Comparators.PLUGINPACKAGE_COMPARATOR);
        return arrayList;
    }

    public String getFullName() {
        String string = this.getName();
        Object object = this.getParent();
        while (object instanceof PluginUIPackagesItemProvider) {
            string = String.valueOf(((PluginUIPackagesItemProvider)object).getName()) + PACKAGE_SEPARATOR + string;
            object = ((PluginUIPackagesItemProvider)object).getParent();
        }
        return string;
    }

    public String getName() {
        return this.name;
    }

    public Object getParent(Object object) {
        if (this.parent != null) {
            return this.parent;
        }
        return this.target;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(MethodPlugin.class)) {
            case 0: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
            }
        }
        super.notifyChanged(notification);
    }

    public void dispose() {
        if (this.pluginPackagesItemProvidersMap != null) {
            this.pluginPackagesItemProvidersMap.clear();
            this.pluginPackagesItemProvidersMap = null;
        }
        super.dispose();
    }

    private void retainPluginPackagesItemProviders(Collection<String> collection) {
        Iterator<String> iterator = this.pluginPackagesItemProvidersMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (collection.contains(string)) continue;
            PluginUIPackagesItemProvider pluginUIPackagesItemProvider = this.pluginPackagesItemProvidersMap.get(string);
            if (pluginUIPackagesItemProvider != null) {
                pluginUIPackagesItemProvider.dispose();
            }
            iterator.remove();
        }
    }

    public Collection<MethodPlugin> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(Collection<MethodPlugin> collection) {
        this.plugins = collection;
    }

    public ItemProviderAdapter getPluginItemProvider(MethodPlugin methodPlugin) {
        String string = PluginUIPackagesItemProvider.getNameDelta(this, methodPlugin);
        int n = string.indexOf(PACKAGE_SEPARATOR);
        if (n != -1) {
            PluginUIPackagesItemProvider pluginUIPackagesItemProvider;
            String string2 = string.substring(0, n);
            if (this.pluginPackagesItemProvidersMap != null && (pluginUIPackagesItemProvider = this.pluginPackagesItemProvidersMap.get(String.valueOf(this.getFullName()) + PACKAGE_SEPARATOR + string2)) != null) {
                return pluginUIPackagesItemProvider;
            }
        } else {
            return (MethodPluginItemProvider)TngUtil.getAdapter((EObject)methodPlugin, MethodPluginItemProvider.class);
        }
        return null;
    }
}

