/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.epf.library.edit.ICachedChildrenItemProvider;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.process.DescriptorItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.command.WorkProductDescriptorCreateCopyCommand;
import org.eclipse.epf.library.edit.util.Comparators;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.util.UmaUtil;

public class WorkProductDescriptorItemProvider
extends DescriptorItemProvider
implements ICachedChildrenItemProvider {
    protected Collection cachedChildren;

    public WorkProductDescriptorItemProvider(AdapterFactory adapterFactory, ItemProviderAdapter itemProviderAdapter) {
        super(adapterFactory, itemProviderAdapter);
    }

    public Activity getActivity(Object object) {
        Object object2 = this.getParent(object);
        while (object2 != null) {
            if (object2 instanceof Activity) {
                return (Activity)object2;
            }
            AdapterFactory adapterFactory = this.getRootAdapterFactory();
            ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)adapterFactory.adapt(object2, ITreeItemContentProvider.class);
            object2 = itemProviderAdapter.getParent(object2);
        }
        return null;
    }

    private Object getDescriptor(Activity activity, Artifact artifact) {
        if (activity == null) {
            return null;
        }
        List list = activity.getBreakdownElements();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = list.get(n2);
            if (e instanceof WorkProductDescriptor && artifact == ((WorkProductDescriptor)e).getWorkProduct()) {
                return e;
            }
            ++n2;
        }
        return null;
    }

    public Collection getChildrenFeatures(Object object) {
        return Collections.EMPTY_LIST;
    }

    private void updateCachedChildren(Collection collection) {
    }

    protected void addContainedArtifactDescriptors(WorkProductDescriptor workProductDescriptor, Collection collection) {
        Artifact artifact;
        List list;
        int n;
        Activity activity = UmaUtil.getParentActivity((BreakdownElement)workProductDescriptor);
        if (activity != null && (n = (list = (artifact = (Artifact)workProductDescriptor.getWorkProduct()).getContainedArtifacts()).size()) > 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n2 = 0;
            while (n2 < n) {
                Object object = this.getDescriptor(activity, (Artifact)list.get(n2));
                if (object != null) {
                    arrayList.add(object);
                }
                ++n2;
            }
            if (!arrayList.isEmpty()) {
                Collections.sort(arrayList, Comparators.PRESENTATION_NAME_COMPARATOR);
                collection.addAll(arrayList);
            }
        }
    }

    public Collection getChildren(Object object) {
        WorkProductDescriptor workProductDescriptor3;
        Object object2;
        WorkProductDescriptor workProductDescriptor2 = (WorkProductDescriptor)object;
        if (!(workProductDescriptor2.getWorkProduct() instanceof Deliverable) && (object2 = TngUtil.unwrap(this.getParent(object))) instanceof WorkProductDescriptor && ((WorkProductDescriptor)object2).getWorkProduct() instanceof Deliverable) {
            this.updateCachedChildren(Collections.EMPTY_LIST);
            return Collections.EMPTY_LIST;
        }
        object2 = super.getChildren(object);
        if (!workProductDescriptor2.getDeliverableParts().isEmpty()) {
            for (WorkProductDescriptor workProductDescriptor3 : workProductDescriptor2.getDeliverableParts()) {
                if (workProductDescriptor3.getSuperActivities() != null) continue;
                object2.add(workProductDescriptor3);
            }
        }
        if (workProductDescriptor2.getWorkProduct() instanceof Artifact) {
            this.addContainedArtifactDescriptors(workProductDescriptor2, (Collection)object2);
        }
        AdapterFactory adapterFactory = this.getRootAdapterFactory();
        workProductDescriptor3 = object2.iterator();
        while (workProductDescriptor3.hasNext()) {
            IBSItemProvider iBSItemProvider = (IBSItemProvider)adapterFactory.adapt(workProductDescriptor3.next(), ITreeItemContentProvider.class);
            iBSItemProvider.setParent(object);
        }
        this.updateCachedChildren((Collection)object2);
        return object2;
    }

    public Collection getChildrenFromCache() {
        if (this.cachedChildren == null) {
            this.getChildren(this.target);
        }
        return this.cachedChildren;
    }

    public Collection getRollupChildrenFromCache() {
        return Collections.EMPTY_LIST;
    }

    public void dispose() {
        if (this.cachedChildren != null) {
            this.cachedChildren.clear();
            this.cachedChildren = null;
        }
        super.dispose();
    }

    public void notifyChanged(Notification notification) {
        switch (notification.getFeatureID(WorkProductDescriptor.class)) {
            case 20: 
            case 21: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 25: {
                List list = ProcessUtil.getAffectedElements(notification, null);
                int n = notification.getEventType();
                boolean bl = false;
                for (BreakdownElement breakdownElement : list) {
                    if (n == 3 || n == 5) {
                        ProcessUtil.addToContainer(breakdownElement, (ItemProviderAdapter)this, false);
                    }
                    if (breakdownElement.getSuperActivities() != null) {
                        this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)breakdownElement, false, true));
                        continue;
                    }
                    bl = true;
                }
                if (bl) {
                    this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                }
                return;
            }
            case 7: {
                WorkProductDescriptor workProductDescriptor = (WorkProductDescriptor)notification.getNotifier();
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)workProductDescriptor, false, true));
                if (workProductDescriptor.getWorkProduct() instanceof Deliverable) {
                    for (Object e : workProductDescriptor.getDeliverableParts()) {
                        this.fireNotifyChanged((Notification)new ViewerNotification(notification, e, false, true));
                    }
                }
                return;
            }
            case 5: {
                WorkProduct workProduct;
                Object object = notification.getNotifier();
                boolean bl = object instanceof WorkProductDescriptor && ((workProduct = ((WorkProductDescriptor)object).getWorkProduct()) instanceof Artifact || workProduct instanceof Deliverable);
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), bl, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public void setAttribute(Object object, String string, String string2) {
        WorkProductDescriptor workProductDescriptor = (WorkProductDescriptor)object;
        if (string == "entry_state") {
            workProductDescriptor.setActivityEntryState(string2);
        } else if (string == "exit_state") {
            workProductDescriptor.setActivityExitState(string2);
        } else {
            super.setAttribute(object, string, string2);
        }
    }

    public Collection getEClasses() {
        return ProcessUtil.getPBSEclasses();
    }

    public void moveUp(Object object, IActionManager iActionManager) {
        Object object2 = this.getParent(object);
        if (object2 != null && object2 instanceof Activity) {
            TngUtil.moveUp((Activity)object2, object, this.getEClasses(), iActionManager);
        }
        if (object2 != null && object2 instanceof WorkProductDescriptor) {
            Artifact artifact;
            WorkProduct workProduct = ((WorkProductDescriptor)object2).getWorkProduct();
            if (workProduct instanceof Artifact) {
                artifact = (Artifact)workProduct;
                List list = artifact.getContainedArtifacts();
                WorkProduct workProduct2 = ((WorkProductDescriptor)object).getWorkProduct();
                int n = 0;
                int n2 = 0;
                while (n2 < list.size()) {
                    if (workProduct2.equals(list.get(n2))) {
                        n = n2;
                        break;
                    }
                    ++n2;
                }
                ((EList)artifact.getContainedArtifacts()).move(n, n - 1);
            }
            artifact = this.getActivity(object);
            TngUtil.moveUp((Activity)artifact, object, this.getEClasses(), iActionManager);
        }
    }

    public void moveDown(Object object, IActionManager iActionManager) {
        Object object2 = this.getParent(object);
        if (object2 != null && object2 instanceof Activity) {
            TngUtil.moveDown((Activity)object2, object, this.getEClasses(), iActionManager);
        }
        if (object2 != null && object2 instanceof WorkProductDescriptor) {
            Artifact artifact;
            WorkProduct workProduct = ((WorkProductDescriptor)object2).getWorkProduct();
            if (workProduct instanceof Artifact) {
                artifact = (Artifact)workProduct;
                List list = artifact.getContainedArtifacts();
                WorkProduct workProduct2 = ((WorkProductDescriptor)object).getWorkProduct();
                int n = 0;
                int n2 = 0;
                while (n2 < list.size()) {
                    if (workProduct2.equals(list.get(n2))) {
                        n = n2;
                        break;
                    }
                    ++n2;
                }
                ((EList)artifact.getContainedArtifacts()).move(n, n + 1);
            }
            artifact = this.getActivity(object);
            TngUtil.moveDown((Activity)artifact, object, this.getEClasses(), iActionManager);
        }
    }

    protected Command createCreateCopyCommand(EditingDomain editingDomain, EObject eObject, CopyCommand.Helper helper) {
        return new WorkProductDescriptorCreateCopyCommand(editingDomain, eObject, helper);
    }

    protected Command factorRemoveCommand(EditingDomain editingDomain, CommandParameter commandParameter) {
        Activity activity;
        if (!(commandParameter.getOwner() instanceof Activity) && (activity = this.getActivity(this.target)) != null) {
            IEditingDomainItemProvider iEditingDomainItemProvider = (IEditingDomainItemProvider)this.adapterFactory.adapt((Notifier)activity, IEditingDomainItemProvider.class);
            commandParameter.setOwner((Object)activity);
            return iEditingDomainItemProvider.createCommand((Object)activity, editingDomain, RemoveCommand.class, commandParameter);
        }
        return super.factorRemoveCommand(editingDomain, commandParameter);
    }

    public String getAttribute(Object object, String string) {
        if (string == "model_info") {
            StringBuffer stringBuffer = new StringBuffer();
            if (object instanceof WorkProductDescriptor) {
                ProcessUtil.getWPDModelInfo(stringBuffer, object, this);
            }
            return stringBuffer.toString();
        }
        return super.getAttribute(object, string);
    }
}

