/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.command.BSDropCommand;
import org.eclipse.epf.library.edit.process.command.SynchronizeCommand;
import org.eclipse.epf.library.edit.ui.IActionTypeProvider;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ActivityHandler;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityDropCommand
extends BSDropCommand {
    private Viewer viewer;
    private List<CapabilityPattern> oldPatterns;
    private List<CapabilityPattern> patterns;
    protected Process targetProcess;
    private boolean isDeliveryProcess;
    private int type;
    private Collection<Activity> appliedActivities;
    protected AdapterFactory adapterFactory;
    protected ActivityHandler activityHandler;
    protected boolean preExecuted;
    protected HashSet<?> addedObjects;
    protected IConfigurator activityDeepCopyConfigurator;

    public ActivityDropCommand(Activity activity, List list, Viewer viewer, AdapterFactory adapterFactory) {
        super(activity, list);
        this.setLabel(LibraryEditResources.ActivityDropCommand_label);
        this.viewer = viewer;
        this.adapterFactory = adapterFactory;
        this.targetProcess = TngUtil.getOwningProcess((BreakdownElement)activity);
        this.isDeliveryProcess = this.targetProcess instanceof DeliveryProcess;
        if (this.isDeliveryProcess) {
            this.oldPatterns = new ArrayList<CapabilityPattern>(((DeliveryProcess)this.targetProcess).getIncludesPatterns());
        }
    }

    public ActivityDropCommand(Activity activity, List list, Viewer viewer, AdapterFactory adapterFactory, IConfigurator iConfigurator) {
        this(activity, list, viewer, adapterFactory);
        this.activityDeepCopyConfigurator = iConfigurator;
    }

    @Override
    protected void prepareDropElements() {
        Iterator iterator = this.dropElements.iterator();
        while (iterator.hasNext()) {
            Suppression suppression;
            Object e = iterator.next();
            Process process = TngUtil.getOwningProcess(e);
            if (process == null || !(suppression = Suppression.getSuppression(process)).isSuppressed(e)) continue;
            iterator.remove();
        }
        super.prepareDropElements();
    }

    public void setType(int n) {
        this.type = n;
        if (n == 3) {
            this.runAsJob = true;
        }
    }

    public IStatus checkCopy() {
        for (Object e : this.dropElements) {
            IStatus iStatus;
            if (!(e instanceof Activity) || (iStatus = this.checkCircular((Activity)e)).isOK()) continue;
            return iStatus;
        }
        return Status.OK_STATUS;
    }

    public IStatus checkExtend() {
        for (Activity activity : this.dropElements) {
            Process process = TngUtil.getOwningProcess((BreakdownElement)activity);
            if (process instanceof DeliveryProcess && process != this.targetProcess) {
                return new Status(4, "org.eclipse.epf.library.edit", 0, LibraryEditResources.cannot_copy_or_extend_delivery_process, null);
            }
            IStatus iStatus = this.checkCircular(activity);
            if (iStatus.isOK()) continue;
            return iStatus;
        }
        return Status.OK_STATUS;
    }

    private IStatus checkCircular(Activity activity) {
        boolean bl = DependencyChecker.newCheckAct ? DependencyChecker.checkCircularForMovingVariabilityElement((VariabilityElement)this.activity, Collections.singletonList(activity), true) : DependencyChecker.checkCircularDependency(activity, this.activity).isOK();
        if (!bl) {
            return new Status(4, "org.eclipse.epf.library.edit", 0, LibraryEditResources.circular_dependency_error_msg, null);
        }
        return Status.OK_STATUS;
    }

    @Override
    public void execute() {
        IActionTypeProvider iActionTypeProvider = (IActionTypeProvider)this.viewer;
        if (this.viewer != null) {
            this.viewer = null;
            boolean bl = this.checkCopy().isOK();
            boolean bl2 = this.checkExtend().isOK();
            int[] nArray = new int[1 + (bl ? 1 : 0) + (bl2 ? 1 : 0)];
            int n = 0;
            if (bl) {
                nArray[n++] = 1;
            }
            if (bl2) {
                nArray[n++] = 2;
            }
            nArray[n] = 3;
            iActionTypeProvider.execute(this, nArray);
            return;
        }
        this.activityHandler = new ActivityHandler();
        try {
            if (this.type == 3) {
                this.doDeepCopy();
            } else {
                super.execute();
            }
        }
        finally {
            this.activityHandler.dispose();
        }
        if (TngUtil.DEBUG) {
            System.out.println("ActivityDropCommand.execute(): done");
        }
    }

    protected void doDeepCopy() {
        boolean bl;
        if (!UserInteractionHelper.confirmDeepCopy(this.dropElements)) {
            return;
        }
        MethodConfiguration methodConfiguration = null;
        try {
            methodConfiguration = UserInteractionHelper.chooseDeepCopyConfiguration(this.targetProcess, this.adapterFactory);
        }
        catch (OperationCanceledException operationCanceledException) {
            this.getModifiedResources().clear();
            return;
        }
        try {
            bl = UserInteractionHelper.copyExternalVariationsAllowed(this.targetProcess, this.adapterFactory);
        }
        catch (OperationCanceledException operationCanceledException) {
            this.getModifiedResources().clear();
            return;
        }
        this.activityHandler.setCopyExternalVariations(bl);
        this.activityHandler.setDeepCopyConfig(methodConfiguration);
        this.activityHandler.setTargetProcess(this.targetProcess);
        this.activityHandler.setActivityDeepCopyConfigurator(this.activityDeepCopyConfigurator);
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                ActivityDropCommand.this.activityHandler.setMonitor(iProgressMonitor);
                ActivityDropCommand.this.preExecuted = ActivityDropCommand.this.preExecute();
            }
        };
        UserInteractionHelper.runWithProgress(iRunnableWithProgress, this.getLabel());
        if (this.preExecuted) {
            this.redo();
        }
    }

    @Override
    protected boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        if (this.isDeliveryProcess) {
            this.patterns = new ArrayList<CapabilityPattern>();
        }
        block5: for (Object e : this.dropElements) {
            if (!(e instanceof Activity)) continue;
            Activity activity = (Activity)e;
            switch (this.type) {
                case 3: {
                    this.activityHandler.deepCopy(e);
                    break;
                }
                case 2: {
                    Process process;
                    this.activityHandler.extend(activity);
                    if (this.patterns == null || !((process = TngUtil.getOwningProcess((BreakdownElement)activity)) instanceof CapabilityPattern)) continue block5;
                    this.patterns.add((CapabilityPattern)process);
                    break;
                }
                case 1: {
                    this.activityHandler.copy(activity);
                }
            }
        }
        this.appliedActivities = new ArrayList<Activity>(this.activityHandler.getActivities());
        return !this.appliedActivities.isEmpty();
    }

    @Override
    protected void doExecute() {
        Iterator<Activity> iterator = this.appliedActivities.iterator();
        ProcessPackage processPackage = (ProcessPackage)this.activity.eContainer();
        while (iterator.hasNext()) {
            Activity activity = iterator.next();
            if (activity.eContainer() != null && activity.eContainer().eContainer() != processPackage) {
                processPackage.getChildPackages().add(activity.eContainer());
            }
            if (this.patterns == null || this.patterns.isEmpty()) continue;
            DeliveryProcess deliveryProcess = (DeliveryProcess)this.targetProcess;
            for (Object e : this.patterns) {
                if (deliveryProcess.getIncludesPatterns().contains(e)) continue;
                deliveryProcess.getIncludesPatterns().add(e);
            }
        }
        long l = 0L;
        if (TngUtil.DEBUG) {
            l = System.currentTimeMillis();
        }
        this.activity.getBreakdownElements().addAll(this.appliedActivities);
        if (TngUtil.DEBUG) {
            System.out.println("ActivityDropCommand.doExecute(): new activities added. " + (System.currentTimeMillis() - l));
        }
        if (!this.activityHandler.getDeepCopies().isEmpty()) {
            if (TngUtil.DEBUG) {
                l = System.currentTimeMillis();
            }
            this.postDeepCopy();
            if (TngUtil.DEBUG) {
                System.out.println("ActivityDropCommand.doExecute(): postDeepCopy(). " + (System.currentTimeMillis() - l));
            }
        }
        ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)this.adapterFactory.adapt((Notifier)this.activity, ITreeItemContentProvider.class);
        iTreeItemContentProvider.getChildren((Object)this.activity);
        this.fixDuplicateNames();
        this.getModifiedResources().add(this.activity.eResource());
    }

    private void postDeepCopy() {
        Runnable runnable = new Runnable(){

            public void run() {
                if (ActivityDropCommand.this.addedObjects == null) {
                    ActivityDropCommand.this.addedObjects = new HashSet();
                } else {
                    ActivityDropCommand.this.addedObjects.clear();
                }
                boolean bl = false;
                Iterator iterator = ActivityDropCommand.this.activityHandler.getDeepCopies().iterator();
                while (iterator.hasNext()) {
                    AbstractTreeIterator abstractTreeIterator = new AbstractTreeIterator(iterator.next()){
                        private static final long serialVersionUID = 1L;

                        protected Iterator getChildren(Object object) {
                            if (object instanceof Activity) {
                                return ((Activity)object).getBreakdownElements().iterator();
                            }
                            return Collections.EMPTY_LIST.iterator();
                        }
                    };
                    while (abstractTreeIterator.hasNext()) {
                        Object e = abstractTreeIterator.next();
                        if (!(e instanceof Descriptor)) continue;
                        MethodElement methodElement = ProcessUtil.getAssociatedElement((Descriptor)e);
                        int n = ActivityDropCommand.this.addedObjects.size();
                        ProcessUtil.addToDefaultConfiguration(ActivityDropCommand.this.targetProcess, (EObject)methodElement, ActivityDropCommand.this.addedObjects);
                        if (bl || n == ActivityDropCommand.this.addedObjects.size()) continue;
                        ActivityDropCommand.this.getModifiedResources().add(ActivityDropCommand.this.targetProcess.getDefaultContext().eResource());
                        bl = true;
                    }
                }
            }
        };
        UserInteractionHelper.runWithProgress(runnable, this.getLabel());
        final SynchronizeCommand synchronizeCommand = new SynchronizeCommand(this.activityHandler.getDeepCopies(), this.targetProcess.getDefaultContext(), null, false);
        try {
            runnable = new Runnable(){

                public void run() {
                    synchronizeCommand.initilize();
                }
            };
            UserInteractionHelper.runWithProgress(runnable, LibraryEditResources.ProcessAutoSynchronizeAction_prepare);
            if (synchronizeCommand.isIntialized()) {
                synchronizeCommand.execute();
            }
        }
        finally {
            synchronizeCommand.dispose();
        }
    }

    protected Suppression getSuppression() {
        return Suppression.getSuppression(this.targetProcess);
    }

    private void fixDuplicateNames() {
        Suppression suppression = this.getSuppression();
        for (Activity activity : this.appliedActivities) {
            this.fixDuplicateNames((BreakdownElement)activity, suppression);
            this.fixTeamProfileDuplicateNames(activity, suppression);
        }
    }

    private void fixDuplicateNames(BreakdownElement breakdownElement, Suppression suppression) {
        ActivityDropCommand.fixDuplicateNames(breakdownElement, suppression, this.adapterFactory);
    }

    private static void fixDuplicateNames(BreakdownElement breakdownElement, Suppression suppression, AdapterFactory adapterFactory) {
        String string;
        int n;
        String string2 = breakdownElement.getName();
        if (ProcessUtil.checkBreakdownElementName(adapterFactory, breakdownElement, string2, suppression) != null) {
            n = 1;
            while (true) {
                if (ProcessUtil.checkBreakdownElementName(adapterFactory, breakdownElement, string = String.valueOf(string2) + '_' + n, suppression) == null) {
                    breakdownElement.setName(string);
                    break;
                }
                ++n;
            }
        }
        if (ProcessUtil.checkBreakdownElementPresentationName(adapterFactory, breakdownElement, string2 = ProcessUtil.getPresentationName(breakdownElement), suppression) != null) {
            n = 1;
            while (true) {
                if (ProcessUtil.checkBreakdownElementPresentationName(adapterFactory, breakdownElement, string = String.valueOf(string2) + '_' + n, suppression) == null) {
                    breakdownElement.setPresentationName(string);
                    break;
                }
                ++n;
            }
        }
    }

    private void fixTeamProfileDuplicateNames(Activity activity, Suppression suppression) {
        int n = activity.getBreakdownElements().size() - 1;
        while (n > -1) {
            Object e = activity.getBreakdownElements().get(n);
            if (e instanceof TeamProfile) {
                ActivityDropCommand.fixDuplicateNames((BreakdownElement)e, suppression, (AdapterFactory)TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory());
            } else if (e instanceof Activity) {
                this.fixTeamProfileDuplicateNames((Activity)e, suppression);
            }
            --n;
        }
    }

    @Override
    protected void doUndo() {
        this.activity.getBreakdownElements().removeAll(this.appliedActivities);
        if (this.isDeliveryProcess) {
            DeliveryProcess deliveryProcess = (DeliveryProcess)this.targetProcess;
            deliveryProcess.getIncludesPatterns().clear();
            deliveryProcess.getIncludesPatterns().addAll(this.oldPatterns);
        }
    }

    public static void setName(List list, Activity activity) {
        String string = activity.getName();
        if (!ActivityDropCommand.isNameTaken(list, (DescribableElement)activity, string)) {
            return;
        }
        int n = 1;
        while (true) {
            String string2;
            if (!ActivityDropCommand.isNameTaken(list, (DescribableElement)activity, string2 = String.valueOf(string) + '_' + n)) {
                activity.setName(string2);
                return;
            }
            ++n;
        }
    }

    public static void setDefaultPresentationName(List list, Activity activity) {
        String string = ProcessUtil.getPresentationName((BreakdownElement)activity);
        if (!ActivityDropCommand.isPresentationNameTaken(list, (DescribableElement)activity, string)) {
            return;
        }
        int n = 1;
        while (true) {
            String string2;
            if (!ActivityDropCommand.isPresentationNameTaken(list, (DescribableElement)activity, string2 = String.valueOf(string) + '_' + n)) {
                activity.setPresentationName(string2);
                return;
            }
            ++n;
        }
    }

    private static boolean isNameTaken(List list, DescribableElement describableElement, String string) {
        int n = list.size() - 1;
        while (n > -1) {
            BreakdownElement breakdownElement = (BreakdownElement)list.get(n);
            if (breakdownElement != describableElement && string.equals(breakdownElement.getName())) {
                return true;
            }
            --n;
        }
        return false;
    }

    private static boolean isPresentationNameTaken(List list, DescribableElement describableElement, String string) {
        int n = list.size() - 1;
        while (n > -1) {
            BreakdownElement breakdownElement = (BreakdownElement)list.get(n);
            if (breakdownElement != describableElement && string.equals(ProcessUtil.getPresentationName(breakdownElement))) {
                return true;
            }
            --n;
        }
        return false;
    }

    public Collection<?> getAffectedObjects() {
        if (this.executed) {
            return this.appliedActivities;
        }
        return Collections.EMPTY_LIST;
    }

    public Collection<?> getResult() {
        return this.getAffectedObjects();
    }

    public ActivityHandler getActivityHandler() {
        return this.activityHandler;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public int getType() {
        return this.type;
    }

    public void setActivityDeepCopyConfigurator(IConfigurator iConfigurator) {
        this.activityDeepCopyConfigurator = iConfigurator;
    }
}

