/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.epf.library.edit.command.ResourceAwareCompoundCommand;
import org.eclipse.epf.library.edit.command.ResourceAwareDragAndDropCommand;
import org.eclipse.epf.library.edit.process.command.ActivityDropCommand;
import org.eclipse.epf.library.edit.util.ExposedAdapterFactory;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;

public abstract class BSDragAndDropCommand
extends ResourceAwareDragAndDropCommand {
    public BSDragAndDropCommand(EditingDomain editingDomain, Object object, float f, int n, int n2, Collection collection) {
        super(editingDomain, object, f, n, n2, collection);
    }

    protected boolean prepareDropCopyOn() {
        return this.prepareDropLinkOn();
    }

    protected boolean prepareDropLinkOn() {
        boolean bl;
        this.dragCommand = IdentityCommand.INSTANCE;
        this.dropCommand = UnexecutableCommand.INSTANCE;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList arrayList2 = new ArrayList();
        for (Object object : this.collection) {
            Object object2 = TngUtil.unwrap(object);
            if (TngUtil.isLocked((EObject)this.owner)) {
                return false;
            }
            if (this.accept(object2)) {
                arrayList.add(object2);
                continue;
            }
            if (!(object2 instanceof Activity) || !(this.owner instanceof Activity)) continue;
            Activity activity = (Activity)this.owner;
            if (DependencyChecker.newCheckAct ? !DependencyChecker.checkCircularForMovingVariabilityElement((VariabilityElement)activity, Collections.singletonList(object2), true) : !DependencyChecker.checkCircularDependency((Activity)object2, activity).isOK()) {
                return false;
            }
            arrayList2.add(object);
        }
        if (arrayList.isEmpty() && arrayList2.isEmpty()) {
            bl = false;
        } else {
            Object object;
            object = new ResourceAwareCompoundCommand();
            if (!arrayList.isEmpty()) {
                object.append(this.createDropCommand(this.owner, arrayList));
            }
            if (!arrayList2.isEmpty() && this.owner instanceof Activity) {
                object.append((Command)new ActivityDropCommand((Activity)this.owner, arrayList2, this.getTargetViewer(), ((AdapterFactoryEditingDomain)this.domain).getAdapterFactory()));
            }
            this.dropCommand = object;
            bl = this.dropCommand.canExecute();
        }
        return bl;
    }

    protected Viewer getTargetViewer() {
        if (this.domain instanceof AdapterFactoryEditingDomain) {
            Process process = TngUtil.getOwningProcess((BreakdownElement)this.owner);
            AdapterFactory adapterFactory = ((AdapterFactoryEditingDomain)this.domain).getAdapterFactory();
            if (adapterFactory instanceof ExposedAdapterFactory) {
                for (Object t : Collections.unmodifiableList(((ExposedAdapterFactory)adapterFactory).getChangeListeners())) {
                    Viewer viewer;
                    if (!(t instanceof IContentProvider) || !(t instanceof IViewerProvider) || !((viewer = ((IViewerProvider)t).getViewer()).getInput() instanceof ProcessComponent) || ((ProcessComponent)viewer.getInput()).getProcess() != process) continue;
                    return viewer;
                }
            }
        }
        return null;
    }

    public Collection getAffectedObjects() {
        return this.dropCommand.getAffectedObjects();
    }

    protected abstract boolean accept(Object var1);

    protected abstract Command createDropCommand(Object var1, List var2);
}

