/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.epf.library.edit.process.command.AddMethodElementCommand;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;

public class LinkMethodElementCommand
extends AddMethodElementCommand {
    private Descriptor desc;
    private Object obj;
    private List objects;
    private int featureID;
    private Collection modifiedResources;

    public LinkMethodElementCommand(Descriptor descriptor, Object object, int n) {
        super(TngUtil.getOwningProcess((BreakdownElement)descriptor));
        this.desc = descriptor;
        this.obj = object;
        this.featureID = n;
        if (object != null) {
            this.objects = new ArrayList();
            this.objects.add(object);
        }
        this.modifiedResources = new HashSet();
    }

    public void execute() {
        if (this.desc == null) {
            return;
        }
        if (!super.addToDefaultConfiguration(this.objects)) {
            return;
        }
        if (!this.objects.isEmpty()) {
            this.redo();
        }
    }

    public void redo() {
        switch (this.featureID) {
            case 24: {
                ((TaskDescriptor)this.desc).setTask((Task)this.obj);
                break;
            }
            case 20: {
                ((RoleDescriptor)this.desc).setRole((Role)this.obj);
                break;
            }
            case 22: {
                ((WorkProductDescriptor)this.desc).setWorkProduct((WorkProduct)this.obj);
            }
        }
    }

    public void undo() {
        if (!this.objects.isEmpty()) {
            super.undo();
            switch (this.featureID) {
                case 24: {
                    ((TaskDescriptor)this.desc).setTask(null);
                    break;
                }
                case 20: {
                    ((RoleDescriptor)this.desc).setRole(null);
                    break;
                }
                case 22: {
                    ((WorkProductDescriptor)this.desc).setWorkProduct(null);
                }
            }
        }
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        if (this.desc.eResource() != null && !this.objects.isEmpty()) {
            this.modifiedResources.add(this.desc.eResource());
        }
        return this.modifiedResources;
    }
}

