/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.ui;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IUserInteractionHandler;
import org.eclipse.epf.library.edit.ui.ProcessListSelectionDialog;
import org.eclipse.epf.library.edit.ui.TeamSelection;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.Messenger;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.services.IAccessController;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.MessageException;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;

public final class UserInteractionHelper {
    private static final boolean canInteract = true;

    private UserInteractionHelper() {
    }

    public static boolean canInteract() {
        return true;
    }

    public static int checkAgainstDefaultConfiguration(Process process, Object object) {
        return UserInteractionHelper.checkAgainstDefaultConfiguration(process, object, null);
    }

    public static int checkAgainstDefaultConfiguration(Process process, Object object, IConfigurator iConfigurator) {
        Object object2 = TngUtil.unwrap(object);
        if (!(object2 instanceof MethodElement)) {
            return 0;
        }
        if (iConfigurator == null) {
            iConfigurator = Providers.getConfiguratorFactory().createConfigurator(process.getDefaultContext());
        }
        if (object2 instanceof VariabilityElement) {
            boolean bl = true;
            VariabilityElement variabilityElement = (VariabilityElement)object;
            while (variabilityElement != null) {
                if (!iConfigurator.accept(variabilityElement)) {
                    bl = false;
                    break;
                }
                variabilityElement = variabilityElement.getVariabilityBasedOnElement();
            }
            if (bl) {
                return 1;
            }
        }
        if (iConfigurator.accept(object2)) {
            return 1;
        }
        String string = NLS.bind((String)LibraryEditResources.ui_UserInteractionHelper_defaultconfigcheck, (Object)((MethodElement)object2).getName());
        int n = MsgBox.prompt((String)string);
        if (TngUtil.DEBUG) {
            System.out.println("UserInteractionHelper.checkAgainstDefaultConfiguration(): element=" + object2 + ", path=" + TngUtil.getLabelWithPath(object2));
        }
        switch (n) {
            case 64: {
                IStatus iStatus = TngUtil.checkEdit((EObject)process.getDefaultContext(), null);
                if (!iStatus.isOK()) {
                    return 0;
                }
                return 2;
            }
            case 128: {
                return 0;
            }
            case 256: {
                return -1;
            }
        }
        return 0;
    }

    public static List selectTasks(List list, WorkProduct workProduct) {
        AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public String getColumnText(Object object, int n) {
                if (object instanceof MethodElement) {
                    return TngUtil.getPresentationName(object);
                }
                return super.getText(object);
            }
        };
        AdapterFactoryContentProvider adapterFactoryContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return ((List)object).toArray();
            }
        };
        try {
            ProcessListSelectionDialog processListSelectionDialog = new ProcessListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), list, (IStructuredContentProvider)adapterFactoryContentProvider, (ILabelProvider)adapterFactoryLabelProvider, NLS.bind((String)LibraryEditResources.ui_UserInteractionHelper_wplistdlg_msg, (Object)workProduct.getName()));
            processListSelectionDialog.setTitle(LibraryEditResources.ui_UserInteractionHelper_tasks);
            processListSelectionDialog.setBlockOnOpen(true);
            processListSelectionDialog.open();
            Object[] objectArray = processListSelectionDialog.getResult();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (objectArray != null && objectArray.length > 0) {
                int n = 0;
                while (n < objectArray.length) {
                    arrayList.add(objectArray[n]);
                    ++n;
                }
            }
            ArrayList<Object> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            adapterFactoryLabelProvider.dispose();
            adapterFactoryContentProvider.dispose();
        }
    }

    public static List selectWorkProducts(List list, Role role) {
        AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public String getColumnText(Object object, int n) {
                if (object instanceof MethodElement) {
                    return TngUtil.getPresentationName(object);
                }
                return super.getText(object);
            }
        };
        AdapterFactoryContentProvider adapterFactoryContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return ((List)object).toArray();
            }
        };
        try {
            ProcessListSelectionDialog processListSelectionDialog = new ProcessListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), list, (IStructuredContentProvider)adapterFactoryContentProvider, (ILabelProvider)adapterFactoryLabelProvider, NLS.bind((String)LibraryEditResources.ui_UserInteractionHelper_rolelistdlg_msg, (Object)role.getName()));
            processListSelectionDialog.setTitle(LibraryEditResources.ui_UserInteractionHelper_workproducts);
            processListSelectionDialog.setBlockOnOpen(true);
            processListSelectionDialog.open();
            Object[] objectArray = processListSelectionDialog.getResult();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (objectArray != null && objectArray.length > 0) {
                int n = 0;
                while (n < objectArray.length) {
                    arrayList.add(objectArray[n]);
                    ++n;
                }
            }
            ArrayList<Object> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            adapterFactoryLabelProvider.dispose();
            adapterFactoryContentProvider.dispose();
        }
    }

    public static String requestName(Object object, EStructuralFeature eStructuralFeature, String string, final IValidator iValidator) {
        EObject eObject;
        String string2;
        IInputValidator iInputValidator = new IInputValidator(){

            public String isValid(String string) {
                if (iValidator != null) {
                    return UserInteractionHelper.getSimpleErrorMessage(iValidator.isValid(string));
                }
                return null;
            }
        };
        String string3 = "";
        if (object instanceof EObject && (string2 = (String)(eObject = (EObject)object).eGet(eStructuralFeature)) != null) {
            string3 = string2;
        }
        if ((eObject = new InputDialog(Display.getCurrent().getActiveShell(), string, LibraryEditResources.UserInteractionHelper_ProcessPackage_Name, string3, iInputValidator)).open() == 0) {
            return eObject.getValue().trim();
        }
        return null;
    }

    public static String getSimpleErrorMessage(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        String string2 = "";
        if (n >= 0) {
            string2 = string.substring(0, n);
            String string3 = LibraryEditResources.emptyElementNameError_msg;
            String string4 = LibraryEditResources.duplicateContentFileError_msg;
            String string5 = LibraryEditResources.duplicateElementNameError_msg;
            if (string3 != null && string3.startsWith(string2)) {
                return LibraryEditResources.emptyElementNameError_simple_msg;
            }
            if (string4 != null && string4.startsWith(string2)) {
                return LibraryEditResources.duplicateContentFileError_simple_msg;
            }
            if (string5 != null && string5.startsWith(string2)) {
                return LibraryEditResources.duplicateElementNameError_simple_msg;
            }
        }
        n = n < 0 ? 0 : ++n;
        int n2 = string.indexOf(10);
        if (n2 < 0) {
            n2 = string.length();
        }
        return string.substring(n, n2).trim();
    }

    public static TeamProfile getTeam(Activity activity, Role role) {
        return UserInteractionHelper.getTeam(activity, role, null);
    }

    public static TeamProfile getTeam(Activity activity, Role role, Object object) {
        ArrayList arrayList = new ArrayList();
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        UserInteractionHelper.getTeamsInScope((AdapterFactory)composedAdapterFactory, (BreakdownElement)activity, role, arrayList);
        if (arrayList.size() == 1) {
            return (TeamProfile)arrayList.get(0);
        }
        if (arrayList.size() > 1) {
            return TeamSelection.getSelectedTeam(arrayList, role, object instanceof Shell ? (Shell)object : null);
        }
        return null;
    }

    private static void getTeamsInScope(AdapterFactory adapterFactory, BreakdownElement breakdownElement, Role role, List list) {
        ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)breakdownElement, ITreeItemContentProvider.class);
        Collection collection = iTreeItemContentProvider.getChildren((Object)breakdownElement);
        for (Object e : collection) {
            if (!(e instanceof TeamProfile)) continue;
            TeamProfile teamProfile = (TeamProfile)e;
            ArrayList arrayList = new ArrayList();
            ProcessUtil.getAllSubTeams(teamProfile, arrayList);
            for (Object e2 : arrayList) {
                List list2;
                if (!(e2 instanceof TeamProfile) || !(list2 = ProcessUtil.getRoles(((TeamProfile)e2).getTeamRoles())).contains(role)) continue;
                list.add(e2);
            }
        }
        Object object = iTreeItemContentProvider.getParent((Object)breakdownElement);
        if (object != null) {
            UserInteractionHelper.getTeamsInScope(adapterFactory, (BreakdownElement)object, role, list);
        }
    }

    private static IRunnableContext getRunnableContext() {
        return ExtensionManager.getDefaultUserInteractionHandler().getRunnableContext();
    }

    public static final boolean runWithProgress(final Runnable runnable, final String string) {
        block5: {
            final MultiStatus multiStatus = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, LibraryEditResources.error_reason, null);
            final IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    iProgressMonitor.beginTask(string, -1);
                    iProgressMonitor.subTask("");
                    try {
                        try {
                            runnable.run();
                        }
                        catch (RuntimeException runtimeException) {
                            String string2;
                            RuntimeException runtimeException2 = null;
                            if (runtimeException instanceof MessageException) {
                                string2 = runtimeException.getMessage();
                            } else {
                                StringWriter stringWriter = new StringWriter();
                                runtimeException.printStackTrace(new PrintWriter(stringWriter));
                                string2 = stringWriter.toString();
                                runtimeException2 = runtimeException;
                            }
                            multiStatus.add((IStatus)new Status(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, string2, runtimeException2));
                            iProgressMonitor.done();
                        }
                    }
                    finally {
                        iProgressMonitor.done();
                    }
                }
            };
            try {
                if (Display.getCurrent() == null) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            try {
                                UserInteractionHelper.getRunnableContext().run(true, false, iRunnableWithProgress);
                            }
                            catch (Exception exception) {
                                LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
                            }
                        }
                    });
                } else {
                    UserInteractionHelper.getRunnableContext().run(true, false, iRunnableWithProgress);
                }
                if (!multiStatus.isOK()) {
                    Messenger.INSTANCE.showError(LibraryEditResources.errorDialog_title, LibraryEditResources.error_msgWithDetails, (IStatus)multiStatus);
                    break block5;
                }
                return true;
            }
            catch (Exception exception) {
                LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
            }
        }
        return false;
    }

    public static final boolean runWithProgress(IRunnableWithProgress iRunnableWithProgress, String string) {
        return UserInteractionHelper.runWithProgress(iRunnableWithProgress, false, string);
    }

    public static final boolean runWithProgress(IRunnableWithProgress iRunnableWithProgress, boolean bl, String string) {
        return UserInteractionHelper.runWithProgress(iRunnableWithProgress, UserInteractionHelper.getRunnableContext(), bl, string);
    }

    public static final IStatus runAsJob(IRunnableWithProgress iRunnableWithProgress, String string) {
        Shell shell = MsgBox.getDefaultShell();
        if (shell == null) {
            try {
                iRunnableWithProgress.run((IProgressMonitor)new NullProgressMonitor());
                return Status.OK_STATUS;
            }
            catch (Exception exception) {
                return new Status(4, LibraryEditPlugin.getPlugin().getId(), 0, exception.toString(), (Throwable)exception);
            }
        }
        return UserInteractionHelper.runAsJob(iRunnableWithProgress, string, shell);
    }

    public static final IStatus runAsJob(final IRunnableWithProgress iRunnableWithProgress, String string, Shell shell) {
        WorkspaceJob workspaceJob = new WorkspaceJob(string){

            public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    iRunnableWithProgress.run(iProgressMonitor);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getCause() != null ? invocationTargetException.getCause() : invocationTargetException;
                    Status status = new Status(4, LibraryEditPlugin.getPlugin().getId(), 0, throwable.toString(), throwable);
                    return status;
                }
                catch (InterruptedException interruptedException) {
                    Status status = new Status(4, LibraryEditPlugin.getPlugin().getId(), 0, interruptedException.toString(), (Throwable)interruptedException);
                    return status;
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        PlatformUI.getWorkbench().getProgressService().showInDialog(shell, (Job)workspaceJob);
        workspaceJob.schedule();
        return workspaceJob.getResult();
    }

    public static void runInUI(final IRunnableWithProgress iRunnableWithProgress, String string) {
        Shell shell = MsgBox.getDefaultShell();
        if (shell == null) {
            try {
                iRunnableWithProgress.run((IProgressMonitor)new NullProgressMonitor());
                return;
            }
            catch (Exception exception) {
                LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
                throw new WrappedException(exception);
            }
        }
        WorkbenchJob workbenchJob = new WorkbenchJob(string){

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask("", -1);
                try {
                    iRunnableWithProgress.run(iProgressMonitor);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getCause() != null ? invocationTargetException.getCause() : invocationTargetException;
                    Status status = new Status(4, LibraryEditPlugin.getPlugin().getId(), 0, throwable.toString(), throwable);
                    return status;
                }
                catch (InterruptedException interruptedException) {
                    Status status = new Status(4, LibraryEditPlugin.getPlugin().getId(), 0, interruptedException.toString(), (Throwable)interruptedException);
                    return status;
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        PlatformUI.getWorkbench().getProgressService().showInDialog(shell, (Job)workbenchJob);
        workbenchJob.schedule();
    }

    public static final void runInUIThread(Runnable runnable) {
        UserInteractionHelper.runInUIThread(runnable, false);
    }

    public static final void runInUIThread(Runnable runnable, boolean bl) {
        if (Display.getCurrent() == null) {
            Display display = null;
            try {
                display = Display.getDefault();
            }
            catch (Exception exception) {}
            if (display != null) {
                if (bl) {
                    display.asyncExec(runnable);
                } else {
                    display.syncExec(runnable);
                }
            } else {
                runnable.run();
            }
        } else {
            runnable.run();
        }
    }

    public static final boolean runInUI(Runnable runnable, String string) {
        return UserInteractionHelper.runInUI(runnable, string, null);
    }

    public static final boolean runInUI(final Runnable runnable, final String string, ISchedulingRule iSchedulingRule) {
        Shell shell = MsgBox.getDefaultShell();
        if (shell == null) {
            runnable.run();
            return true;
        }
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    iProgressMonitor.beginTask(string, 2);
                    iProgressMonitor.worked(1);
                    runnable.run();
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        return UserInteractionHelper.runInUI(iRunnableWithProgress, iSchedulingRule, shell);
    }

    public static final boolean runInUI(IRunnableWithProgress iRunnableWithProgress, Shell shell) {
        return UserInteractionHelper.runInUI(iRunnableWithProgress, null, shell);
    }

    public static final boolean runInUI(IRunnableWithProgress iRunnableWithProgress, ISchedulingRule iSchedulingRule, Shell shell) {
        if (shell == null) {
            shell = MsgBox.getDefaultShell();
        }
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)progressMonitorDialog, iRunnableWithProgress, iSchedulingRule);
            return true;
        }
        catch (Exception exception) {
            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
            String string = LibraryEditResources.errorDialog_title;
            ExtensionManager.getDefaultUserInteractionHandler().getMessenger().showError(string, exception.toString(), null, exception);
            return false;
        }
    }

    public static final boolean runWithProgress(final IRunnableWithProgress iRunnableWithProgress, final IRunnableContext iRunnableContext, final boolean bl, final String string) {
        block5: {
            final MultiStatus multiStatus = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, LibraryEditResources.error_reason, null);
            final IRunnableWithProgress iRunnableWithProgress2 = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    iProgressMonitor.beginTask(string, -1);
                    iProgressMonitor.subTask("");
                    try {
                        try {
                            iRunnableWithProgress.run(iProgressMonitor);
                        }
                        catch (RuntimeException runtimeException) {
                            String string2;
                            if (runtimeException instanceof MessageException) {
                                string2 = runtimeException.getMessage();
                            } else {
                                StringWriter stringWriter = new StringWriter();
                                runtimeException.printStackTrace(new PrintWriter(stringWriter));
                                string2 = stringWriter.toString();
                            }
                            multiStatus.add((IStatus)new Status(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, string2, (Throwable)runtimeException));
                            iProgressMonitor.done();
                        }
                    }
                    finally {
                        iProgressMonitor.done();
                    }
                }
            };
            try {
                if (Display.getCurrent() == null) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            try {
                                iRunnableContext.run(true, bl, iRunnableWithProgress2);
                            }
                            catch (Exception exception) {
                                LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
                            }
                        }
                    });
                } else {
                    iRunnableContext.run(true, bl, iRunnableWithProgress2);
                }
                if (!multiStatus.isOK()) {
                    ExtensionManager.getDefaultUserInteractionHandler().getMessenger().showError(LibraryEditResources.errorDialog_title, LibraryEditResources.error_msgWithDetails, (IStatus)multiStatus);
                    break block5;
                }
                return true;
            }
            catch (Exception exception) {
                LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
            }
        }
        return false;
    }

    public static WorkProductDescriptor getDeliverable(Activity activity, WorkProduct workProduct) {
        return null;
    }

    private static void getDeliverablesInScope(AdapterFactory adapterFactory, BreakdownElement breakdownElement, WorkProduct workProduct, List list) {
        ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)breakdownElement, ITreeItemContentProvider.class);
        Collection collection = iTreeItemContentProvider.getChildren((Object)breakdownElement);
        for (Object e : collection) {
            WorkProductDescriptor workProductDescriptor;
            List list2;
            if (!(e instanceof WorkProductDescriptor) || !(ProcessUtil.getAssociatedElement((Descriptor)((WorkProductDescriptor)e)) instanceof Deliverable) || !(list2 = ProcessUtil.getAssociatedElementList((workProductDescriptor = (WorkProductDescriptor)e).getDeliverableParts())).contains(workProduct)) continue;
            list.add(e);
        }
        Object object = iTreeItemContentProvider.getParent((Object)breakdownElement);
        if (object != null) {
            UserInteractionHelper.getDeliverablesInScope(adapterFactory, (BreakdownElement)object, workProduct, list);
        }
    }

    public static IStatus checkModify(EObject eObject, Shell shell) {
        if (TngUtil.isLocked(eObject)) {
            String string = MessageFormat.format(LibraryEditResources.UserInteractionHelper_lockedPlugin, UmaUtil.getMethodPlugin((EObject)eObject).getName());
            return new Status(4, LibraryEditPlugin.INSTANCE.getId(), 0, string, null);
        }
        return TngUtil.checkEdit(eObject, shell);
    }

    public static IStatus checkModify(Collection collection, Shell shell) {
        IAccessController iAccessController = Services.getAccessController();
        if (iAccessController == null) {
            return Status.OK_STATUS;
        }
        Resource[] resourceArray = new Resource[collection.size()];
        collection.toArray(resourceArray);
        return iAccessController.checkModify(resourceArray, (Object)shell);
    }

    public static IResource getWorkspaceResource(Resource resource) {
        if (!resource.getURI().isFile()) {
            return null;
        }
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(resource.getURI().toFileString());
        return iWorkspaceRoot.getFileForLocation((IPath)path);
    }

    public static boolean checkOutOfSynch(Collection collection) {
        IUserInteractionHandler iUserInteractionHandler;
        Object object3;
        Object object22;
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        for (Object object22 : collection) {
            object3 = UserInteractionHelper.getWorkspaceResource((Resource)object22);
            if (object3 == null || object3.isSynchronized(0)) continue;
            arrayList.add((IResource)object3);
        }
        if (arrayList.isEmpty()) {
            return true;
        }
        MultiStatus multiStatus = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, "", null);
        for (Object object3 : arrayList) {
            iUserInteractionHandler = new Status(1, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, object3.getLocation().toOSString(), null);
            multiStatus.add((IStatus)iUserInteractionHandler);
        }
        object22 = LibraryEditResources.update_outofsynch_title;
        object3 = LibraryEditResources.update_outofsynch_msg;
        iUserInteractionHandler = ExtensionManager.getDefaultUserInteractionHandler();
        int[] nArray = new int[2];
        nArray[1] = 1;
        return iUserInteractionHandler.selectOne(nArray, (String)object22, (String)object3, (IStatus)multiStatus) != 1;
    }

    public static boolean checkModifyOpposite(MethodElement methodElement, EStructuralFeature eStructuralFeature, MethodElement methodElement2) {
        NamedElement namedElement;
        OppositeFeature oppositeFeature = OppositeFeature.getOppositeFeature((EStructuralFeature)eStructuralFeature);
        MultiResourceEObject multiResourceEObject = (MultiResourceEObject)methodElement2;
        if (oppositeFeature != null && !oppositeFeature.isMany() && (namedElement = (NamedElement)multiResourceEObject.getOppositeFeatureMap().get(oppositeFeature)) != null && (namedElement instanceof MethodLibrary || namedElement.eContainer() != null) && namedElement.eResource() != null) {
            String string = MessageFormat.format(LibraryEditResources.UserInteractionHelper_errRelationshipExists, methodElement2.getName(), TngUtil.getLabelWithPath(namedElement), methodElement.getName());
            Messenger.INSTANCE.showWarning(LibraryEditResources.errorDialog_title, string);
            return false;
        }
        return true;
    }

    public static IStatus checkConfigurationsToUpdate(AddCommand addCommand, Shell shell) {
        EObject eObject = addCommand.getOwner();
        if (!(eObject instanceof MethodPackage)) {
            return Status.OK_STATUS;
        }
        EStructuralFeature eStructuralFeature = addCommand.getFeature();
        if (!(eStructuralFeature instanceof EReference) || !((EReference)eStructuralFeature).isContainment()) {
            return Status.OK_STATUS;
        }
        ArrayList arrayList = new ArrayList();
        MethodPackage methodPackage = (MethodPackage)eObject;
        for (Object object : addCommand.getCollection()) {
            if (!(object instanceof MethodPackage)) continue;
            TngUtil.getConfigurationsToUpdate(methodPackage, (MethodPackage)object, arrayList);
        }
        if (!arrayList.isEmpty()) {
            HashSet hashSet = new HashSet();
            for (EObject eObject2 : arrayList) {
                Resource resource = eObject2.eResource();
                if (resource == null) continue;
                hashSet.add(resource);
            }
            return UserInteractionHelper.checkModify(hashSet, shell);
        }
        return Status.OK_STATUS;
    }

    public static boolean confirmDeepCopy(Collection collection) {
        if (UserInteractionHelper.canInteract()) {
            boolean bl = false;
            for (Object object : collection) {
                if (!(object instanceof Activity) || !ProcessUtil.hasInherited((Activity)object)) continue;
                bl = true;
                break;
            }
            if (bl) {
                Object object;
                String string = LibraryEditResources.deepCopy_title;
                object = LibraryEditResources.deepCopy_promptMsg;
                int n = ExtensionManager.getDefaultUserInteractionHandler().selectOne(new int[]{4, 5}, string, (String)object, null);
                if (n == 5) {
                    return false;
                }
            }
        }
        return true;
    }

    public static MethodConfiguration chooseDeepCopyConfiguration(Process process, AdapterFactory adapterFactory) {
        MethodConfiguration methodConfiguration;
        IFilter iFilter = ProcessUtil.getFilter(adapterFactory);
        MethodConfiguration methodConfiguration2 = null;
        if (iFilter instanceof IConfigurator && (methodConfiguration = ((IConfigurator)iFilter).getMethodConfiguration()) != null && methodConfiguration != process.getDefaultContext() && UserInteractionHelper.canInteract()) {
            String string = LibraryEditResources.ActivityDropCommand_deepCopy_promptConfigurationMsg;
            switch (MsgBox.prompt((String)string)) {
                case 64: {
                    break;
                }
                case 128: {
                    methodConfiguration2 = methodConfiguration;
                    break;
                }
                case 256: {
                    throw new OperationCanceledException();
                }
            }
        }
        return methodConfiguration2;
    }

    public static boolean copyExternalVariationsAllowed(Process process, AdapterFactory adapterFactory) {
        MethodConfiguration methodConfiguration;
        IFilter iFilter = ProcessUtil.getFilter(adapterFactory);
        if (iFilter instanceof IConfigurator && (methodConfiguration = ((IConfigurator)iFilter).getMethodConfiguration()) != null && methodConfiguration != process.getDefaultContext()) {
            String string = LibraryEditResources.activity_deep_copy_variability_prompt;
            IUserInteractionHandler iUserInteractionHandler = ExtensionManager.getDefaultUserInteractionHandler();
            if (iUserInteractionHandler != null) {
                int n = iUserInteractionHandler.selectOne(new int[]{4, 5, 1}, LibraryEditResources.deepCopy_title, string, null);
                switch (n) {
                    case 4: {
                        return true;
                    }
                    case 5: {
                        return false;
                    }
                    case 1: {
                        throw new OperationCanceledException();
                    }
                }
            }
        }
        return true;
    }
}

