/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.command.INestedCommandProvider;
import org.eclipse.epf.library.edit.command.IUserInteractionHandler;
import org.eclipse.epf.library.edit.util.IDiagramManager;
import org.eclipse.epf.library.edit.util.ITextReferenceReplacer;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtensionManager {
    private static Map IDToExtensionMap = new HashMap();
    private static List<INestedCommandProvider> nestedCommandProviders;
    private static List oppositeFeatureLoaders;

    public static List getExtensions(String string, String string2, Class clazz) {
        ArrayList arrayList;
        block8: {
            arrayList = new ArrayList();
            try {
                IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
                IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string, string2);
                if (iExtensionPoint == null) break block8;
                IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
                int n = 0;
                while (n < iExtensionArray.length) {
                    IExtension iExtension = iExtensionArray[n];
                    String string3 = iExtension.getNamespaceIdentifier();
                    Bundle bundle = Platform.getBundle((String)string3);
                    IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                    int n2 = 0;
                    while (n2 < iConfigurationElementArray.length) {
                        IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                        try {
                            Object t;
                            String string4 = iConfigurationElement.getAttribute("class");
                            if (string4 != null && clazz.isInstance(t = bundle.loadClass(string4).newInstance())) {
                                arrayList.add(t);
                            }
                        }
                        catch (Exception exception) {
                            LibraryEditPlugin.INSTANCE.log(exception);
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
            }
        }
        if (arrayList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getExtension(String string, String string2) {
        String string3 = String.valueOf(string) + '.' + string2;
        Object object = IDToExtensionMap.get(string3);
        if (object == null) {
            Map map = IDToExtensionMap;
            synchronized (map) {
                object = IDToExtensionMap.get(string3);
                if (object == null) {
                    IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
                    IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string, string2);
                    if (iExtensionPoint != null) {
                        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
                        int n = 0;
                        block5: while (n < iExtensionArray.length) {
                            IExtension iExtension = iExtensionArray[n];
                            String string4 = iExtension.getNamespaceIdentifier();
                            Bundle bundle = Platform.getBundle((String)string4);
                            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                            int n2 = 0;
                            while (n2 < iConfigurationElementArray.length) {
                                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                                try {
                                    String string5 = iConfigurationElement.getAttribute("class");
                                    if (string5 != null) {
                                        object = bundle.loadClass(string5).newInstance();
                                        break block5;
                                    }
                                }
                                catch (Exception exception) {
                                    LibraryEditPlugin.INSTANCE.log(exception);
                                }
                                ++n2;
                            }
                            ++n;
                        }
                    }
                    if (object != null) {
                        IDToExtensionMap.put(string3, object);
                    }
                }
            }
        }
        return object;
    }

    public static ITextReferenceReplacer getTextReferenceReplacer() {
        return (ITextReferenceReplacer)ExtensionManager.getExtension(LibraryEditPlugin.getDefault().getId(), "textReferenceReplacer");
    }

    public static List<INestedCommandProvider> getNestedCommandProviders() {
        if (nestedCommandProviders == null) {
            nestedCommandProviders = ExtensionManager.getExtensions(LibraryEditPlugin.getDefault().getId(), "nestedCommandProviders", INestedCommandProvider.class);
        }
        return nestedCommandProviders;
    }

    public static IDiagramManager getDiagramManager() {
        return (IDiagramManager)ExtensionManager.getExtension(LibraryEditPlugin.getDefault().getId(), "diagramManager");
    }

    public static List getOppositeFeatureLoaders() {
        if (oppositeFeatureLoaders == null) {
            oppositeFeatureLoaders = ExtensionManager.getExtensions(LibraryEditPlugin.getDefault().getId(), "oppositeFeatureLoaders", INestedCommandProvider.class);
        }
        return oppositeFeatureLoaders;
    }

    public static IUserInteractionHandler getDefaultUserInteractionHandler() {
        return (IUserInteractionHandler)ExtensionManager.getExtension(LibraryEditPlugin.getDefault().getId(), "userInteractionHandler");
    }
}

