/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyInfoMgr;
import org.eclipse.epf.library.edit.validation.IDependencyInfo;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.util.AssociationHelper;

public class UpwardReachableInfo
implements IDependencyInfo {
    private DependencyInfoMgr mgr;
    private MethodElement element;
    private HashMap parentMap;
    private boolean complete = false;
    private boolean debug = false;

    protected UpwardReachableInfo(DependencyInfoMgr dependencyInfoMgr, MethodElement methodElement) {
        this.mgr = dependencyInfoMgr;
        this.element = methodElement;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void build(boolean bl) {
        if (this.debug) {
            System.out.println("LD> build: " + this);
        }
        this.buildInner(bl);
    }

    private void buildInner(boolean bl) {
        IDependencyInfo iDependencyInfo = this.mgr.getProcessedInfo(this.element);
        if (iDependencyInfo != null) {
            if (iDependencyInfo == this && this.complete) {
                return;
            }
            throw new RuntimeException("Internal error in buildInner: " + iDependencyInfo);
        }
        this.mgr.addToProcessed(this);
        if (this.debug) {
            System.out.println("LD> buildInner: " + this);
            System.out.println("");
        }
        this.buildInner_(bl);
    }

    private void buildInner_(boolean bl) {
        int n;
        List list = this.getMixedParentList();
        int n2 = n = list == null ? 0 : list.size();
        if (n == 0) {
            this.complete = true;
            return;
        }
        this.parentMap = new HashMap();
        ArrayList<UpwardReachableInfo> arrayList = null;
        int n3 = 0;
        while (n3 < n) {
            MethodElement methodElement = (MethodElement)list.get(n3);
            UpwardReachableInfo upwardReachableInfo = (UpwardReachableInfo)this.mgr.getProcessedInfo(methodElement);
            if (upwardReachableInfo == null) {
                upwardReachableInfo = new UpwardReachableInfo(this.mgr, methodElement);
                this.parentMap.put(methodElement.getGuid(), upwardReachableInfo);
                upwardReachableInfo.buildInner(bl);
            } else {
                this.parentMap.put(methodElement.getGuid(), upwardReachableInfo);
                if (bl) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<UpwardReachableInfo>();
                    }
                    arrayList.add(upwardReachableInfo);
                }
            }
            ++n3;
        }
        this.complete = true;
        if (bl && arrayList != null) {
            n3 = 0;
            while (n3 < arrayList.size()) {
                this.reachableBy((IDependencyInfo)arrayList.get(n3));
                ++n3;
            }
        }
    }

    public boolean reachableBy(IDependencyInfo iDependencyInfo) {
        if (!(iDependencyInfo instanceof UpwardReachableInfo)) {
            throw new UnsupportedOperationException();
        }
        if (this.debug) {
            System.out.println("LD> Entry reachableBy: this -> " + this);
            System.out.println("LD> Entry reachableBy: info -> " + iDependencyInfo);
            System.out.println("");
        }
        return this.reachableBy((UpwardReachableInfo)iDependencyInfo, new Stack(), new HashMap());
    }

    private boolean reachableBy(UpwardReachableInfo upwardReachableInfo, Stack stack, Map map) {
        stack.push(upwardReachableInfo);
        if (this.debug) {
            System.out.println("LD> reachableBy: this -> " + this);
            System.out.println("LD> reachableBy: info -> " + upwardReachableInfo);
            System.out.println("");
        }
        boolean bl = this.reachableBy_(upwardReachableInfo, stack, map);
        stack.pop();
        return bl;
    }

    private boolean reachableBy_(UpwardReachableInfo upwardReachableInfo, Stack stack, Map map) {
        HashMap hashMap = upwardReachableInfo.parentMap;
        if (hashMap == null || hashMap.isEmpty()) {
            return false;
        }
        if (hashMap.containsKey(this.element.getGuid())) {
            if (this.debug) {
                System.out.println("LD> Contained in parentMap of: " + upwardReachableInfo);
            }
            stack.push(this);
            this.mgr.logCircularDependency((Stack)stack.clone());
            stack.pop();
            return true;
        }
        if (map.containsKey(upwardReachableInfo.getElement().getGuid())) {
            return false;
        }
        map.put(upwardReachableInfo.getElement().getGuid(), upwardReachableInfo);
        for (UpwardReachableInfo upwardReachableInfo2 : hashMap.values()) {
            if (upwardReachableInfo2.containedIn(stack)) {
                if (this.debug) {
                    System.out.println("LD> containedIn stack: " + upwardReachableInfo);
                }
                stack.push(upwardReachableInfo2);
                this.mgr.logCircularDependency((Stack)stack.clone());
                stack.pop();
                return true;
            }
            if (!this.reachableBy(upwardReachableInfo2, stack, map)) continue;
            return true;
        }
        return false;
    }

    public MethodElement getElement() {
        return this.element;
    }

    private List getMixedParentList() {
        ArrayList arrayList = new ArrayList();
        this.collectParentList(this.element, arrayList);
        VariabilityElement variabilityElement = (VariabilityElement)this.element;
        this.collectParentListByVariantPaths(variabilityElement, arrayList);
        if (variabilityElement.getVariabilityType() == VariabilityType.REPLACES_LITERAL) {
            this.mgr.addToReplacerMap(this);
        }
        return arrayList;
    }

    private void collectParentList(MethodElement methodElement, List list) {
        int n;
        List list2 = UpwardReachableInfo.getParentList(methodElement);
        int n2 = n = list2 == null ? 0 : list2.size();
        if (this.mgr.isMoveElement(methodElement)) {
            if (n > 1 && !(methodElement instanceof CustomCategory)) {
                throw new UnsupportedOperationException();
            }
        } else if (n > 0) {
            list.addAll(list2);
        }
    }

    public static List getParentList(MethodElement methodElement) {
        ArrayList<MethodElement> arrayList = null;
        if (methodElement instanceof CustomCategory) {
            arrayList = AssociationHelper.getCustomCategories((DescribableElement)((CustomCategory)methodElement));
        } else if (methodElement instanceof Deliverable) {
            arrayList = AssociationHelper.getDeliverables((WorkProduct)((Deliverable)methodElement));
        } else {
            MethodElement methodElement2 = UpwardReachableInfo.getSameTypeParent(methodElement);
            if (methodElement2 != null) {
                arrayList = new ArrayList<MethodElement>();
                arrayList.add(methodElement2);
            }
        }
        return arrayList;
    }

    private void collectParentListByVariantPaths(VariabilityElement variabilityElement, List list) {
        VariabilityType variabilityType;
        Object object;
        if (!this.mgr.isFilterElement((MethodElement)variabilityElement)) {
            object = variabilityElement.getVariabilityBasedOnElement();
            VariabilityType variabilityType2 = variabilityType = object == null ? null : variabilityElement.getVariabilityType();
            if (variabilityType == VariabilityType.CONTRIBUTES_LITERAL || variabilityType == VariabilityType.REPLACES_LITERAL) {
                list.add(object);
            }
        }
        if (this.mgr.isDndElement((MethodElement)variabilityElement)) {
            return;
        }
        object = TngUtil.getImmediateVarieties(variabilityElement, VariabilityType.EXTENDS_LITERAL);
        while (object.hasNext()) {
            variabilityType = (VariabilityElement)object.next();
            if (this.mgr.isFilterElement((MethodElement)variabilityType)) continue;
            list.add(variabilityType);
        }
    }

    private static MethodElement getSameTypeParent(MethodElement methodElement) {
        if (methodElement instanceof Activity) {
            return ((Activity)methodElement).getSuperActivities();
        }
        MethodElement methodElement2 = (MethodElement)methodElement.eContainer();
        return methodElement2.getType() == methodElement.getType() ? methodElement2 : null;
    }

    public String toString() {
        return TngUtil.getLabelWithPath(this.element);
    }

    public boolean inheritAncestor(VariabilityType variabilityType) {
        VariabilityElement variabilityElement = ((VariabilityElement)this.element).getVariabilityBasedOnElement();
        if (variabilityElement == null) {
            return false;
        }
        if (((VariabilityElement)this.element).getVariabilityType() != variabilityType) {
            return false;
        }
        ArrayList arrayList = new ArrayList();
        this.collectParentList(this.element, arrayList);
        if (arrayList != null && arrayList.contains(variabilityElement)) {
            return true;
        }
        UpwardReachableInfo upwardReachableInfo = (UpwardReachableInfo)this.parentMap.get(variabilityElement.getGuid());
        for (UpwardReachableInfo upwardReachableInfo2 : this.parentMap.values()) {
            if (upwardReachableInfo == upwardReachableInfo2 || !upwardReachableInfo.reachableBy(upwardReachableInfo2)) continue;
            return true;
        }
        return false;
    }

    private boolean containedIn(List list) {
        int n;
        int n2 = n = list == null ? 0 : list.size();
        if (n == 0) {
            return false;
        }
        String string = this.getElement().getGuid();
        if (n == 1) {
            return string.equals(((IDependencyInfo)list.get(0)).getElement().getGuid());
        }
        HashMap<String, IDependencyInfo> hashMap = new HashMap<String, IDependencyInfo>();
        int n3 = 0;
        while (n3 < n) {
            IDependencyInfo iDependencyInfo = (IDependencyInfo)list.get(n3);
            hashMap.put(iDependencyInfo.getElement().getGuid(), iDependencyInfo);
            ++n3;
        }
        return hashMap.containsKey(string);
    }
}

