/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epf.export.services.ConfigurationSpec;
import org.eclipse.epf.export.services.LibraryDocument;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.services.ConfigSpecs;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.UmaFactory;
import org.w3c.dom.Element;

public class ConfigSpecsImportManager {
    ConfigSpecsImportManager() {
    }

    public ConfigSpecs getConfigSpecs(final LibraryDocument libraryDocument) {
        final ConfigSpecs configSpecs = new ConfigSpecs();
        File file = new File(libraryDocument.getFile().getParent(), "configurations");
        LibraryDocument.ConfigDocVisitor configDocVisitor = new LibraryDocument.ConfigDocVisitor(){

            public void visit(File file, Element element) {
                ConfigSpecs.Entry entry = configSpecs.newEntry();
                entry.configSpec = libraryDocument.getConfigurationSpec(element);
                entry.existingConfig = ConfigSpecsImportManager.this.getExistingConfig(entry.configSpec.guid);
            }
        };
        LibraryDocument.visitConfigFiles((File)file, (LibraryDocument.ConfigDocVisitor)configDocVisitor);
        return configSpecs;
    }

    private MethodConfiguration getExistingConfig(String string) {
        MethodConfiguration[] methodConfigurationArray = LibraryServiceUtil.getMethodConfigurations((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary());
        if (methodConfigurationArray == null || methodConfigurationArray.length == 0) {
            return null;
        }
        int n = 0;
        while (n < methodConfigurationArray.length) {
            MethodConfiguration methodConfiguration = methodConfigurationArray[n];
            if (methodConfiguration.getGuid().equals(string)) {
                return methodConfiguration;
            }
            ++n;
        }
        return null;
    }

    public void doImport(ConfigSpecs configSpecs) {
        try {
            MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
            LibraryUtil.loadAll((MethodLibrary)methodLibrary);
            Iterator iterator = configSpecs.iterator();
            while (iterator.hasNext()) {
                ConfigSpecs.Entry entry = (ConfigSpecs.Entry)iterator.next();
                if (!entry.selected) continue;
                MethodConfiguration methodConfiguration = this.createConfig(entry.configSpec);
                if (entry.existingConfig != null) {
                    List list = entry.existingConfig.getMethodPluginSelection();
                    List list2 = entry.existingConfig.getMethodPackageSelection();
                    List list3 = entry.existingConfig.getProcessViews();
                    for (Object e : methodConfiguration.getMethodPluginSelection()) {
                        if (list.contains(e)) continue;
                        list.add(e);
                    }
                    for (Object e : methodConfiguration.getMethodPackageSelection()) {
                        if (list2.contains(e)) continue;
                        list2.add(e);
                    }
                    for (Object e : methodConfiguration.getProcessViews()) {
                        if (list2.contains(e)) continue;
                        list3.add(e);
                    }
                    continue;
                }
                methodLibrary.getPredefinedConfigurations().add(methodConfiguration);
            }
            LibraryUtil.saveLibrary((MethodLibrary)methodLibrary, (boolean)false, (boolean)false);
        }
        catch (Exception exception) {
            ImportPlugin.getDefault().getLogger().logError((Throwable)exception);
        }
    }

    private MethodConfiguration createConfig(ConfigurationSpec configurationSpec) {
        MethodConfiguration methodConfiguration = UmaFactory.eINSTANCE.createMethodConfiguration();
        methodConfiguration.setName(configurationSpec.name);
        methodConfiguration.setBriefDescription(configurationSpec.brief_desc);
        methodConfiguration.setGuid(configurationSpec.guid);
        List list = methodConfiguration.getMethodPluginSelection();
        List list2 = methodConfiguration.getMethodPackageSelection();
        List list3 = methodConfiguration.getProcessViews();
        ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
        if (iLibraryManager != null) {
            MethodElement methodElement;
            for (String string : configurationSpec.pluginIds) {
                methodElement = iLibraryManager.getMethodElement(string);
                if (methodElement == null || list.contains(methodElement)) continue;
                list.add(methodElement);
            }
            for (String string : configurationSpec.packageIds) {
                methodElement = iLibraryManager.getMethodElement(string);
                if (methodElement == null || list2.contains(methodElement)) continue;
                list2.add(methodElement);
            }
            for (String string : configurationSpec.viewIds) {
                methodElement = iLibraryManager.getMethodElement(string);
                if (methodElement == null || list3.contains(methodElement)) continue;
                list3.add(methodElement);
            }
        }
        return methodConfiguration;
    }
}

