/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.importing.services.FileModifyChecker;
import org.eclipse.epf.services.Services;

public class DirCopy {
    File srcDir;
    File targetDir;
    List newFiles = new ArrayList();
    List oldFiles = new ArrayList();
    List deletedFiles = new ArrayList();
    private static String CP_FODLER = "capabilitypatterns/";
    private static String DP_FODLER = "deliveryprocesses/";
    private static final String CVS_FOLDER = String.valueOf(File.separator) + "CVS" + File.separator;
    private static final String SVN_FOLDER = String.valueOf(File.separator) + ".svn" + File.separator;
    private static final String[] ignoreFiles = new String[]{".copyarea.dat", ".copyarea.db"};

    public DirCopy(File file, File file2) {
        this.srcDir = file;
        this.targetDir = file2;
        this.prepare();
    }

    public IStatus execute() {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.oldFiles) {
            if (!DirCopy.needCopy(new File(this.srcDir, string2), new File(this.targetDir, string2))) continue;
            arrayList.add(new File(this.targetDir, string2).getAbsolutePath());
        }
        IStatus iStatus = FileModifyChecker.checkModify(arrayList);
        if (!iStatus.isOK()) {
            return iStatus;
        }
        string2 = Services.getFileManager();
        for (String string3 : this.deletedFiles) {
            File file;
            String[] stringArray;
            File file2 = new File(this.targetDir, string3);
            string2.delete(file2.getAbsolutePath());
            string3 = string3.replace(File.separatorChar, '/');
            if (!string3.startsWith(CP_FODLER) && !string3.startsWith(DP_FODLER) || (stringArray = (file = file2.getParentFile()).list()) != null && stringArray.length != 0) continue;
            string2.delete(file.getAbsolutePath());
        }
        for (String string3 : this.oldFiles) {
            FileUtil.copyFile((File)new File(this.srcDir, string3), (File)new File(this.targetDir, string3));
        }
        for (String string3 : this.newFiles) {
            FileUtil.copyFile((File)new File(this.srcDir, string3), (File)new File(this.targetDir, string3));
        }
        return iStatus;
    }

    private void prepare() {
        List list = this.getAllFiles(this.srcDir);
        List list2 = this.getAllFiles(this.targetDir);
        while (list2.size() > 0) {
            String string = (String)list2.remove(0);
            if (list.contains(string)) {
                this.oldFiles.add(string);
                list.remove(string);
                continue;
            }
            this.deletedFiles.add(string);
        }
        this.newFiles.addAll(list);
    }

    private List getAllFiles(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        FileUtil.getAllFiles((File)file, arrayList, (boolean)true);
        URI uRI = file.toURI();
        int n = 0;
        while (n < arrayList.size()) {
            File file2 = (File)arrayList.get(n);
            if (this.canIgnore(file2.getAbsolutePath()) || this.canIgnore(file2)) {
                arrayList.remove(n);
                continue;
            }
            URI uRI2 = uRI.relativize(file2.toURI());
            arrayList.set(n, uRI2.getPath());
            ++n;
        }
        return arrayList;
    }

    private boolean canIgnore(String string) {
        if (string.indexOf(CVS_FOLDER) >= 0) {
            return true;
        }
        return string.indexOf(SVN_FOLDER) >= 0;
    }

    private boolean canIgnore(File file) {
        String string = file.getName();
        int n = 0;
        while (n < ignoreFiles.length) {
            if (string.equals(ignoreFiles[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean needCopy(File file, File file2) {
        boolean bl = true;
        if (file2.exists()) {
            bl = file2.lastModified() != file.lastModified() || file2.length() != file.length();
        }
        return bl;
    }
}

