/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.services.ElementDiffTree;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Dimension;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Point;

public class LibraryDiffManager {
    private MethodLibrary baseLibrary;
    private MethodLibrary importLibraty;
    private Map diffElementMap = new HashMap();
    private Map importElementMap = new HashMap();
    private Map currentElementMap = new HashMap();
    ElementDiffTree rootDiffTree = null;
    private boolean debug = ImportPlugin.getDefault().isDebugging();

    public LibraryDiffManager(MethodLibrary methodLibrary, MethodLibrary methodLibrary2) {
        this.baseLibrary = methodLibrary;
        this.importLibraty = methodLibrary2;
        this.rootDiffTree = new ElementDiffTree((MethodElement)methodLibrary, (MethodElement)methodLibrary2);
    }

    public MethodLibrary getImportingLibrary() {
        return this.importLibraty;
    }

    public ElementDiffTree buildDiffTree() {
        List list;
        Object object2;
        this.buildUIDMap((List)this.importLibraty.eContents(), this.importElementMap, true, false);
        this.buildUIDMap((List)this.baseLibrary.eContents(), this.currentElementMap, true, true);
        List list2 = this.baseLibrary.getMethodPlugins();
        for (Object object2 : list2) {
            list = TngUtil.getAllSystemPackages((MethodPlugin)object2);
            List list3 = TngUtil.getContentCategoryPackages((MethodPlugin)object2);
            for (Object object3 : list3) {
                if (!list.contains(object3)) continue;
                list.remove(object3);
            }
            int n = 0;
            while (n < list.size()) {
                Object object3;
                object3 = (MethodPackage)list.get(n);
                if (TngUtil.isRootCutomCategoryPackage(object3)) {
                    list.remove(object3);
                    break;
                }
                ++n;
            }
            this.iterateElement((MethodElement)object2, this.rootDiffTree, list);
        }
        List list4 = this.baseLibrary.getPredefinedConfigurations();
        object2 = list4.iterator();
        while (object2.hasNext()) {
            list = (MethodConfiguration)object2.next();
            this.iterateElement((MethodElement)list, this.rootDiffTree, new ArrayList());
        }
        this.handleNewElements((MethodElement)this.importLibraty);
        return this.rootDiffTree;
    }

    public ElementDiffTree getDiffTree() {
        return this.rootDiffTree;
    }

    public Map getDiffTreeMap() {
        return this.diffElementMap;
    }

    private void iterateElement(MethodElement methodElement, ElementDiffTree object, List list) {
        Object object2;
        if (!this.selectable(methodElement)) {
            return;
        }
        if (!list.contains(methodElement) && !(methodElement instanceof MethodLibrary)) {
            object2 = methodElement.getGuid();
            ElementDiffTree elementDiffTree = new ElementDiffTree(methodElement, (MethodElement)this.importElementMap.get(object2));
            this.diffElementMap.put(object2, elementDiffTree);
            ((ElementDiffTree)object).addChild(elementDiffTree);
            object = elementDiffTree;
        }
        if ((object2 = methodElement.eContents()) != null) {
            for (Object e : object2) {
                if (e instanceof MethodElement) {
                    MethodElement methodElement2 = (MethodElement)e;
                    if (!this.selectable(methodElement2)) continue;
                    this.iterateElement(methodElement2, (ElementDiffTree)object, list);
                    continue;
                }
                if (!this.debug) continue;
                System.out.println("Error! " + e + " is not a MethodElement object");
            }
        }
    }

    private void handleNewElements(MethodElement methodElement) {
        if (!this.selectable(methodElement)) {
            return;
        }
        if (this.isNewElement(methodElement)) {
            MethodElement methodElement2;
            MethodElement methodElement3 = (MethodElement)methodElement.eContainer();
            while (this.isNewElement(methodElement3)) {
                methodElement = methodElement3;
                methodElement3 = (MethodElement)methodElement3.eContainer();
            }
            if (methodElement3 instanceof MethodLibrary) {
                methodElement3 = this.baseLibrary;
            }
            if ((methodElement2 = (MethodElement)this.currentElementMap.get(methodElement3.getGuid())) == null) {
                methodElement2 = this.baseLibrary;
            }
            ElementDiffTree elementDiffTree = new ElementDiffTree(null, methodElement, methodElement2);
            ElementDiffTree elementDiffTree2 = null;
            while (elementDiffTree2 == null && methodElement3 != null) {
                elementDiffTree2 = (ElementDiffTree)this.diffElementMap.get(methodElement3.getGuid());
                methodElement3 = (MethodElement)methodElement3.eContainer();
            }
            if (elementDiffTree2 == null) {
                elementDiffTree2 = this.rootDiffTree;
            }
            elementDiffTree2.addChild(elementDiffTree);
        } else {
            EList eList = methodElement.eContents();
            for (Object e : eList) {
                if (!(e instanceof MethodElement)) continue;
                MethodElement methodElement4 = (MethodElement)e;
                this.handleNewElements(methodElement4);
            }
        }
    }

    private boolean isNewElement(MethodElement methodElement) {
        if (methodElement == null || methodElement instanceof MethodLibrary) {
            return false;
        }
        return !this.currentElementMap.containsKey(methodElement.getGuid());
    }

    private void buildUIDMap(List list, Map map, boolean bl, boolean bl2) {
        for (Object e : list) {
            if (e instanceof MethodElement) {
                MethodElement methodElement = (MethodElement)e;
                if (!this.selectable(methodElement) && !bl2) continue;
                String string = methodElement.getGuid();
                map.put(string, methodElement);
                if (!bl) continue;
                this.buildUIDMap((List)methodElement.eContents(), map, bl, bl2);
                continue;
            }
            if (e instanceof Point || e instanceof Dimension || e instanceof MethodElementProperty) continue;
            ImportPlugin.getDefault().getLogger().logError("Import error. " + e + " is not a MethodElement object");
        }
    }

    public boolean selectable(MethodElement methodElement) {
        return methodElement instanceof MethodLibrary || methodElement instanceof MethodPlugin || methodElement instanceof MethodPackage || methodElement instanceof MethodConfiguration;
    }

    public MethodElement getExistingElement(String string) {
        return (MethodElement)this.currentElementMap.get(string);
    }
}

