/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceScanner {
    public static final Pattern p_src_ref = Pattern.compile("src\\s*=\\s*\"(.*?)\"", 34);
    public static final Pattern p_href_ref = Pattern.compile("href\\s*=\\s*\"(.*?)\"", 34);
    File srcLibRoot;
    File targetLibRoot;
    private Map newFileMap = new HashMap();
    private Map existingFileMap = new HashMap();
    Map<String, String> renamePluginMap;

    public ResourceScanner(File file, File file2, Map<String, String> map) {
        this.srcLibRoot = file;
        this.targetLibRoot = file2;
        this.renamePluginMap = map;
    }

    public void scan(MethodElement methodElement, String string) {
        try {
            String string2;
            Matcher matcher = p_src_ref.matcher(string);
            while (matcher.find()) {
                string2 = matcher.group(1);
                this.processUrl(methodElement, string2);
            }
            matcher = p_href_ref.matcher(string);
            while (matcher.find()) {
                string2 = matcher.group(1);
                this.processUrl(methodElement, string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void processUrl(MethodElement methodElement, String string) {
        this.processUrl(methodElement, string, null);
    }

    private void processUrl(MethodElement methodElement, String string, MethodPlugin methodPlugin) {
        if (string == null) {
            return;
        }
        int n = string.indexOf("#");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("?")) >= 0) {
            string = string.substring(0, n);
        }
        if (string.trim().length() == 0) {
            return;
        }
        File file = null;
        File file2 = null;
        try {
            if (methodElement != null) {
                ILibraryResourceManager iLibraryResourceManager = ResourceHelper.getResourceMgr((MethodElement)methodElement);
                String string2 = ResourceHelper.getElementPath((MethodElement)methodElement);
                file = new File(new File(this.srcLibRoot, string2 = this.getElementPathWithRenamedPlugin(string2)), string);
                if (!file.isFile() || !file.exists()) {
                    string = NetUtil.decodeURL((String)string);
                    file = new File(new File(this.srcLibRoot, string2), string);
                }
                String string3 = iLibraryResourceManager.getPhysicalPluginPath(methodElement);
                File file3 = new File(string3).getParentFile();
                file2 = new File(new File(file3, string2), string);
            } else {
                if (methodPlugin == null) {
                    throw new UnsupportedOperationException();
                }
                File file4 = new File(this.srcLibRoot, methodPlugin.getName());
                file = new File(file4, string);
                if (!file.isFile() || !file.exists()) {
                    string = NetUtil.decodeURL((String)string);
                    file = new File(file4, string);
                }
                ILibraryResourceManager iLibraryResourceManager = ResourceHelper.getResourceMgr((MethodElement)methodPlugin);
                String string4 = iLibraryResourceManager.getPhysicalPluginPath((MethodElement)methodPlugin);
                file2 = new File(string4, string);
            }
            if (file.isFile() && file.exists()) {
                file = file.getCanonicalFile();
                if ((file2 = file2.getCanonicalFile()).exists()) {
                    if (!(this.existingFileMap.containsKey(file) || file.length() == file2.length() && file.lastModified() == file2.lastModified())) {
                        this.existingFileMap.put(file, file2);
                    }
                } else if (!this.newFileMap.containsKey(file)) {
                    this.newFileMap.put(file, file2);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String getElementPathWithRenamedPlugin(String string) {
        String string2;
        String string3;
        int n;
        if (this.renamePluginMap != null && !this.renamePluginMap.isEmpty() && (n = string.indexOf("\\")) > 0 && (string3 = this.renamePluginMap.get(string2 = string.substring(0, n))) != null) {
            return String.valueOf(string3) + string.substring(n);
        }
        return string;
    }

    public void copyResource(String string, MethodPlugin methodPlugin) {
        this.processUrl(null, string, methodPlugin);
    }

    public void copyResource(MethodElement methodElement, String string) {
        this.processUrl(methodElement, string);
    }

    public List getFilesTobeReplaced() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.existingFileMap.size() > 0) {
            for (File file : this.existingFileMap.values()) {
                String string;
                if (file == null || arrayList.contains(string = file.getAbsolutePath())) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public void execute() {
        File file;
        File file2;
        for (Map.Entry entry : this.newFileMap.entrySet()) {
            file2 = (File)entry.getKey();
            file = (File)entry.getValue();
            FileUtil.copyFile((File)file2, (File)file);
        }
        for (Map.Entry entry : this.existingFileMap.entrySet()) {
            file2 = (File)entry.getKey();
            file = (File)entry.getValue();
            FileUtil.copyFile((File)file2, (File)file);
        }
    }
}

