/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ui.viewer;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.diagram.DiagramInfo;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Process;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractDiagramGraphicalViewer {
    protected Composite parent;
    protected GraphicalViewer graphicalViewer;
    protected Object wrapper;

    public AbstractDiagramGraphicalViewer(Composite composite) {
        this.parent = composite;
        this.createGraphicalViewer();
    }

    public AbstractDiagramGraphicalViewer(Composite composite, Object object) {
        this.parent = composite;
        this.wrapper = object;
        this.createGraphicalViewer();
    }

    protected void createGraphicalViewer() {
        this.graphicalViewer = new ScrollingGraphicalViewer();
        this.graphicalViewer.createControl(this.parent);
        this.configureGraphicalViewer();
    }

    public GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    protected void configureGraphicalViewer() {
        this.getGraphicalViewer().getControl().setBackground(ColorConstants.listBackground);
        ScrollingGraphicalViewer scrollingGraphicalViewer = (ScrollingGraphicalViewer)this.getGraphicalViewer();
        ScalableFreeformRootEditPart scalableFreeformRootEditPart = new ScalableFreeformRootEditPart();
        scrollingGraphicalViewer.setRootEditPart((RootEditPart)scalableFreeformRootEditPart);
        scrollingGraphicalViewer.setEditPartFactory(this.createEditPartFactory());
    }

    protected IFigure getFigure() {
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        LayerManager layerManager = (LayerManager)graphicalViewer.getEditPartRegistry().get(LayerManager.ID);
        IFigure iFigure = layerManager.getLayer((Object)"Printable Layers");
        return iFigure;
    }

    protected void setSuppressionToDiagram(Diagram diagram) {
        Process process;
        Object object = diagram.getObject();
        if (object instanceof BreakdownElement && (process = TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)object))) != null) {
            diagram.setSuppression(Suppression.getSuppression((Process)process));
        }
    }

    public Image createDiagramImage() {
        IFigure iFigure = this.getFigure();
        SWTGraphics sWTGraphics = null;
        GC gC = null;
        Image image = null;
        try {
            try {
                Rectangle rectangle = iFigure.getBounds();
                int n = rectangle.height;
                int n2 = rectangle.width;
                Display display = Display.getDefault();
                image = new Image((Device)display, n2, n);
                gC = new GC((Drawable)image);
                sWTGraphics = new SWTGraphics(gC);
                iFigure.paint((Graphics)sWTGraphics);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (sWTGraphics != null) {
                    sWTGraphics.dispose();
                }
                if (gC != null) {
                    gC.dispose();
                }
            }
        }
        finally {
            if (sWTGraphics != null) {
                sWTGraphics.dispose();
            }
            if (gC != null) {
                gC.dispose();
            }
        }
        return image;
    }

    public void dispose() {
        try {
            if (this.graphicalViewer != null) {
                EditPart editPart;
                Control control = this.graphicalViewer.getControl();
                if (control != null) {
                    control.dispose();
                }
                if ((editPart = this.graphicalViewer.getContents()) != null) {
                    editPart.setModel(null);
                }
                this.graphicalViewer = null;
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    protected abstract EditPartFactory createEditPartFactory();

    protected abstract EditPart createEditPart(Object var1, IFilter var2, Suppression var3);

    protected abstract String getDiagramType();

    protected void cleanUpDiagram() {
    }

    public abstract DiagramInfo getDiagramInfo();

    public abstract EditPart loadDiagram(Object var1, boolean var2, IFilter var3, Suppression var4);

    public abstract void setMethodConfiguration(MethodConfiguration var1);
}

