/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.dialogs;

import java.io.File;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.dialogs.BaseDialog;
import org.eclipse.epf.richtext.html.Image;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddImageDialog
extends BaseDialog {
    protected Image image = new Image();
    protected Text urlText;
    protected Button browseButton;
    protected SelectionAdapter browseSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
            fileDialog.setFilterExtensions(new String[]{"*.gif", "*.jpg", "*.bmp"});
            String string = fileDialog.open();
            if (string != null && string.length() > 0) {
                File file = new File(string);
                try {
                    String string2 = file.toURL().toExternalForm();
                    AddImageDialog.this.urlText.setText(string2);
                }
                catch (Exception exception) {
                    AddImageDialog.this.logger.logError((Throwable)exception);
                }
            }
        }
    };
    protected ModifyListener urlTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            if (AddImageDialog.this.okButton != null) {
                AddImageDialog.this.okButton.setEnabled(AddImageDialog.this.urlText.getText().trim().length() > 0);
            }
        }
    };

    public AddImageDialog(Shell shell) {
        super(shell);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.numColumns = 3;
        Label label = new Label(composite2, 0);
        label.setText(RichTextResources.urlLabel_text);
        this.urlText = new Text(composite2, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 300;
        this.urlText.setLayoutData((Object)gridData);
        this.urlText.addModifyListener(this.urlTextListener);
        this.browseButton = new Button(composite2, 0);
        this.browseButton.setText(RichTextResources.browseButton_text);
        this.browseButton.addSelectionListener((SelectionListener)this.browseSelectionAdapter);
        super.getShell().setText(RichTextResources.addImageDialog_title);
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        super.createButtonsForButtonBar(composite);
        this.okButton.setEnabled(false);
    }

    protected void okPressed() {
        String string = this.urlText.getText();
        if (string != null && string.length() > 0) {
            this.image.setURL(string);
        }
        super.okPressed();
    }

    public Image getImage() {
        return this.image;
    }
}

