/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.edit.command.MethodElementAddCommand;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.util.ContentResourceScanner;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.library.util.SAXParserXMI;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.GuidanceDescription;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.osgi.util.NLS;

public class CopyAttachmentsToNewLocation
extends MethodElementAddCommand.BasicResourceManager {
    private Collection modifiedResourceSet;
    private boolean debug = LibraryPlugin.getDefault().isDebugging();
    private Map elementToOldPluginMap;
    private MethodPlugin lastOldPlugin = null;

    public Collection copyReferencedContents(Collection collection, Map map) {
        this.lastOldPlugin = null;
        this.modifiedResourceSet = new HashSet();
        if (map == null) {
            return this.modifiedResourceSet;
        }
        this.elementToOldPluginMap = map;
        for (Object e : collection) {
            Resource resource;
            if (e instanceof Resource) {
                resource = (Resource)e;
                for (EObject eObject : resource.getContents()) {
                    this.HandleAttachmentsPlugin(eObject);
                }
                continue;
            }
            if (!(e instanceof EObject)) continue;
            resource = (EObject)e;
            this.HandleAttachmentsPlugin((EObject)resource);
        }
        return this.modifiedResourceSet;
    }

    private void HandleAttachmentsPlugin(EObject eObject) {
        Object object;
        Object object2;
        ContentDescription contentDescription = null;
        if (this.elementToOldPluginMap != null && (MethodPlugin)this.elementToOldPluginMap.get(eObject) != null) {
            this.lastOldPlugin = (MethodPlugin)this.elementToOldPluginMap.get(eObject);
        }
        if (this.lastOldPlugin != null) {
            if (eObject instanceof DescribableElement) {
                DescribableElement describableElement = (DescribableElement)eObject;
                try {
                    Comparable<File> comparable;
                    Object object3;
                    File file;
                    Object object4;
                    URI uRI;
                    URI uRI2 = describableElement.getShapeicon();
                    if (uRI2 != null) {
                        uRI = TngUtil.getFullPathURI((EObject)describableElement, (URI)uRI2);
                        object4 = uRI2.getPath();
                        if (((String)object4).indexOf(this.lastOldPlugin.getName()) < 0) {
                            uRI = new File(String.valueOf(ResourceHelper.getPluginPath(this.lastOldPlugin)) + File.separator + (String)object4).toURI();
                        }
                        if (!(file = new File(((File)(object3 = new File(uRI))).getAbsolutePath().replaceFirst("\\" + File.separator + this.lastOldPlugin.getName() + "\\" + File.separator, "\\" + File.separator + UmaUtil.getMethodPlugin((EObject)describableElement).getName() + "\\" + File.separator))).exists()) {
                            FileUtil.copyFile((File)object3, (File)file);
                        }
                        comparable = new URI(NetUtil.encodeFileURL((String)FileUtil.getRelativePath((File)file, (File)new File(ResourceHelper.getPluginPath((MethodElement)describableElement)))));
                        describableElement.setShapeicon((URI)comparable);
                        this.modifiedResourceSet.add(describableElement.eResource());
                    }
                    if ((uRI = describableElement.getNodeicon()) != null) {
                        object4 = TngUtil.getFullPathURI((EObject)describableElement, (URI)uRI);
                        object3 = uRI.getPath();
                        if (((String)object3).indexOf(this.lastOldPlugin.getName()) < 0) {
                            object4 = new File(String.valueOf(ResourceHelper.getPluginPath(this.lastOldPlugin)) + File.separator + (String)object3).toURI();
                        }
                        if (!(comparable = new File((file = new File((URI)object4)).getAbsolutePath().replaceFirst("\\" + File.separator + this.lastOldPlugin.getName() + "\\" + File.separator, "\\" + File.separator + UmaUtil.getMethodPlugin((EObject)describableElement).getName() + "\\" + File.separator))).exists()) {
                            FileUtil.copyFile((File)file, (File)comparable);
                        }
                        URI uRI3 = new URI(NetUtil.encodeFileURL((String)FileUtil.getRelativePath((File)comparable, (File)new File(ResourceHelper.getPluginPath((MethodElement)describableElement)))));
                        describableElement.setNodeicon(uRI3);
                        this.modifiedResourceSet.add(describableElement.eResource());
                    }
                }
                catch (Exception exception) {
                    LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
                this.HandleAttachmentsPlugin((EObject)describableElement.getPresentation());
                return;
            }
            if (eObject instanceof ContentDescription) {
                contentDescription = (ContentDescription)eObject;
            } else if (eObject instanceof MethodElement) {
                contentDescription = (MethodElement)eObject;
            } else if (this.debug) {
                System.out.println("CopyAttachmentsToNewLocation.HandleAttachmentsPlugin: unknown type " + eObject);
            }
            if (contentDescription != null && contentDescription.eResource() != null) {
                Object object5;
                String string;
                Object object6;
                object2 = ResourceHelper.getResourceMgr((MethodElement)contentDescription);
                object = ResourceHelper.getResourceMgr((MethodElement)this.lastOldPlugin);
                ContentResourceScanner contentResourceScanner = this.getScanner((MethodElement)contentDescription);
                String string2 = ResourceHelper.getElementPath((MethodElement)contentDescription);
                if (string2 == null || string2.length() == 0) {
                    LibraryPlugin.getDefault().getLogger().logWarning(NLS.bind((String)LibraryResources.CopyAttachmentsToNewLocation_log_noContentPath, (Object[])new Object[]{contentDescription.getName()}));
                    return;
                }
                String string3 = string2.replaceFirst(UmaUtil.getMethodPlugin((EObject)contentDescription).getName(), this.lastOldPlugin.getName());
                for (Object object7 : contentDescription.eClass().getEAllAttributes()) {
                    object6 = contentDescription.eGet((EStructuralFeature)object7);
                    if (!(object6 instanceof String) || (string = (String)object6).length() <= 0 || (object5 = contentResourceScanner.resolveResourcesPlugin(string, string2, string3)) == null || ((String)object5).trim().length() == 0 || string.equals(object5)) continue;
                    contentDescription.eSet((EStructuralFeature)object7, object5);
                    this.modifiedResourceSet.add(contentDescription.eResource());
                }
                if (contentDescription instanceof GuidanceDescription) {
                    Object object7;
                    object7 = ((GuidanceDescription)contentDescription).getAttachments();
                    object6 = TngUtil.convertGuidanceAttachmentsToList((String)object7);
                    Iterator iterator = object6.iterator();
                    while (iterator.hasNext()) {
                        string = (String)iterator.next();
                        if (string == null || string.trim().length() <= 0 || ((Matcher)(object5 = ResourceHelper.p_template_attachment_url.matcher(string))).find()) continue;
                        File file = new File(object.resolve((MethodElement)this.lastOldPlugin, string3));
                        File file2 = new File(file, string);
                        File file3 = new File(object2.getPhysicalPath((MethodElement)contentDescription));
                        File file4 = new File(file3, string);
                        if (file4.exists()) continue;
                        FileUtil.copyFile((File)file2, (File)file4);
                    }
                }
            }
        }
        object2 = eObject.eAllContents();
        while (object2.hasNext()) {
            object = (EObject)object2.next();
            this.HandleAttachmentsPlugin((EObject)object);
        }
    }

    private ContentResourceScanner getScanner(MethodElement methodElement) {
        File file;
        ILibraryResourceManager iLibraryResourceManager = ResourceHelper.getResourceMgr(methodElement);
        if (iLibraryResourceManager == null) {
            return null;
        }
        String string = iLibraryResourceManager.getLogicalPluginPath(methodElement);
        File file2 = file = new File(iLibraryResourceManager.getPhysicalPluginPath(methodElement));
        ContentResourceScanner contentResourceScanner = new ContentResourceScanner(file, file2, string, this.getValidator());
        return contentResourceScanner;
    }

    public IContentValidator getValidator() {
        return null;
    }

    public static void copyAttachmentsLibrary(String string, String string2, List list, IProgressMonitor iProgressMonitor) {
        if (list == null) {
            list = FileUtil.fileList((File)new File(string2), (String)"xmi");
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.subTask(LibraryResources.copyingAttachmentsTask_name);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            File file;
            if (iProgressMonitor != null) {
                iProgressMonitor.worked(1);
            }
            if (!(file = (File)iterator.next()).exists()) continue;
            SAXParserXMI sAXParserXMI = new SAXParserXMI(null);
            sAXParserXMI.parse(file.getAbsolutePath());
            ContentResourceScanner contentResourceScanner = new ContentResourceScanner(new File(string), new File(string2), null);
            CopyAttachmentsToNewLocation.HandleAttachments(sAXParserXMI.xmiMap, contentResourceScanner, file.getParent().substring(string2.length()));
        }
    }

    private static void HandleAttachments(HashMap hashMap, ContentResourceScanner contentResourceScanner, String string) {
        String string2 = SAXParserXMI.getElementContent(hashMap);
        if (string2 != null) {
            contentResourceScanner.resolveResources(string2, string);
        }
        for (HashMap hashMap2 : (ArrayList)hashMap.get("children")) {
            CopyAttachmentsToNewLocation.HandleAttachments(hashMap2, contentResourceScanner, string);
        }
    }
}

