/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.library.edit.command.AddToCategoryCommand;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.RemoveFromCategoryCommand;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.Misc;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.DisciplineGrouping;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.RoleSetGrouping;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.Tool;
import org.eclipse.epf.uma.ToolMentor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductType;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.UmaUtil;

public class LibraryManager {
    private static Comparator nameComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            if (object instanceof MethodElement && object2 instanceof MethodElement) {
                return ((MethodElement)object).getName().compareTo(((MethodElement)object2).getName());
            }
            return 0;
        }
    };
    private static LibraryManager instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final LibraryManager getInstance() {
        if (instance != null) return instance;
        Class<LibraryManager> clazz = LibraryManager.class;
        synchronized (LibraryManager.class) {
            if (instance != null) return instance;
            instance = new LibraryManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected LibraryManager() {
    }

    public List getAvailableCategories(MethodElement methodElement, Class clazz, String[] stringArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)methodElement);
        if (methodPlugin != null) {
            Object object;
            int n;
            List list;
            ContentPackage contentPackage = UmaUtil.findContentPackage((MethodPlugin)methodPlugin, (String[])stringArray);
            if (contentPackage != null) {
                list = (EList)contentPackage.getContentElements();
                n = 0;
                while (n < list.size()) {
                    object = list.get(n);
                    if (clazz.isInstance(object) && object != methodElement) {
                        arrayList.add(object);
                    }
                    ++n;
                }
            }
            list = Misc.getAllBase((MethodPlugin)methodPlugin);
            n = 0;
            while (n < list.size()) {
                object = UmaUtil.findContentPackage((MethodPlugin)((MethodPlugin)list.get(n)), (String[])stringArray);
                if (object != null) {
                    EList eList = (EList)object.getContentElements();
                    int n2 = 0;
                    while (n2 < eList.size()) {
                        VariabilityElement variabilityElement;
                        Object object2 = eList.get(n2);
                        if (clazz.isInstance(object2) && (variabilityElement = (VariabilityElement)object2).getVariabilityBasedOnElement() == null) {
                            int n3 = 0;
                            while (n3 < arrayList.size()) {
                                if (((VariabilityElement)arrayList.get(n3)).getVariabilityBasedOnElement() == variabilityElement) break;
                                ++n3;
                            }
                            if (n3 == arrayList.size()) {
                                arrayList.add(variabilityElement);
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        Collections.sort(arrayList, nameComparator);
        return arrayList;
    }

    public List getAvailableDisciplines(MethodElement methodElement) {
        return this.getAvailableCategories(methodElement, Discipline.class, ModelStructure.DEFAULT_DISCIPLINE_DEF_PATH);
    }

    public List getAvailableDomains(MethodElement methodElement) {
        List list = this.getAvailableCategories(methodElement, Domain.class, ModelStructure.DEFAULT_DOMAIN_PATH);
        ArrayList arrayList = new ArrayList();
        for (Domain domain : list) {
            AbstractTreeIterator abstractTreeIterator = new AbstractTreeIterator(domain, true){

                protected Iterator getChildren(Object object) {
                    return ((Domain)object).getSubdomains().iterator();
                }
            };
            while (abstractTreeIterator.hasNext()) {
                arrayList.add(abstractTreeIterator.next());
            }
        }
        Collections.sort(arrayList, nameComparator);
        return arrayList;
    }

    public List getAvailableWorkProductTypes(MethodElement methodElement) {
        return this.getAvailableCategories(methodElement, WorkProductType.class, ModelStructure.DEFAULT_WORK_PRODUCT_TYPE_PATH);
    }

    public List getAvailableRoleSets(MethodElement methodElement) {
        return this.getAvailableCategories(methodElement, RoleSet.class, ModelStructure.DEFAULT.roleSetPath);
    }

    public List getAvailableCustomCategories(MethodElement methodElement) {
        List list = this.getAvailableCategories(methodElement, CustomCategory.class, ModelStructure.DEFAULT_CUSTOM_CATEGORY_PATH);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!TngUtil.isRootCustomCategory((CustomCategory)((CustomCategory)iterator.next()))) continue;
            iterator.remove();
        }
        return list;
    }

    public List getAvailableTools(MethodElement methodElement) {
        return this.getAvailableCategories(methodElement, Tool.class, ModelStructure.DEFAULT.toolPath);
    }

    public List getAvailableDisciplineGroupings(MethodElement methodElement) {
        return this.getAvailableCategories(methodElement, DisciplineGrouping.class, ModelStructure.DEFAULT.disciplineDefinitionPath);
    }

    public List getAvailableRoleSetGroupings(MethodElement methodElement) {
        return this.getAvailableCategories(methodElement, RoleSetGrouping.class, ModelStructure.DEFAULT.roleSetPath);
    }

    public Discipline addToDiscipline(IActionManager iActionManager, Discipline discipline, Task task, List list) {
        return (Discipline)this.addToCategory(iActionManager, (ContentCategory)discipline, (MethodElement)task, (EStructuralFeature)UmaPackage.eINSTANCE.getDiscipline_Tasks(), ModelStructure.DEFAULT.disciplineDefinitionPath, true, list);
    }

    public Domain addToDomain(IActionManager iActionManager, Domain domain, WorkProduct workProduct, List list) {
        return (Domain)this.addToCategory(iActionManager, (ContentCategory)domain, (MethodElement)workProduct, (EStructuralFeature)UmaPackage.eINSTANCE.getDomain_WorkProducts(), ModelStructure.DEFAULT.domainPath, true, list);
    }

    public WorkProductType addToWorkProductType(IActionManager iActionManager, WorkProductType workProductType, WorkProduct workProduct, List list) {
        return (WorkProductType)this.addToCategory(iActionManager, (ContentCategory)workProductType, (MethodElement)workProduct, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductType_WorkProducts(), ModelStructure.DEFAULT.workProductTypePath, true, list);
    }

    public CustomCategory addToCustomCategory(IActionManager iActionManager, CustomCategory customCategory, MethodElement methodElement, List list) {
        if (methodElement instanceof DescribableElement) {
            return (CustomCategory)this.addToCategory(iActionManager, (ContentCategory)customCategory, methodElement, (EStructuralFeature)UmaPackage.eINSTANCE.getCustomCategory_CategorizedElements(), ModelStructure.DEFAULT.customCategoryPath, true, list);
        }
        return null;
    }

    public Tool addToTool(IActionManager iActionManager, Tool tool, ToolMentor toolMentor, List list) {
        return (Tool)this.addToCategory(iActionManager, (ContentCategory)tool, (MethodElement)toolMentor, (EStructuralFeature)UmaPackage.eINSTANCE.getTool_ToolMentors(), ModelStructure.DEFAULT.toolPath, true, list);
    }

    public RoleSet addToRoleSet(IActionManager iActionManager, RoleSet roleSet, Role role, List list) {
        return (RoleSet)this.addToCategory(iActionManager, (ContentCategory)roleSet, (MethodElement)role, (EStructuralFeature)UmaPackage.eINSTANCE.getRoleSet_Roles(), ModelStructure.DEFAULT.roleSetPath, true, list);
    }

    public ContentCategory addToCategory(IActionManager iActionManager, ContentCategory contentCategory, MethodElement methodElement, EStructuralFeature eStructuralFeature, String[] stringArray, boolean bl, List list) {
        AddToCategoryCommand addToCategoryCommand = new AddToCategoryCommand(contentCategory, methodElement, eStructuralFeature, stringArray, bl, list);
        iActionManager.execute((IResourceAwareCommand)addToCategoryCommand);
        return (ContentCategory)((List)addToCategoryCommand.getAffectedObjects()).get(0);
    }

    public boolean removeFromCategory(IActionManager iActionManager, ContentCategory contentCategory, MethodElement methodElement, EStructuralFeature eStructuralFeature, String[] stringArray, List list) {
        RemoveFromCategoryCommand removeFromCategoryCommand = new RemoveFromCategoryCommand(contentCategory, methodElement, eStructuralFeature, stringArray, list);
        iActionManager.execute((IResourceAwareCommand)removeFromCategoryCommand);
        return !removeFromCategoryCommand.getResult().isEmpty();
    }

    public boolean removeFromDiscipline(IActionManager iActionManager, Discipline discipline, Task task, List list) {
        EReference eReference = UmaPackage.eINSTANCE.getDiscipline_Tasks();
        return this.removeFromCategory(iActionManager, (ContentCategory)discipline, (MethodElement)task, (EStructuralFeature)eReference, ModelStructure.DEFAULT.disciplineDefinitionPath, list);
    }

    public boolean removeFromDomain(IActionManager iActionManager, Domain domain, WorkProduct workProduct, List list) {
        EReference eReference = UmaPackage.eINSTANCE.getDomain_WorkProducts();
        return this.removeFromCategory(iActionManager, (ContentCategory)domain, (MethodElement)workProduct, (EStructuralFeature)eReference, ModelStructure.DEFAULT.domainPath, list);
    }

    public boolean removeFromWorkProductType(IActionManager iActionManager, WorkProductType workProductType, WorkProduct workProduct, List list) {
        EReference eReference = UmaPackage.eINSTANCE.getWorkProductType_WorkProducts();
        return this.removeFromCategory(iActionManager, (ContentCategory)workProductType, (MethodElement)workProduct, (EStructuralFeature)eReference, ModelStructure.DEFAULT.workProductTypePath, list);
    }

    public boolean removeFromRoleSet(IActionManager iActionManager, RoleSet roleSet, Role role, List list) {
        EReference eReference = UmaPackage.eINSTANCE.getRoleSet_Roles();
        return this.removeFromCategory(iActionManager, (ContentCategory)roleSet, (MethodElement)role, (EStructuralFeature)eReference, ModelStructure.DEFAULT.roleSetPath, list);
    }

    public boolean removeFromTool(IActionManager iActionManager, Tool tool, ToolMentor toolMentor, List list) {
        EReference eReference = UmaPackage.eINSTANCE.getTool_ToolMentors();
        return this.removeFromCategory(iActionManager, (ContentCategory)tool, (MethodElement)toolMentor, (EStructuralFeature)eReference, ModelStructure.DEFAULT.toolPath, list);
    }

    public boolean removeFromCustomCategory(IActionManager iActionManager, CustomCategory customCategory, MethodElement methodElement, List list) {
        if (methodElement instanceof DescribableElement) {
            EReference eReference = UmaPackage.eINSTANCE.getCustomCategory_CategorizedElements();
            return this.removeFromCategory(iActionManager, (ContentCategory)customCategory, methodElement, (EStructuralFeature)eReference, ModelStructure.DEFAULT.customCategoryPath, list);
        }
        return false;
    }

    public void releaseCategories(MethodElement methodElement, Collection collection) {
        MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)methodElement);
        for (ContentCategory contentCategory : collection) {
            ContentPackage contentPackage;
            ContentCategory contentCategory2;
            MethodPlugin methodPlugin2 = UmaUtil.getMethodPlugin((EObject)contentCategory);
            if (contentCategory.getVariabilityBasedOnElement() != null && methodPlugin2 == methodPlugin && TngUtil.isEmpty((ContentCategory)contentCategory)) {
                EcoreUtil.remove((EObject)contentCategory);
                if (!(contentCategory instanceof CustomCategory)) continue;
                TngUtil.getRootCustomCategory((MethodPlugin)methodPlugin2).getCategorizedElements().remove(contentCategory);
                continue;
            }
            String[] stringArray = LibraryManager.getCategoryPackagePath(contentCategory);
            if (stringArray == null || (contentCategory2 = TngUtil.findContributor((ContentPackage)(contentPackage = UmaUtil.findContentPackage((MethodPlugin)methodPlugin, (String[])stringArray)), (ContentCategory)contentCategory)) == null || !TngUtil.isEmpty((ContentCategory)contentCategory2)) continue;
            EcoreUtil.remove((EObject)contentCategory2);
            if (!(contentCategory2 instanceof CustomCategory)) continue;
            TngUtil.getRootCustomCategory((MethodPlugin)methodPlugin).getCategorizedElements().remove(contentCategory2);
        }
    }

    public List getAvailableTasks(ContentCategory contentCategory) {
        return this.getAvailableContentElements(Task.class, (ContentElement)contentCategory, false);
    }

    public List getAvailableWorkProducts(ContentCategory contentCategory) {
        return this.getAvailableContentElements(WorkProduct.class, (ContentElement)contentCategory, false);
    }

    public List getAvailableRoles(ContentCategory contentCategory) {
        return this.getAvailableContentElements(Role.class, (ContentElement)contentCategory, false);
    }

    public List getAvailableContentElements(Class clazz, ContentElement contentElement, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List<MethodPlugin> list = bl ? Collections.singletonList(UmaUtil.getMethodPlugin((EObject)contentElement)) : MethodElementUtil.getAllModels((Object)contentElement);
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            MethodPlugin methodPlugin = list.get(n2);
            ContentPackage contentPackage = UmaUtil.findContentPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.coreContentPath);
            if (contentPackage != null) {
                TreeIterator treeIterator = contentPackage.eAllContents();
                while (treeIterator.hasNext()) {
                    Object object = treeIterator.next();
                    if (!clazz.isInstance(object) || object == contentElement) continue;
                    arrayList.add(object);
                }
            }
            ++n2;
        }
        Collections.sort(arrayList, nameComparator);
        return arrayList;
    }

    public List getAvailableTasks(Role role) {
        return this.getAvailableContentElements(Task.class, (ContentElement)role, true);
    }

    public List getAvailableTasks(WorkProduct workProduct) {
        return this.getAvailableContentElements(Task.class, (ContentElement)workProduct, true);
    }

    public List getAvailableRoles(WorkProduct workProduct) {
        return this.getAvailableContentElements(Role.class, (ContentElement)workProduct, true);
    }

    public List getAvailableWorkProducts(Role role) {
        return this.getAvailableContentElements(WorkProduct.class, (ContentElement)role, false);
    }

    public List getAvailableWorkProducts(Task task) {
        return this.getAvailableContentElements(WorkProduct.class, (ContentElement)task, false);
    }

    public List getAvailableRoles(Task task) {
        return this.getAvailableContentElements(Role.class, (ContentElement)task, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getStepList(Task task) {
        if (task.getVariabilityType() == VariabilityType.EXTENDS_LITERAL || task.getVariabilityType() == VariabilityType.CONTRIBUTES_LITERAL) {
            Object object;
            VariabilityElement variabilityElement = TngUtil.getBase((VariabilityElement)task);
            final ArrayList<VariabilityType> arrayList = new ArrayList<VariabilityType>();
            if (arrayList.isEmpty()) {
                object = arrayList;
                synchronized (object) {
                    if (arrayList.isEmpty()) {
                        arrayList.add(VariabilityType.CONTRIBUTES_LITERAL);
                        arrayList.add(VariabilityType.EXTENDS_LITERAL);
                    }
                }
            }
            object = new AbstractTreeIterator(variabilityElement){

                protected Iterator getChildren(Object object) {
                    List list = AssociationHelper.getImmediateVarieties((VariabilityElement)((VariabilityElement)object));
                    if (list == null || list.isEmpty()) {
                        Collections.EMPTY_LIST.iterator();
                    }
                    int n = list.size();
                    ArrayList<VariabilityElement> arrayList2 = new ArrayList<VariabilityElement>();
                    int n2 = 0;
                    while (n2 < n) {
                        VariabilityElement variabilityElement = (VariabilityElement)list.get(n2);
                        if (arrayList.contains(variabilityElement.getVariabilityType())) {
                            arrayList2.add(variabilityElement);
                        }
                        ++n2;
                    }
                    return arrayList2.iterator();
                }
            };
            while (object.hasNext()) {
                Task task2 = (Task)object.next();
                task2.getPresentation().getSections();
            }
        }
        return null;
    }

    public List getExtended(VariabilityElement variabilityElement, Collection collection) {
        ArrayList arrayList = new ArrayList();
        LibraryManager.getExtended(arrayList, variabilityElement, collection);
        return arrayList;
    }

    private static void getExtended(List list, VariabilityElement variabilityElement, Collection collection) {
        VariabilityElement variabilityElement2;
        List list2 = AssociationHelper.getImmediateVarieties((VariabilityElement)variabilityElement);
        if (list2 == null || list2.isEmpty()) {
            return;
        }
        int n = list2.size();
        int n2 = 0;
        while (n2 < n) {
            variabilityElement2 = (VariabilityElement)list2.get(n2);
            if (collection.contains(variabilityElement2.getVariabilityType())) {
                list.add(variabilityElement2);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            variabilityElement2 = (VariabilityElement)list2.get(n2);
            if (collection.contains(variabilityElement2.getVariabilityType())) {
                LibraryManager.getExtended(list, variabilityElement, collection);
            }
            ++n2;
        }
    }

    private static String[] getCategoryPackagePath(ContentCategory contentCategory) {
        EObject eObject = null;
        eObject = contentCategory.eContainer();
        while (eObject != null && !(eObject instanceof ContentPackage)) {
            eObject = eObject.eContainer();
        }
        if (eObject == null) {
            return null;
        }
        ContentPackage contentPackage = (ContentPackage)eObject;
        return Misc.getPathRelativeToPlugin((NamedElement)contentPackage);
    }
}

