/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.sdo.EProperty;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.TransientGroupItemProvider;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.persistence.PersistenceService;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.MethodUnit;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryUtil {
    public static boolean PUBLISH_MODE = false;

    public static String checkPluginName(MethodPlugin methodPlugin, String string) {
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        return IValidatorFactory.INSTANCE.createValidator((EObject)methodLibrary, UmaPackage.Literals.METHOD_LIBRARY__METHOD_PLUGINS, null, null, (EStructuralFeature)UmaPackage.Literals.NAMED_ELEMENT__NAME).isValid(string);
    }

    public static boolean selectable(EObject eObject) {
        return eObject instanceof MethodLibrary || eObject instanceof MethodPlugin || eObject instanceof MethodPackage;
    }

    public static EObject getSelectable(EObject eObject) {
        if (eObject instanceof BreakdownElement) {
            EObject eObject2 = eObject.eContainer();
            while (eObject2 != null && !(eObject2 instanceof ProcessComponent)) {
                eObject2 = eObject2.eContainer();
            }
            return eObject2;
        }
        EObject eObject3 = eObject;
        while (eObject3 != null && !LibraryUtil.selectable(eObject3)) {
            eObject3 = eObject3.eContainer();
        }
        return eObject3;
    }

    public static MethodPlugin getMethodPlugin(EObject eObject) {
        return UmaUtil.getMethodPlugin((EObject)eObject);
    }

    public static String getName(Object object) {
        if (object == null) {
            return LibraryResources.unknown_text;
        }
        if (object instanceof MethodElement) {
            return LibraryUtil.getFullName((MethodElement)object);
        }
        return object.toString();
    }

    public static String getFullName(MethodElement methodElement) {
        if (LibraryUtil.selectable((EObject)methodElement)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[").append(methodElement.getName()).append("]");
            MethodElement methodElement2 = methodElement;
            while ((methodElement2 = (MethodElement)methodElement2.eContainer()) != null) {
                if (methodElement2 instanceof MethodLibrary) break;
                stringBuffer.insert(0, "[" + methodElement2.getName() + "].");
            }
            return stringBuffer.toString();
        }
        return methodElement.getName();
    }

    public static String getLocalizeTypeName(MethodElement methodElement) {
        if (methodElement == null) {
            return "";
        }
        if (methodElement instanceof DescribableElement) {
            String string = String.valueOf(TngUtil.getTypeText((EObject)methodElement)) + LibraryResources.colon_with_space;
            string = ((DescribableElement)methodElement).getPresentationName() != null ? String.valueOf(string) + "(" + ((DescribableElement)methodElement).getPresentationName() + ") " + ((DescribableElement)methodElement).getName() : String.valueOf(string) + methodElement.getName();
            return string;
        }
        return LibraryUtil.getTypeName(methodElement);
    }

    public static String getTypeName(MethodElement methodElement) {
        return methodElement == null ? "" : String.valueOf(methodElement.getType().getName()) + ":" + methodElement.getName();
    }

    public static String getTypePath(MethodElement methodElement) {
        return methodElement == null ? "" : String.valueOf(methodElement.getType().getName()) + ":" + TngUtil.getLabelWithPath((Object)methodElement);
    }

    public static List getMethodPlugins(MethodLibrary methodLibrary) {
        ArrayList<EObject> arrayList = new ArrayList<EObject>();
        EList eList = methodLibrary.eContents();
        if (eList != null) {
            for (EObject eObject : eList) {
                if (!(eObject instanceof MethodPlugin)) continue;
                arrayList.add(eObject);
            }
        }
        return arrayList;
    }

    public static List getMethodPluginGuids(MethodLibrary methodLibrary) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = methodLibrary.getMethodPlugins();
        if (list != null) {
            for (MethodPlugin methodPlugin : list) {
                arrayList.add(methodPlugin.getGuid());
            }
        }
        return arrayList;
    }

    public static MethodPlugin getMethodPlugin(MethodLibrary methodLibrary, String string) {
        if (string == null) {
            return null;
        }
        List list = methodLibrary.getMethodPlugins();
        if (list != null) {
            for (MethodPlugin methodPlugin : list) {
                if (!string.equals(methodPlugin.getGuid())) continue;
                return methodPlugin;
            }
        }
        return null;
    }

    public static MethodPlugin getMethodPluginByName(MethodLibrary methodLibrary, String string) {
        if (string == null) {
            return null;
        }
        List list = methodLibrary.getMethodPlugins();
        if (list != null) {
            for (MethodPlugin methodPlugin : list) {
                if (!string.equals(methodPlugin.getName())) continue;
                return methodPlugin;
            }
        }
        return null;
    }

    public static List getMethodPackages(MethodElement methodElement) {
        ArrayList<EObject> arrayList = new ArrayList<EObject>();
        TreeIterator treeIterator = methodElement.eAllContents();
        while (treeIterator.hasNext()) {
            EObject eObject = (EObject)treeIterator.next();
            if (!(eObject instanceof MethodPackage)) continue;
            arrayList.add(eObject);
        }
        return arrayList;
    }

    public static Object unwrap(Object object) {
        return TngUtil.unwrap((Object)object);
    }

    public static Command unwrap(Command command) {
        return TngUtil.unwrap((Command)command);
    }

    public static void detachFromResource(MethodLibrary methodLibrary) {
        ResourceSet resourceSet = null;
        Resource resource = methodLibrary.eResource();
        if (resource != null) {
            resourceSet = resource.getResourceSet();
        }
        if (resourceSet != null) {
            TreeIterator treeIterator = resourceSet.getAllContents();
            while (treeIterator.hasNext()) {
                Object object = treeIterator.next();
                if (!(object instanceof MultiResourceEObject)) continue;
                ((MultiResourceEObject)object).eSetResource(null);
            }
        }
        LibraryUtil.clearProxies((EObject)methodLibrary);
    }

    public static void clearProxies(EObject eObject) {
        if (eObject.eIsProxy()) {
            LibraryUtil.setProxyURI(eObject, null);
        } else {
            TreeIterator treeIterator = eObject.eAllContents();
            while (treeIterator.hasNext()) {
                EObject eObject2 = (EObject)treeIterator.next();
                if (!eObject2.eIsProxy()) continue;
                LibraryUtil.setProxyURI(eObject2, null);
            }
        }
    }

    public static void setProxyURI(EObject eObject, URI uRI) {
        ((InternalEObject)eObject).eSetProxyURI(uRI);
    }

    public static Collection<Resource> getLoadedResources(MethodLibrary methodLibrary, Collection<Resource> collection) {
        HashSet<Resource> hashSet = new HashSet<Resource>();
        for (Resource resource : methodLibrary.eResource().getResourceSet().getResources()) {
            if (!resource.isLoaded() || collection != null && collection.contains(resource)) continue;
            hashSet.add(resource);
        }
        return hashSet;
    }

    public static Collection<Resource> loadAll(MethodLibrary methodLibrary) {
        Collection<Resource> collection = LibraryUtil.getLoadedResources(methodLibrary, null);
        TreeIterator treeIterator = methodLibrary.eAllContents();
        while (treeIterator.hasNext()) {
            try {
                EObject eObject = (EObject)treeIterator.next();
                Iterator iterator = eObject.eCrossReferences().iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                }
            }
            catch (Exception exception) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
            }
        }
        return LibraryUtil.getLoadedResources(methodLibrary, collection);
    }

    public static void loadAllProcesses(MethodLibrary methodLibrary) {
        Iterator iterator = methodLibrary.getMethodPlugins().iterator();
        while (iterator.hasNext()) {
            try {
                MethodPlugin methodPlugin = (MethodPlugin)iterator.next();
                TngUtil.getAllProcesses((MethodPlugin)methodPlugin);
            }
            catch (Exception exception) {
                LibraryEditPlugin.INSTANCE.log((Object)exception);
            }
        }
    }

    public static void saveAll(MethodLibrary methodLibrary) throws Exception {
        LibraryUtil.saveLibrary(methodLibrary, true, false);
    }

    public static void saveLibrary(MethodLibrary methodLibrary, boolean bl, boolean bl2) throws Exception {
        ILibraryResourceSet iLibraryResourceSet = (ILibraryResourceSet)methodLibrary.eResource().getResourceSet();
        if (iLibraryResourceSet instanceof MultiFileResourceSetImpl) {
            MultiFileResourceSetImpl multiFileResourceSetImpl = (MultiFileResourceSetImpl)iLibraryResourceSet;
            ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
            HashMap<String, String> hashMap = iLibraryManager != null ? iLibraryManager.getSaveOptions() : new HashMap<String, String>();
            Object v = hashMap.get("REFRESH_NEW_RESOURCE");
            Object v2 = hashMap.get("CHECK_MODIFY");
            try {
                hashMap.put("REFRESH_NEW_RESOURCE", bl2 ? "true" : "false");
                hashMap.put("CHECK_MODIFY", "false");
                multiFileResourceSetImpl.save(hashMap, bl);
            }
            finally {
                hashMap.put("REFRESH_NEW_RESOURCE", (String)v);
                hashMap.put("CHECK_MODIFY", (String)v2);
            }
        } else {
            iLibraryResourceSet.save(Collections.EMPTY_MAP);
        }
    }

    public static MethodLibrary loadLibrary(String string) throws Exception {
        ILibraryResourceSet iLibraryResourceSet = PersistenceService.INSTANCE.createResourceSet("xmi");
        iLibraryResourceSet.loadMethodLibraries(URI.createFileURI((String)string), Collections.EMPTY_MAP);
        return iLibraryResourceSet.getFirstMethodLibrary();
    }

    public static File getLibraryRootPath(MethodLibrary methodLibrary) {
        Resource resource = methodLibrary.eResource();
        if (resource == null) {
            return null;
        }
        URI uRI = resource.getURI();
        String string = uRI.toFileString();
        File file = new File(string);
        return file.getParentFile();
    }

    public static List getAllPackages(MethodPlugin methodPlugin) {
        ArrayList arrayList = new ArrayList();
        List list = methodPlugin.getMethodPackages();
        arrayList.addAll(list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            LibraryUtil.getAllChildPackages((MethodPackage)iterator.next(), arrayList);
        }
        return arrayList;
    }

    public static void getAllChildPackages(MethodPackage methodPackage, List list) {
        List list2 = methodPackage.getChildPackages();
        list.addAll(list2);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            LibraryUtil.getAllChildPackages((MethodPackage)iterator.next(), list);
        }
    }

    public static List getAssociatedConfigurations(MethodPlugin methodPlugin) {
        Object object2;
        ArrayList<MethodConfiguration> arrayList = new ArrayList<MethodConfiguration>();
        List list = (List)((MultiResourceEObject)methodPlugin).getOppositeFeatureValue(AssociationHelper.MethodPlugin_MethodConfigurations);
        LibraryUtil.addUniqueItems(list, arrayList);
        List list2 = LibraryUtil.getAllPackages(methodPlugin);
        for (Object object2 : list2) {
            list = (List)object2.getOppositeFeatureValue(AssociationHelper.MethodPackage_MethodConfigurations);
            LibraryUtil.addUniqueItems(list, arrayList);
        }
        List list3 = TngUtil.getAllProcesses((MethodPlugin)methodPlugin);
        object2 = list3.iterator();
        while (object2.hasNext()) {
            Process process = (Process)object2.next();
            MethodConfiguration methodConfiguration = process.getDefaultContext();
            if (methodConfiguration != null && !arrayList.contains(methodConfiguration)) {
                arrayList.add(methodConfiguration);
            }
            LibraryUtil.addUniqueItems(process.getValidContext(), arrayList);
        }
        return arrayList;
    }

    private static void addUniqueItems(List list, List list2) {
        if (list == null || list2 == null || list.size() == 0) {
            return;
        }
        for (Object e : list) {
            if (list2.contains(e)) continue;
            list2.add(e);
        }
    }

    public static void validateMethodConfiguration(IActionManager iActionManager, MethodConfiguration methodConfiguration) {
        TngUtil.validateMethodConfiguration((IActionManager)iActionManager, (MethodConfiguration)methodConfiguration);
    }

    public static void validateMethodConfiguration(MethodConfiguration methodConfiguration) {
        LibraryUtil.validateMethodConfiguration(null, methodConfiguration);
    }

    public static SupportingMaterial getCopyright(MethodElement methodElement) {
        MethodPlugin methodPlugin;
        SupportingMaterial supportingMaterial = null;
        if (methodElement instanceof MethodUnit) {
            supportingMaterial = ((MethodUnit)methodElement).getCopyrightStatement();
        } else if (methodElement instanceof DescribableElement) {
            supportingMaterial = ((DescribableElement)methodElement).getPresentation().getCopyrightStatement();
        }
        if (supportingMaterial == null && (methodPlugin = LibraryUtil.getMethodPlugin((EObject)methodElement)) != null) {
            supportingMaterial = methodPlugin.getCopyrightStatement();
        }
        return supportingMaterial;
    }

    public static Collection getContainedElements(Object object, Collection collection) {
        if (object instanceof TransientGroupItemProvider) {
            object = ((TransientGroupItemProvider)object).getTarget();
        }
        ArrayList arrayList = new ArrayList();
        for (Object e : collection) {
            if (!(e instanceof EObject) || !UmaUtil.isContainedBy((EObject)((EObject)e), (Object)object)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public static boolean isIdentical(MethodElement methodElement, MethodElement methodElement2) {
        if (methodElement == null && methodElement2 == null) {
            return true;
        }
        if (methodElement == null || methodElement2 == null) {
            return false;
        }
        List list = LibraryUtil.getStructuralFeatures(methodElement);
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)list.get(n);
                Object object = methodElement.eGet(eStructuralFeature);
                Object object2 = methodElement2.eGet(eStructuralFeature);
                if (object != null || object2 != null) {
                    Object object3;
                    if (object == null || object2 == null) {
                        return false;
                    }
                    if (object instanceof MethodElement) {
                        object3 = (MethodElement)object;
                        if (object3.eContainer() == methodElement ? !LibraryUtil.isIdentical((MethodElement)object3, (MethodElement)object2) : object != object2) {
                            return false;
                        }
                    } else if (object instanceof List) {
                        object3 = (List)object;
                        List list2 = (List)object2;
                        if (object3.size() != list2.size()) {
                            return false;
                        }
                        int n2 = 0;
                        while (n2 < object3.size()) {
                            MethodElement methodElement3;
                            Object e = object3.get(n2);
                            Object e2 = list2.get(n2);
                            if (e instanceof MethodElement ? ((methodElement3 = (MethodElement)e).eContainer() == methodElement ? !LibraryUtil.isIdentical(methodElement3, (MethodElement)e2) : object != object2) : !e.equals(e2)) {
                                return false;
                            }
                            ++n2;
                        }
                    } else if (!object.equals(object2)) {
                        return false;
                    }
                }
                ++n;
            }
        }
        return true;
    }

    public static boolean isProcess(EObject eObject) {
        return eObject instanceof Process && eObject.eContainer() instanceof ProcessComponent;
    }

    public static List getValidViews(MethodConfiguration methodConfiguration) {
        ArrayList<ContentCategory> arrayList = new ArrayList<ContentCategory>();
        for (ContentCategory contentCategory : methodConfiguration.getProcessViews()) {
            if (ConfigurationHelper.isContributor((VariabilityElement)contentCategory) || (contentCategory = (ContentCategory)ConfigurationHelper.getCalculatedElement((MethodElement)contentCategory, methodConfiguration)) == null || arrayList.contains(contentCategory)) continue;
            arrayList.add(contentCategory);
        }
        return arrayList;
    }

    public static List getStructuralFeatures(MethodElement methodElement) {
        List list = methodElement.getInstanceProperties();
        if (list != null) {
            ArrayList<EStructuralFeature> arrayList = new ArrayList<EStructuralFeature>();
            int n = 0;
            while (n < list.size()) {
                EProperty eProperty = (EProperty)list.get(n);
                if (eProperty != null) {
                    EStructuralFeature eStructuralFeature = eProperty.getEStructuralFeature();
                    arrayList.add(eStructuralFeature);
                }
                ++n;
            }
            return arrayList;
        }
        return null;
    }
}

