/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.I18nUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.preferences.LibraryPreferences;
import org.eclipse.epf.library.prefs.PreferenceUtil;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.actions.ConfigurationContributionItem;
import org.eclipse.epf.library.ui.dialogs.CopyLibraryDialog;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.ui.wizards.LibraryBackupUtil;
import org.eclipse.epf.library.xmi.XMILibraryUtil;
import org.eclipse.epf.persistence.migration.MappingUtil;
import org.eclipse.epf.persistence.migration.UpgradeCallerInfo;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.util.MessageException;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryUIManager {
    public static boolean DEBUG = LibraryUIPlugin.getDefault().isDebugging();
    private static final String TOOLBAR_CONFIG_CONTRIBUTION_ID = "toolbar.config.contribution";
    private static final String CONFIG_VIEW_ID = "org.eclipse.epf.authoring.ui.views.ConfigurationView";
    private static final String PROCESS_EDITOR_ID = "org.eclipse.epf.authoring.ui.editors.ProcessEditor";
    private static LibraryUIManager instance = null;
    protected static URI libraryURI;
    protected static URI defaultLibraryURI;
    protected static URI defaultLibraryURI_NL;
    private boolean libraryInitialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LibraryUIManager getInstance() {
        if (instance != null) return instance;
        Class<LibraryUIManager> clazz = LibraryUIManager.class;
        synchronized (LibraryUIManager.class) {
            if (instance != null) return instance;
            instance = new LibraryUIManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LibraryUIManager() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            iWorkbenchWindow.addPerspectiveListener(new IPerspectiveListener(){

                public void perspectiveActivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
                    LibraryUIManager.this.checkConfigurationContribution();
                }

                public void perspectiveChanged(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, String string) {
                    LibraryUIManager.this.checkConfigurationContribution();
                }
            });
        }
    }

    public boolean createLibrary(String string) {
        try {
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            XMILibraryUtil.createMethodLibrary((String)file.getName(), (String)string);
            LibraryUIPreferences.setSavedLibraryPath(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean openDefaultLibrary(final URI uRI) {
        block3: {
            try {
                File file = new File(uRI);
                File file2 = new File(file, "library.xmi");
                if (file2.exists()) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor iProgressMonitor) {
                try {
                    try {
                        URI uRI2 = uRI;
                        String string = LibraryUIManager.this.handleLibraryOnReadOnlyInstallPath(uRI2);
                        if (string != null) {
                            uRI2 = StrUtil.toURI((String)string);
                        }
                        String string2 = LibraryUIResources.openingLibraryTask_name;
                        iProgressMonitor.beginTask(string2, 2);
                        iProgressMonitor.setTaskName(string2);
                        iProgressMonitor.worked(1);
                        LibraryService.getInstance().closeCurrentMethodLibrary();
                        LibraryService.getInstance().openMethodLibrary("xmi", uRI2);
                    }
                    catch (Exception exception) {
                        LibraryUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                        iProgressMonitor.done();
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        Shell shell = Display.getCurrent().getActiveShell();
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell){

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setText(LibraryUIResources.openLibraryWizard_title);
            }
        };
        progressMonitorDialog.run(true, false, (IRunnableWithProgress)workspaceModifyOperation);
        return LibraryService.getInstance().getCurrentMethodLibrary() != null;
    }

    public boolean openLastOpenedLibrary() {
        block3: {
            try {
                String string = LibraryPreferences.getSavedMethodLibraryURI();
                URI uRI = new URI(string);
                if (uRI.getPath().length() != 0) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor iProgressMonitor) {
                try {
                    try {
                        String string = LibraryUIResources.openingLibraryTask_name;
                        iProgressMonitor.beginTask(string, 2);
                        iProgressMonitor.setTaskName(string);
                        iProgressMonitor.worked(1);
                        LibraryService.getInstance().closeCurrentMethodLibrary();
                        LibraryService.getInstance().openLastOpenedMethodLibrary();
                    }
                    catch (Exception exception) {
                        LibraryUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                        iProgressMonitor.done();
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        Shell shell = Display.getCurrent().getActiveShell();
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell){

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setText(LibraryUIResources.openLibraryWizard_title);
            }
        };
        progressMonitorDialog.run(true, false, (IRunnableWithProgress)workspaceModifyOperation);
        return LibraryService.getInstance().getCurrentMethodLibrary() != null;
    }

    public boolean openLibrary(URI uRI) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("library.path", new File(uRI).getAbsolutePath());
        return this.openLibrary("xmi", hashMap);
    }

    public boolean openLibrary(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("library.path", string);
        return this.openLibrary("xmi", hashMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean openLibrary(final String string, final Map<String, Object> map) {
        final String string2 = (String)map.get("library.path");
        Shell shell = Display.getCurrent().getActiveShell();
        final ArrayList arrayList = new ArrayList();
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor iProgressMonitor) {
                String string3 = LibraryUIResources.openingLibraryTask_name;
                iProgressMonitor.beginTask(string3, 2);
                try {
                    try {
                        iProgressMonitor.setTaskName(string3);
                        iProgressMonitor.worked(1);
                        LibraryService.getInstance().closeCurrentMethodLibrary();
                        MethodLibrary methodLibrary = LibraryService.getInstance().openMethodLibrary(string, map);
                        LibraryService.getInstance().setCurrentMethodLibrary(methodLibrary);
                        LibraryUIPreferences.setSavedLibraryPath(string2);
                        ILibraryResourceSet iLibraryResourceSet = (ILibraryResourceSet)LibraryService.getInstance().getCurrentLibraryManager().getEditingDomain().getResourceSet();
                        if (iLibraryResourceSet.hasUnresolvedProxy()) {
                            SafeUpdateController.asyncExec((Runnable)new Runnable(){

                                public void run() {
                                    try {
                                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.ProblemView", null, 2);
                                    }
                                    catch (Exception exception) {
                                        LibraryUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception exception) {
                        if (!(exception instanceof IOException) || !exception.getMessage().startsWith("###")) {
                            LibraryUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                        }
                        arrayList.add(exception);
                        iProgressMonitor.done();
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        try {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell){

                protected void configureShell(Shell shell) {
                    super.configureShell(shell);
                    shell.setText(LibraryUIResources.openLibraryWizard_title);
                }
            };
            progressMonitorDialog.run(true, false, (IRunnableWithProgress)workspaceModifyOperation);
            if (arrayList.isEmpty()) {
                IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (iWorkbenchWindow == null) return true;
                IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                if (iWorkbenchPage == null) return true;
                iWorkbenchPage.closeAllEditors(false);
                return true;
            }
            Iterator iterator = arrayList.iterator();
            while (true) {
                String string3;
                Object object;
                if (!iterator.hasNext()) {
                    return false;
                }
                Exception exception = (Exception)iterator.next();
                if (exception instanceof IOException) {
                    object = exception.getMessage();
                    if (!((String)object).startsWith("###")) continue;
                    string3 = ((String)object).substring(3);
                    String string4 = LibraryUIResources.bind(LibraryUIResources.readOnlyProjectFile_text, string3);
                    String[] stringArray = new String[]{LibraryUIResources.retryButton_text, LibraryUIResources.cancelButton_text};
                    MessageDialog messageDialog = new MessageDialog(Display.getCurrent().getActiveShell(), LibraryUIResources.openLibraryWizard_title, null, string4, 4, stringArray, 0);
                    if (messageDialog.open() != 0) return true;
                    return this.openLibrary(string2);
                }
                object = exception;
                object = exception;
                while (true) {
                    block7: {
                        if (object != null && !(object instanceof MessageException)) break block7;
                    }
                    object = ((Throwable)object).getCause();
                }
                string3 = object != null && ((Throwable)object).getMessage() != null ? ((Throwable)object).getMessage() : (exception.getMessage() != null ? exception.getMessage() : exception.toString());
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.openLibraryWizard_title, string3, (Throwable)exception);
            }
        }
        catch (Exception exception) {
            LibraryUIPlugin.getDefault().getLogger().logError((Throwable)exception);
        }
        return false;
    }

    public static boolean upgradeLibrary(String string, UpgradeCallerInfo upgradeCallerInfo) {
        Shell shell = Display.getCurrent().getActiveShell();
        if (UpgradeCallerInfo.isUpgradeLibrary((UpgradeCallerInfo)upgradeCallerInfo)) {
            LibraryBackupUtil.promptBackupLibrary(shell, new File(string));
        }
        String string2 = "library.xmi";
        if (upgradeCallerInfo != null && upgradeCallerInfo.getIsExportedPluginLib()) {
            string2 = "export.xmi";
        }
        return LibraryUIManager.upgradeLibrary(new File(string, string2), upgradeCallerInfo);
    }

    public static boolean upgradeLibrary(final File file, final UpgradeCallerInfo upgradeCallerInfo) {
        StringBuffer stringBuffer;
        block5: {
            stringBuffer = new StringBuffer();
            final boolean[] blArray = new boolean[1];
            WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor iProgressMonitor) {
                    iProgressMonitor.beginTask(LibraryUIResources.upgradingLibraryTask_name, 10);
                    iProgressMonitor.worked(1);
                    try {
                        try {
                            MappingUtil.migrate((String)file.getAbsolutePath(), (IProgressMonitor)iProgressMonitor, (UpgradeCallerInfo)upgradeCallerInfo);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            blArray[0] = true;
                            iProgressMonitor.done();
                        }
                        catch (Exception exception) {
                            String string;
                            LibraryUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                            if (DEBUG) {
                                exception.printStackTrace();
                            }
                            if ((string = exception.getMessage()) == null) {
                                string = LibraryUIResources.upgradeLibraryError_msg;
                            }
                            stringBuffer.append(string);
                            iProgressMonitor.done();
                        }
                    }
                    finally {
                        iProgressMonitor.done();
                    }
                }
            };
            try {
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell()){

                    protected Point getInitialSize() {
                        Point point = super.getInitialSize();
                        if (point.x < 675) {
                            point.x = 675;
                        }
                        return point;
                    }
                };
                progressMonitorDialog.run(true, false, (IRunnableWithProgress)workspaceModifyOperation);
                if (!blArray[0]) break block5;
                return false;
            }
            catch (Exception exception) {
                LibraryUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                if (DEBUG) {
                    exception.printStackTrace();
                }
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.upgradeLibraryDialog_title, LibraryUIResources.upgradeLibraryError_msg);
                return false;
            }
        }
        if (stringBuffer.length() > 0) {
            Status status = new Status(4, LibraryUIPlugin.PLUGIN_ID, 0, "", null){

                public IStatus[] getChildren() {
                    Status status = new Status(4, LibraryUIPlugin.PLUGIN_ID, 0, stringBuffer.toString(), null);
                    Status[] statusArray = new Status[]{status};
                    return statusArray;
                }

                public boolean isMultiStatus() {
                    return true;
                }
            };
            LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.upgradeLibraryDialog_title, LibraryUIResources.upgradeLibraryError_msg, (IStatus)status);
            return false;
        }
        return true;
    }

    public static void setCommandLineDefaultLibrary(String string) {
        if (string != null && string.length() > 0) {
            IPath iPath = Path.fromOSString((String)string);
            try {
                defaultLibraryURI = iPath.toFile().toURI();
            }
            catch (Exception exception) {
                defaultLibraryURI = null;
                LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
            }
        }
    }

    public static void setCommandLineLibrary(String string) {
        if (string != null && string.length() > 0) {
            IPath iPath = Path.fromOSString((String)string);
            try {
                libraryURI = iPath.toFile().toURI();
            }
            catch (Exception exception) {
                libraryURI = null;
                LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
            }
        }
    }

    private void checkConfigurationContribution() {
        block5: {
            IWorkbenchWindow iWorkbenchWindow;
            IWorkbench iWorkbench = LibraryUIPlugin.getDefault().getWorkbench();
            if (iWorkbench != null && (iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow()) != null && iWorkbenchWindow instanceof ApplicationWindow) {
                CoolBarManager coolBarManager = ((ApplicationWindow)iWorkbenchWindow).getCoolBarManager();
                try {
                    IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                    if (this.foundConfigView(iWorkbenchPage) || this.foundProcessEditor(iWorkbenchPage)) {
                        this.showConfigurationContribution((ICoolBarManager)coolBarManager);
                    } else {
                        this.hideConfigurationContribution((ICoolBarManager)coolBarManager);
                    }
                }
                catch (Exception exception) {
                    LibraryUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                    if (!DEBUG) break block5;
                    exception.printStackTrace();
                }
            }
        }
    }

    private boolean foundConfigView(IWorkbenchPage iWorkbenchPage) {
        if (iWorkbenchPage == null) {
            return false;
        }
        return iWorkbenchPage.findView(CONFIG_VIEW_ID) != null;
    }

    private boolean foundProcessEditor(IWorkbenchPage iWorkbenchPage) {
        if (iWorkbenchPage == null) {
            return false;
        }
        IEditorReference[] iEditorReferenceArray = iWorkbenchPage.findEditors(null, PROCESS_EDITOR_ID, 2);
        return iEditorReferenceArray != null && iEditorReferenceArray.length > 0;
    }

    private void showConfigurationContribution(ICoolBarManager iCoolBarManager) throws Exception {
        IContributionItem iContributionItem = iCoolBarManager.find(TOOLBAR_CONFIG_CONTRIBUTION_ID);
        if (iContributionItem != null && iContributionItem instanceof ToolBarContributionItem) {
            Object object;
            IToolBarManager iToolBarManager = ((ToolBarContributionItem)iContributionItem).getToolBarManager();
            if (iToolBarManager != null && (object = iToolBarManager.getItems()) != null && ((IContributionItem[])object).length > 0) {
                int n = 0;
                while (n < ((IContributionItem[])object).length) {
                    object[n].setVisible(true);
                    ++n;
                }
                iContributionItem.setVisible(true);
                this.updateSystemToolBar(iCoolBarManager);
                return;
            }
            object = new ConfigurationContributionItem(null);
            iToolBarManager.add((IContributionItem)object);
            iContributionItem.setVisible(true);
            this.updateSystemToolBar(iCoolBarManager);
            return;
        }
        ToolBarManager toolBarManager = new ToolBarManager(0x804000);
        ConfigurationContributionItem configurationContributionItem = new ConfigurationContributionItem(null);
        toolBarManager.add((IContributionItem)configurationContributionItem);
        ToolBarContributionItem toolBarContributionItem = new ToolBarContributionItem((IToolBarManager)toolBarManager, TOOLBAR_CONFIG_CONTRIBUTION_ID);
        iCoolBarManager.add((IContributionItem)toolBarContributionItem);
    }

    private void hideConfigurationContribution(ICoolBarManager iCoolBarManager) throws Exception {
        IContributionItem iContributionItem = iCoolBarManager.find(TOOLBAR_CONFIG_CONTRIBUTION_ID);
        if (iContributionItem == null) {
            return;
        }
        if (iContributionItem instanceof ToolBarContributionItem) {
            IToolBarManager iToolBarManager = ((ToolBarContributionItem)iContributionItem).getToolBarManager();
            IContributionItem[] iContributionItemArray = iToolBarManager.getItems();
            int n = 0;
            while (n < iContributionItemArray.length) {
                iContributionItemArray[n].setVisible(false);
                ++n;
            }
        }
        iContributionItem.setVisible(false);
        this.updateSystemToolBar(iCoolBarManager);
    }

    private void updateSystemToolBar(ICoolBarManager iCoolBarManager) {
        if (iCoolBarManager instanceof CoolBarManager) {
            ((CoolBarManager)iCoolBarManager).update(true);
        }
    }

    public void addMethodViewPartListener(final String string) {
        block3: {
            IWorkbenchWindow iWorkbenchWindow;
            IWorkbench iWorkbench = LibraryUIPlugin.getDefault().getWorkbench();
            if (iWorkbench != null && (iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow()) != null && iWorkbenchWindow instanceof ApplicationWindow) {
                try {
                    final IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                    iWorkbenchPage.addPartListener(new IPartListener2(){

                        public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
                        }

                        public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
                        }

                        public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
                        }

                        public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
                        }

                        public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
                        }

                        public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
                        }

                        public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
                        }

                        public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
                            if (iWorkbenchPartReference.getId().equals(string)) {
                                iWorkbenchPage.removePartListener((IPartListener2)this);
                                LibraryUIManager.this.startupOpenLibrary();
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    LibraryUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                    if (!DEBUG) break block3;
                    exception.printStackTrace();
                }
            }
        }
    }

    public void startupOpenLibrary() {
        if (this.libraryInitialized) {
            return;
        }
        this.libraryInitialized = true;
        try {
            Locale locale;
            String string = LibraryPreferences.getSavedMethodLibraryURI();
            boolean bl = string != null && string.length() > 0;
            String string2 = PreferenceUtil.getSavedLastConfig();
            if (!(libraryURI != null && this.openLibrary(libraryURI) || this.openLastOpenedLibrary() || defaultLibraryURI == null || bl)) {
                locale = Locale.getDefault();
                String string3 = new File(defaultLibraryURI).getAbsolutePath();
                String string4 = I18nUtil.getLocalizedFile((String)FileUtil.removeAllSeparator((String)string3), (Locale)locale);
                if (string4 != null) {
                    defaultLibraryURI_NL = StrUtil.toURI((String)string4);
                }
                if (defaultLibraryURI_NL == null || !this.openDefaultLibrary(defaultLibraryURI_NL)) {
                    this.openDefaultLibrary(defaultLibraryURI);
                }
            }
            if (LibraryService.getInstance().getCurrentMethodLibrary() != null && (locale = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (String)string2)) != null) {
                LibraryService.getInstance().setCurrentMethodConfiguration((MethodConfiguration)locale);
            }
        }
        catch (Exception exception) {
            LibraryUIPlugin.getDefault().getLogger().logError((Throwable)exception);
        }
    }

    private String handleLibraryOnReadOnlyInstallPath(URI uRI) {
        File file;
        block11: {
            boolean bl;
            block10: {
                block9: {
                    bl = false;
                    file = new File(uRI);
                    if (file.exists()) break block9;
                    return null;
                }
                Location location = Platform.getInstallLocation();
                URL uRL = location.getURL();
                URI uRI2 = new URI(NetUtil.encodeFileURL((String)uRL.toExternalForm()));
                File file2 = new File(uRI2);
                String string = file.getCanonicalPath();
                String string2 = file2.getCanonicalPath();
                if (string.startsWith(string2)) break block10;
                return null;
            }
            String string = System.getProperty("os.name");
            String string3 = Platform.getOS();
            if (string.indexOf("Vista") > -1 || string3.equals("linux")) {
                bl = true;
            }
            File file3 = new File(file, "library.xmi");
            if (!file.canWrite() || !file3.canWrite()) {
                bl = true;
            }
            if (bl) break block11;
            return null;
        }
        try {
            final String string = new File(new File(LibraryUIPreferences.getDefaultLibraryPath()).getParent(), file.getName()).getAbsolutePath();
            final StringBuffer stringBuffer = new StringBuffer();
            UserInteractionHelper.runInUIThread((Runnable)new Runnable(){

                public void run() {
                    String string3 = LibraryUIResources.copyLibraryDialog_title;
                    String string2 = LibraryUIResources.copyLibraryDialog_text_readOnlyLib;
                    CopyLibraryDialog copyLibraryDialog = new CopyLibraryDialog(Display.getCurrent().getActiveShell(), string3, string2, string);
                    if (copyLibraryDialog.open() == 0) {
                        stringBuffer.append(copyLibraryDialog.getPath());
                    }
                }
            }, (boolean)false);
            if (stringBuffer.length() > 0) {
                LibraryUIManager.copyLibrary(file, new File(stringBuffer.toString()));
                return stringBuffer.toString();
            }
            return null;
        }
        catch (URISyntaxException uRISyntaxException) {
            LibraryUIPlugin.getDefault().getLogger().logError((Throwable)uRISyntaxException);
            return null;
        }
        catch (IOException iOException) {
            LibraryUIPlugin.getDefault().getLogger().logError((Throwable)iOException);
            return null;
        }
    }

    private static void copyLibrary(final File file, final File file2) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    String string = ".lock";
                    LayoutResources.copyDir((File)file, (File)file2, (String)"**", (String)string);
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                }
            }
        };
        UserInteractionHelper.runWithProgress((Runnable)runnable, (String)LibraryUIResources.copyLibraryTask_name);
    }
}

