/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import com.ibm.icu.text.BreakIterator;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.epf.authoring.gef.commands.ChangeNameCommand;
import org.eclipse.epf.authoring.gef.edit.ActivityDetailDiagramEditPart;
import org.eclipse.epf.authoring.gef.edit.NodeEditPart;
import org.eclipse.epf.authoring.gef.figures.Colors;
import org.eclipse.epf.authoring.gef.figures.SelectableLabel;
import org.eclipse.epf.authoring.gef.figures.TextFigure;
import org.eclipse.epf.authoring.gef.util.TemplateConstants;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.TaskNode;
import org.eclipse.epf.diagram.model.WorkBreakdownElementNode;
import org.eclipse.epf.diagram.model.WorkProductDescriptorNode;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.swt.graphics.Image;

public abstract class NamedNodeEditPart
extends NodeEditPart {
    protected static final int WRAP_WIDTH = 12;
    protected static final int WORK_PRODUCT_WRAP_WIDTH = 3;

    public NamedNodeEditPart(NamedNode namedNode) {
        super((Node)namedNode);
    }

    protected IFigure createFigure() {
        SelectableLabel selectableLabel = new SelectableLabel();
        selectableLabel.setLabelAlignment(1);
        if (this.getImage() != null) {
            selectableLabel.setIcon(this.getImage());
        }
        selectableLabel.setTextPlacement(4);
        selectableLabel.setFont(TemplateConstants.DEFAULT_FONT);
        this.setLabelForegroundColor(selectableLabel);
        return selectableLabel;
    }

    private void setLabelForegroundColor(Label label) {
        NamedNode namedNode = (NamedNode)this.getModel();
        boolean bl = namedNode.isSuppressed();
        if (namedNode.isReadOnly()) {
            if (!bl) {
                label.setForegroundColor(Colors.INHERITED_ELEMENT_LABEL);
            }
        } else if (!bl) {
            label.setForegroundColor(ColorConstants.black);
        }
        if (bl) {
            label.setForegroundColor(Colors.SUPRESSED_ELEMENT_LABEL);
        }
    }

    protected Image getImage() {
        return null;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        if (!((Node)this.getModel()).isReadOnly()) {
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)this.createDirectEditPolicy());
        }
    }

    protected DirectEditPolicy createDirectEditPolicy() {
        return new DirectEditPolicy(){

            protected Command getDirectEditCommand(DirectEditRequest directEditRequest) {
                return new ChangeNameCommand((NamedNode)NamedNodeEditPart.this.getModel(), (String)directEditRequest.getCellEditor().getValue());
            }

            protected void showCurrentEditValue(DirectEditRequest directEditRequest) {
                IFigure iFigure = NamedNodeEditPart.this.getDirectEditFigure();
                String string = (String)directEditRequest.getCellEditor().getValue();
                if (iFigure instanceof Label) {
                    ((Label)iFigure).setText(string);
                } else if (iFigure instanceof TextFigure) {
                    ((TextFigure)iFigure).setText(string);
                }
                iFigure.getUpdateManager().performUpdate();
            }
        };
    }

    protected void handlePropertyChanged(Notification notification) {
        switch (notification.getFeatureID(NamedNode.class)) {
            case 7: {
                this.refreshVisuals();
                return;
            }
        }
        super.handlePropertyChanged(notification);
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" && !((Node)this.getModel()).isReadOnly()) {
            this.performDirectEdit();
        } else {
            super.performRequest(request);
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        IFigure iFigure = this.getDirectEditFigure();
        if (iFigure instanceof Label) {
            WorkBreakdownElementNode workBreakdownElementNode;
            Object object;
            Label label = (Label)iFigure;
            this.setLabelForegroundColor(label);
            String string = this.getModel() instanceof WorkBreakdownElementNode ? ((object = (workBreakdownElementNode = (WorkBreakdownElementNode)this.getModel()).getObject()) instanceof Activity && ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)((BreakdownElement)object)) ? ProcessUtil.getPresentationName((BreakdownElement)((BreakdownElement)object)) : ((NamedNode)this.getModel()).getName()) : ((NamedNode)this.getModel()).getName();
            try {
                if (this.getParent() instanceof ActivityDetailDiagramEditPart || this.getParent().getParent() instanceof ActivityDetailDiagramEditPart) {
                    int n = 12;
                    if (this.getModel() instanceof WorkProductDescriptorNode) {
                        n = 3;
                    }
                    if (this.getModel() instanceof TaskNode && GraphicalDataHelper.isAutoLayout((ActivityDetailDiagram)((ActivityDetailDiagram)this.getParent().getParent().getModel())) && string.length() < 16) {
                        int n2 = 16 - string.length();
                        int n3 = 0;
                        while (n3 < n2 / 2) {
                            string = String.valueOf(string) + " ";
                            ++n3;
                        }
                        n3 = 0;
                        while (n3 < n2 / 2) {
                            string = " " + string;
                            ++n3;
                        }
                    }
                    string = this.wrap(string, n);
                }
            }
            catch (NullPointerException nullPointerException) {}
            label.setText(string);
        }
    }

    protected String wrap(String string, int n) {
        String string2 = "";
        BreakIterator breakIterator = BreakIterator.getLineInstance();
        String string3 = string;
        while (true) {
            if (string3.length() <= n) {
                string2 = String.valueOf(string2) + string3;
                break;
            }
            breakIterator.setText(string3);
            int n2 = breakIterator.following(n);
            if (n2 == -1) {
                string2 = String.valueOf(string2) + string3;
                break;
            }
            if (n2 >= string3.length()) {
                string2 = String.valueOf(string2) + string3;
                break;
            }
            string2 = String.valueOf(string2) + string3.substring(0, n2) + "\n";
            string3 = string3.substring(n2);
        }
        return string2;
    }
}

