/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.authoring.ui.filters.ProcessGuidanceFilter;
import org.eclipse.epf.diagram.model.util.DiagramInfo;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.configuration.GuidanceItemProvider;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class UserDefinedDiagramDialog
extends Dialog {
    private Button assignADImageButton;
    private Button assignADDImageButton;
    private Button assignWPDImageButton;
    private Button clearADImageButton;
    private Button clearADDImageButton;
    private Button clearWPDImageButton;
    private Button useADImageButton;
    private Button useADDImageButton;
    private Button useWPDImageButton;
    private Text adImageText;
    private Text addImageText;
    private Text wpdImageText;
    private IEditorPart editor;
    private Activity activity;
    private Composite area;
    private final String tabName = FilterConstants.GUIDANCE;
    private IFilter filter;
    private SupportingMaterial activityDiagram;
    private SupportingMaterial activityDetailDiagram;
    private SupportingMaterial wpdDiagram;
    private static final int buttonWidthHint = 60;
    private Set existingList;
    private boolean isWrapped = false;

    public UserDefinedDiagramDialog(Shell shell, IEditorPart iEditorPart, Activity activity, MethodConfiguration methodConfiguration, boolean bl) {
        super(shell);
        this.editor = iEditorPart;
        this.isWrapped = bl;
        this.activity = activity;
        this.filter = new ProcessGuidanceFilter(methodConfiguration, null, this.tabName){

            public boolean childAccept(Object object) {
                if (super.childAccept(object)) {
                    return true;
                }
                if (object instanceof GuidanceItemProvider) {
                    String string = ((GuidanceItemProvider)object).getText(object);
                    return string.equalsIgnoreCase(FilterConstants.SUPPORTING_MATERIALS) && !((GuidanceItemProvider)object).getChildren(object).isEmpty();
                }
                return object instanceof SupportingMaterial;
            }
        };
        this.existingList = new HashSet();
    }

    protected Control createDialogArea(Composite composite) {
        this.area = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout(4, false);
        this.area.setLayout((Layout)gridLayout);
        Label label = new Label(this.area, 0);
        label.setText("");
        this.useADImageButton = new Button(this.area, 32);
        this.useADImageButton.setText(AuthoringUIResources.UserDefinedDiagramDialog_useADImage);
        GridData gridData = new GridData(1);
        gridData.horizontalSpan = 3;
        this.useADImageButton.setLayoutData((Object)gridData);
        Label label2 = new Label(this.area, 0);
        label2.setText(AuthoringUIResources.UserDefinedDiagramDialog_adImage);
        this.adImageText = new Text(this.area, 2056);
        GridData gridData2 = new GridData(769);
        gridData2.widthHint = 300;
        this.adImageText.setLayoutData((Object)gridData2);
        this.assignADImageButton = new Button(this.area, 0);
        this.assignADImageButton.setText(AuthoringUIResources.UserDefinedDiagramDialog_assignButton);
        GridData gridData3 = new GridData(769);
        gridData3.widthHint = 60;
        this.assignADImageButton.setLayoutData((Object)gridData3);
        this.clearADImageButton = new Button(this.area, 0);
        this.clearADImageButton.setText(AuthoringUIResources.clearButton_text);
        this.clearADImageButton.setLayoutData((Object)gridData3);
        label = new Label(this.area, 0);
        label.setText("");
        this.useADDImageButton = new Button(this.area, 32);
        this.useADDImageButton.setText(AuthoringUIResources.UserDefinedDiagramDialog_useADDImage);
        gridData = new GridData(1);
        gridData.horizontalSpan = 3;
        this.useADDImageButton.setLayoutData((Object)gridData);
        label2 = new Label(this.area, 0);
        label2.setText(AuthoringUIResources.UserDefinedDiagramDialog_addImage);
        this.addImageText = new Text(this.area, 2056);
        this.addImageText.setLayoutData((Object)gridData2);
        this.assignADDImageButton = new Button(this.area, 0);
        this.assignADDImageButton.setText(AuthoringUIResources.UserDefinedDiagramDialog_assignButton);
        this.assignADDImageButton.setLayoutData((Object)gridData3);
        this.clearADDImageButton = new Button(this.area, 0);
        this.clearADDImageButton.setText(AuthoringUIResources.clearButton_text);
        this.clearADDImageButton.setLayoutData((Object)gridData3);
        label = new Label(this.area, 0);
        label.setText("");
        this.useWPDImageButton = new Button(this.area, 32);
        this.useWPDImageButton.setText(AuthoringUIResources.UserDefinedDiagramDialog_useWPDImage);
        gridData = new GridData(1);
        gridData.horizontalSpan = 3;
        this.useWPDImageButton.setLayoutData((Object)gridData);
        label2 = new Label(this.area, 0);
        label2.setText(AuthoringUIResources.UserDefinedDiagramDialog_wpdImage);
        this.wpdImageText = new Text(this.area, 2056);
        this.wpdImageText.setLayoutData((Object)gridData2);
        this.assignWPDImageButton = new Button(this.area, 0);
        this.assignWPDImageButton.setText(AuthoringUIResources.UserDefinedDiagramDialog_assignButton);
        this.assignWPDImageButton.setLayoutData((Object)gridData3);
        this.clearWPDImageButton = new Button(this.area, 0);
        this.clearWPDImageButton.setText(AuthoringUIResources.clearButton_text);
        this.clearWPDImageButton.setLayoutData((Object)gridData3);
        this.loadData();
        if (TngUtil.isLocked((EObject)this.activity) || this.isWrapped) {
            this.disableControls();
        }
        this.addListeners();
        super.getShell().setText(AuthoringUIResources.UserDefinedDiagramDialog_title);
        return this.area;
    }

    private void disableControls() {
        this.useADImageButton.setEnabled(false);
        this.useADDImageButton.setEnabled(false);
        this.useWPDImageButton.setEnabled(false);
        this.assignADImageButton.setEnabled(false);
        this.assignADDImageButton.setEnabled(false);
        this.assignWPDImageButton.setEnabled(false);
        this.clearADImageButton.setEnabled(false);
        this.clearADDImageButton.setEnabled(false);
        this.clearWPDImageButton.setEnabled(false);
    }

    private void loadData() {
        this.existingList.addAll(this.activity.getSupportingMaterials());
        DiagramInfo diagramInfo = new DiagramInfo(this.activity);
        if (diagramInfo.getActivityDiagram() != null) {
            this.adImageText.setText(TngUtil.getLabelWithPath((Object)diagramInfo.getActivityDiagram()));
            this.activityDiagram = diagramInfo.getActivityDiagram();
            this.existingList.add(this.activityDiagram);
        }
        if (diagramInfo.getActivityDetailDiagram() != null) {
            this.addImageText.setText(TngUtil.getLabelWithPath((Object)diagramInfo.getActivityDetailDiagram()));
            this.activityDetailDiagram = diagramInfo.getActivityDetailDiagram();
            this.existingList.add(this.activityDetailDiagram);
        }
        if (diagramInfo.getWPDDiagram() != null) {
            this.wpdImageText.setText(TngUtil.getLabelWithPath((Object)diagramInfo.getWPDDiagram()));
            this.wpdDiagram = diagramInfo.getWPDDiagram();
            this.existingList.add(this.wpdDiagram);
        }
        this.useADImageButton.setSelection(diagramInfo.canPublishADImage());
        this.useADDImageButton.setSelection(diagramInfo.canPublishADDImage());
        this.useWPDImageButton.setSelection(diagramInfo.canPublishWPDImage());
    }

    private void addListeners() {
        this.assignADImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    SupportingMaterial supportingMaterial = UserDefinedDiagramDialog.this.openFilterDialog();
                    if (supportingMaterial != null) {
                        UserDefinedDiagramDialog.this.activityDiagram = supportingMaterial;
                        UserDefinedDiagramDialog.this.adImageText.setText(TngUtil.getLabelWithPath((Object)supportingMaterial));
                        UserDefinedDiagramDialog.this.existingList.add(UserDefinedDiagramDialog.this.activityDiagram);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.assignADDImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    SupportingMaterial supportingMaterial = UserDefinedDiagramDialog.this.openFilterDialog();
                    if (supportingMaterial != null) {
                        UserDefinedDiagramDialog.this.activityDetailDiagram = supportingMaterial;
                        UserDefinedDiagramDialog.this.addImageText.setText(TngUtil.getLabelWithPath((Object)supportingMaterial));
                        UserDefinedDiagramDialog.this.existingList.add(UserDefinedDiagramDialog.this.activityDetailDiagram);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.assignWPDImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    SupportingMaterial supportingMaterial = UserDefinedDiagramDialog.this.openFilterDialog();
                    if (supportingMaterial != null) {
                        UserDefinedDiagramDialog.this.wpdDiagram = supportingMaterial;
                        UserDefinedDiagramDialog.this.wpdImageText.setText(TngUtil.getLabelWithPath((Object)supportingMaterial));
                        UserDefinedDiagramDialog.this.existingList.add(UserDefinedDiagramDialog.this.wpdDiagram);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.clearADImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UserDefinedDiagramDialog.this.existingList.remove(UserDefinedDiagramDialog.this.activityDiagram);
                UserDefinedDiagramDialog.this.adImageText.setText("");
                UserDefinedDiagramDialog.this.activityDiagram = null;
            }
        });
        this.clearADDImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UserDefinedDiagramDialog.this.existingList.remove(UserDefinedDiagramDialog.this.activityDetailDiagram);
                UserDefinedDiagramDialog.this.addImageText.setText("");
                UserDefinedDiagramDialog.this.activityDetailDiagram = null;
            }
        });
        this.clearWPDImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UserDefinedDiagramDialog.this.existingList.remove(UserDefinedDiagramDialog.this.wpdDiagram);
                UserDefinedDiagramDialog.this.wpdImageText.setText("");
                UserDefinedDiagramDialog.this.wpdDiagram = null;
            }
        });
    }

    private SupportingMaterial openFilterDialog() {
        Object e;
        ItemsFilterDialog itemsFilterDialog = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.filter, this.activity, FilterConstants.SUPPORTING_MATERIALS, Arrays.asList(this.existingList.toArray()));
        itemsFilterDialog.setTitle(FilterConstants.SUPPORTING_MATERIALS);
        itemsFilterDialog.setViewerSelectionSingle(true);
        itemsFilterDialog.setInput(UmaUtil.getMethodLibrary((EObject)this.activity));
        itemsFilterDialog.setBlockOnOpen(true);
        itemsFilterDialog.open();
        ArrayList arrayList = itemsFilterDialog.getSelectedItems();
        if (arrayList != null && !arrayList.isEmpty() && (e = arrayList.get(0)) instanceof SupportingMaterial) {
            return (SupportingMaterial)e;
        }
        return null;
    }

    protected void okPressed() {
        if (TngUtil.isLocked((EObject)this.activity) || this.isWrapped) {
            super.okPressed();
        }
        boolean bl = false;
        DiagramInfo diagramInfo = new DiagramInfo(this.activity);
        if (this.activityDiagram != diagramInfo.getActivityDiagram()) {
            bl = true;
        }
        diagramInfo.setActivityDiagram(this.activityDiagram);
        if (!bl && this.activityDetailDiagram != diagramInfo.getActivityDetailDiagram()) {
            bl = true;
        }
        diagramInfo.setActivityDetailDiagram(this.activityDetailDiagram);
        if (!bl && this.wpdDiagram != diagramInfo.getWPDDiagram()) {
            bl = true;
        }
        diagramInfo.setWPDDiagram(this.wpdDiagram);
        boolean bl2 = diagramInfo.canPublishADImage();
        boolean bl3 = this.useADImageButton.getSelection();
        if (!bl && bl2 != bl3) {
            bl = true;
        }
        diagramInfo.setPublishADImage(this.useADImageButton.getSelection());
        bl2 = diagramInfo.canPublishADDImage();
        bl3 = this.useADDImageButton.getSelection();
        if (!bl && bl2 != bl3) {
            bl = true;
        }
        diagramInfo.setPublishADDImage(this.useADDImageButton.getSelection());
        bl2 = diagramInfo.canPublishWPDImage();
        bl3 = this.useWPDImageButton.getSelection();
        if (!bl && bl2 != bl3) {
            bl = true;
        }
        diagramInfo.setPublishWPDImage(this.useWPDImageButton.getSelection());
        if (bl && !this.promptSaveActiveEditor()) {
            return;
        }
        this.saveActiveEditor();
        super.okPressed();
    }

    private boolean promptSaveActiveEditor() {
        String string = AuthoringUIResources.processFormEditorSaveDialog_title;
        String string2 = AuthoringUIResources.processFormEditorSaveDialog_message2;
        return AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(string, string2);
    }

    private void saveActiveEditor() {
        BusyIndicator.showWhile((Display)this.editor.getEditorSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ((ProcessEditor)((UserDefinedDiagramDialog)UserDefinedDiagramDialog.this).editor).resourcesToSave.add(((ProcessComponent)((MethodElementEditorInput)UserDefinedDiagramDialog.this.editor.getEditorInput()).getMethodElement()).getProcess().eResource());
                UserDefinedDiagramDialog.this.editor.doSave((IProgressMonitor)new NullProgressMonitor());
            }
        });
    }
}

