/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.editors;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.actions.IWorkbenchPartAction;
import org.eclipse.epf.authoring.ui.actions.LibraryValidateAction;
import org.eclipse.epf.authoring.ui.dnd.EditingDomainTableTreeViewerDropAdapter;
import org.eclipse.epf.authoring.ui.editors.ActivityDetailDiagramEditor;
import org.eclipse.epf.authoring.ui.editors.ColumnDescriptor;
import org.eclipse.epf.authoring.ui.editors.GraphicalWPDependencyEditor;
import org.eclipse.epf.authoring.ui.editors.GraphicalWorkflowEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.editors.ProcessEditorInput;
import org.eclipse.epf.authoring.ui.forms.DeliveryProcessDescription;
import org.eclipse.epf.authoring.ui.forms.IExtensionFormPage;
import org.eclipse.epf.authoring.ui.forms.ProcessBreakdownStructureFormPage;
import org.eclipse.epf.authoring.ui.forms.ProcessDescription;
import org.eclipse.epf.authoring.ui.properties.EPFPropertySheetPage;
import org.eclipse.epf.authoring.ui.providers.ProcessEditorPageProvider;
import org.eclipse.epf.authoring.ui.views.ProcessViewer;
import org.eclipse.epf.diagram.core.part.AbstractDiagramEditor;
import org.eclipse.epf.diagram.core.part.DiagramEditorInput;
import org.eclipse.epf.diagram.core.part.DiagramEditorInputProxy;
import org.eclipse.epf.diagram.ui.service.DiagramEditorHelper;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ProcessAuthoringConfigurator;
import org.eclipse.epf.library.edit.IAdapterFactoryProvider;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.CommandStackChangedEvent;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.ui.IActionTypeProvider;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.EditingDomainComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.prefs.PreferenceUtil;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.edit.domain.TraceableAdapterFactoryEditingDomain;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessEditor
extends MethodElementEditor
implements IEditingDomainProvider,
IMenuListener,
ISelectionProvider,
IViewerProvider,
ITabbedPropertySheetPageContributor {
    public static final String EDITOR_ID = ProcessEditor.class.getName();
    public static final String WORKFLOW_EDITOR_ID = GraphicalWorkflowEditor.class.getName();
    public static final String ACTIVITY_DETAIL_DIAGRAM_EDITOR_ID = ActivityDetailDiagramEditor.class.getName();
    public static final String WPDEPENDENCY_EDITOR_ID = GraphicalWPDependencyEditor.class.getName();
    public static final ColumnDescriptor COL_DESC_NAME = new ColumnDescriptor("name", ProcessUtil.getColumnDisplayName((String)"name"), 3, 200, true, 1);
    public static final ColumnDescriptor COL_DESC_ID = new ColumnDescriptor("id", ProcessUtil.getColumnDisplayName((String)"id"), 0, 40, true, 0);
    public static final ColumnDescriptor COL_DESC_PREFIX = new ColumnDescriptor("prefix", ProcessUtil.getColumnDisplayName((String)"prefix"), 0, 80, true, 1);
    public static final ColumnDescriptor COL_DESC_MODEL_INFO = new ColumnDescriptor("model_info", ProcessUtil.getColumnDisplayName((String)"model_info"), 0, 120, true, 0);
    public static final ColumnDescriptor COL_DESC_TYPE = new ColumnDescriptor("type", ProcessUtil.getColumnDisplayName((String)"type"), 0, 80, true, 0);
    public static final ColumnDescriptor COL_DESC_PREDECESSORS = new ColumnDescriptor("predecessors", ProcessUtil.getColumnDisplayName((String)"predecessors"), 2, 100, true, 1);
    public static final ColumnDescriptor COL_DESC_IS_REPEATABLE = new ColumnDescriptor("is_repeatable", ProcessUtil.getColumnDisplayName((String)"is_repeatable"), 1, 60, true, 3);
    public static final ColumnDescriptor COL_DESC_IS_ONGOING = new ColumnDescriptor("is_ongoing", ProcessUtil.getColumnDisplayName((String)"is_ongoing"), 1, 60, true, 3);
    public static final ColumnDescriptor COL_DESC_IS_EVENT_DRIVEN = new ColumnDescriptor("is_event_driven", ProcessUtil.getColumnDisplayName((String)"is_event_driven"), 1, 60, true, 3);
    public static final ColumnDescriptor COL_DESC_TEAM = new ColumnDescriptor("teams", ProcessUtil.getColumnDisplayName((String)"teams"), 1, 100, true, 1);
    public static final ColumnDescriptor COL_DESC_ENTRY_STATE = new ColumnDescriptor("entry_state", ProcessUtil.getColumnDisplayName((String)"entry_state"), 1, 60, true, 1);
    public static final ColumnDescriptor COL_DESC_EXIT_STATE = new ColumnDescriptor("exit_state", ProcessUtil.getColumnDisplayName((String)"exit_state"), 1, 60, true, 1);
    public static final ColumnDescriptor COL_DESC_PRESENTATION_NAME = new ColumnDescriptor("presentation_name", ProcessUtil.getColumnDisplayName((String)"presentation_name"), 3, 200, true, 1);
    public static final ColumnDescriptor COL_DESC_DELIVERABLE = new ColumnDescriptor("deliverable", ProcessUtil.getColumnDisplayName((String)"deliverable"), 1, 100, true, 1);
    public static final ColumnDescriptor COL_DESC_IS_OPTIONAL = new ColumnDescriptor("is_optional", ProcessUtil.getColumnDisplayName((String)"is_optional"), 1, 60, true, 3);
    public static final ColumnDescriptor COL_DESC_IS_PLANNED = new ColumnDescriptor("is_planned", ProcessUtil.getColumnDisplayName((String)"is_planned"), 1, 60, true, 3);
    public static final ColumnDescriptor COL_DESC_HAS_MULTIPLE_OCCURRENCES = new ColumnDescriptor("has_multiple_occurrences", ProcessUtil.getColumnDisplayName((String)"has_multiple_occurrences"), 1, 60, true, 3);
    public static final String WBS_FORM_ID = "wbs";
    public static final String TA_FORM_ID = "tbs";
    public static final String WPBS_FORM_ID = "wpbs";
    public static final String CONSOLIDATED_FORM_ID = "consolidated";
    DiagramEditorHelper diagramEditorHelper = null;
    public static final List<ColumnDescriptor> DEFAULT_TBS_COLUMNS = Arrays.asList(COL_DESC_PRESENTATION_NAME, COL_DESC_MODEL_INFO, COL_DESC_TEAM, COL_DESC_TYPE, COL_DESC_IS_PLANNED, COL_DESC_HAS_MULTIPLE_OCCURRENCES, COL_DESC_IS_OPTIONAL);
    public static final List DEFAULT_WPBS_COLUMNS = Arrays.asList(COL_DESC_PRESENTATION_NAME, COL_DESC_MODEL_INFO, COL_DESC_ENTRY_STATE, COL_DESC_EXIT_STATE, COL_DESC_DELIVERABLE, COL_DESC_TYPE, COL_DESC_IS_PLANNED, COL_DESC_HAS_MULTIPLE_OCCURRENCES, COL_DESC_IS_OPTIONAL);
    public static final List<ColumnDescriptor> DEFAULT_WBS_COLUMNS = Arrays.asList(COL_DESC_PRESENTATION_NAME, COL_DESC_ID, COL_DESC_PREDECESSORS, COL_DESC_MODEL_INFO, COL_DESC_TYPE, COL_DESC_IS_PLANNED, COL_DESC_IS_REPEATABLE, COL_DESC_HAS_MULTIPLE_OCCURRENCES, COL_DESC_IS_ONGOING, COL_DESC_IS_EVENT_DRIVEN, COL_DESC_IS_OPTIONAL);
    public static final List<ColumnDescriptor> ALL_WBS_COLUMNS = new ArrayList<ColumnDescriptor>(DEFAULT_WBS_COLUMNS);
    public static final List<ColumnDescriptor> ALL_TBS_COLUMNS = new ArrayList<ColumnDescriptor>(DEFAULT_TBS_COLUMNS);
    public static final List<ColumnDescriptor> ALL_WPBS_COLUMNS = new ArrayList<ColumnDescriptor>(DEFAULT_WPBS_COLUMNS);
    public static final Map<String, ColumnDescriptor> idToColumnDescriptorMap = new HashMap<String, ColumnDescriptor>();
    protected static boolean addAdapterFactoryListeners;
    protected ComposedAdapterFactory adapterFactory;
    protected AdapterFactoryEditingDomain editingDomain;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection selectionChangedListeners = new ArrayList();
    protected ISelection viewSelection;
    protected ProcessComponent selectedProcessComponent;
    protected Process selectedProcess;
    protected Adapter processComponentListener = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            switch (notification.getFeatureID(ProcessComponent.class)) {
                case 0: {
                    String string = notification.getNewStringValue();
                    if (string == null) {
                        string = "";
                    }
                    ProcessEditor.this.setPartName(string);
                    if (ProcessEditor.this.pages == null) break;
                    for (Object e : ProcessEditor.this.pages) {
                        if (!(e instanceof ProcessDescription)) continue;
                        ((ProcessDescription)((Object)e)).refreshElementName(string);
                    }
                    break;
                }
            }
        }
    };
    protected AdapterFactoryContentProvider propContentProvider;
    protected MethodConfiguration currentConfig;
    protected ILibraryChangeListener libraryListener = new ILibraryChangeListener(){

        public void libraryChanged(int n, Collection collection) {
            switch (n) {
                case 8: {
                    if (collection == null || !collection.contains(ProcessEditor.this.currentConfig)) break;
                    MethodConfiguration methodConfiguration = ProcessAuthoringConfigurator.INSTANCE.getMethodConfiguration();
                    try {
                        ProcessAuthoringConfigurator.INSTANCE.setMethodConfiguration(ProcessEditor.this.currentConfig);
                        ProcessEditor.this.refreshAll();
                    }
                    finally {
                        ProcessAuthoringConfigurator.INSTANCE.setMethodConfiguration(methodConfiguration);
                    }
                }
            }
        }
    };
    protected ILibraryServiceListener libSvcListener = new ILibraryServiceListener(){

        public void configurationSet(MethodConfiguration methodConfiguration) {
            ProcessEditor.this.configChanged();
        }

        public void libraryClosed(MethodLibrary methodLibrary) {
        }

        public void libraryCreated(MethodLibrary methodLibrary) {
        }

        public void libraryOpened(MethodLibrary methodLibrary) {
        }

        public void libraryReopened(MethodLibrary methodLibrary) {
        }

        public void librarySet(MethodLibrary methodLibrary) {
        }
    };
    protected ProcessBreakdownStructureFormPage WBSTab;
    protected ProcessBreakdownStructureFormPage OBSTab;
    protected ProcessBreakdownStructureFormPage PBSTab;
    protected ProcessBreakdownStructureFormPage procTab;
    protected ProcessBreakdownStructureFormPage[] extensionTabs = null;
    protected ProcessBreakdownStructureFormPage[] bsPages;
    protected EPFPropertySheetPage propertySheetPage;
    public Collection resourcesToSave = new ArrayList();
    protected IPartListener partActivationListener = new IPartListener(){

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart instanceof PropertySheet) {
                ProcessEditor.this.removePropertiesDropDownMenu(iWorkbenchPart);
            }
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart instanceof PropertySheet) {
                ProcessEditor.this.propertySheetPage = null;
            }
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        }

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart instanceof PropertySheet) {
                ProcessEditor.this.removePropertiesDropDownMenu(iWorkbenchPart);
            }
        }
    };
    protected IPropertyChangeListener prefStoreListener;
    protected Suppression suppression;
    protected boolean synchronizingSelection;
    protected boolean inputChanged;
    public static final IAdapterFactoryProvider adapterFactoryProvider;

    static {
        ALL_WBS_COLUMNS.add(COL_DESC_PREFIX);
        ALL_TBS_COLUMNS.add(COL_DESC_PREFIX);
        ALL_WPBS_COLUMNS.add(COL_DESC_PREFIX);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_NAME.id, COL_DESC_NAME);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_ID.id, COL_DESC_ID);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_PREFIX.id, COL_DESC_PREFIX);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_MODEL_INFO.id, COL_DESC_MODEL_INFO);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_TYPE.id, COL_DESC_TYPE);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_PREDECESSORS.id, COL_DESC_PREDECESSORS);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_IS_REPEATABLE.id, COL_DESC_IS_REPEATABLE);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_IS_ONGOING.id, COL_DESC_IS_ONGOING);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_IS_EVENT_DRIVEN.id, COL_DESC_IS_EVENT_DRIVEN);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_TEAM.id, COL_DESC_TEAM);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_ENTRY_STATE.id, COL_DESC_ENTRY_STATE);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_EXIT_STATE.id, COL_DESC_EXIT_STATE);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_PRESENTATION_NAME.id, COL_DESC_PRESENTATION_NAME);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_DELIVERABLE.id, COL_DESC_DELIVERABLE);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_IS_OPTIONAL.id, COL_DESC_IS_OPTIONAL);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_IS_PLANNED.id, COL_DESC_IS_PLANNED);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_HAS_MULTIPLE_OCCURRENCES.id, COL_DESC_HAS_MULTIPLE_OCCURRENCES);
        ALL_WBS_COLUMNS.add(COL_DESC_NAME);
        ALL_TBS_COLUMNS.add(COL_DESC_NAME);
        ALL_WPBS_COLUMNS.add(COL_DESC_NAME);
        addAdapterFactoryListeners = false;
        adapterFactoryProvider = new IAdapterFactoryProvider(){

            public AdapterFactory getCBSAdapterFactory() {
                return TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory();
            }

            public AdapterFactory getTBSAdapterFactory() {
                return TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
            }

            public AdapterFactory getWBSAdapterFactory() {
                return TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
            }

            public AdapterFactory getWPBSAdapterFactory() {
                return TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
            }
        };
    }

    @Override
    protected boolean isValidateResourcesBeforeSaveRequired() {
        return true;
    }

    @Override
    protected LibraryValidateAction createValidateResourceAction() {
        LibraryValidateAction libraryValidateAction = super.createValidateResourceAction();
        libraryValidateAction.putContextData("CTX_ADAPTER_FACTORY_PROVIDER", adapterFactoryProvider);
        return libraryValidateAction;
    }

    protected void inputChanged(Object object) {
        this.inputChanged = false;
        if (!(object instanceof MethodElementEditorInput)) {
            return;
        }
        MethodElementEditorInput methodElementEditorInput = (MethodElementEditorInput)object;
        MethodElement methodElement = methodElementEditorInput.getMethodElement();
        if (methodElement instanceof ProcessComponent) {
            this.selectedProcessComponent = (ProcessComponent)methodElement;
            this.selectedProcess = this.getTopBreakdownElement(this.selectedProcessComponent);
            this.suppression = this.getSuppression(this.selectedProcess);
            if (this.WBSTab != null) {
                this.WBSTab.setProcess(this.selectedProcess);
            }
            if (this.OBSTab != null) {
                this.OBSTab.setProcess(this.selectedProcess);
            }
            if (this.PBSTab != null) {
                this.PBSTab.setProcess(this.selectedProcess);
            }
            if (this.procTab != null) {
                this.procTab.setProcess(this.selectedProcess);
            }
            if (this.extensionTabs != null) {
                int n = 0;
                while (n < this.extensionTabs.length) {
                    if (this.extensionTabs[n] != null) {
                        this.extensionTabs[n].setProcess(this.selectedProcess);
                    }
                    ++n;
                }
            }
        }
    }

    protected Process getTopBreakdownElement(ProcessComponent processComponent) {
        return (Process)ProcessUtil.getTopBreakdownElement((ProcessComponent)processComponent);
    }

    protected Suppression getSuppression(Process process) {
        return Suppression.getSuppression((Process)process);
    }

    protected Image getProcTitleImage() {
        MethodElement methodElement;
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof MethodElementEditorInput && (methodElement = ((MethodElementEditorInput)iEditorInput).getMethodElement()) instanceof ProcessComponent) {
            ProcessComponent processComponent = (ProcessComponent)methodElement;
            Process process = processComponent.getProcess();
            if (process instanceof CapabilityPattern) {
                return LibraryUIImages.IMG_CAPABILITY_PATTERN;
            }
            if (process instanceof DeliveryProcess) {
                return LibraryUIImages.IMG_DELIVERY_PROCESS;
            }
        }
        return LibraryUIImages.IMG_PROCESS;
    }

    protected void removePropertiesDropDownMenu(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart instanceof PropertySheet) {
            IViewSite iViewSite = ((PropertySheet)iWorkbenchPart).getViewSite();
            IMenuManager iMenuManager = iViewSite.getActionBars().getMenuManager();
            iMenuManager.removeAll();
            iMenuManager.updateAll(true);
        }
    }

    @Override
    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        super.init(iEditorSite, iEditorInput);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new ResourceItemProviderAdapterFactory());
        arrayList.add(new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory = new ComposedAdapterFactory(arrayList);
        CommandStack commandStack = this.actionMgr.getCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject eventObject) {
                boolean bl = false;
                if (eventObject instanceof CommandStackChangedEvent) {
                    switch (((CommandStackChangedEvent)eventObject).getType()) {
                        case 2: 
                        case 4: {
                            bl = true;
                        }
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            ProcessEditor.this.firePropertyChange(257);
                            Command command = ((CommandStack)eventObject.getSource()).getMostRecentCommand();
                            if (command != null) {
                                Object[] objectArray;
                                if (!(TngUtil.unwrap((Command)command) instanceof SetCommand)) {
                                    ProcessEditor.this.setSelectionToViewer(command.getAffectedObjects());
                                }
                                if (command instanceof CreateChildCommand && (this).ProcessEditor.this.currentViewer instanceof ProcessViewer && (objectArray = command.getAffectedObjects().toArray()).length == 1) {
                                    ProcessViewer processViewer = (ProcessViewer)(this).ProcessEditor.this.currentViewer;
                                    processViewer.editElement(objectArray[0], 0);
                                }
                            }
                        }
                    });
                }
            }
        });
        this.editingDomain = new TraceableAdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, commandStack);
        LibraryService.getInstance().addListener(this.libSvcListener);
        ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
        if (iLibraryManager != null) {
            iLibraryManager.addListener(this.libraryListener);
            iLibraryManager.startListeningTo(this.actionMgr.getCommandStack());
            if (!addAdapterFactoryListeners) {
                addAdapterFactoryListeners = true;
                iLibraryManager.startListeningTo(TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory());
                iLibraryManager.startListeningTo(TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory());
                iLibraryManager.startListeningTo(TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory());
            }
        }
        this.setPartFacade(iEditorInput);
        MethodElementEditorInput methodElementEditorInput = (MethodElementEditorInput)iEditorInput;
        this.elementObj = methodElementEditorInput.getMethodElement();
        if (this.elementObj instanceof ProcessComponent) {
            this.selectedProcessComponent = (ProcessComponent)this.elementObj;
            this.selectedProcess = this.selectedProcessComponent.getProcess();
        }
        if (this.selectedProcessComponent != null) {
            this.selectedProcessComponent.eAdapters().add((Object)this.processComponentListener);
        }
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.partActivationListener);
        if (this.prefStoreListener == null) {
            this.prefStoreListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ProcessBreakdownStructureFormPage processBreakdownStructureFormPage = null;
                    if (propertyChangeEvent.getProperty().equals("org.eclipse.epf.library.edit.wbs_columns")) {
                        processBreakdownStructureFormPage = ProcessEditor.this.WBSTab;
                    } else if (propertyChangeEvent.getProperty().equals("org.eclipse.epf.library.edit.tbs_columns")) {
                        processBreakdownStructureFormPage = ProcessEditor.this.OBSTab;
                    } else if (propertyChangeEvent.getProperty().equals("org.eclipse.epf.library.edit.wpbs_columns")) {
                        processBreakdownStructureFormPage = ProcessEditor.this.PBSTab;
                    }
                    if (processBreakdownStructureFormPage != null) {
                        ColumnDescriptor[] columnDescriptorArray = ProcessEditor.toColumnDescriptors(ProcessEditor.this.getPreferenceStore().getString(propertyChangeEvent.getProperty()));
                        processBreakdownStructureFormPage.updateColumns(columnDescriptorArray);
                        if (processBreakdownStructureFormPage == ProcessEditor.this.WBSTab || processBreakdownStructureFormPage == ProcessEditor.this.OBSTab) {
                            EList eList = ProcessEditor.toColumnDescriptorList(ProcessEditor.this.getPreferenceStore().getString("org.eclipse.epf.library.edit.wbs_columns"));
                            ColumnDescriptor[] columnDescriptorArray2 = ProcessEditor.toColumnDescriptors(ProcessEditor.this.getPreferenceStore().getString("org.eclipse.epf.library.edit.tbs_columns"));
                            int n = 0;
                            while (n < columnDescriptorArray2.length) {
                                ColumnDescriptor columnDescriptor = columnDescriptorArray2[n];
                                if (columnDescriptor == COL_DESC_TEAM) {
                                    eList.add(columnDescriptor);
                                    break;
                                }
                                ++n;
                            }
                            ColumnDescriptor[] columnDescriptorArray3 = new ColumnDescriptor[eList.size()];
                            eList.toArray(columnDescriptorArray3);
                            ProcessEditor.this.procTab.updateColumns(columnDescriptorArray3);
                        }
                    }
                }
            };
        }
        this.getPreferenceStore().addPropertyChangeListener(this.prefStoreListener);
        this.diagramEditorHelper = new DiagramEditorHelper();
    }

    protected void setPartFacade(IEditorInput iEditorInput) {
        this.setPartName(iEditorInput.getName());
        this.setTitleImage(this.getProcTitleImage());
    }

    public void setSelectionToViewer(Collection collection) {
        if (this.currentViewer != null && collection != null && !collection.isEmpty()) {
            this.currentViewer.setSelection((ISelection)new StructuredSelection(collection.toArray()), true);
        }
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    @Override
    public void dispose() {
        ILibraryManager iLibraryManager;
        this.closeAllDiagramEditors();
        this.getPreferenceStore().removePropertyChangeListener(this.prefStoreListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if ((iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager()) != null) {
            iLibraryManager.removeListener(this.libraryListener);
            iLibraryManager.stopListeningTo(this.editingDomain.getCommandStack());
        }
        LibraryService.getInstance().removeListener(this.libSvcListener);
        if (this.selectedProcessComponent != null) {
            this.selectedProcessComponent.eAdapters().remove((Object)this.processComponentListener);
        }
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partActivationListener);
        boolean bl = this.isDirty();
        super.dispose();
        if (this.diagramEditorHelper != null) {
            this.diagramEditorHelper.dispose();
        }
        this.suppression.saveIsDone();
    }

    private void closeAllDiagramEditors() {
        IWorkbenchPage iWorkbenchPage = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (iWorkbenchPage == null) {
            return;
        }
        IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
        ArrayList<IEditorReference> arrayList = new ArrayList<IEditorReference>();
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            MethodElement methodElement;
            DiagramEditorInput diagramEditorInput;
            IEditorReference iEditorReference = iEditorReferenceArray[n];
            IEditorPart iEditorPart = iEditorReference.getEditor(true);
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            if (iEditorInput instanceof DiagramEditorInputProxy && (diagramEditorInput = ((DiagramEditorInputProxy)iEditorInput).getDiagramEditorInput()) != null && (methodElement = diagramEditorInput.getMethodElement()) instanceof BreakdownElement && this.selectedProcess == TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)methodElement))) {
                arrayList.add(iEditorReference);
            }
            ++n;
        }
        if (!arrayList.isEmpty()) {
            IEditorReference[] iEditorReferenceArray2 = new IEditorReference[arrayList.size()];
            arrayList.toArray(iEditorReferenceArray2);
            iWorkbenchPage.closeEditors(iEditorReferenceArray2, true);
        }
    }

    protected void addDescriptionPage() throws PartInitException {
        if (this.selectedProcess instanceof DeliveryProcess) {
            this.addPage(0, (IFormPage)new DeliveryProcessDescription(this));
        } else {
            this.addPage(0, (IFormPage)new ProcessDescription(this));
        }
    }

    @Override
    protected void addPages() {
        try {
            Object object;
            this.addDescriptionPage();
            PreferenceUtil.validatePreferences();
            IPreferenceStore iPreferenceStore = this.getPreferenceStore();
            ArrayList<ProcessBreakdownStructureFormPage> arrayList = new ArrayList<ProcessBreakdownStructureFormPage>();
            this.WBSTab = new ProcessBreakdownStructureFormPage(this, WBS_FORM_ID, AuthoringUIResources.ProcessEditor_WorkBreakdownStructure);
            ColumnDescriptor[] columnDescriptorArray = ProcessEditor.toColumnDescriptors(iPreferenceStore.getString("org.eclipse.epf.library.edit.wbs_columns"));
            ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
            this.currentConfig = LibraryService.getInstance().getCurrentMethodConfiguration();
            ProcessAuthoringConfigurator.INSTANCE.setMethodConfiguration(this.currentConfig);
            if (composedAdapterFactory instanceof ConfigurableComposedAdapterFactory) {
                ((ConfigurableComposedAdapterFactory)composedAdapterFactory).setFilter((IFilter)ProcessAuthoringConfigurator.INSTANCE);
            }
            this.WBSTab.setAdapterFactory((AdapterFactory)composedAdapterFactory);
            this.WBSTab.setColumnDescriptors(columnDescriptorArray);
            int n = this.addPage(this.WBSTab.createControl(this.getContainer()));
            this.setPageText(n, this.WBSTab.getTitle());
            this.WBSTab.setTabIndex(n);
            StructuredViewer structuredViewer = (StructuredViewer)this.WBSTab.getViewer();
            this.createContextMenuFor(structuredViewer);
            arrayList.add(this.WBSTab);
            this.OBSTab = new ProcessBreakdownStructureFormPage(this, TA_FORM_ID, AuthoringUIResources.ProcessEditor_TeamAllocation);
            columnDescriptorArray = ProcessEditor.toColumnDescriptors(iPreferenceStore.getString("org.eclipse.epf.library.edit.tbs_columns"));
            composedAdapterFactory = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
            if (composedAdapterFactory instanceof ConfigurableComposedAdapterFactory) {
                ((ConfigurableComposedAdapterFactory)composedAdapterFactory).setFilter((IFilter)ProcessAuthoringConfigurator.INSTANCE);
            }
            this.OBSTab.setAdapterFactory((AdapterFactory)composedAdapterFactory);
            this.OBSTab.setColumnDescriptors(columnDescriptorArray);
            n = this.addPage(this.OBSTab.createControl(this.getContainer()));
            this.setPageText(n, this.OBSTab.getTitle());
            this.OBSTab.setTabIndex(n);
            structuredViewer = (StructuredViewer)this.OBSTab.getViewer();
            this.createContextMenuFor(structuredViewer);
            arrayList.add(this.OBSTab);
            this.PBSTab = new ProcessBreakdownStructureFormPage(this, WPBS_FORM_ID, AuthoringUIResources.ProcessEditor_WorkProductUsage);
            columnDescriptorArray = ProcessEditor.toColumnDescriptors(iPreferenceStore.getString("org.eclipse.epf.library.edit.wpbs_columns"));
            composedAdapterFactory = TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
            if (composedAdapterFactory instanceof ConfigurableComposedAdapterFactory) {
                ((ConfigurableComposedAdapterFactory)composedAdapterFactory).setFilter((IFilter)ProcessAuthoringConfigurator.INSTANCE);
            }
            this.PBSTab.setAdapterFactory((AdapterFactory)composedAdapterFactory);
            this.PBSTab.setColumnDescriptors(columnDescriptorArray);
            n = this.addPage(this.PBSTab.createControl(this.getContainer()));
            this.setPageText(n, this.PBSTab.getTitle());
            this.PBSTab.setTabIndex(n);
            structuredViewer = (StructuredViewer)this.PBSTab.getViewer();
            this.createContextMenuFor(structuredViewer);
            arrayList.add(this.PBSTab);
            this.procTab = new ProcessBreakdownStructureFormPage(this, CONSOLIDATED_FORM_ID, AuthoringUIResources.ProcessEditor_ConsolidatedView);
            this.procTab.setReadOnly(true);
            composedAdapterFactory = TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory();
            if (composedAdapterFactory instanceof ConfigurableComposedAdapterFactory) {
                ((ConfigurableComposedAdapterFactory)composedAdapterFactory).setFilter((IFilter)ProcessAuthoringConfigurator.INSTANCE);
            }
            this.procTab.setAdapterFactory((AdapterFactory)composedAdapterFactory);
            EList eList = ProcessEditor.toColumnDescriptorList(iPreferenceStore.getString("org.eclipse.epf.library.edit.wbs_columns"));
            ColumnDescriptor[] columnDescriptorArray2 = ProcessEditor.toColumnDescriptors(iPreferenceStore.getString("org.eclipse.epf.library.edit.tbs_columns"));
            int n2 = 0;
            while (n2 < columnDescriptorArray2.length) {
                object = columnDescriptorArray2[n2];
                if (object == COL_DESC_TEAM) {
                    eList.add(object);
                    break;
                }
                ++n2;
            }
            ColumnDescriptor[] columnDescriptorArray3 = new ColumnDescriptor[eList.size()];
            eList.toArray(columnDescriptorArray3);
            this.procTab.setColumnDescriptors(columnDescriptorArray3);
            n = this.addPage(this.procTab.createControl(this.getContainer()));
            this.setPageText(n, this.procTab.getTitle());
            this.procTab.setTabIndex(n);
            structuredViewer = (StructuredViewer)this.procTab.getViewer();
            this.createContextMenuFor(structuredViewer);
            arrayList.add(this.procTab);
            object = ProcessEditorPageProvider.getInstance().getPageProviders();
            if (object != null && object.size() > 0) {
                try {
                    this.extensionTabs = new ProcessBreakdownStructureFormPage[object.size()];
                    int n3 = 0;
                    while (n3 < object.size()) {
                        Object e = object.get(n3);
                        if (e instanceof IExtensionFormPage) {
                            IExtensionFormPage iExtensionFormPage = (IExtensionFormPage)e;
                            IFormPage iFormPage = iExtensionFormPage.setEditor(this);
                            iExtensionFormPage.setInput(this.selectedProcess);
                            ProcessBreakdownStructureFormPage processBreakdownStructureFormPage = null;
                            if (iFormPage instanceof ProcessBreakdownStructureFormPage) {
                                this.extensionTabs[n3] = processBreakdownStructureFormPage = (ProcessBreakdownStructureFormPage)iFormPage;
                            }
                            n = this.addPage(processBreakdownStructureFormPage.createControl(this.getContainer()));
                            this.setPageText(n, processBreakdownStructureFormPage.getTitle());
                            processBreakdownStructureFormPage.setTabIndex(n);
                            structuredViewer = (StructuredViewer)processBreakdownStructureFormPage.getViewer();
                            this.createContextMenuFor(structuredViewer);
                            arrayList.add(processBreakdownStructureFormPage);
                        }
                        ++n3;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.bsPages = new ProcessBreakdownStructureFormPage[arrayList.size()];
            int n4 = 0;
            while (n4 < arrayList.size()) {
                this.bsPages[n4] = (ProcessBreakdownStructureFormPage)((Object)arrayList.get(n4));
                ++n4;
            }
            this.inputChanged(this.getEditorInput());
        }
        catch (PartInitException partInitException) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)partInitException);
            partInitException.printStackTrace();
        }
    }

    protected void setActivePage(int n) {
        Viewer viewer;
        Object object;
        super.setActivePage(n);
        this.handlePageChange();
        if (n > 0 && this.bsPages.length <= n && ((object = (viewer = this.bsPages[n].getViewer()).getSelection()) == null || object.isEmpty())) {
            ISelection iSelection = null;
            if (this.getEditorInput() instanceof ProcessEditorInput) {
                iSelection = ((ProcessEditorInput)this.getEditorInput()).getInitialSelection();
            }
            object = iSelection == null ? new StructuredSelection((Object)this.selectedProcess) : iSelection;
            viewer.setSelection(object, true);
        }
    }

    public IFormPage setActivePage(String string) {
        Object object;
        int n = -1;
        Object object2 = null;
        int n2 = 0;
        while (n2 < this.pages.size()) {
            IFormPage iFormPage;
            object = this.pages.get(n2);
            if (object instanceof IFormPage && (iFormPage = (IFormPage)object).getId().equals(string)) {
                n = n2;
                object2 = iFormPage;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            n2 = 0;
            while (n2 < this.bsPages.length) {
                object = this.bsPages[n2];
                if (object.getId().equals(string)) {
                    n = ((ProcessBreakdownStructureFormPage)((Object)object)).getTabIndex();
                    object2 = object;
                    break;
                }
                ++n2;
            }
        }
        if (n == -1 && this.extensionTabs != null) {
            n2 = 0;
            while (n2 < this.extensionTabs.length) {
                object = this.extensionTabs[n2];
                if (object.getId().equals(string)) {
                    n = ((ProcessBreakdownStructureFormPage)((Object)object)).getTabIndex();
                    object2 = object;
                    break;
                }
                ++n2;
            }
        }
        if (object2 != null) {
            this.setActivePage(n);
            return object2;
        }
        return null;
    }

    protected void handlePageChange() {
        int n = this.getActivePage();
        if (n != -1) {
            Object e = this.pages.get(n);
            if (e instanceof ProcessDescription) {
                ((ProcessDescription)((Object)e)).setFormText();
            }
            if (this.WBSTab != null && n == this.WBSTab.getTabIndex()) {
                this.setCurrentViewer(this.WBSTab.getViewer());
            } else if (this.OBSTab != null && n == this.OBSTab.getTabIndex()) {
                this.setCurrentViewer(this.OBSTab.getViewer());
            } else if (this.PBSTab != null && n == this.PBSTab.getTabIndex()) {
                this.setCurrentViewer(this.PBSTab.getViewer());
            } else if (this.procTab != null && n == this.procTab.getTabIndex()) {
                this.setCurrentViewer(this.procTab.getViewer());
            } else if (this.extensionTabs != null) {
                int n2 = 0;
                while (n2 < this.extensionTabs.length) {
                    if (this.extensionTabs[n2] != null && n == this.extensionTabs[n2].getTabIndex()) {
                        this.setCurrentViewer(this.extensionTabs[n2].getViewer());
                    }
                    ++n2;
                }
            } else {
                this.setCurrentViewer(null);
            }
            if (this.propertySheetPage != null) {
                this.propertySheetPage.refresh();
            }
        }
    }

    @Override
    protected void pageChange(int n) {
        super.pageChange(n);
        this.handlePageChange();
    }

    public void createContextMenuFor(StructuredViewer structuredViewer) {
        MenuManager menuManager = new MenuManager("#PopUp");
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu menu = menuManager.createContextMenu(structuredViewer.getControl());
        structuredViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)structuredViewer);
        structuredViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                ProcessEditor.this.setSelection((ISelection)iStructuredSelection);
            }
        });
        int n = 7;
        Transfer[] transferArray = new Transfer[]{LocalTransfer.getInstance()};
        structuredViewer.addDropSupport(n, transferArray, (DropTargetListener)new ProcessEditorDropAdapter((EditingDomain)this.editingDomain, (Viewer)structuredViewer));
        n = 3;
        transferArray = new Transfer[]{LocalTransfer.getInstance()};
        structuredViewer.addDragSupport(n, transferArray, (DragSourceListener)new ViewerDragAdapter((Viewer)structuredViewer));
    }

    protected void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            IContentProvider iContentProvider;
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        ProcessEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            if (this.currentViewer instanceof ProcessViewer && (iContentProvider = ((ProcessViewer)this.currentViewer).getContentProvider()) instanceof AdapterFactoryContentProvider) {
                AdapterFactoryContentProvider adapterFactoryContentProvider = (AdapterFactoryContentProvider)iContentProvider;
                AdapterFactory adapterFactory = adapterFactoryContentProvider.getAdapterFactory();
                if (adapterFactory instanceof EditingDomainComposedAdapterFactory) {
                    ((EditingDomainComposedAdapterFactory)adapterFactory).setEditingDomain((EditingDomain)this.editingDomain);
                } else {
                    this.editingDomain.setAdapterFactory(adapterFactory);
                }
                if (this.propContentProvider != null) {
                    this.propContentProvider.setAdapterFactory(adapterFactory);
                }
            }
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public static Activity getParentActivity(BreakdownElement breakdownElement, AdapterFactory adapterFactory) {
        Activity activity = UmaUtil.getParentActivity((BreakdownElement)breakdownElement);
        if (activity != null) {
            return activity;
        }
        return null;
    }

    public static AdapterFactory getAdapterFactory(StructuredViewer structuredViewer) {
        return ((AdapterFactoryContentProvider)structuredViewer.getContentProvider()).getAdapterFactory();
    }

    public static void setSelectionToViewer(Viewer viewer, IStructuredSelection iStructuredSelection, boolean bl) {
        if (bl) {
            IStructuredSelection iStructuredSelection2 = (IStructuredSelection)viewer.getSelection();
            Object object = null;
            if (iStructuredSelection2.size() == 1) {
                Activity activity;
                object = iStructuredSelection2.getFirstElement();
                if (object instanceof BreakdownElement && (activity = ProcessEditor.getParentActivity((BreakdownElement)object, ProcessEditor.getAdapterFactory((StructuredViewer)viewer))) != iStructuredSelection.getFirstElement()) {
                    viewer.setSelection((ISelection)iStructuredSelection, true);
                }
            } else {
                viewer.setSelection((ISelection)iStructuredSelection, true);
            }
        } else {
            viewer.setSelection((ISelection)iStructuredSelection, true);
        }
    }

    @Override
    public void setSelection(ISelection iSelection) {
        if (this.synchronizingSelection) {
            return;
        }
        this.viewSelection = iSelection;
        ArrayList arrayList = new ArrayList(this.selectionChangedListeners);
        int n = 0;
        while (n < arrayList.size()) {
            ISelectionChangedListener iSelectionChangedListener = (ISelectionChangedListener)arrayList.get(n);
            iSelectionChangedListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, iSelection));
            ++n;
        }
        this.synchronizeSelection(iSelection, this.currentViewer);
    }

    protected boolean refreshOutOfSynch(ISelection iSelection) {
        if (this.currentViewer != null && iSelection instanceof IStructuredSelection) {
            Object object;
            ArrayList arrayList;
            boolean bl = false;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            HashSet<Resource> hashSet = new HashSet<Resource>();
            Object object2 = iStructuredSelection.iterator();
            while (object2.hasNext()) {
                arrayList = TngUtil.unwrap(object2.next());
                if (!(arrayList instanceof EObject)) continue;
                EObject eObject = (EObject)arrayList;
                if (eObject.eIsProxy()) {
                    eObject = RefreshJob.getInstance().resolve(eObject);
                    bl = true;
                }
                if ((object = eObject.eResource()) == null) continue;
                hashSet.add((Resource)object);
            }
            if (!hashSet.isEmpty()) {
                boolean bl2;
                object2 = new ArrayList();
                arrayList = new ArrayList();
                ResourceUtil.checkOutOfSynchResources(hashSet, (Collection)object2, arrayList);
                if (!(((ArrayList)object2).isEmpty() && arrayList.isEmpty() || !(bl2 = this.promptReloadFiles()))) {
                    Object object3;
                    if (!((ArrayList)object2).isEmpty()) {
                        PersistenceUtil.unload((Collection)object2);
                    }
                    object = null;
                    if (!arrayList.isEmpty() && (object3 = LibraryService.getInstance().getCurrentLibraryManager()) != null) {
                        object = object3.reloadResources(arrayList);
                    }
                    if (!((ArrayList)object2).isEmpty() || object != null) {
                        bl = true;
                    }
                    object3 = arrayList.iterator();
                    while (object3.hasNext()) {
                        FileManager.getInstance().refresh((Resource)object3.next());
                    }
                }
            }
            if (bl) {
                this.currentViewer.refresh();
                return true;
            }
        }
        return false;
    }

    protected void synchronizeSelection(ISelection iSelection, Viewer viewer) {
        block45: {
            try {
                Object object;
                IStructuredSelection iStructuredSelection;
                this.synchronizingSelection = true;
                if (viewer == null || !(iSelection instanceof IStructuredSelection) || (iStructuredSelection = (IStructuredSelection)iSelection).size() != 1) break block45;
                Object object2 = iStructuredSelection.getFirstElement();
                IStructuredSelection iStructuredSelection2 = null;
                boolean bl = false;
                ArrayList<Object> arrayList = null;
                AdapterFactory adapterFactory = ProcessEditor.getAdapterFactory((StructuredViewer)viewer);
                if (object2 instanceof BreakdownElementWrapperItemProvider) {
                    if (((BreakdownElementWrapperItemProvider)object2).isReadOnly()) {
                        if (adapterFactory != null) {
                            object = TngUtil.unwrap((Object)object2);
                            arrayList = new ArrayList<Object>();
                            ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)object2;
                            while (true) {
                                arrayList.add(0, object);
                                Object object3 = iTreeItemContentProvider.getParent(object);
                                if (object3 != null) {
                                    if (object3 instanceof BreakdownElementWrapperItemProvider) {
                                        iTreeItemContentProvider = (ITreeItemContentProvider)object3;
                                        object = TngUtil.unwrap((Object)object3);
                                        continue;
                                    }
                                    iTreeItemContentProvider = (ITreeItemContentProvider)adapterFactory.adapt(object3, ITreeItemContentProvider.class);
                                    object = object3;
                                    continue;
                                }
                                break;
                            }
                        }
                    } else if (this.procTab.getViewer() == viewer) {
                        object2 = TngUtil.unwrap((Object)object2);
                        iSelection = new StructuredSelection(object2);
                    } else if (this.extensionTabs != null) {
                        int n = 0;
                        while (n < this.extensionTabs.length) {
                            if (this.extensionTabs[n].getViewer() == viewer) {
                                object2 = TngUtil.unwrap((Object)object2);
                                iSelection = new StructuredSelection(object2);
                            }
                            ++n;
                        }
                    }
                }
                if (object2 instanceof BreakdownElement) {
                    if (this.procTab.getViewer() != viewer) {
                        this.procTab.getViewer().setSelection(iSelection, false);
                    }
                    if (this.extensionTabs != null) {
                        int n = 0;
                        while (n < this.extensionTabs.length) {
                            if (this.extensionTabs[n].getViewer() != viewer) {
                                this.extensionTabs[n].getViewer().setSelection(iSelection, false);
                            }
                            ++n;
                        }
                    }
                    if (object2 instanceof Activity || object2 instanceof Milestone) {
                        iStructuredSelection2 = (IStructuredSelection)iSelection;
                    } else {
                        object = ProcessEditor.getParentActivity((BreakdownElement)object2, adapterFactory);
                        if (object != null) {
                            iStructuredSelection2 = new StructuredSelection(object);
                            bl = true;
                        }
                    }
                }
                if (iStructuredSelection2 != null) {
                    object = null;
                    if (this.WBSTab != null) {
                        object = this.WBSTab.getViewer();
                    }
                    if (object != null && object != viewer) {
                        if (object2 instanceof WorkBreakdownElement) {
                            object.setSelection(iSelection, false);
                        } else {
                            ProcessEditor.setSelectionToViewer((Viewer)object, iStructuredSelection2, bl);
                        }
                    }
                    if (this.OBSTab != null) {
                        object = this.OBSTab.getViewer();
                    }
                    if (object != null && object != viewer) {
                        if (object2 instanceof RoleDescriptor) {
                            object.setSelection(iSelection, false);
                        } else {
                            ProcessEditor.setSelectionToViewer((Viewer)object, iStructuredSelection2, bl);
                        }
                    }
                    if (this.PBSTab != null) {
                        object = this.PBSTab.getViewer();
                    }
                    if (object != null && object != viewer) {
                        if (object2 instanceof WorkProductDescriptor) {
                            object.setSelection(iSelection, false);
                        } else {
                            ProcessEditor.setSelectionToViewer((Viewer)object, iStructuredSelection2, bl);
                        }
                    }
                } else if (arrayList != null) {
                    object = null;
                    if (this.WBSTab != null && (object = this.WBSTab.getViewer()) != viewer) {
                        iSelection = new StructuredSelection(ProcessEditor.findSelection(arrayList, this.WBSTab.getAdapterFactory()));
                        object.setSelection(iSelection, false);
                    }
                    if (this.OBSTab != null && (object = this.OBSTab.getViewer()) != viewer) {
                        iSelection = new StructuredSelection(ProcessEditor.findSelection(arrayList, this.OBSTab.getAdapterFactory()));
                        object.setSelection(iSelection, false);
                    }
                    if (this.PBSTab != null && (object = this.PBSTab.getViewer()) != viewer) {
                        iSelection = new StructuredSelection(ProcessEditor.findSelection(arrayList, this.PBSTab.getAdapterFactory()));
                        object.setSelection(iSelection, false);
                    }
                    if (this.procTab != null && (object = this.procTab.getViewer()) != viewer) {
                        iSelection = new StructuredSelection(ProcessEditor.findSelection(arrayList, this.procTab.getAdapterFactory()));
                        object.setSelection(iSelection, false);
                    }
                    if (this.extensionTabs != null) {
                        int n = 0;
                        while (n < this.extensionTabs.length) {
                            object = this.extensionTabs[n].getViewer();
                            if (object != viewer) {
                                iSelection = new StructuredSelection(ProcessEditor.findSelection(arrayList, this.extensionTabs[n].getAdapterFactory()));
                                object.setSelection(iSelection, false);
                            }
                            ++n;
                        }
                    }
                }
            }
            finally {
                this.synchronizingSelection = false;
            }
        }
    }

    public static Object findSelection(List list, AdapterFactory adapterFactory) {
        Object e;
        int n = list.size();
        if (n == 0) {
            return null;
        }
        Object e2 = e = list.get(0);
        ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)adapterFactory.adapt(e, ITreeItemContentProvider.class);
        Collection collection = iTreeItemContentProvider.getChildren(e);
        int n2 = 1;
        block0: while (n2 < n) {
            e = list.get(n2);
            for (Object e3 : collection) {
                Object object = TngUtil.unwrap(e3);
                if (object != e) continue;
                e2 = e3;
                iTreeItemContentProvider = (ITreeItemContentProvider)adapterFactory.adapt(e3, ITreeItemContentProvider.class);
                collection = iTreeItemContentProvider.getChildren(e);
                ++n2;
                continue block0;
            }
        }
        return e2;
    }

    @Override
    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.add(iSelectionChangedListener);
    }

    @Override
    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.remove(iSelectionChangedListener);
    }

    @Override
    public ISelection getSelection() {
        return this.viewSelection;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    public AdapterFactory getAdapterFactory() {
        IFormPage iFormPage = this.getActivePageInstance();
        if (iFormPage instanceof ProcessBreakdownStructureFormPage) {
            return ((ProcessBreakdownStructureFormPage)iFormPage).getAdapterFactory();
        }
        return null;
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        IAction[] iActionArray;
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(iMenuManager);
        IFormPage iFormPage = this.getActivePageInstance();
        if (iFormPage instanceof ProcessBreakdownStructureFormPage && (iActionArray = ((ProcessBreakdownStructureFormPage)iFormPage).getAdditionalActions()) != null && iActionArray.length > 0) {
            iMenuManager.insertAfter("additions", (IContributionItem)new Separator());
            int n = 0;
            while (n < iActionArray.length) {
                IAction iAction = iActionArray[n];
                ISelection iSelection = this.getSelection();
                if (iSelection instanceof IStructuredSelection && iAction instanceof BaseSelectionListenerAction) {
                    ((BaseSelectionListenerAction)iAction).selectionChanged((IStructuredSelection)iSelection);
                }
                if (iAction instanceof IWorkbenchPartAction) {
                    ((IWorkbenchPartAction)iAction).setActiveWorkbenchPart((IWorkbenchPart)this);
                }
                iMenuManager.insertAfter("additions", iAction);
                ++n;
            }
        }
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = (EPFPropertySheetPage)this.createPropertySheetPage();
            if (this.currentViewer != null) {
                AdapterFactoryContentProvider adapterFactoryContentProvider = (AdapterFactoryContentProvider)((ProcessViewer)this.currentViewer).getContentProvider();
                this.propContentProvider = new AdapterFactoryContentProvider(adapterFactoryContentProvider.getAdapterFactory());
                this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)this.propContentProvider);
            }
        }
        return this.propertySheetPage;
    }

    protected TabbedPropertySheetPage createPropertySheetPage() {
        return new EPFPropertySheetPage(this);
    }

    public Object getAdapter(Class clazz) {
        if (clazz.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (clazz.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(clazz);
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public static EList toColumnDescriptorList(String string) {
        BasicEList basicEList = new BasicEList();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            ColumnDescriptor columnDescriptor = idToColumnDescriptorMap.get(string2);
            if (columnDescriptor == null) continue;
            basicEList.add((Object)columnDescriptor);
        }
        return basicEList;
    }

    public static ColumnDescriptor[] toColumnDescriptors(String string) {
        EList eList = ProcessEditor.toColumnDescriptorList(string);
        ColumnDescriptor[] columnDescriptorArray = new ColumnDescriptor[eList.size()];
        eList.toArray(columnDescriptorArray);
        return columnDescriptorArray;
    }

    public int getCurrentPage() {
        return super.getCurrentPage();
    }

    public Suppression getSuppression() {
        return this.suppression;
    }

    protected void configChanged() {
        MethodConfiguration methodConfiguration = LibraryService.getInstance().getCurrentMethodConfiguration();
        if (methodConfiguration != this.currentConfig) {
            boolean bl;
            IWorkbenchPart iWorkbenchPart = this.getSite().getWorkbenchWindow().getPartService().getActivePart();
            boolean bl2 = bl = iWorkbenchPart == this;
            if (!bl && iWorkbenchPart instanceof AbstractDiagramEditor) {
                DiagramEditorInput diagramEditorInput = ((DiagramEditorInputProxy)((IEditorPart)iWorkbenchPart).getEditorInput()).getDiagramEditorInput();
                boolean bl3 = bl = diagramEditorInput.getSuppression().getProcess() == this.selectedProcess;
            }
            if (bl) {
                this.currentConfig = methodConfiguration;
                this.refreshAll();
            }
        }
    }

    @Override
    protected void setInput(IEditorInput iEditorInput) {
        if (iEditorInput != this.getEditorInput()) {
            this.inputChanged = true;
        }
        super.setInput(iEditorInput);
    }

    @Override
    protected void updatePages() {
        Resource resource = this.selectedProcess.eResource();
        Resource resource2 = this.selectedProcess.getPresentation().eResource();
        if (this.changedResources.contains(resource) || resource2 != null && this.changedResources.contains(resource2)) {
            this.removePage(0);
            try {
                this.addDescriptionPage();
            }
            catch (PartInitException partInitException) {
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.ProcessEditor_refreshErrorTitle, AuthoringUIResources.ProcessEditor_refreshErrorMsg, (Throwable)partInitException);
            }
        }
        if (this.inputChanged) {
            this.inputChanged(this.getEditorInput());
            if (this.propertySheetPage != null) {
                this.propertySheetPage.refresh();
            }
        } else {
            this.refreshAll();
        }
    }

    protected void refreshAll() {
        BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ProcessEditor.this.doRefreshAll(true);
            }
        });
    }

    public void doRefreshAll(boolean bl) {
        this.updateIDs(bl);
        if (this.WBSTab != null && this.WBSTab.getViewer() != null) {
            this.WBSTab.getViewer().refresh();
        }
        if (this.OBSTab != null && this.OBSTab.getViewer() != null) {
            this.OBSTab.getViewer().refresh();
        }
        if (this.PBSTab != null && this.PBSTab.getViewer() != null) {
            this.PBSTab.getViewer().refresh();
        }
        if (this.procTab != null && this.procTab.getViewer() != null) {
            this.procTab.getViewer().refresh();
        }
        if (this.extensionTabs != null) {
            int n = 0;
            while (n < this.extensionTabs.length) {
                this.extensionTabs[n].getViewer().refresh();
                ++n;
            }
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.refresh();
        }
    }

    protected void updateIDs(boolean bl) {
        if (bl) {
            ComposedAdapterFactory composedAdapterFactory = null;
            if (this.WBSTab != null) {
                composedAdapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
                ProcessUtil.updateIDs((AdapterFactory)composedAdapterFactory, (Process)this.selectedProcess);
                ProcessUtil.refreshPredeccessorLists((AdapterFactory)composedAdapterFactory, (Process)this.selectedProcess);
            }
            if (this.procTab != null) {
                composedAdapterFactory = TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory();
                ProcessUtil.updateIDs((AdapterFactory)composedAdapterFactory, (Process)this.selectedProcess);
            }
        }
    }

    public void refreshAllProcessEditors() {
        IEditorReference[] iEditorReferenceArray = this.getSite().getPage().getEditorReferences();
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            IEditorReference iEditorReference = iEditorReferenceArray[n];
            IEditorPart iEditorPart = iEditorReference.getEditor(true);
            if (iEditorPart instanceof ProcessEditor) {
                ((ProcessEditor)iEditorPart).doRefreshAll(false);
            }
            ++n;
        }
    }

    public IFormPage getActivePageInstance() {
        int n = this.getActivePage();
        if (n == -1) {
            return null;
        }
        if (n == 0) {
            return super.getActivePageInstance();
        }
        return this.bsPages[n - 1];
    }

    protected Collection getModifiedResources() {
        Collection<Resource> collection = super.getModifiedResources();
        if (this.suppression.isSaveNeeded() && !collection.contains(this.selectedProcessComponent.eResource())) {
            collection.add(this.selectedProcessComponent.eResource());
        }
        collection.addAll(this.resourcesToSave);
        return collection;
    }

    @Override
    public void doSave(IProgressMonitor iProgressMonitor) {
        this.suppression.saveToModel();
        super.doSave(iProgressMonitor);
        this.suppression.saveIsDone();
        this.resourcesToSave.clear();
        this.firePropertyChange(257);
    }

    @Override
    public boolean isDirty() {
        if (this.suppression.isSaveNeeded()) {
            return true;
        }
        return super.isDirty();
    }

    public void firePropertyChange(int n) {
        super.firePropertyChange(n);
    }

    @Override
    public Collection<Resource> getUsedResources() {
        MethodConfiguration methodConfiguration;
        HashSet<Resource> hashSet = new HashSet<Resource>();
        Resource resource = this.elementObj.eResource();
        if (resource != null) {
            hashSet.add(resource);
        }
        if ((resource = this.selectedProcess.getPresentation().eResource()) != null) {
            hashSet.add(resource);
        }
        if ((methodConfiguration = this.selectedProcess.getDefaultContext()) != null && (resource = methodConfiguration.eResource()) != null) {
            hashSet.add(resource);
        }
        AdapterFactory adapterFactory = this.getAdapterFactoryFromTab();
        AdapterFactoryTreeIterator adapterFactoryTreeIterator = new AdapterFactoryTreeIterator(adapterFactory, (Object)this.selectedProcess);
        while (adapterFactoryTreeIterator.hasNext()) {
            Object object = TngUtil.unwrap(adapterFactoryTreeIterator.next());
            if (!(object instanceof EObject) || (resource = ((EObject)object).eResource()) == null) continue;
            hashSet.add(resource);
        }
        this.lastUsedResources = hashSet;
        return hashSet;
    }

    protected AdapterFactory getAdapterFactoryFromTab() {
        return this.WBSTab.getAdapterFactory();
    }

    public static boolean canReveal(Collection<?> collection, AdapterFactory adapterFactory, Suppression suppression) {
        return true;
    }

    public static boolean hasInherited(Collection collection) {
        for (Object e : collection) {
            if (!ProcessUtil.isInherited(e)) continue;
            return true;
        }
        return false;
    }

    protected IPreferenceStore getPreferenceStore() {
        IPreferenceStore iPreferenceStore = LibraryPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore;
    }

    protected DiagramEditorHelper getDiagramEditorHelper() {
        if (this.diagramEditorHelper == null) {
            this.diagramEditorHelper = new DiagramEditorHelper();
            this.diagramEditorHelper.getDiagramManager(this.selectedProcess);
        }
        return this.diagramEditorHelper;
    }

    protected int getActivePage() {
        return super.getActivePage();
    }

    private class ProcessEditorDropAdapter
    extends EditingDomainTableTreeViewerDropAdapter {
        public ProcessEditorDropAdapter(EditingDomain editingDomain, Viewer viewer) {
            super(editingDomain, viewer);
        }

        protected Object getDropTarget(Widget widget) {
            Object object = super.getDropTarget(widget);
            if (object == null && ProcessEditor.this.selectedProcessComponent != null) {
                object = ProcessEditor.this.selectedProcessComponent.getProcess();
            }
            return object;
        }

        public void drop(DropTargetEvent dropTargetEvent) {
            if (ProcessEditor.this.currentViewer instanceof IActionTypeProvider) {
                ((IActionTypeProvider)ProcessEditor.this.currentViewer).setInputData((Object)new Point(dropTargetEvent.x, dropTargetEvent.y));
            }
            super.drop(dropTargetEvent);
        }
    }
}

