/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.filters;

import org.eclipse.epf.authoring.ui.filters.ActivityVariabilityFilter;
import org.eclipse.epf.authoring.ui.filters.DescriptorConfigurationFilter;
import org.eclipse.epf.library.edit.configuration.CategorizedProcessesItemProvider;
import org.eclipse.epf.library.edit.configuration.ProcessesItemProvider;
import org.eclipse.epf.library.edit.itemsfilter.FilterHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class ProcessActivityFilter
extends DescriptorConfigurationFilter {
    private Activity activity = null;
    private int command = 0;
    private ActivityVariabilityFilter delegateFilter;

    public ProcessActivityFilter(MethodConfiguration methodConfiguration, TableViewer tableViewer, String string, Activity activity, int n) {
        super(methodConfiguration, (Viewer)tableViewer, string);
        this.activity = activity;
        this.command = n;
        this.delegateFilter = new ActivityVariabilityFilter(methodConfiguration, tableViewer, string, activity);
    }

    public void setHelper(FilterHelper filterHelper) {
        super.setHelper(filterHelper);
        this.delegateFilter.setHelper(filterHelper);
    }

    public boolean accept(Object object) {
        if (this.command == 3 && (object instanceof Activity || object instanceof ProcessComponent)) {
            return true;
        }
        return super.accept(object);
    }

    public boolean childAccept(Object object) {
        if (object instanceof ProcessesItemProvider) {
            return true;
        }
        if (object instanceof CategorizedProcessesItemProvider) {
            return true;
        }
        if (object instanceof Activity || object instanceof ProcessPackage) {
            switch (this.command) {
                case 2: {
                    return this.delegateFilter.accept(object);
                }
                case 1: {
                    BreakdownElement breakdownElement;
                    Process process = null;
                    if (object instanceof ProcessComponent) {
                        process = ((ProcessComponent)object).getProcess();
                    } else if (object instanceof BreakdownElement) {
                        breakdownElement = (BreakdownElement)object;
                        process = TngUtil.getOwningProcess((BreakdownElement)breakdownElement);
                    }
                    if (process == null) break;
                    breakdownElement = TngUtil.getOwningProcess((BreakdownElement)this.activity);
                    return !(process instanceof DeliveryProcess) || !(breakdownElement instanceof CapabilityPattern);
                }
            }
            return true;
        }
        return false;
    }
}

