/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.dialogs.ConfigurationAddViewsDialog;
import org.eclipse.epf.authoring.ui.dialogs.ConfigurationOrderDialog;
import org.eclipse.epf.authoring.ui.editors.ConfigurationEditor;
import org.eclipse.epf.authoring.ui.editors.ConfigurationEditorInput;
import org.eclipse.epf.authoring.ui.filters.ProcessViewFilter;
import org.eclipse.epf.authoring.ui.providers.ConfigurationLabelProvider;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.library.configuration.ConfigurationFilter;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ConfigViewPage
extends FormPage {
    private MethodConfiguration config = null;
    private String formPrefix = AuthoringUIResources.configViewPage_configuration;
    private FormToolkit toolkit;
    private CTabFolder tabFolder;
    private CTabItem tabDefaultviewItem;
    private Button removeButton;
    private Button makeDefaultButton;
    private Button orderButton;
    private Object selectedItem = null;
    private IActionManager actionMgr = null;
    private Logger logger = null;

    public ConfigViewPage(FormEditor formEditor) {
        super(formEditor, AuthoringUIResources.configViewPage_configurationViews, AuthoringUIResources.configViewPage_views);
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        ConfigurationEditorInput configurationEditorInput = (ConfigurationEditorInput)iEditorInput;
        this.config = configurationEditorInput.getConfiguration();
        this.actionMgr = ((ConfigurationEditor)this.getEditor()).getActionManager();
        this.logger = AuthoringUIPlugin.getDefault().getLogger();
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        ScrolledForm scrolledForm = iManagedForm.getForm();
        scrolledForm.setText(String.valueOf(this.formPrefix) + this.config.getName());
        this.toolkit = iManagedForm.getToolkit();
        scrolledForm.getBody().setLayout((Layout)new GridLayout());
        Section section = this.toolkit.createSection(scrolledForm.getBody(), 450);
        GridData gridData = new GridData(1808);
        section.setLayoutData((Object)gridData);
        section.setText(AuthoringUIResources.configViewPage_configurationViewSectionTitle);
        section.setDescription(AuthoringUIResources.configViewPage_configurationViewSectionMessage);
        section.setLayout((Layout)new GridLayout());
        Composite composite = this.toolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        section.setClient((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite.getParent(), AuthoringUIHelpContexts.CONFIGURATION_EDITOR_ALL_CONTEXT);
        this.createButtonPane(composite);
        this.createTabPane(composite);
        this.toolkit.paintBordersFor(composite);
        this.loadData();
    }

    private void createTabPane(Composite composite) {
        this.tabFolder = new CTabFolder(composite, 0x800880);
        this.tabFolder.setLayout((Layout)new GridLayout());
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        Color color = this.toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        this.tabFolder.setSelectionBackground(new Color[]{color, this.toolkit.getColors().getBackground()}, new int[]{50});
        this.toolkit.paintBordersFor((Composite)this.tabFolder);
    }

    private void createButtonPane(Composite composite) {
        Composite composite2 = this.toolkit.createComposite(composite);
        composite2.setLayoutData((Object)new GridData(768));
        composite2.setLayout((Layout)new GridLayout(4, false));
        Button button = this.toolkit.createButton(composite2, AuthoringUIResources.configViewPage_addViewButtonText, 0);
        GridData gridData = new GridData(1);
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProcessViewFilter processViewFilter = new ProcessViewFilter(ConfigViewPage.this.config, null, FilterConstants.ALL_ELEMENTS);
                ConfigurationAddViewsDialog configurationAddViewsDialog = new ConfigurationAddViewsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                configurationAddViewsDialog.setTypes(ConfigViewPage.this.getTypes());
                configurationAddViewsDialog.setTitle(AuthoringUIResources.ConfigProcessViewDialog_SelectCategories);
                configurationAddViewsDialog.setInput(ConfigViewPage.this.config);
                configurationAddViewsDialog.setFilter((IFilter)processViewFilter);
                configurationAddViewsDialog.setExistingElements(ConfigViewPage.this.config.getProcessViews());
                configurationAddViewsDialog.setContentProvider((IStructuredContentProvider)new AdapterFactoryContentProvider(TngAdapterFactory.INSTANCE.getItemsFilter_AdapterFactory((IFilter)processViewFilter)), TngAdapterFactory.INSTANCE.getItemsFilter_ComposedAdapterFactory());
                configurationAddViewsDialog.setBlockOnOpen(true);
                configurationAddViewsDialog.open();
                ArrayList arrayList = configurationAddViewsDialog.getSelectedItems();
                for (Object e : arrayList) {
                    if (!(e instanceof ContentCategory)) continue;
                    if (ConfigViewPage.this.config.getProcessViews().contains((ContentCategory)e)) {
                        String string = ((ContentCategory)e).getName();
                        String string2 = AuthoringUIResources.configViewPageViewExistsDialog_title;
                        String string3 = AuthoringUIResources.bind((String)AuthoringUIResources.configViewPageViewExistsDialog_message, (Object)string);
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(string2, string3);
                        continue;
                    }
                    boolean bl = ConfigViewPage.this.actionMgr.doAction(3, (EObject)ConfigViewPage.this.config, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodConfiguration_ProcessViews(), (Object)((ContentCategory)e), -1);
                    if (!bl) continue;
                    ConfigViewPage.this.addView((ContentCategory)e);
                }
            }
        });
        this.removeButton = this.toolkit.createButton(composite2, AuthoringUIResources.configViewPage_removeViewButtonText, 0);
        gridData = new GridData(1);
        this.removeButton.setLayoutData((Object)gridData);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConfigViewPage.this.removeView();
            }
        });
        this.makeDefaultButton = this.toolkit.createButton(composite2, AuthoringUIResources.configViewPage_makeDefaultButtonText, 0);
        gridData = new GridData(1);
        this.makeDefaultButton.setLayoutData((Object)gridData);
        this.makeDefaultButton.setEnabled(false);
        this.makeDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConfigViewPage.this.makeDefaultView();
            }
        });
        this.orderButton = this.toolkit.createButton(composite2, AuthoringUIResources.orderButton_text, 0);
        gridData = new GridData(1);
        this.removeButton.setLayoutData((Object)gridData);
        this.orderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConfigurationOrderDialog configurationOrderDialog = new ConfigurationOrderDialog(Display.getCurrent().getActiveShell(), ConfigViewPage.this.config, ConfigViewPage.this.getActionManager());
                int n = configurationOrderDialog.open();
                if (n == 0) {
                    ConfigViewPage.this.refresh();
                }
            }
        });
        this.toolkit.paintBordersFor(composite2);
    }

    private void removeView() {
        Control[] controlArray;
        int n;
        CTabItem cTabItem = this.tabFolder.getSelection();
        if (cTabItem == null) {
            return;
        }
        String string = cTabItem.getText();
        String string2 = AuthoringUIResources.configViewPageRemoveViewDialog_title;
        String string3 = AuthoringUIResources.bind((String)AuthoringUIResources.configViewPageRemoveViewDialog_message, (Object)cTabItem.getText());
        boolean bl = AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(string2, string3);
        if (!bl) {
            return;
        }
        boolean bl2 = false;
        if (this.tabDefaultviewItem != null && cTabItem == this.tabDefaultviewItem) {
            bl2 = true;
        }
        List list = this.config.getProcessViews();
        if (bl2 && (n = string.lastIndexOf((String)(controlArray = " " + AuthoringUIResources.processDescription_default))) > 0) {
            string = string.substring(0, n);
        }
        controlArray = list.iterator();
        while (controlArray.hasNext()) {
            ContentCategory contentCategory = (ContentCategory)controlArray.next();
            if (!contentCategory.getName().equals(string)) continue;
            this.actionMgr.doAction(4, (EObject)this.config, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodConfiguration_ProcessViews(), (Object)contentCategory, -1);
            ContentCategory contentCategory2 = this.config.getDefaultView();
            if (contentCategory2 != null && contentCategory2.equals(contentCategory)) {
                if (list.size() > 0) {
                    this.actionMgr.doAction(1, (EObject)this.config, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodConfiguration_DefaultView(), (Object)((ContentCategory)list.get(0)), -1);
                } else {
                    this.actionMgr.doAction(1, (EObject)this.config, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodConfiguration_DefaultView(), null, -1);
                }
            }
            cTabItem.dispose();
            break;
        }
        list = this.config.getProcessViews();
        if (list == null || list.size() <= 0) {
            this.removeButton.setEnabled(false);
            this.makeDefaultButton.setEnabled(false);
        }
        if (bl2 && (controlArray = this.tabFolder.getTabList()) != null && controlArray.length > 0) {
            this.tabFolder.setSelection(0);
            this.makeDefaultView();
        }
    }

    private void addView(ContentCategory contentCategory) {
        this.selectedItem = contentCategory;
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        TreeViewer treeViewer = new TreeViewer(composite, 2816);
        treeViewer.getTree().setLayout((Layout)new GridLayout());
        treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        ConfigurationFilter configurationFilter = new ConfigurationFilter(this.config, (Viewer)treeViewer);
        AdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.getConfigurationView_AdapterFactory((IFilter)configurationFilter);
        AdapterFactoryContentProvider adapterFactoryContentProvider = new AdapterFactoryContentProvider(adapterFactory){

            public Object[] getElements(Object object) {
                ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)this.adapterFactory.adapt(ConfigViewPage.this.selectedItem, ITreeItemContentProvider.class);
                return iTreeItemContentProvider.getChildren(ConfigViewPage.this.selectedItem).toArray();
            }
        };
        treeViewer.setContentProvider((IContentProvider)adapterFactoryContentProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationLabelProvider(this.config, adapterFactory));
        try {
            treeViewer.setInput((Object)this.config);
        }
        catch (Exception exception) {
            this.logger.logError("Error creating treeviewer for config", (Throwable)exception);
        }
        CTabItem cTabItem = new CTabItem(this.tabFolder, 128);
        cTabItem.setText(contentCategory.getName());
        cTabItem.setControl((Control)composite);
        this.removeButton.setEnabled(true);
        this.makeDefaultButton.setEnabled(true);
        this.toolkit.paintBordersFor(composite);
        this.tabFolder.setSelection(cTabItem);
    }

    private void makeDefaultView() {
        CTabItem cTabItem = this.tabFolder.getSelection();
        List list = this.config.getProcessViews();
        for (ContentCategory contentCategory : list) {
            if (!contentCategory.getName().equals(cTabItem.getText())) continue;
            this.clearDefaultViewIndicator();
            this.actionMgr.doAction(1, (EObject)this.config, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodConfiguration_DefaultView(), (Object)contentCategory, -1);
            this.setDefaultViewIndicator(cTabItem);
            break;
        }
    }

    private void loadData() {
        List list = this.config.getProcessViews();
        ContentCategory contentCategory = list.iterator();
        while (contentCategory.hasNext()) {
            this.addView((ContentCategory)contentCategory.next());
        }
        contentCategory = this.config.getDefaultView();
        int n = this.tabFolder.getItemCount();
        if (contentCategory != null) {
            CTabItem[] cTabItemArray = this.tabFolder.getItems();
            int n2 = 0;
            while (n2 < cTabItemArray.length) {
                String string = cTabItemArray[n2].getText();
                if (string.equals(contentCategory.getName())) {
                    this.tabFolder.setSelection(cTabItemArray[n2]);
                    this.setDefaultViewIndicator(cTabItemArray[n2]);
                    break;
                }
                ++n2;
            }
        } else if (n > 0) {
            this.tabFolder.setSelection(0);
        }
    }

    private void refresh() {
        ContentCategory contentCategory = this.config.getDefaultView();
        String string = "";
        if (contentCategory != null) {
            string = contentCategory.getName();
            this.clearDefaultViewIndicator();
        }
        String string2 = this.tabFolder.getSelection().getText();
        HashMap<String, Control> hashMap = new HashMap<String, Control>();
        int n = 0;
        while (n < this.tabFolder.getItemCount()) {
            CTabItem cTabItem = this.tabFolder.getItem(n);
            hashMap.put(cTabItem.getText(), cTabItem.getControl());
            ++n;
        }
        List list = this.config.getProcessViews();
        int n2 = 0;
        int n3 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && n2 < this.tabFolder.getItemCount()) {
            String string3 = ((ContentCategory)iterator.next()).getName();
            CTabItem cTabItem = this.tabFolder.getItem(n2++);
            cTabItem.setText(string3);
            cTabItem.setControl((Control)hashMap.get(string3));
            if (string3.equals(string)) {
                this.setDefaultViewIndicator(cTabItem);
            }
            if (!string3.equals(string2)) continue;
            n3 = n2 - 1;
        }
        this.tabFolder.setSelection(n3);
    }

    private void clearDefaultViewIndicator() {
        ContentCategory contentCategory = this.config.getDefaultView();
        if (contentCategory != null) {
            String string = String.valueOf(contentCategory.getName()) + " " + AuthoringUIResources.processDescription_default;
            CTabItem[] cTabItemArray = this.tabFolder.getItems();
            int n = 0;
            while (n < cTabItemArray.length) {
                String string2 = cTabItemArray[n].getText();
                if (string2.equals(string)) {
                    cTabItemArray[n].setText(contentCategory.getName());
                }
                ++n;
            }
        }
    }

    private void setDefaultViewIndicator(CTabItem cTabItem) {
        this.tabDefaultviewItem = cTabItem;
        String string = String.valueOf(cTabItem.getText()) + " " + AuthoringUIResources.processDescription_default;
        cTabItem.setText(string);
    }

    private String[] getTypes() {
        String[] stringArray = new String[]{FilterConstants.CUSTOM_CATEGORIES, FilterConstants.ALL_ELEMENTS, FilterConstants.DISCIPLINES, FilterConstants.DOMAINS, FilterConstants.ROLESETS, FilterConstants.WORKPRODUCTTYPES, FilterConstants.TOOLS};
        return stringArray;
    }

    protected IActionManager getActionManager() {
        return this.actionMgr;
    }
}

