/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import com.ibm.icu.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.filters.ContentFilter;
import org.eclipse.epf.authoring.ui.forms.BaseFormPage;
import org.eclipse.epf.authoring.ui.forms.IRefreshable;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichTextEditor;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.RemoveReferencesCommand;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.util.Misc;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.PluginReferenceChecker;
import org.eclipse.epf.richtext.RichTextListener;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodPluginDescriptionPage
extends BaseFormPage
implements IRefreshable {
    private static final String FORM_PREFIX = String.valueOf(LibraryUIText.TEXT_METHOD_PLUGIN) + ": ";
    private Text ctrl_name;
    private Text ctrl_brief_desc;
    private Text ctrl_r_brief_desc;
    private CheckboxTableViewer ctrl_refModel;
    private Section generalSection;
    private Section refModelSection;
    private Composite generalComposite;
    private Composite refModelComposite;
    private boolean descExpandFlag = false;
    private MethodPlugin plugin;
    private IActionManager actionMgr;
    protected Section versionSection;
    protected Composite versionComposite;
    private Text ctrl_authors;
    private Text ctrl_change_date;
    private Text ctrl_change_desc;
    private Text ctrl_version;
    protected boolean versionSectionOn = true;
    protected boolean anyAttributeModified = false;
    protected static final int VERSION_SECTION_ID = 3;
    protected IMethodRichTextEditor ctrl_version_expanded;
    protected ImageHyperlink expandVersionLink;
    protected Label expandVersionLabel;
    protected Composite expandedVersionComposite;
    protected ModifyListener modelModifyListener;
    protected ModifyListener contentModifyListener;
    protected static final int GENERAL_SECTION_ID = 1;
    private IMethodRichText activeControl;
    protected Label label_copyright;
    protected TableViewer copyright_viewer;
    protected Table ctrl_copyright;
    protected IStructuredContentProvider copyrightContentProvider;
    private ILabelProvider labelProviderBase = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
    private Button copyright_button;
    private Button copyright_button_deselect;
    private Button ctrl_changeable;
    public boolean notificationEnabled = true;
    protected Adapter userChangeableAdapter;
    private ModifyListener nameModifyListener;

    public MethodPluginDescriptionPage(FormEditor formEditor) {
        super(formEditor, AuthoringUIText.DESCRIPTION_PAGE_TITLE, AuthoringUIText.DESCRIPTION_PAGE_TITLE);
        this.actionMgr = ((MethodElementEditor)formEditor).getActionManager();
        this.userChangeableAdapter = new UserChangeableAdapter();
    }

    @Override
    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) {
        super.init(iEditorSite, iEditorInput);
        MethodElementEditorInput methodElementEditorInput = (MethodElementEditorInput)iEditorInput;
        MethodElement methodElement = methodElementEditorInput.getMethodElement();
        this.plugin = (MethodPlugin)methodElement;
        if (this.userChangeableAdapter != null) {
            this.plugin.eAdapters().add((Object)this.userChangeableAdapter);
        }
    }

    @Override
    protected void createFormContent(IManagedForm iManagedForm) {
        super.createFormContent(iManagedForm);
        this.createEditorContent(this.toolkit);
        this.createReferenceContent(this.toolkit);
        this.setContextHelp();
        this.loadData();
        this.addListeners();
    }

    private void setContextHelp() {
        if (this.generalComposite != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.generalComposite.getParent().getParent(), AuthoringUIHelpContexts.PLUGIN_EDITOR_DESCRIPTION_ALL_CONTEXT);
        }
    }

    protected void createEditorContent(FormToolkit formToolkit) {
        this.form.setText(String.valueOf(FORM_PREFIX) + this.plugin.getName());
        this.generalSection = formToolkit.createSection(this.form.getBody(), 450);
        TableWrapData tableWrapData = new TableWrapData(256);
        this.generalSection.setLayoutData((Object)tableWrapData);
        this.generalSection.setText(AuthoringUIText.GENERAL_INFO_SECTION_NAME);
        this.generalSection.setDescription(MessageFormat.format(AuthoringUIText.GENERAL_INFO_SECTION_DESC, LibraryUIText.getUITextLower((MethodElement)this.methodElement)));
        this.generalSection.setLayout((Layout)new GridLayout());
        this.generalComposite = formToolkit.createComposite((Composite)this.generalSection);
        this.generalComposite.setLayoutData((Object)new GridData(768));
        this.generalComposite.setLayout((Layout)new GridLayout(3, false));
        this.generalSection.setClient((Control)this.generalComposite);
        this.ctrl_name = MethodPluginDescriptionPage.createTextEditWithLabel(formToolkit, this.generalComposite, AuthoringUIText.NAME_TEXT);
        this.ctrl_brief_desc = MethodPluginDescriptionPage.createTextEditWithLabel2(formToolkit, this.generalComposite, AuthoringUIText.BRIEF_DESCRIPTION_TEXT);
        if (this.versionSectionOn) {
            this.createVersionSection(formToolkit);
            this.createVersionSectionContent();
        }
        formToolkit.paintBordersFor(this.generalComposite);
        Display display = this.form.getBody().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    MethodPluginDescriptionPage.this.ctrl_name.setFocus();
                }
            });
        }
    }

    private void createReferenceContent(FormToolkit formToolkit) {
        this.refModelSection = formToolkit.createSection(this.form.getBody(), 450);
        TableWrapData tableWrapData = new TableWrapData(256);
        this.refModelSection.setLayoutData((Object)tableWrapData);
        this.refModelSection.setText(AuthoringUIText.REFERENCED_PLUGINS_SECTION_NAME);
        this.refModelSection.setDescription(AuthoringUIText.REFERENCED_PLUGINS_SECTION_DESC);
        this.refModelSection.setLayout((Layout)new GridLayout());
        this.refModelComposite = formToolkit.createComposite((Composite)this.refModelSection);
        this.refModelComposite.setLayoutData((Object)new GridData(768));
        this.refModelComposite.setLayout((Layout)new GridLayout(2, false));
        this.refModelSection.setClient((Control)this.refModelComposite);
        Table table = formToolkit.createTable(this.refModelComposite, 32);
        Object object = new GridData(1809);
        object.heightHint = 100;
        table.setLayoutData(object);
        this.ctrl_refModel = new CheckboxTableViewer(table);
        object = new LabelProvider(){

            public String getText(Object object) {
                MethodPlugin methodPlugin = (MethodPlugin)object;
                return methodPlugin.getName();
            }
        };
        this.ctrl_refModel.setLabelProvider((IBaseLabelProvider)object);
        Label label = formToolkit.createLabel(this.refModelComposite, AuthoringUIText.BRIEF_DESCRIPTION_TEXT);
        GridData gridData = new GridData(1);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        this.ctrl_r_brief_desc = formToolkit.createText(this.refModelComposite, "", 586);
        gridData = new GridData(768);
        gridData.heightHint = 80;
        this.ctrl_r_brief_desc.setLayoutData((Object)gridData);
        formToolkit.paintBordersFor(this.refModelComposite);
    }

    private void setCheckboxForCurrentBase(List list) {
        this.ctrl_refModel.setAllChecked(false);
        int n = 0;
        while (n < list.size()) {
            MethodPlugin methodPlugin = (MethodPlugin)list.get(n);
            this.ctrl_refModel.setChecked((Object)methodPlugin, true);
            ++n;
        }
    }

    private void addListeners() {
        MethodElementEditor methodElementEditor = (MethodElementEditor)this.getEditor();
        this.form.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                MethodPluginDescriptionPage.this.ctrl_refModel.getTable().clearAll();
                MethodPluginDescriptionPage.this.ctrl_refModel.refresh();
                List list = PluginReferenceChecker.getApplicableBasePlugins((MethodPlugin)MethodPluginDescriptionPage.this.plugin);
                MethodPluginDescriptionPage.this.ctrl_refModel.add(list.toArray());
                List list2 = MethodPluginDescriptionPage.this.plugin.getBases();
                MethodPluginDescriptionPage.this.setCheckboxForCurrentBase(list2);
                if (!MethodPluginDescriptionPage.this.plugin.getUserChangeable().booleanValue()) {
                    MethodPluginDescriptionPage.this.enableControls(false);
                } else {
                    MethodPluginDescriptionPage.this.enableControls(true);
                }
                MethodPluginDescriptionPage.this.copyright_viewer.refresh();
            }
        });
        MethodElementEditor.ModifyListener modifyListener = methodElementEditor.createModifyListener((EObject)this.plugin);
        this.nameModifyListener = methodElementEditor.createModifyListener((EObject)this.plugin, true);
        this.ctrl_name.addModifyListener(this.nameModifyListener);
        this.ctrl_name.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                String string = MethodPluginDescriptionPage.this.plugin.getName();
                if (((MethodElementEditor)MethodPluginDescriptionPage.this.getEditor()).mustRestoreValue(event.widget, string)) {
                    return;
                }
                if (MethodPluginDescriptionPage.this.ctrl_name.getText().equals(MethodPluginDescriptionPage.this.plugin.getName())) {
                    return;
                }
                String string2 = null;
                String string3 = MethodPluginDescriptionPage.this.ctrl_name.getText().trim();
                if (string3 != null) {
                    string2 = string.indexOf("&") < 0 && string3.indexOf("&") > -1 ? NLS.bind((String)LibraryEditResources.invalidElementNameError4_msg, (Object)string3) : LibraryUtil.checkPluginName(null, (String)string3);
                }
                String string4 = StrUtil.makeValidFileName((String)MethodPluginDescriptionPage.this.ctrl_name.getText());
                if (string2 == null) {
                    string2 = LibraryUtil.checkPluginName((MethodPlugin)MethodPluginDescriptionPage.this.plugin, (String)string4);
                }
                if (string2 == null) {
                    if (!string4.equals(MethodPluginDescriptionPage.this.plugin.getName())) {
                        String string5;
                        Shell shell = MethodPluginDescriptionPage.this.getSite().getShell();
                        if (!MessageDialog.openConfirm((Shell)shell, (String)(string5 = AuthoringUIResources.methodPluginDescriptionPage_confirmRename_title), (String)(string2 = AuthoringUIResources.bind((String)AuthoringUIResources.methodPluginDescriptionPage_confirmRename, (Object[])new Object[]{MethodPluginDescriptionPage.this.plugin.getName(), MethodPluginDescriptionPage.this.ctrl_name.getText()})))) {
                            MethodPluginDescriptionPage.this.ctrl_name.setText(MethodPluginDescriptionPage.this.plugin.getName());
                            return;
                        }
                        event.doit = true;
                        EditorChooser.getInstance().closeMethodEditorsForPluginElements(MethodPluginDescriptionPage.this.plugin);
                        MethodPluginDescriptionPage.this.ctrl_name.setText(string4);
                        boolean bl = MethodPluginDescriptionPage.this.actionMgr.doAction(1, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (Object)string4, -1);
                        if (!bl) {
                            return;
                        }
                        MethodPluginDescriptionPage.this.form.setText(String.valueOf(FORM_PREFIX) + MethodPluginDescriptionPage.this.plugin.getName());
                        MethodPluginDescriptionPage.this.updateChangeDate();
                        BusyIndicator.showWhile((Display)MethodPluginDescriptionPage.this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

                            public void run() {
                                MethodElementEditor methodElementEditor = (MethodElementEditor)MethodPluginDescriptionPage.this.getEditor();
                                methodElementEditor.doSave((IProgressMonitor)new NullProgressMonitor());
                                ILibraryPersister.FailSafeMethodLibraryPersister failSafeMethodLibraryPersister = methodElementEditor.getPersister();
                                try {
                                    failSafeMethodLibraryPersister.adjustLocation(MethodPluginDescriptionPage.this.plugin.eResource());
                                    failSafeMethodLibraryPersister.commit();
                                }
                                catch (RuntimeException runtimeException) {
                                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)runtimeException);
                                    try {
                                        failSafeMethodLibraryPersister.rollback();
                                    }
                                    catch (Exception exception) {
                                        AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                                        ViewHelper.reloadCurrentLibaryOnRollbackError(MethodPluginDescriptionPage.this.getSite().getShell());
                                        return;
                                    }
                                    AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(MethodPluginDescriptionPage.this.getSite().getShell().getText(), AuthoringUIResources.methodPluginDescriptionPage_cannotRenamePluginFolder, runtimeException.getMessage(), (Throwable)runtimeException);
                                }
                            }
                        });
                    }
                } else {
                    MethodPluginDescriptionPage.this.ctrl_name.setText(MethodPluginDescriptionPage.this.plugin.getName());
                    Shell shell = MethodPluginDescriptionPage.this.getSite().getShell();
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(shell.getText(), string2);
                    event.doit = false;
                    MethodPluginDescriptionPage.this.ctrl_name.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MethodPluginDescriptionPage.this.ctrl_name.setFocus();
                            MethodPluginDescriptionPage.this.ctrl_name.selectAll();
                        }
                    });
                }
            }
        });
        this.ctrl_name.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ((MethodElementEditor)MethodPluginDescriptionPage.this.getEditor()).setCurrentFeatureEditor(focusEvent.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            }
        });
        this.ctrl_brief_desc.addModifyListener((ModifyListener)modifyListener);
        this.ctrl_brief_desc.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ((MethodElementEditor)MethodPluginDescriptionPage.this.getEditor()).setCurrentFeatureEditor(focusEvent.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription());
            }

            public void focusLost(FocusEvent focusEvent) {
                boolean bl;
                String string = MethodPluginDescriptionPage.this.plugin.getBriefDescription();
                if (((MethodElementEditor)MethodPluginDescriptionPage.this.getEditor()).mustRestoreValue(focusEvent.widget, string)) {
                    return;
                }
                String string2 = MethodPluginDescriptionPage.this.ctrl_brief_desc.getText();
                if (!string2.equals(string) && (bl = MethodPluginDescriptionPage.this.actionMgr.doAction(1, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription(), (Object)string2, -1))) {
                    MethodPluginDescriptionPage.this.ctrl_brief_desc.setText(string2);
                }
            }
        });
        this.ctrl_refModel.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                StructuredSelection structuredSelection = (StructuredSelection)selectionChangedEvent.getSelection();
                MethodPlugin methodPlugin = (MethodPlugin)structuredSelection.getFirstElement();
                if (methodPlugin == null) {
                    return;
                }
                MethodPluginDescriptionPage.this.ctrl_r_brief_desc.setText(methodPlugin.getBriefDescription());
            }
        });
        this.ctrl_refModel.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                Object object = checkStateChangedEvent.getElement();
                MethodPluginDescriptionPage.this.ctrl_r_brief_desc.setText(((MethodPlugin)object).getBriefDescription());
                if (TngUtil.isLocked((EObject)MethodPluginDescriptionPage.this.plugin)) {
                    MethodPluginDescriptionPage.this.ctrl_refModel.setChecked(object, !checkStateChangedEvent.getChecked());
                    return;
                }
                if (checkStateChangedEvent.getChecked()) {
                    MethodPluginDescriptionPage.this.actionMgr.doAction(3, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodPlugin_Bases(), (Object)((MethodPlugin)object), -1);
                } else {
                    final MethodPlugin methodPlugin = (MethodPlugin)object;
                    if (!MethodPluginDescriptionPage.this.removeAllReferences(methodPlugin)) {
                        Display.getCurrent().asyncExec(new Runnable(){

                            public void run() {
                                MethodPluginDescriptionPage.this.ctrl_refModel.setChecked((Object)methodPlugin, true);
                            }
                        });
                        return;
                    }
                    MethodPluginDescriptionPage.this.ctrl_refModel.setChecked((Object)methodPlugin, false);
                    MethodPluginDescriptionPage.this.actionMgr.doAction(4, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodPlugin_Bases(), (Object)((MethodPlugin)object), -1);
                }
                PluginReferenceChecker.hasCircularConflictWithPlugin((MethodPlugin)MethodPluginDescriptionPage.this.plugin);
                MethodPluginDescriptionPage.this.updateChangeDate();
            }
        });
        if (this.versionSectionOn) {
            this.addVersionSectionListeners();
        }
    }

    protected void enableControls(boolean bl) {
        this.ctrl_name.setEditable(bl);
        this.ctrl_authors.setEditable(bl);
        this.ctrl_brief_desc.setEditable(bl);
        this.ctrl_version.setEditable(bl);
        this.ctrl_change_desc.setEditable(bl);
        this.copyright_button.setEnabled(bl);
        this.copyright_button_deselect.setEnabled(bl);
        this.ctrl_r_brief_desc.setEditable(false);
    }

    private void loadData() {
        String string = this.plugin.getName();
        String string2 = this.plugin.getBriefDescription();
        this.ctrl_name.setText(string == null ? "" : string);
        this.ctrl_brief_desc.setText(string2 == null ? "" : string2);
        if (this.versionSectionOn) {
            this.loadVersionSectionData();
        }
    }

    public boolean isVersionSectionOn() {
        return this.versionSectionOn;
    }

    public void setVersionSectionOn(boolean bl) {
        this.versionSectionOn = bl;
    }

    private void createVersionSection(FormToolkit formToolkit) {
        this.versionSection = formToolkit.createSection(this.form.getBody(), 450);
        TableWrapData tableWrapData = new TableWrapData(256);
        this.versionSection.setLayoutData((Object)tableWrapData);
        this.versionSection.setText(AuthoringUIText.VERSION_INFO_SECTION_NAME);
        this.versionSection.setDescription(MessageFormat.format(AuthoringUIText.VERSION_INFO_SECTION_DESC, LibraryUIText.getUITextLower((MethodElement)this.methodElement)));
        this.versionSection.setLayout((Layout)new GridLayout());
        this.versionComposite = formToolkit.createComposite((Composite)this.versionSection);
        this.versionComposite.setLayoutData((Object)new GridData(768));
        this.versionComposite.setLayout((Layout)new GridLayout(5, false));
        this.versionSection.setClient((Control)this.versionComposite);
    }

    private void createVersionSectionContent() {
        String string = this.plugin.getVersion() == null ? "" : this.plugin.getVersion();
        this.ctrl_version = MethodPluginDescriptionPage.createTextEditWithLabel4(this.toolkit, this.versionComposite, AuthoringUIText.VERSION_TEXT, -1, 4, string);
        string = this.plugin.getChangeDate() == null ? "" : DateFormat.getDateInstance((int)0).format(this.plugin.getChangeDate());
        this.ctrl_change_date = MethodPluginDescriptionPage.createTextEditWithLabel4(this.toolkit, this.versionComposite, AuthoringUIText.CHANGE_DATE_TEXT, -1, 4, string);
        this.ctrl_change_date.setEditable(false);
        this.ctrl_change_desc = MethodPluginDescriptionPage.createTextEditWithLabel5(this.toolkit, this.versionComposite, AuthoringUIText.CHANGE_DESCRIPTION_TEXT, 40, 2);
        this.ctrl_authors = MethodPluginDescriptionPage.createTextEditWithLabel5(this.toolkit, this.versionComposite, AuthoringUIText.AUTHORS_TEXT, 40, 2);
        this.label_copyright = MethodPluginDescriptionPage.createLabel(this.toolkit, this.versionComposite, AuthoringUIText.COPYRIGHT_TEXT, 2);
        this.ctrl_copyright = MethodPluginDescriptionPage.createTable(this.toolkit, this.versionComposite, 12, 1809, 5, 400, 1, 2);
        this.copyright_viewer = new TableViewer(this.ctrl_copyright);
        this.initContentProviderCopyright();
        this.copyright_viewer.setLabelProvider((IBaseLabelProvider)this.labelProviderBase);
        this.copyright_viewer.setInput((Object)this.plugin);
        Composite composite = MethodPluginDescriptionPage.createComposite(this.toolkit, this.versionComposite, 128, 1, 1, 1);
        GridData gridData = new GridData(128);
        composite.setLayoutData((Object)gridData);
        this.copyright_button = this.toolkit.createButton(composite, AuthoringUIText.SELECT_BUTTON_TEXT, 64);
        gridData = new GridData(128);
        gridData.widthHint = 150;
        this.copyright_button.setLayoutData((Object)gridData);
        this.copyright_button_deselect = this.toolkit.createButton(composite, AuthoringUIText.DESELECT_BUTTON_TEXT, 64);
        gridData = new GridData(128);
        gridData.widthHint = 150;
        this.copyright_button_deselect.setLayoutData((Object)gridData);
        this.ctrl_changeable = this.toolkit.createButton(this.versionComposite, AuthoringUIResources.methodPluginDescriptionPage_lockPluginLabel, 32);
        this.expandedVersionComposite = this.toolkit.createComposite((Composite)this.versionSection, 0);
        this.expandedVersionComposite.setLayoutData((Object)new GridData(768));
        this.expandedVersionComposite.setLayout((Layout)new GridLayout(2, false));
        this.expandedVersionComposite.setVisible(false);
        this.expandVersionLink = this.toolkit.createImageHyperlink(this.expandedVersionComposite, 0);
        this.expandVersionLink.setImage(AuthoringUIImages.IMG_EXPANDED);
        this.expandVersionLink.setUnderlined(false);
        this.expandVersionLink.setToolTipText(AuthoringUIResources.closeRTE);
        this.expandVersionLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                MethodPluginDescriptionPage.this.toggle(hyperlinkEvent, 3);
            }
        });
        this.expandVersionLabel = MethodPluginDescriptionPage.createDecoratedLabel(this.toolkit, this.expandedVersionComposite, "");
        this.toolkit.paintBordersFor(this.expandedVersionComposite);
        this.toolkit.paintBordersFor(this.versionComposite);
    }

    private void initContentProviderCopyright() {
        this.copyrightContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                ArrayList<SupportingMaterial> arrayList = new ArrayList<SupportingMaterial>();
                if (MethodPluginDescriptionPage.this.plugin.getCopyrightStatement() != null) {
                    arrayList.add(MethodPluginDescriptionPage.this.plugin.getCopyrightStatement());
                }
                return arrayList.toArray();
            }
        };
        this.copyright_viewer.setContentProvider((IContentProvider)this.copyrightContentProvider);
    }

    protected void addVersionSectionListeners() {
        final MethodElementEditor methodElementEditor = (MethodElementEditor)this.getEditor();
        this.modelModifyListener = methodElementEditor.createModifyListener((EObject)this.plugin);
        this.contentModifyListener = methodElementEditor.createModifyListener((EObject)this.plugin);
        this.ctrl_version.addModifyListener(this.contentModifyListener);
        this.ctrl_version.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ((MethodElementEditor)MethodPluginDescriptionPage.this.getEditor()).setCurrentFeatureEditor(focusEvent.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_Version());
            }

            public void focusLost(FocusEvent focusEvent) {
                String string = MethodPluginDescriptionPage.this.plugin.getVersion();
                if (((MethodElementEditor)MethodPluginDescriptionPage.this.getEditor()).mustRestoreValue(focusEvent.widget, string)) {
                    return;
                }
                String string2 = StrUtil.getPlainText((String)MethodPluginDescriptionPage.this.ctrl_version.getText());
                if (!string2.equals(string)) {
                    MethodPluginDescriptionPage.this.actionMgr.doAction(1, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_Version(), (Object)string2, -1);
                    MethodPluginDescriptionPage.this.updateChangeDate();
                }
            }
        });
        this.ctrl_authors.addModifyListener(this.contentModifyListener);
        this.ctrl_authors.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ((MethodElementEditor)MethodPluginDescriptionPage.this.getEditor()).setCurrentFeatureEditor(focusEvent.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_Authors());
            }

            public void focusLost(FocusEvent focusEvent) {
                String string = MethodPluginDescriptionPage.this.plugin.getAuthors();
                if (((MethodElementEditor)MethodPluginDescriptionPage.this.getEditor()).mustRestoreValue(focusEvent.widget, string)) {
                    return;
                }
                String string2 = StrUtil.getPlainText((String)MethodPluginDescriptionPage.this.ctrl_authors.getText());
                if (!string2.equals(string)) {
                    MethodPluginDescriptionPage.this.actionMgr.doAction(1, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_Authors(), (Object)string2, -1);
                    MethodPluginDescriptionPage.this.updateChangeDate();
                }
            }
        });
        this.copyright_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object;
                ContentFilter contentFilter = new ContentFilter(){

                    protected boolean childAccept(Object object) {
                        if (object instanceof Guidance) {
                            return object instanceof SupportingMaterial;
                        }
                        return false;
                    }
                };
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if (MethodPluginDescriptionPage.this.ctrl_copyright.getItemCount() > 0 && (object = MethodPluginDescriptionPage.this.ctrl_copyright.getItems()[0]).getData() != null) {
                    arrayList.add(object.getData());
                }
                object = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IFilter)contentFilter, MethodPluginDescriptionPage.this.plugin, FilterConstants.SUPPORTING_MATERIALS, arrayList);
                ((ItemsFilterDialog)((Object)object)).setViewerSelectionSingle(true);
                object.setBlockOnOpen(true);
                ((ItemsFilterDialog)((Object)object)).setTitle(FilterConstants.SUPPORTING_MATERIALS);
                object.open();
                ((ItemsFilterDialog)((Object)object)).getSelectedItems();
                if (((ItemsFilterDialog)((Object)object)).getSelectedItems().size() > 0) {
                    methodElementEditor.getActionManager().doAction(1, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_CopyrightStatement(), (Object)((SupportingMaterial)((ItemsFilterDialog)((Object)object)).getSelectedItems().get(0)), -1);
                }
                MethodPluginDescriptionPage.this.copyright_viewer.refresh();
            }
        });
        this.ctrl_change_desc.addModifyListener(this.contentModifyListener);
        this.ctrl_change_desc.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ((MethodElementEditor)MethodPluginDescriptionPage.this.getEditor()).setCurrentFeatureEditor(focusEvent.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_ChangeDescription());
            }

            public void focusLost(FocusEvent focusEvent) {
                boolean bl;
                String string = MethodPluginDescriptionPage.this.plugin.getChangeDescription();
                if (((MethodElementEditor)MethodPluginDescriptionPage.this.getEditor()).mustRestoreValue(focusEvent.widget, string)) {
                    return;
                }
                String string2 = MethodPluginDescriptionPage.this.ctrl_change_desc.getText();
                if (!(string2 = string2.replace(StrUtil.LINE_FEED, AuthoringUIResources.ChangeHistoryDialog_delimiter)).equals(string) && (bl = MethodPluginDescriptionPage.this.actionMgr.doAction(1, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_ChangeDescription(), (Object)string2, -1))) {
                    MethodPluginDescriptionPage.this.updateChangeDate();
                }
            }
        });
        this.copyright_button_deselect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MethodPluginDescriptionPage.this.actionMgr.doAction(1, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_CopyrightStatement(), null, -1);
                MethodPluginDescriptionPage.this.copyright_viewer.refresh();
            }
        });
        this.ctrl_changeable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MethodPluginDescriptionPage.this.notificationEnabled = true;
                IStatus iStatus = TngUtil.checkEdit((EObject)MethodPluginDescriptionPage.this.plugin, (Object)MethodPluginDescriptionPage.this.getSite().getShell());
                if (iStatus.isOK()) {
                    String string = AuthoringUIResources.bind((String)AuthoringUIResources.methodPluginDescriptionPage_lockPlugin_message, (Object)MethodPluginDescriptionPage.this.plugin.getName());
                    Shell shell = MethodPluginDescriptionPage.this.getSite().getShell();
                    if (AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(shell.getText(), string)) {
                        EditorChooser.getInstance().closeMethodEditorsForPluginElements(MethodPluginDescriptionPage.this.plugin);
                        boolean bl = MethodPluginDescriptionPage.this.actionMgr.doAction(1, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodPlugin_UserChangeable(), (Object)new Boolean(!MethodPluginDescriptionPage.this.ctrl_changeable.getSelection()), -1);
                        if (!bl) {
                            MethodPluginDescriptionPage.this.ctrl_changeable.setSelection(!MethodPluginDescriptionPage.this.ctrl_changeable.getSelection());
                            return;
                        }
                        MethodPluginDescriptionPage.this.enableControls(!MethodPluginDescriptionPage.this.ctrl_changeable.getSelection());
                    } else {
                        MethodPluginDescriptionPage.this.ctrl_changeable.setSelection(!MethodPluginDescriptionPage.this.ctrl_changeable.getSelection());
                        MethodPluginDescriptionPage.this.enableControls(!MethodPluginDescriptionPage.this.ctrl_changeable.getSelection());
                    }
                } else {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.editDialog_title, AuthoringUIResources.editDialog_msgCannotEdit, iStatus);
                    return;
                }
                MethodPluginDescriptionPage.this.copyright_viewer.refresh();
                ((MethodElementEditor)MethodPluginDescriptionPage.this.getEditor()).refreshTitleImage();
            }
        });
    }

    protected void updateChangeDate() {
        Date date;
        String string;
        Date date2 = this.plugin.getChangeDate();
        DateFormat dateFormat = DateFormat.getDateInstance((int)0);
        String string2 = "";
        if (date2 != null) {
            string2 = dateFormat.format(date2);
        }
        if (!(string = dateFormat.format(date = new Date())).equals(string2)) {
            this.actionMgr.doAction(1, (EObject)this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_ChangeDate(), (Object)date, -1);
            this.ctrl_change_date.setText(string);
        }
    }

    protected void loadVersionSectionData() {
        this.ctrl_version.setText(this.plugin.getVersion() == null ? "" : this.plugin.getVersion());
        this.ctrl_authors.setText(this.plugin.getAuthors() == null ? "" : this.plugin.getAuthors());
        String string = this.plugin.getChangeDescription() == null ? "" : this.plugin.getChangeDescription();
        string = string.replace(AuthoringUIResources.ChangeHistoryDialog_delimiter, StrUtil.LINE_FEED);
        this.ctrl_change_desc.setText(string);
        this.ctrl_change_date.setText(this.plugin.getChangeDate() == null ? "" : DateFormat.getDateInstance((int)0).format(this.plugin.getChangeDate()));
        this.ctrl_changeable.setSelection(this.plugin.getUserChangeable() == false);
    }

    @Override
    protected void toggle(HyperlinkEvent hyperlinkEvent, int n) {
        if (n == 1) {
            this.toggle(hyperlinkEvent);
        }
        if (n == 3) {
            this.toggleVersionSection(hyperlinkEvent);
        }
    }

    private void toggleVersionSection(HyperlinkEvent hyperlinkEvent) {
        if (this.ctrl_version_expanded == null) {
            this.ctrl_version_expanded = this.createRichTextEditor(this.toolkit, this.expandedVersionComposite, 578, 1808, this.getRichTextEditorHeight(), this.getRichTextEditorWidth(), 2, this.expandVersionLabel);
            this.ctrl_version_expanded.addModifyListener(this.contentModifyListener);
        }
        if (this.descExpandFlag) {
            this.versionComposite.setVisible(true);
            this.expandedVersionComposite.setVisible(false);
            this.versionSection.setClient((Control)this.versionComposite);
            this.refModelSection.setExpanded(true);
            this.generalSection.setExpanded(true);
            IMethodRichText iMethodRichText = this.getActiveRichTextControl();
            iMethodRichText.setText(this.ctrl_version_expanded.getText());
            Iterator iterator = iMethodRichText.getListeners();
            while (iterator.hasNext()) {
                RichTextListener richTextListener = (RichTextListener)iterator.next();
                this.ctrl_version_expanded.removeListener(richTextListener.getEventType(), richTextListener.getListener());
            }
            if (this.ctrl_version_expanded.getModified()) {
                ((MethodElementEditor)this.getEditor()).saveModifiedRichText(this.ctrl_version_expanded);
            }
            iMethodRichText.setFocus();
        } else {
            this.versionComposite.setVisible(false);
            this.expandedVersionComposite.setVisible(true);
            this.versionSection.setClient((Control)this.expandedVersionComposite);
            this.refModelSection.setExpanded(false);
            this.generalSection.setExpanded(false);
            this.expandVersionLabel.setText((String)((ImageHyperlink)hyperlinkEvent.getSource()).getData("Title"));
            IMethodRichText iMethodRichText = (IMethodRichText)hyperlinkEvent.getHref();
            this.ctrl_version_expanded.setText(iMethodRichText.getText());
            this.ctrl_version_expanded.setModalObject(iMethodRichText.getModalObject());
            this.ctrl_version_expanded.setModalObjectFeature(iMethodRichText.getModalObjectFeature());
            Iterator iterator = iMethodRichText.getListeners();
            while (iterator.hasNext()) {
                RichTextListener richTextListener = (RichTextListener)iterator.next();
                this.ctrl_version_expanded.addListener(richTextListener.getEventType(), richTextListener.getListener());
            }
            this.ctrl_version_expanded.setFocus();
            this.setActiveRichTextControl(iMethodRichText);
        }
        this.versionSection.layout(true);
        this.descExpandFlag = !this.descExpandFlag;
    }

    private void setActiveRichTextControl(IMethodRichText iMethodRichText) {
        this.activeControl = iMethodRichText;
    }

    private IMethodRichText getActiveRichTextControl() {
        return this.activeControl;
    }

    public void setUserChangeable(boolean bl) {
        if (!this.notificationEnabled) {
            return;
        }
        this.notificationEnabled = false;
        this.plugin.setUserChangeable(Boolean.valueOf(bl));
    }

    public void dispose() {
        this.plugin.eAdapters().remove((Object)this.userChangeableAdapter);
        super.dispose();
    }

    @Override
    public void refreshName(String string) {
        if (string != null && this.ctrl_name != null && !this.ctrl_name.isDisposed()) {
            this.ctrl_name.removeModifyListener(this.nameModifyListener);
            this.ctrl_name.setText(string);
            this.ctrl_name.addModifyListener(this.nameModifyListener);
            this.form.setText(String.valueOf(FORM_PREFIX) + this.plugin.getName());
        }
    }

    private static boolean isOneOrBaseOf(MethodPlugin methodPlugin, Collection<MethodPlugin> collection) {
        for (MethodPlugin methodPlugin2 : collection) {
            if (methodPlugin != methodPlugin2 && !Misc.isBaseOf((MethodPlugin)methodPlugin, (MethodPlugin)methodPlugin2)) continue;
            return true;
        }
        return false;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private boolean removeAllReferences(MethodPlugin var1_1) {
        var2_2 = new ArrayList<Object>();
        var2_2.add(var1_1);
        var3_3 = new AbstractTreeIterator<MethodPlugin>((Object)var1_1, false){
            private static final long serialVersionUID = 1L;

            protected Iterator<? extends MethodPlugin> getChildren(Object object) {
                if (object instanceof MethodPlugin) {
                    return ((MethodPlugin)object).getBases().iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        };
        while (var3_3.hasNext()) {
            var4_4 = (MethodPlugin)var3_3.next();
            var5_5 = new ArrayList<E>(this.plugin.getBases());
            var5_5.remove(var1_1);
            if (MethodPluginDescriptionPage.isOneOrBaseOf((MethodPlugin)var4_4, (Collection<MethodPlugin>)var5_5)) continue;
            var2_2.add(var4_4);
        }
        var3_3 = new ArrayList<E>();
        var4_4 = LibraryService.getInstance().getCurrentMethodLibrary().getMethodPlugins();
        var5_5 = var4_4.iterator();
        while (var5_5.hasNext()) {
            var6_6 /* !! */  = (MethodPlugin)var5_5.next();
            if (var6_6 /* !! */  == this.plugin || !Misc.isBaseOf((MethodPlugin)this.plugin, (MethodPlugin)var6_6 /* !! */ )) continue;
            var3_3.add(var6_6 /* !! */ );
        }
        var5_5 = new ArrayList<RemoveReferencesCommand>();
        for (MethodPlugin var6_6 : var2_2) {
            if (UmaUtil.hasReference((MethodPlugin)this.plugin, (MethodPlugin)var6_6 /* !! */ )) {
                var5_5.add(new RemoveReferencesCommand(this.plugin, var6_6 /* !! */ ));
            }
            var9_10 = var3_3.iterator();
            while (var9_10.hasNext()) {
                var8_8 = (MethodPlugin)var9_10.next();
                var10_12 = new ArrayList<E>(var8_8.getBases());
                var10_12.remove(var6_6 /* !! */ );
                if (MethodPluginDescriptionPage.isOneOrBaseOf(var6_6 /* !! */ , (Collection<MethodPlugin>)var10_12) || !UmaUtil.hasReference((MethodPlugin)var8_8, (MethodPlugin)var6_6 /* !! */ )) continue;
                var5_5.add(new RemoveReferencesCommand(var8_8, var6_6 /* !! */ ));
            }
        }
        if (!var5_5.isEmpty()) {
            var6_6 /* !! */  = AuthoringUIResources.bind((String)AuthoringUIResources.methodPluginDescriptionRemoveRefConfirm_message, (Object)this.plugin.getName());
            var7_7 = this.getSite().getShell();
            if (AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(var7_7.getText(), (String)var6_6 /* !! */ )) {
                var8_9 = 0;
                try {
                    for (RemoveReferencesCommand var9_10 : var5_5) {
                        this.actionMgr.execute((IResourceAwareCommand)var9_10);
                        ++var8_9;
                    }
                    return true;
                }
                catch (Exception var9_11) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)var9_11);
                    ** while (var8_9 > 0)
                }
lbl-1000:
                // 1 sources

                {
                    this.actionMgr.undo();
                    --var8_9;
                    continue;
                }
lbl57:
                // 1 sources

                return false;
            }
            return false;
        }
        return true;
    }

    protected class UserChangeableAdapter
    extends AdapterImpl {
        protected UserChangeableAdapter() {
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getFeatureID(MethodPlugin.class)) {
                case 12: {
                    Boolean bl = (Boolean)notification.getNewValue();
                    MethodPluginDescriptionPage.this.setUserChangeable(bl);
                    return;
                }
            }
        }
    }
}

