/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.filters.CategoryFilter;
import org.eclipse.epf.authoring.ui.filters.CustomCategoryFilter;
import org.eclipse.epf.authoring.ui.forms.AssociationFormPage;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.util.LibraryManager;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;

public class TaskCategoriesPage
extends AssociationFormPage {
    private static final String FORM_PAGE_ID = "taskCategoriesPage";
    private Task task;

    public TaskCategoriesPage(FormEditor formEditor) {
        super(formEditor, FORM_PAGE_ID, AuthoringUIText.CATEGORIES_PAGE_TITLE);
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) {
        super.init(iEditorSite, iEditorInput);
        this.task = (Task)this.contentElement;
        this.setAllowChange1(true);
        this.setAllowChange2(true);
        this.setUseCategory3(false);
    }

    protected void initContentProviderSelected() {
        this.contentProviderSelected = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return AssociationHelper.getDisciplines((Task)((Task)object)).toArray();
            }
        };
        this.viewer_selected.setContentProvider((IContentProvider)this.contentProviderSelected);
    }

    protected void addItemsToModel1(ArrayList arrayList) {
        if (!arrayList.isEmpty()) {
            for (Object e : arrayList) {
                if (!(e instanceof Discipline)) continue;
                LibraryManager.getInstance().addToDiscipline(this.getActionManager(), (Discipline)e, this.task, (List)this.usedCategories);
            }
        }
    }

    protected void removeItemsFromModel1(ArrayList arrayList) {
        if (!arrayList.isEmpty()) {
            for (Discipline discipline : arrayList) {
                LibraryManager.getInstance().removeFromDiscipline(this.getActionManager(), discipline, this.task, (List)this.usedCategories);
            }
        }
    }

    protected void initContentProviderSelected2() {
        this.contentProviderSelected2 = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return AssociationHelper.getCustomCategories((DescribableElement)((Task)object)).toArray();
            }
        };
        this.viewer_selected2.setContentProvider((IContentProvider)this.contentProviderSelected2);
    }

    protected void addItemsToModel2(ArrayList arrayList) {
        if (!arrayList.isEmpty()) {
            for (CustomCategory customCategory : arrayList) {
                LibraryManager.getInstance().addToCustomCategory(this.getActionManager(), customCategory, (MethodElement)this.task, (List)this.usedCategories);
            }
        }
    }

    protected void removeItemsFromModel2(ArrayList arrayList) {
        if (!arrayList.isEmpty()) {
            for (CustomCategory customCategory : arrayList) {
                LibraryManager.getInstance().removeFromCustomCategory(this.getActionManager(), customCategory, (MethodElement)this.task, (List)this.usedCategories);
            }
        }
    }

    protected Object getContentElement() {
        return this.task;
    }

    protected String getTabString() {
        return FilterConstants.DISCIPLINES;
    }

    protected String getTabString2() {
        return FilterConstants.CUSTOM_CATEGORIES;
    }

    protected IFilter getFilter() {
        this.filter = new CategoryFilter(){

            protected boolean childAccept(Object object) {
                return object instanceof Discipline;
            }
        };
        return this.filter;
    }

    protected IFilter getFilter2() {
        this.filter2 = new CustomCategoryFilter();
        return this.filter2;
    }

    protected String getSectionDescription() {
        return AuthoringUIResources.taskCategoriesPage_sectionDescription;
    }

    protected String getSectionName() {
        return AuthoringUIResources.taskCategoriesPage_sectionName;
    }

    protected String getSelectedLabel() {
        return AuthoringUIResources.taskCategoriesPage_selectedLabel;
    }

    protected String getSelectedLabel2() {
        return AuthoringUIResources.taskCategoriesPage_selectedLabel2;
    }

    protected String getMultipleSelectDescriptionString() {
        return AuthoringUIResources.taskCategoriesPage_multipleSelectDescription;
    }
}

