/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.persistence.util.UnresolvedProxyMarkerManager;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class MarkerResolutionGenerator
implements IMarkerResolutionGenerator {
    private static final IMarkerResolution[] EMPTY_RESOLUTIONS = new IMarkerResolution[0];

    private static ReferenceInfo getReferenceInfo(IMarker iMarker) {
        block7: {
            try {
                EObject eObject;
                Resource resource;
                String string = (String)iMarker.getAttribute("proxyURI");
                String string2 = (String)iMarker.getAttribute("ownerGUID");
                if (string == null || string2 == null || (resource = RefreshJob.getInstance().getResource(iMarker.getResource())) == null || (eObject = resource.getEObject(string2)) == null) break block7;
                URI uRI = URI.createURI((String)string);
                int n = -1;
                EReference eReference = null;
                block2: for (EReference eReference2 : eObject.eClass().getEAllReferences()) {
                    InternalEList internalEList;
                    if (!eReference2.isChangeable() || eReference2.isDerived()) continue;
                    if (eReference2.isMany()) {
                        internalEList = (InternalEList)eObject.eGet((EStructuralFeature)eReference2);
                        int n2 = 0;
                        Iterator iterator = internalEList.basicIterator();
                        while (iterator.hasNext()) {
                            InternalEObject internalEObject = (InternalEObject)iterator.next();
                            if (internalEObject.eIsProxy() && uRI.equals((Object)internalEObject.eProxyURI())) {
                                n = n2;
                                eReference = eReference2;
                                break block2;
                            }
                            ++n2;
                        }
                        continue;
                    }
                    internalEList = (InternalEObject)eObject.eGet((EStructuralFeature)eReference2, false);
                    if (internalEList == null || !internalEList.eIsProxy() || !uRI.equals((Object)internalEList.eProxyURI())) continue;
                    eReference = eReference2;
                    break;
                }
                if (eReference != null) {
                    return new ReferenceInfo(eObject, eReference, n);
                }
            }
            catch (Exception exception) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
            }
        }
        return null;
    }

    public IMarkerResolution[] getResolutions(IMarker iMarker) {
        ReferenceInfo referenceInfo = MarkerResolutionGenerator.getReferenceInfo(iMarker);
        if (referenceInfo != null) {
            Object object = MarkerResolutionGenerator.getSelectableObject(referenceInfo.owner);
            MarkerResolution markerResolution = new MarkerResolution(iMarker, referenceInfo);
            if (object != null) {
                return new IMarkerResolution[]{markerResolution, new ShowOwnerInLibraryView(object)};
            }
            return new IMarkerResolution[]{markerResolution};
        }
        return EMPTY_RESOLUTIONS;
    }

    private static Object getSelectableObject(EObject eObject) {
        ProcessComponent processComponent;
        if (eObject instanceof MethodPlugin || eObject instanceof ContentElement || eObject instanceof ContentPackage || eObject instanceof ProcessComponent) {
            return eObject;
        }
        if (eObject instanceof MethodElement && (processComponent = UmaUtil.getProcessComponent((MethodElement)((MethodElement)eObject))) != null) {
            return processComponent;
        }
        if (eObject instanceof ProcessPackage) {
            return eObject;
        }
        if (eObject instanceof ContentDescription && eObject.eContainer() instanceof ContentElement) {
            return eObject.eContainer();
        }
        processComponent = eObject.eResource();
        MethodElement methodElement = PersistenceUtil.getMethodElement((Resource)processComponent);
        if (methodElement != eObject) {
            return MarkerResolutionGenerator.getSelectableObject((EObject)methodElement);
        }
        return null;
    }

    private static class MarkerResolution
    extends WorkbenchMarkerResolution {
        private IMarker currentMarker;
        private ReferenceInfo referenceInfo;

        public MarkerResolution(IMarker iMarker, ReferenceInfo referenceInfo) {
            this.currentMarker = iMarker;
            this.referenceInfo = referenceInfo;
        }

        public String getLabel() {
            return AuthoringUIResources.MarkerResolutionGenerator_removeUnresolvedReference;
        }

        public void run(IMarker iMarker) {
            ResourceSet resourceSet;
            ReferenceInfo referenceInfo;
            ReferenceInfo referenceInfo2 = referenceInfo = this.currentMarker.equals((Object)iMarker) ? this.referenceInfo : MarkerResolutionGenerator.getReferenceInfo(iMarker);
            if (referenceInfo == null) {
                return;
            }
            if (referenceInfo.reference.isMany()) {
                ((List)referenceInfo.owner.eGet((EStructuralFeature)referenceInfo.reference)).remove(referenceInfo.index);
            } else {
                referenceInfo.owner.eSet((EStructuralFeature)referenceInfo.reference, null);
            }
            boolean bl = false;
            Resource resource = referenceInfo.owner.eResource();
            ILibraryPersister.FailSafeMethodLibraryPersister failSafeMethodLibraryPersister = LibraryServiceUtil.getPersisterFor((Resource)resource).getFailSafePersister();
            try {
                failSafeMethodLibraryPersister.save(resource);
                failSafeMethodLibraryPersister.commit();
                bl = true;
            }
            catch (Exception exception) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                failSafeMethodLibraryPersister.rollback();
            }
            if (bl && (resourceSet = resource.getResourceSet()) instanceof MultiFileResourceSetImpl) {
                ((MultiFileResourceSetImpl)resourceSet).getMarkerMananger().doValidateMarkers(resource);
            }
        }

        public IMarker[] findOtherMarkers(IMarker[] iMarkerArray) {
            ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
            int n = 0;
            while (n < iMarkerArray.length) {
                IMarker iMarker = iMarkerArray[n];
                if (!this.currentMarker.equals((Object)iMarker)) {
                    try {
                        if (UnresolvedProxyMarkerManager.MARKER_ID.equals(iMarker.getType())) {
                            arrayList.add(iMarker);
                        }
                    }
                    catch (CoreException coreException) {}
                }
                ++n;
            }
            IMarker[] iMarkerArray2 = new IMarker[arrayList.size()];
            arrayList.toArray(iMarkerArray2);
            return iMarkerArray2;
        }

        public String getDescription() {
            return null;
        }

        public Image getImage() {
            return null;
        }
    }

    private static class ReferenceInfo {
        private EObject owner;
        private EReference reference;
        private int index;

        public ReferenceInfo(EObject eObject, EReference eReference, int n) {
            this.owner = eObject;
            this.reference = eReference;
            this.index = n;
        }
    }

    private static class ShowOwnerInLibraryView
    implements IMarkerResolution {
        private Object owner;

        private ShowOwnerInLibraryView(Object object) {
            this.owner = object;
        }

        public String getLabel() {
            return AuthoringUIResources.MarkerResolutionGenerator_showOwnerInLibraryView;
        }

        public void run(IMarker iMarker) {
            LibraryView.getView().setSelectionToViewer(this.owner);
        }
    }
}

