/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.PerspectiveListUtil;
import org.eclipse.epf.authoring.ui.UIActionDispatcher;
import org.eclipse.epf.authoring.ui.actions.ConfigurationViewEditAction;
import org.eclipse.epf.authoring.ui.actions.ILibraryActionBarContributor;
import org.eclipse.epf.authoring.ui.actions.LibraryActionBarContributor;
import org.eclipse.epf.authoring.ui.actions.LibraryViewCopyAction;
import org.eclipse.epf.authoring.ui.actions.LibraryViewFindElementAction;
import org.eclipse.epf.authoring.ui.dnd.LibraryViewerDragAdapter;
import org.eclipse.epf.authoring.ui.providers.ConfigurationLabelProvider;
import org.eclipse.epf.authoring.ui.views.AbstractBaseView;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.common.utils.ClipboardUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.ConfigurationFilter;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class ConfigurationView
extends AbstractBaseView
implements ILibraryChangeListener {
    public static final String VIEW_ID = ConfigurationView.class.getName();
    private String configName;
    private TreeViewer treeViewer;
    private IDoubleClickListener doubleClickListener;

    public void init(IViewSite iViewSite) throws PartInitException {
        super.init(iViewSite);
        this.createActions(iViewSite);
        LibraryUIManager.getInstance();
    }

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, AuthoringUIHelpContexts.CONFIGURATION_VIEW_CONTEXT);
        this.editingDomain = new AdapterFactoryEditingDomain(this.adapterFactory, (CommandStack)new BasicCommandStack());
        this.adapterFactory = (ComposedAdapterFactory)this.editingDomain.getAdapterFactory();
        this.setConfiguration(null);
    }

    public void libraryCreated(MethodLibrary methodLibrary) {
    }

    public void libraryOpened(MethodLibrary methodLibrary) {
    }

    public void libraryClosed(MethodLibrary methodLibrary) {
        this.setInputForViewer(null);
        if (this.adapterFactory instanceof ComposedAdapterFactory) {
            ((ComposedAdapterFactory)this.adapterFactory).dispose();
        }
    }

    public void librarySet(MethodLibrary methodLibrary) {
        this.setMethodConfiguration(null);
        ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
        if (iLibraryManager != null) {
            iLibraryManager.addListener((ILibraryChangeListener)this);
        }
    }

    public void libraryChanged(int n, Collection collection) {
        switch (n) {
            case 16: {
                if (collection == null) break;
                for (Object e : collection) {
                    if (!(e instanceof MethodConfiguration) || !((MethodConfiguration)e).getName().equals(this.getCurrentConfig())) continue;
                    this.setMethodConfiguration(null);
                }
                break;
            }
            case 8: {
                if (collection == null) break;
                for (Object e : collection) {
                    if (!(e instanceof MethodConfiguration) || !((MethodConfiguration)e).equals(LibraryService.getInstance().getCurrentMethodConfiguration())) continue;
                    this.setContentDescription(((MethodConfiguration)e).getName());
                }
                break;
            }
        }
    }

    public void configurationSet(MethodConfiguration methodConfiguration) {
        this.setMethodConfiguration(methodConfiguration);
    }

    public String getCurrentConfig() {
        return this.configName;
    }

    public void setFocus() {
        this.actionBarContributor.setActiveView((IViewPart)this);
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getSelection();
        if (iStructuredSelection.isEmpty()) {
            this.actionBarContributor.disableGlobalEditMenu();
        } else {
            this.actionBarContributor.enableGlobalEditMenu();
        }
        if (this.treeViewer != null) {
            this.treeViewer.getControl().setFocus();
        }
    }

    public void createViewer(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        this.treeViewer = new TreeViewer(composite2);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        int n = 3;
        Transfer[] transferArray = new Transfer[]{HTMLTransfer.getInstance(), LocalTransfer.getInstance()};
        this.treeViewer.addDragSupport(n, transferArray, (DragSourceListener)new LibraryViewerDragAdapter((Viewer)this.treeViewer));
        this.doubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                UIActionDispatcher.getInstance().handleDoubleClickEvent(doubleClickEvent);
            }
        };
        this.treeViewer.addDoubleClickListener(this.doubleClickListener);
        this.createContextMenuFor((StructuredViewer)this.treeViewer);
    }

    public void createActions(IViewSite iViewSite) {
        Action action = new Action(AuthoringUIResources.actionLabel_edit){

            public void run() {
                UIActionDispatcher.editConfiguration(ConfigurationView.this.configName);
            }
        };
        action.setToolTipText(AuthoringUIResources.editConfiguration_tooltip);
    }

    private void reset() {
        IBaseLabelProvider iBaseLabelProvider;
        this.configName = null;
        if (this.adapterFactory != null) {
            if (this.adapterFactory instanceof IDisposable) {
                ((IDisposable)this.adapterFactory).dispose();
            }
            this.adapterFactory = null;
        }
        this.editingDomain.setAdapterFactory(null);
        IContentProvider iContentProvider = this.treeViewer.getContentProvider();
        if (iContentProvider != null) {
            iContentProvider.dispose();
        }
        if ((iBaseLabelProvider = this.treeViewer.getLabelProvider()) != null) {
            iBaseLabelProvider.dispose();
        }
        StructuredSelection structuredSelection = new StructuredSelection();
        this.actionDispatcher.setSelection((ISelection)structuredSelection);
        UIActionDispatcher.getInstance().setSelection((ISelection)structuredSelection);
    }

    public void setMethodConfiguration(MethodConfiguration methodConfiguration) {
        Control control = this.getViewer().getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        if (this.treeViewer.getInput() == methodConfiguration) {
            return;
        }
        String string = "";
        if (methodConfiguration != null) {
            this.configName = methodConfiguration.getName();
            ConfigurationFilter configurationFilter = new ConfigurationFilter(methodConfiguration, (Viewer)this.treeViewer);
            this.adapterFactory = TngAdapterFactory.INSTANCE.getConfigurationView_AdapterFactory((IFilter)configurationFilter);
            this.editingDomain.setAdapterFactory(this.adapterFactory);
            this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.adapterFactory));
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationLabelProvider(methodConfiguration, this.adapterFactory));
            string = methodConfiguration.getName();
        } else {
            IBaseLabelProvider iBaseLabelProvider;
            this.configName = null;
            if (this.adapterFactory != null) {
                if (this.adapterFactory instanceof IDisposable) {
                    ((IDisposable)this.adapterFactory).dispose();
                }
                this.adapterFactory = null;
            }
            this.editingDomain.setAdapterFactory(null);
            IContentProvider iContentProvider = this.treeViewer.getContentProvider();
            if (iContentProvider != null) {
                iContentProvider.dispose();
            }
            if ((iBaseLabelProvider = this.treeViewer.getLabelProvider()) != null) {
                iBaseLabelProvider.dispose();
            }
            StructuredSelection structuredSelection = new StructuredSelection();
            this.actionDispatcher.setSelection((ISelection)structuredSelection);
            UIActionDispatcher.getInstance().setSelection((ISelection)structuredSelection);
        }
        this.treeViewer.setInput((Object)methodConfiguration);
        this.setContentDescription(string);
    }

    public void setConfiguration(String string) {
        MethodConfiguration methodConfiguration;
        this.configName = string;
        if (string == null && (methodConfiguration = LibraryService.getInstance().getCurrentMethodConfiguration()) != null) {
            this.configName = methodConfiguration.getName();
        }
        if (this.configName != null && (methodConfiguration = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (String)this.configName)) != null) {
            this.setMethodConfiguration(methodConfiguration);
            return;
        }
        this.configName = null;
    }

    public void dispose() {
        super.dispose();
        if (this.doubleClickListener != null) {
            this.treeViewer.removeDoubleClickListener(this.doubleClickListener);
        }
    }

    public static ConfigurationView getView() {
        boolean bl = ViewHelper.isViewInCurrentPerspective(VIEW_ID);
        return (ConfigurationView)ViewHelper.findView(VIEW_ID, bl);
    }

    public Viewer getViewer() {
        return this.treeViewer;
    }

    public ILibraryActionBarContributor createActionBarContributor() {
        return new ConfigurationViewActionBarContributor((EditingDomain)this.editingDomain);
    }

    public void setInputForViewer(Object object) {
        if (object == null || object instanceof MethodConfiguration) {
            this.setMethodConfiguration((MethodConfiguration)object);
        } else {
            this.reset();
        }
    }

    public String getViewId() {
        return VIEW_ID;
    }

    private class ConfigurationViewActionBarContributor
    extends LibraryActionBarContributor {
        private LibraryViewFindElementAction libraryViewFindElementAction;

        public ConfigurationViewActionBarContributor(EditingDomain editingDomain) {
            super(editingDomain);
            this.validateAction = null;
        }

        public void init(IActionBars iActionBars) {
            ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
            this.copyAction = this.createCopyAction();
            this.copyAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            iActionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
            this.viewActionBars = iActionBars;
            this.configViewEditAction = new ConfigurationViewEditAction(AuthoringUIResources.actionLabel_edit);
            iActionBars.setGlobalActionHandler("org.eclipse.epf.authoring.ui.actions.openElement", (IAction)this.configViewEditAction);
            this.libraryViewFindElementAction = new LibraryViewFindElementAction(AuthoringUIResources.actionLabel_findElementInLibNav);
            iActionBars.setGlobalActionHandler(LibraryViewFindElementAction.ACTION_ID, (IAction)this.libraryViewFindElementAction);
        }

        public void activate() {
            this.activeViewPart.addPropertyListener((IPropertyListener)this);
            ISelectionProvider iSelectionProvider = this.activeViewPart instanceof ISelectionProvider ? (ISelectionProvider)this.activeViewPart : this.activeViewPart.getSite().getSelectionProvider();
            iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.configViewEditAction);
            iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.libraryViewFindElementAction);
            this.copyAction.setEditingDomain((EditingDomain)ConfigurationView.this.editingDomain);
            iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.copyAction);
            this.update();
        }

        public void deactivate() {
            this.activeViewPart.removePropertyListener((IPropertyListener)this);
            ISelectionProvider iSelectionProvider = this.activeViewPart instanceof ISelectionProvider ? (ISelectionProvider)this.activeViewPart : this.activeViewPart.getSite().getSelectionProvider();
            iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.configViewEditAction);
            iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.libraryViewFindElementAction);
            this.copyAction.setEditingDomain(null);
            iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.copyAction);
        }

        public void update() {
            ISelectionProvider iSelectionProvider = this.activeViewPart instanceof ISelectionProvider ? (ISelectionProvider)this.activeViewPart : this.activeViewPart.getSite().getSelectionProvider();
            ISelection iSelection = iSelectionProvider.getSelection();
            StructuredSelection structuredSelection = iSelection instanceof IStructuredSelection ? (IStructuredSelection)iSelection : StructuredSelection.EMPTY;
            this.configViewEditAction.selectionChanged((IStructuredSelection)structuredSelection);
            this.libraryViewFindElementAction.selectionChanged((IStructuredSelection)structuredSelection);
            this.copyAction.updateSelection((IStructuredSelection)structuredSelection);
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        }

        public void disableGlobalEditMenu() {
            this.configViewEditAction.setEnabled(false);
        }

        public void enableGlobalEditMenu() {
            this.configViewEditAction.setEnabled(true);
        }

        public void menuAboutToShow(IMenuManager iMenuManager) {
            iMenuManager.add((IContributionItem)new Separator("additions"));
            iMenuManager.add((IContributionItem)new Separator("edit"));
            iMenuManager.add((IContributionItem)new Separator("additions-end"));
            this.addGlobalActions(iMenuManager);
            iMenuManager.add((IContributionItem)new Separator());
            iMenuManager.add((IContributionItem)new ActionContributionItem((IAction)this.configViewEditAction));
            if (PerspectiveListUtil.isAuthoringPerspective()) {
                iMenuManager.add((IContributionItem)new ActionContributionItem((IAction)this.libraryViewFindElementAction));
            }
        }

        protected CopyAction createCopyAction() {
            return new LibraryViewCopyAction(){

                public Command createCommand(Collection collection) {
                    return new IdentityCommand(collection);
                }

                public void run() {
                    String string = "";
                    Iterator iterator = ((IdentityCommand)this.command).getResult().iterator();
                    while (iterator.hasNext()) {
                        Object object = TngUtil.unwrap(iterator.next());
                        if (!(object instanceof MethodElement)) continue;
                        MethodElement methodElement = (MethodElement)object;
                        String string2 = ResourceHelper.getUrl((MethodElement)methodElement, null, (String)"html");
                        if (string.length() > 0) {
                            string = String.valueOf(string) + StrUtil.LINE_FEED;
                        }
                        string = String.valueOf(string) + ResourceHelper.getElementLink((MethodElement)methodElement, (boolean)true, (String)("file://" + string2));
                    }
                    if (string.length() > 0) {
                        ClipboardUtil.copyTextHTMLToClipboard((String)string);
                    }
                }
            };
        }
    }
}

