/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.views.AbstractBaseView;
import org.eclipse.epf.authoring.ui.views.AbstractLocker;
import org.eclipse.epf.authoring.ui.views.LockerFactory;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.common.utils.PerspectiveUtil;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.FeatureValueWrapperItemProvider;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.Misc;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.uma.BreakdownElementDescription;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public final class ViewHelper {
    public static boolean promptSave() {
        ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
        if (iLibraryManager != null && iLibraryManager.isMethodLibraryModified()) {
            int n = MsgBox.prompt((String)AuthoringUIResources.saveLibraryDialog_title, (String)AuthoringUIResources.saveLibraryDialog_text, (int)448);
            switch (n) {
                case 64: {
                    try {
                        LibraryService.getInstance().saveCurrentMethodLibrary();
                        break;
                    }
                    catch (Exception exception) {
                        MsgDialog msgDialog = AuthoringUIPlugin.getDefault().getMsgDialog();
                        msgDialog.displayError(AuthoringUIResources.saveLibraryDialog_title, AuthoringUIResources.saveLibraryError_msg, AuthoringUIResources.error_reason, (Throwable)exception);
                        return msgDialog.displayPrompt(AuthoringUIResources.openLibraryDialog_title, AuthoringUIResources.openLibraryDialog_text);
                    }
                }
                case 128: {
                    iLibraryManager.discardMethodLibraryChanges();
                    break;
                }
                case 256: {
                    return false;
                }
            }
        }
        return true;
    }

    public static int promptSaveInt() {
        ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
        if (iLibraryManager != null && iLibraryManager.isMethodLibraryModified()) {
            int n = MsgBox.prompt((String)AuthoringUIResources.saveLibraryDialog_title, (String)AuthoringUIResources.saveLibraryDialog_text, (int)448);
            switch (n) {
                case 64: {
                    try {
                        LibraryService.getInstance().saveCurrentMethodLibrary();
                    }
                    catch (Exception exception) {
                        MsgDialog msgDialog = AuthoringUIPlugin.getDefault().getMsgDialog();
                        msgDialog.displayError(AuthoringUIResources.saveLibraryDialog_title, AuthoringUIResources.saveLibraryError_msg, AuthoringUIResources.error_reason, (Throwable)exception);
                    }
                    return 64;
                }
                case 128: {
                    iLibraryManager.discardMethodLibraryChanges();
                    return 128;
                }
                case 256: {
                    return 256;
                }
            }
        }
        return 256;
    }

    public static void closeAllEditors() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(true);
    }

    public static Object handleDangling(Object object) {
        FeatureValueWrapperItemProvider featureValueWrapperItemProvider;
        Object object2;
        if (object instanceof MethodElement && ((EObject)object).eResource() == null) {
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.errorDialog_title, AuthoringUIResources.bind((String)AuthoringUIResources.elementAlreadyDeletedError_msg, (Object)((MethodElement)object).getName()));
            return null;
        }
        if (object instanceof FeatureValueWrapperItemProvider && (object2 = (featureValueWrapperItemProvider = (FeatureValueWrapperItemProvider)object).getValue()) instanceof MethodElement && ((EObject)object2).eResource() == null) {
            Object object3 = TngUtil.unwrap((Object)featureValueWrapperItemProvider.getParent(object2));
            if (object3 instanceof ItemProviderAdapter) {
                object3 = ((ItemProviderAdapter)object3).getTarget();
            }
            String string = ((MethodElement)object3).getName();
            EStructuralFeature eStructuralFeature = featureValueWrapperItemProvider.getFeature();
            if (eStructuralFeature != null) {
                if (AuthoringUIPlugin.getDefault().getMsgDialog().displayPrompt(AuthoringUIResources.deleteDialog_title, AuthoringUIResources.bind((String)AuthoringUIResources.ViewHelper_alreadydeletedconfirm_text, (Object)((MethodElement)object2).getName(), (Object)string)) && eStructuralFeature.isMany()) {
                    ((Collection)((EObject)object3).eGet(eStructuralFeature)).remove(object2);
                }
            } else {
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.errorDialog_title, AuthoringUIResources.bind((String)AuthoringUIResources.elementAlreadyDeletedError_msg, (Object)((MethodElement)object2).getName()));
            }
            return null;
        }
        return object;
    }

    public static boolean isLocked(IStructuredSelection iStructuredSelection) {
        for (Object object : iStructuredSelection) {
            while (object instanceof ITreeItemContentProvider) {
                object = ((ITreeItemContentProvider)object).getParent(null);
            }
            if (!((object = TngUtil.unwrap(object)) instanceof EObject) || !TngUtil.isLocked((EObject)((EObject)object))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCustomizedLocker(IStructuredSelection iStructuredSelection) {
        for (Object object : iStructuredSelection) {
            while (object instanceof ITreeItemContentProvider) {
                object = ((ITreeItemContentProvider)object).getParent(null);
            }
            if (!((object = TngUtil.unwrap(object)) instanceof EObject)) continue;
            AbstractLocker abstractLocker = null;
            if (object instanceof MethodConfiguration) {
                abstractLocker = LockerFactory.getInstance().getLocker(object);
            } else {
                MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)((EObject)object));
                if (methodPlugin != null) {
                    abstractLocker = LockerFactory.getInstance().getLocker(methodPlugin);
                }
            }
            if (abstractLocker == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isLockedWithCustomizedLocker(IStructuredSelection iStructuredSelection) {
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            AbstractLocker abstractLocker;
            AbstractLocker abstractLocker2;
            Object e;
            Object object = e = iterator.next();
            while (object instanceof ITreeItemContentProvider) {
                object = ((ITreeItemContentProvider)object).getParent(null);
            }
            Object object2 = TngUtil.unwrap(object);
            if (!(object2 instanceof EObject)) continue;
            if (object instanceof MethodConfiguration && (abstractLocker2 = LockerFactory.getInstance().getLocker(object)) != null && abstractLocker2.isLocked(object)) {
                return true;
            }
            abstractLocker2 = UmaUtil.getMethodPlugin((EObject)((EObject)object2));
            if (abstractLocker2 == null || !((abstractLocker = LockerFactory.getInstance().getLocker(abstractLocker2)) != null ? abstractLocker.isLocked(e) : TngUtil.isLocked((EObject)((EObject)object2)))) continue;
            return true;
        }
        return false;
    }

    public static boolean isExtendedLocked(Object object) {
        block5: {
            if (object != null) break block5;
            return false;
        }
        try {
            AbstractLocker abstractLocker;
            MethodPlugin methodPlugin;
            Object object2 = object;
            while (object2 instanceof ITreeItemContentProvider) {
                object2 = ((ITreeItemContentProvider)object2).getParent(null);
            }
            if ((object2 = TngUtil.unwrap((Object)object2)) instanceof EObject && (methodPlugin = UmaUtil.getMethodPlugin((EObject)((EObject)object2))) != null && (abstractLocker = LockerFactory.getInstance().getLocker(methodPlugin)) != null && abstractLocker.isLocked(object)) {
                return true;
            }
        }
        catch (Exception exception) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
        }
        return false;
    }

    public static void fixContentDescriptionGUIDs() {
        final MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        if (methodLibrary == null) {
            return;
        }
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                HashSet<Resource> hashSet = new HashSet<Resource>();
                TreeIterator treeIterator = methodLibrary.eAllContents();
                while (treeIterator.hasNext()) {
                    InternalEObject internalEObject = (InternalEObject)treeIterator.next();
                    if (internalEObject.eProxyURI() == null) {
                        String string;
                        if (!(internalEObject instanceof ContentDescription)) continue;
                        ContentDescription contentDescription = (ContentDescription)internalEObject;
                        DescribableElement describableElement = (DescribableElement)internalEObject.eContainer();
                        if (describableElement == null || (string = UmaUtil.generateGUID((String)describableElement.getGuid())).equals(contentDescription.getGuid())) continue;
                        contentDescription.setGuid(string);
                        hashSet.add(contentDescription.eResource());
                        hashSet.add(describableElement.eResource());
                        continue;
                    }
                    AuthoringUIPlugin.getDefault().getLogger().logError("Unresolved proxy in '" + internalEObject.eResource().getURI().toFileString() + "': " + internalEObject);
                }
                iProgressMonitor.subTask(AuthoringUIResources.savingFilesTask_name);
                treeIterator = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
                try {
                    for (Resource resource : hashSet) {
                        iProgressMonitor.subTask(AuthoringUIResources.bind((String)AuthoringUIResources.savingTask_name, (Object)resource.getURI().toFileString()));
                        treeIterator.save(resource);
                    }
                    treeIterator.commit();
                }
                catch (Exception exception) {
                    treeIterator.rollback();
                    throw new WrappedException(exception);
                }
            }
        };
        UserInteractionHelper.runWithProgress((IRunnableWithProgress)iRunnableWithProgress, (String)AuthoringUIResources.fixingContentDescriptionGUIDsTask_name);
    }

    private static String checkProxy(InternalEObject internalEObject, EReference eReference, Object object) {
        InternalEObject internalEObject2;
        if (object instanceof InternalEObject && (internalEObject2 = (InternalEObject)object).eIsProxy()) {
            EObject eObject = internalEObject.eResolveProxy(internalEObject2);
            String string = null;
            if (eObject == internalEObject2) {
                string = "Unresolved proxy";
            } else if (!eReference.getEType().isInstance((Object)eObject)) {
                string = "Invalid data";
            }
            if (string != null) {
                String string2 = internalEObject instanceof NamedElement ? String.valueOf(eReference.getEType().getName()) + "(" + Misc.getPathRelativeToLibrary((NamedElement)((NamedElement)internalEObject)) + ")." + eReference.getName() + " = " : "";
                return String.valueOf(string) + " in '" + internalEObject.eResource().getURI().toFileString() + "': " + string2 + eObject;
            }
        }
        return null;
    }

    public static void checkLibraryHealth() {
        final MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        if (methodLibrary == null) {
            return;
        }
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                AuthoringUIPlugin.getDefault().getLogger().logInfo("++++ LIBRARY HEALTH CHECK REPORT - START +++");
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                printWriter.println();
                printWriter.println("UNRESOLVED/INVALID PROXIES IN X-REFERENCES");
                printWriter.println("------------------------------------------");
                TreeIterator treeIterator = methodLibrary.eAllContents();
                while (treeIterator.hasNext()) {
                    InternalEObject internalEObject = (InternalEObject)treeIterator.next();
                    if (internalEObject.eProxyURI() == null) {
                        Object object;
                        Object object2;
                        Object object3;
                        Object object4;
                        String string;
                        Object object5;
                        Object object6;
                        if (internalEObject instanceof ContentDescription) {
                            object6 = (ContentDescription)internalEObject;
                            object5 = (DescribableElement)internalEObject.eContainer();
                            if (object5 != null) {
                                string = UmaUtil.generateGUID((String)object5.getGuid());
                                if (!string.equals(object6.getGuid())) {
                                    AuthoringUIPlugin.getDefault().getLogger().logError("ContentDescription with invalid GUID: " + object6.getGuid() + " in '" + object6.eResource().getURI().toFileString() + "'");
                                }
                            } else {
                                AuthoringUIPlugin.getDefault().getLogger().logError("ContentDescription without a container: " + object6);
                            }
                            if (object6 instanceof BreakdownElementDescription && (string = UmaUtil.getProcessComponent((MethodElement)object6)) != null && !((File)(object4 = new File((String)(object3 = string.eResource().getURI().toFileString())).getParentFile())).equals(object2 = new File((String)(object = object6.eResource().getURI().toFileString())).getParentFile())) {
                                AuthoringUIPlugin.getDefault().getLogger().logError("Content file of " + object5.eClass().getName() + " '" + object5.getName() + "' in '" + (String)object3 + " is misplaced: " + (String)object);
                            }
                        }
                        object6 = new ArrayList(internalEObject.eClass().getEAllReferences());
                        ((ArrayList)object6).removeAll((Collection<?>)internalEObject.eClass().getEAllContainments());
                        object5 = ((ArrayList)object6).iterator();
                        while (object5.hasNext()) {
                            string = (EReference)object5.next();
                            object3 = internalEObject.eGet((EStructuralFeature)string, false);
                            if (string.isMany()) {
                                if (!(object3 instanceof InternalEList)) continue;
                                object4 = (InternalEList)object3;
                                object = object4.basicIterator();
                                while (object.hasNext()) {
                                    object2 = ViewHelper.checkProxy(internalEObject, (EReference)string, object.next());
                                    if (object2 == null) continue;
                                    printWriter.println((String)object2);
                                }
                                continue;
                            }
                            object4 = ViewHelper.checkProxy(internalEObject, (EReference)string, object3);
                            if (object4 == null) continue;
                            printWriter.println((String)object4);
                        }
                        continue;
                    }
                    AuthoringUIPlugin.getDefault().getLogger().logError("Unresolved proxy in '" + internalEObject.eResource().getURI().toFileString() + "': " + internalEObject);
                }
                AuthoringUIPlugin.getDefault().getLogger().logError(stringWriter.toString());
                AuthoringUIPlugin.getDefault().getLogger().logInfo("++++ LIBRARY HEALTH CHECK REPORT - END +++");
            }
        };
        if (UserInteractionHelper.runWithProgress((IRunnableWithProgress)iRunnableWithProgress, (String)AuthoringUIResources.viewHelper_performHealthCheck)) {
            String string = AuthoringUIResources.viewHelperHealthCheckDialog_title;
            String string2 = AuthoringUIResources.viewHelperHealthCheckDialog_message;
            AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(string, string2);
        }
    }

    public static void removeInvalidReferences() {
        final MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        if (methodLibrary == null) {
            return;
        }
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                HashSet<Resource> hashSet = new HashSet<Resource>();
                TreeIterator treeIterator = methodLibrary.eAllContents();
                while (treeIterator.hasNext()) {
                    InternalEObject internalEObject = (InternalEObject)treeIterator.next();
                    if (internalEObject.eProxyURI() == null) {
                        Resource resource = new ArrayList(internalEObject.eClass().getEAllReferences());
                        resource.removeAll((Collection<?>)internalEObject.eClass().getEAllContainments());
                        for (EReference eReference : resource) {
                            Object object = internalEObject.eGet((EStructuralFeature)eReference, false);
                            if (eReference.isMany()) {
                                if (!(object instanceof InternalEList)) continue;
                                InternalEList internalEList = (InternalEList)object;
                                ArrayList arrayList = new ArrayList();
                                Iterator iterator = internalEList.basicIterator();
                                while (iterator.hasNext()) {
                                    Object e = iterator.next();
                                    if (!this.isInvalidReference(internalEObject, eReference, e)) continue;
                                    arrayList.add(e);
                                }
                                if (arrayList.isEmpty()) continue;
                                this.removeInvalidReferences(internalEObject, internalEList, arrayList);
                                hashSet.add(internalEObject.eResource());
                                continue;
                            }
                            if (!this.isInvalidReference(internalEObject, eReference, object)) continue;
                            internalEObject.eSet((EStructuralFeature)eReference, null);
                            hashSet.add(internalEObject.eResource());
                        }
                        continue;
                    }
                    AuthoringUIPlugin.getDefault().getLogger().logError("Unresolved proxy in '" + internalEObject.eResource().getURI().toFileString() + "': " + internalEObject);
                }
                iProgressMonitor.subTask(AuthoringUIResources.savingFilesTask_name);
                treeIterator = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
                try {
                    for (Resource resource : hashSet) {
                        iProgressMonitor.subTask(AuthoringUIResources.bind((String)AuthoringUIResources.savingTask_name, (Object)resource.getURI().toFileString()));
                        treeIterator.save(resource);
                    }
                    treeIterator.commit();
                }
                catch (Exception exception) {
                    treeIterator.rollback();
                    throw new WrappedException(exception);
                }
            }

            private boolean isInvalidReference(InternalEObject internalEObject, EReference eReference, Object object) {
                InternalEObject internalEObject2;
                if (object instanceof InternalEObject && (internalEObject2 = (InternalEObject)object).eIsProxy()) {
                    EObject eObject = internalEObject.eResolveProxy(internalEObject2);
                    if (!eReference.getEType().isInstance((Object)eObject)) {
                        return true;
                    }
                }
                return false;
            }

            private void removeInvalidReferences(InternalEObject internalEObject, InternalEList internalEList, Collection collection) {
                int n;
                ArrayList<EObject> arrayList = new ArrayList<EObject>(internalEList.basicList());
                arrayList.removeAll(collection);
                internalEList.clear();
                int n2 = n = arrayList.size() - 1;
                while (n2 > -1) {
                    arrayList.set(n2, internalEObject.eResolveProxy((InternalEObject)arrayList.get(n2)));
                    --n2;
                }
                internalEList.addAll(arrayList);
            }
        };
        UserInteractionHelper.runWithProgress((IRunnableWithProgress)iRunnableWithProgress, (String)AuthoringUIResources.deletingInvalidReferencesTask_name);
    }

    public static void reloadCurrentLibaryOnRollbackError(Shell shell) {
        ViewHelper.reloadCurrentLibrary(shell, AuthoringUIResources.ViewHelper_reloadLibOnRollbackError);
    }

    public static void reloadCurrentLibrary(final Shell shell, final String string) {
        Display display = MsgBox.getDisplay();
        Runnable runnable = new Runnable(){

            public void run() {
                ViewHelper.doReloadCurrentLibrary(shell, string);
            }
        };
        if (display != null) {
            display.asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    private static void doReloadCurrentLibrary(Shell shell, String string) {
        if (shell == null) {
            MsgBox.getDefaultShell();
        }
        String string2 = AuthoringUIResources.reloadDialog_title;
        if (string == null) {
            string = AuthoringUIResources.reloadDialog_message;
        }
        AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(string2, string);
        String string3 = LibraryService.getInstance().getCurrentMethodLibraryLocation();
        LibraryUIManager.getInstance().openLibrary(string3);
    }

    public static IViewPart openView(String string) {
        return ViewHelper.findView(string, true);
    }

    public static IViewPart findView(String string, boolean bl) {
        try {
            IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (iWorkbenchPage != null) {
                IViewPart iViewPart = iWorkbenchPage.findView(string);
                if (iViewPart == null) {
                    iViewPart = iWorkbenchPage.showView(string);
                }
                if (!bl) {
                    iWorkbenchPage.hideView(iViewPart);
                }
                return iViewPart;
            }
        }
        catch (Exception exception) {
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.errorDialog_title, AuthoringUIResources.internalError_msg, (Throwable)exception);
        }
        return null;
    }

    public static boolean isViewInCurrentPerspective(String string) {
        String string2 = PerspectiveUtil.getActivePerspectiveId();
        return ViewHelper.isViewInPerspective(string, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isViewInPerspective(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = null;
        if (iExtensionRegistry != null) {
            iExtensionPoint = iExtensionRegistry.getExtensionPoint("org.eclipse.ui", "perspectiveExtensions");
        }
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < iExtensionArray.length) {
                IExtension iExtension = iExtensionArray[n];
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                    try {
                        String string3 = iConfigurationElement.getAttribute("targetID");
                        if (string2.equals(string3)) {
                            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElement.getChildren("view");
                            int n3 = 0;
                            while (n3 < iConfigurationElementArray2.length) {
                                IConfigurationElement iConfigurationElement2 = iConfigurationElementArray2[n3];
                                if (string.equals(iConfigurationElement2.getAttribute("id"))) {
                                    return true;
                                }
                                ++n3;
                            }
                            IConfigurationElement[] iConfigurationElementArray3 = iConfigurationElement.getChildren("viewShortcut");
                            int n4 = 0;
                            while (n4 < iConfigurationElementArray3.length) {
                                IConfigurationElement iConfigurationElement3 = iConfigurationElementArray3[n4];
                                if (string.equals(iConfigurationElement3.getAttribute("id"))) {
                                    return true;
                                }
                                ++n4;
                            }
                        }
                    }
                    catch (Exception exception) {
                        AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return false;
    }

    public static void refreshView(AbstractBaseView abstractBaseView) {
        Object object;
        Control control = abstractBaseView.getViewer().getControl();
        if (control != null && !control.isDisposed() && (object = abstractBaseView.getViewer().getInput()) instanceof EObject) {
            EObject eObject = (EObject)object;
            if (eObject.eIsProxy()) {
                abstractBaseView.setInputForViewer(RefreshJob.getInstance().resolve(eObject));
            } else {
                ISelection iSelection = abstractBaseView.getViewer().getSelection();
                abstractBaseView.getViewer().refresh();
                ViewHelper.restoreSelection(abstractBaseView.getViewer(), iSelection);
            }
        }
    }

    public static void restoreSelection(Viewer viewer, ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection && !iSelection.isEmpty()) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            boolean bl = false;
            ArrayList<EObject> arrayList = new ArrayList<EObject>();
            for (Object e : iStructuredSelection) {
                if (!(e instanceof EObject)) continue;
                EObject eObject = (EObject)e;
                if (eObject.eIsProxy()) {
                    eObject = RefreshJob.getInstance().resolve(eObject);
                    bl = true;
                }
                if (eObject.eIsProxy()) continue;
                arrayList.add(eObject);
            }
            if (bl) {
                viewer.setSelection((ISelection)new StructuredSelection(arrayList), true);
            }
        }
    }
}

