/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.validation.internal.l10n.ValidationMessages;

public final class ConstraintSeverity
implements Serializable {
    private static final long serialVersionUID = -5310833954198275258L;
    private static int nextOrdinal = 0;
    public static final ConstraintSeverity INFO = new ConstraintSeverity("INFO", ValidationMessages.severity_info, 1);
    public static final ConstraintSeverity WARNING = new ConstraintSeverity("WARNING", ValidationMessages.severity_warning, 2);
    public static final ConstraintSeverity ERROR = new ConstraintSeverity("ERROR", ValidationMessages.severity_error, 4);
    public static final ConstraintSeverity CANCEL = new ConstraintSeverity("CANCEL", ValidationMessages.severity_cancel, 8);
    public static final ConstraintSeverity NULL = new ConstraintSeverity("none", ValidationMessages.severity_null, 0);
    private static final List instances = Collections.unmodifiableList(Arrays.asList(INFO, WARNING, ERROR, CANCEL, NULL));
    private final String name;
    private final String localizedName;
    private final int ordinal;
    private final int istatusSeverity;

    private ConstraintSeverity(String name, String localizedName, int istatusSeverity) {
        this.name = name;
        this.ordinal = nextOrdinal++;
        this.istatusSeverity = istatusSeverity;
        this.localizedName = localizedName;
    }

    public static ConstraintSeverity getInstance(String name) {
        ConstraintSeverity result = NULL;
        Iterator iter = instances.iterator();
        while (iter.hasNext()) {
            ConstraintSeverity next = (ConstraintSeverity)iter.next();
            if (!next.getName().equalsIgnoreCase(name)) continue;
            result = next;
            break;
        }
        return result;
    }

    public static final List getAllInstances() {
        return instances;
    }

    public final String getName() {
        return this.name;
    }

    public final String getLocalizedName() {
        return this.localizedName;
    }

    public boolean isNull() {
        return this == NULL;
    }

    public int toIStatusSeverity() {
        return this.istatusSeverity;
    }

    public String toString() {
        return this.getName();
    }

    private Object readResolve() {
        return ConstraintSeverity.getAllInstances().get(this.ordinal);
    }
}

