/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class DiffImage
extends CompositeImageDescriptor {
    static final int HEIGHT = 16;
    private Image fBaseImage;
    private ImageDescriptor fOverlayImage;
    private int fWidth;
    private boolean fLeft = true;

    public DiffImage(Image base, ImageDescriptor overlay, int w) {
        this.fBaseImage = base;
        this.fOverlayImage = overlay;
        this.fWidth = w;
    }

    public DiffImage(Image base, ImageDescriptor overlay, int w, boolean onLeft) {
        this.fBaseImage = base;
        this.fOverlayImage = overlay;
        this.fWidth = w;
        this.fLeft = onLeft;
    }

    protected Point getSize() {
        return new Point(this.fWidth, 16);
    }

    protected void drawCompositeImage(int width, int height) {
        if (this.fLeft) {
            if (this.fBaseImage != null) {
                ImageData base = this.fBaseImage.getImageData();
                if (base == null) {
                    base = DEFAULT_IMAGE_DATA;
                }
                this.drawImage(base, this.fWidth - base.width, 0);
            }
            if (this.fOverlayImage != null) {
                ImageData overlay = this.fOverlayImage.getImageData();
                if (overlay == null) {
                    overlay = DEFAULT_IMAGE_DATA;
                }
                this.drawImage(overlay, 0, (16 - overlay.height) / 2);
            }
        } else {
            if (this.fBaseImage != null) {
                ImageData base = this.fBaseImage.getImageData();
                if (base == null) {
                    base = DEFAULT_IMAGE_DATA;
                }
                this.drawImage(base, 0, 0);
            }
            if (this.fOverlayImage != null) {
                ImageData overlay = this.fOverlayImage.getImageData();
                if (overlay == null) {
                    overlay = DEFAULT_IMAGE_DATA;
                }
                this.drawImage(overlay, this.fWidth - overlay.width, (16 - overlay.height) / 2);
            }
        }
    }
}

