/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.utils;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.utils.ICommandLineRunner;
import org.osgi.framework.Bundle;

public class CommandLineRunUtil {
    private static CommandLineRunUtil instance = new CommandLineRunUtil();
    private boolean needToRun = false;

    public static CommandLineRunUtil getInstance() {
        return instance;
    }

    public boolean execute(String[] stringArray) {
        this.executeCommandRunner(stringArray, "commandLinePluginImporter");
        return false;
    }

    protected boolean executeCommandRunner(String[] stringArray, String string) {
        ICommandLineRunner iCommandLineRunner = CommandLineRunUtil.getRunner(string);
        if (iCommandLineRunner != null) {
            return iCommandLineRunner.execute(stringArray);
        }
        return false;
    }

    private static final ICommandLineRunner getRunner(String string) {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint("org.eclipse.epf.common", "commandLineRunners");
        if (iExtensionPoint == null) {
            return null;
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IExtension iExtension = iExtensionArray[n];
            String string2 = iExtension.getNamespaceIdentifier();
            Bundle bundle = Platform.getBundle((String)string2);
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                String string3;
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                String string4 = iConfigurationElement.getAttribute("runnerId");
                if (string4 != null && (string4 = string4.trim()).equals(string) && (string3 = iConfigurationElement.getAttribute("class")) != null) {
                    string3 = string3.trim();
                    try {
                        ICommandLineRunner iCommandLineRunner = (ICommandLineRunner)bundle.loadClass(string3).newInstance();
                        return iCommandLineRunner;
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public boolean isNeedToRun() {
        return this.needToRun;
    }

    public void setNeedToRun(boolean bl) {
        this.needToRun = bl;
    }

    public static void setInstance(CommandLineRunUtil commandLineRunUtil) {
        instance = commandLineRunUtil;
    }
}

