/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.bridge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.bridge.ControlNodeAdapter;
import org.eclipse.epf.diagram.core.bridge.DiagramAdapter;
import org.eclipse.epf.diagram.core.bridge.NodeAdapter;
import org.eclipse.epf.diagram.core.bridge.WorkBreakdownElementNodeAdapter;
import org.eclipse.epf.diagram.model.util.IAdapterFactoryFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.ActivityWrapperItemProvider;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.WBSActivityItemProvider;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.ControlNode;
import org.eclipse.uml2.uml.StructuredActivityNode;
import org.eclipse.uml2.uml.UMLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityDiagramAdapter
extends DiagramAdapter {
    public ActivityDiagramAdapter(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider) {
        super(breakdownElementWrapperItemProvider);
    }

    public ActivityDiagramAdapter(org.eclipse.epf.uma.Activity activity) {
        super(activity);
    }

    @Override
    protected ActivityNode addNode(Collection collection, Object object) {
        org.eclipse.epf.uma.Activity activity;
        VariabilityElement variabilityElement;
        if (object instanceof org.eclipse.epf.uma.Activity && (variabilityElement = (activity = (org.eclipse.epf.uma.Activity)object).getVariabilityBasedOnElement()) != null) {
            Activity activity2 = this.getDiagram();
            ActivityNode activityNode = BridgeHelper.findNode(activity2, variabilityElement);
            if (activityNode == null) {
                activityNode = BridgeHelper.findNode(activity2, activity);
            }
            if (activityNode != null) {
                NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityNode);
                if (nodeAdapter != null) {
                    nodeAdapter.dispose();
                }
                if ((nodeAdapter = this.createNodeAdapter((MethodElement)activity)) != null) {
                    this.initializeNodeAdapter(nodeAdapter);
                    activityNode.eAdapters().add((Object)nodeAdapter);
                    nodeAdapter.updateView();
                    BridgeHelper.associate((EModelElement)activityNode, (MethodElement)activity);
                    if (BridgeHelper.isInherited((EModelElement)nodeAdapter.getView())) {
                        BridgeHelper.unmarkInHerited((EModelElement)nodeAdapter.getView());
                    }
                    nodeAdapter.setTargetReadOnly(false);
                }
                return null;
            }
        }
        return super.addNode(collection, object);
    }

    @Override
    protected NodeAdapter createNodeAdapter(MethodElement methodElement) {
        if (methodElement instanceof WorkBreakdownElement) {
            return new WorkBreakdownElementNodeAdapter(methodElement);
        }
        return null;
    }

    @Override
    protected void addToUmaModel(int n, ActivityNode activityNode) {
        MethodElement methodElement = BridgeHelper.getMethodElement((EModelElement)activityNode);
        if (methodElement == null) {
            return;
        }
        org.eclipse.epf.uma.Activity activity = (org.eclipse.epf.uma.Activity)this.getElement();
        int n2 = this.toActivityIndex(n);
        NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityNode);
        boolean bl = nodeAdapter.notificationEnabled;
        try {
            nodeAdapter.notificationEnabled = false;
            this.getActionManager().doAction(3, (EObject)activity, (EStructuralFeature)UmaPackage.Literals.ACTIVITY__BREAKDOWN_ELEMENTS, (Object)methodElement, n2);
            BridgeHelper.addEAnnotation((EModelElement)activityNode, methodElement);
        }
        finally {
            nodeAdapter.notificationEnabled = bl;
        }
        super.addToUmaModel(n, activityNode);
    }

    /*
     * Unable to fully structure code
     */
    private int toActivityIndex(int var1_1) {
        if (var1_1 == -1) {
            return var1_1;
        }
        var3_3 = var1_1 + 1;
        var2_2 = this.getNodes().size();
        if (var3_3 == var2_2) {
            return -1;
        }
        var4_4 = (ActivityNode)this.getNodes().get(var3_3);
        if (var4_4 != null) ** GOTO lbl12
        return -1;
lbl-1000:
        // 1 sources

        {
            var4_4 = (ActivityNode)this.getNodes().get(var3_3);
            ++var3_3;
lbl12:
            // 2 sources

            ** while (!(BridgeHelper.getMethodElement((EModelElement)var4_4) instanceof BreakdownElement) && var3_3 < var2_2)
        }
lbl13:
        // 1 sources

        if (var3_3 == var2_2) {
            return -1;
        }
        var5_5 = (org.eclipse.epf.uma.Activity)this.getElement();
        return var5_5.getBreakdownElements().indexOf(BridgeHelper.getMethodElement((EModelElement)var4_4));
    }

    @Override
    protected List getBreakdownElementTypes() {
        return Collections.singletonList(WorkBreakdownElement.class);
    }

    @Override
    protected ActivityNode newNode(MethodElement methodElement) {
        StructuredActivityNode structuredActivityNode = null;
        if (methodElement instanceof org.eclipse.epf.uma.Activity) {
            structuredActivityNode = UMLFactory.eINSTANCE.createStructuredActivityNode();
        } else if (methodElement instanceof TaskDescriptor || methodElement instanceof Milestone) {
            structuredActivityNode = UMLFactory.eINSTANCE.createActivityParameterNode();
        } else if (methodElement instanceof WorkBreakdownElement) {
            structuredActivityNode = UMLFactory.eINSTANCE.createStructuredActivityNode();
        }
        if (structuredActivityNode != null) {
            BridgeHelper.associate((EModelElement)structuredActivityNode, methodElement);
        }
        return structuredActivityNode;
    }

    private boolean isValid(ActivityEdge activityEdge) {
        return activityEdge.getSource() != null && activityEdge.getTarget() != null && this.getNodes().contains(activityEdge.getSource()) && this.getNodes().contains(activityEdge.getTarget());
    }

    private static boolean isValidWorkOrder(WorkOrder workOrder, Object object) {
        if (workOrder.getPred() == object) {
            return true;
        }
        if (object instanceof org.eclipse.epf.uma.Activity) {
            org.eclipse.epf.uma.Activity activity = (org.eclipse.epf.uma.Activity)object;
            VariabilityElement variabilityElement = activity.getVariabilityBasedOnElement();
            while (variabilityElement != null) {
                if (variabilityElement == workOrder.getPred()) {
                    return true;
                }
                variabilityElement = variabilityElement.getVariabilityBasedOnElement();
            }
        }
        return false;
    }

    private static boolean canReachAsFirstActivityNode(ActivityNode activityNode, ActivityNode activityNode2) {
        for (ActivityEdge activityEdge : activityNode.getOutgoings()) {
            if (activityEdge.getTarget() == activityNode2) {
                return true;
            }
            if (!(activityEdge.getTarget() instanceof ControlNode) || !ActivityDiagramAdapter.canReachAsFirstActivityNode(activityEdge.getTarget(), activityNode2)) continue;
            return true;
        }
        return false;
    }

    AdapterFactory getAdapterFactory() {
        ComposedAdapterFactory composedAdapterFactory = null;
        if (this.filter == null) {
            composedAdapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        } else if (this.filter instanceof IAdapterFactoryFilter) {
            composedAdapterFactory = (ConfigurableComposedAdapterFactory)((IAdapterFactoryFilter)this.filter).getWBSAdapterFactory();
        }
        return composedAdapterFactory;
    }

    @Override
    protected void populateLinks(List<ActivityNode> list) {
        Iterator iterator;
        ActivityEdge activityEdge2;
        ArrayList<ActivityEdge> arrayList;
        MethodElement methodElement;
        if (list.isEmpty()) {
            return;
        }
        super.populateLinks(list);
        for (ActivityNode adapterFactory2 : list) {
            WorkBreakdownElement workBreakdownElement = null;
            methodElement = BridgeHelper.getMethodElement((EModelElement)adapterFactory2);
            if (methodElement instanceof WorkBreakdownElement) {
                workBreakdownElement = (WorkBreakdownElement)methodElement;
            }
            arrayList = new ArrayList<ActivityEdge>();
            for (ActivityEdge activityEdge2 : adapterFactory2.getIncomings()) {
                if (!this.isValid(activityEdge2)) {
                    arrayList.add(activityEdge2);
                }
                if (workBreakdownElement == null || activityEdge2.getSource() != null && activityEdge2.getSource() instanceof ControlNode) continue;
                MethodElement methodElement2 = BridgeHelper.getMethodElement((EModelElement)activityEdge2.getSource());
                boolean bl = false;
                for (WorkOrder workOrder : workBreakdownElement.getLinkToPredecessor()) {
                    if (!ActivityDiagramAdapter.isValidWorkOrder(workOrder, methodElement2)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.add(activityEdge2);
            }
            activityEdge2 = arrayList.iterator();
            while (activityEdge2.hasNext()) {
                iterator = (ActivityEdge)activityEdge2.next();
                BridgeHelper.removeLink((ActivityEdge)iterator);
            }
            arrayList.clear();
            for (ActivityEdge activityEdge2 : adapterFactory2.getOutgoings()) {
                if (this.isValid(activityEdge2)) continue;
                arrayList.add(activityEdge2);
            }
            for (ActivityEdge activityEdge2 : arrayList) {
                BridgeHelper.removeLink(activityEdge2);
            }
            arrayList.clear();
            arrayList = null;
        }
        AdapterFactory adapterFactory = this.getAdapterFactory();
        for (ActivityNode activityNode : list) {
            methodElement = BridgeHelper.getMethodElement((EModelElement)activityNode);
            if (!(methodElement instanceof WorkBreakdownElement)) continue;
            arrayList = new ArrayList();
            iterator = (WorkBreakdownElement)methodElement;
            arrayList.addAll(iterator.getLinkToPredecessor());
            activityEdge2 = null;
            activityEdge2 = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)iterator, ITreeItemContentProvider.class);
            if (activityEdge2 instanceof IBSItemProvider) {
                arrayList.addAll((Collection<ActivityEdge>)((IBSItemProvider)activityEdge2).getPredecessors());
            }
            for (Object e : arrayList) {
                Object object2;
                ActivityNode activityNode2;
                WorkOrder workOrder;
                WorkOrder workOrder2 = null;
                workOrder = null;
                if (e instanceof WorkOrder) {
                    workOrder2 = (WorkOrder)e;
                    workOrder = workOrder2.getPred();
                }
                if (e instanceof WBSActivityItemProvider) {
                    workOrder = (BreakdownElement)((WBSActivityItemProvider)e).getTarget();
                }
                if (workOrder == null || !(workOrder instanceof WorkBreakdownElement) || (activityNode2 = BridgeHelper.findNode(this.getDiagram(), workOrder, true)) == null) continue;
                boolean bl = false;
                for (Object object2 : activityNode.getIncomings()) {
                    if (object2.getSource() != activityNode2) continue;
                    bl = true;
                    if (object2 != null) break;
                    BridgeHelper.setSemanticModel(object2, workOrder2);
                    break;
                }
                if (bl || ActivityDiagramAdapter.canReachAsFirstActivityNode(activityNode2, activityNode)) continue;
                NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityNode);
                object2 = BridgeHelper.getNodeAdapter((EObject)activityNode2);
                if (nodeAdapter == null || object2 == null) continue;
                boolean bl2 = nodeAdapter.notificationEnabled;
                boolean bl3 = object2.notificationEnabled;
                try {
                    nodeAdapter.notificationEnabled = false;
                    object2.notificationEnabled = false;
                    nodeAdapter.addIncomingConnection((MethodElement)workOrder);
                }
                finally {
                    nodeAdapter.notificationEnabled = bl2;
                    object2.notificationEnabled = bl3;
                }
            }
        }
        this.cleanDuplicateLinks(list);
    }

    private void cleanDuplicateLinks(List<ActivityNode> list) {
        ArrayList arrayList = new ArrayList();
        for (ActivityNode activityNode : list) {
            if (activityNode.getIncomings() != null) {
                this.findDuplicateLinks(arrayList, (List)activityNode.getIncomings());
            }
            if (activityNode.getOutgoings() == null) continue;
            this.findDuplicateLinks(arrayList, (List)activityNode.getOutgoings());
        }
        for (ActivityNode activityNode : arrayList) {
            BridgeHelper.removeLink((ActivityEdge)activityNode);
        }
        arrayList.clear();
        arrayList = null;
    }

    private void findDuplicateLinks(List list, List list2) {
        int n = 0;
        while (n < list2.size()) {
            ActivityEdge activityEdge = (ActivityEdge)list2.get(n);
            if (!list.contains(activityEdge)) {
                int n2 = n + 1;
                while (n2 < list2.size()) {
                    ActivityEdge activityEdge2 = (ActivityEdge)list2.get(n2);
                    if (activityEdge2.getSource() == activityEdge.getSource() && activityEdge2.getTarget() == activityEdge.getTarget()) {
                        list.add(activityEdge2);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    @Override
    protected Collection populateNodes() {
        HashSet hashSet = new HashSet();
        Collection collection = this.getChildren();
        hashSet.addAll(this.associateControlNodes(collection));
        hashSet.addAll(this.addElementNodes(collection));
        return hashSet;
    }

    private List associateControlNodes(Collection collection) {
        ArrayList<ActivityNode> arrayList = new ArrayList<ActivityNode>();
        for (ActivityNode activityNode : this.getDiagram().getNodes()) {
            if (!(activityNode instanceof ControlNode) || this.addNodeAdapterTo(activityNode) == null) continue;
            arrayList.add(activityNode);
        }
        return arrayList;
    }

    private List addElementNodes(Collection collection) {
        ArrayList<ActivityNode> arrayList = new ArrayList<ActivityNode>();
        ArrayList<ActivityNode> arrayList2 = new ArrayList<ActivityNode>();
        for (Object e : collection) {
            String string;
            Object object = TngUtil.unwrap(e);
            if (!(object instanceof WorkBreakdownElement)) continue;
            ActivityNode activityNode = BridgeHelper.findNode(this.getDiagram(), object);
            if (activityNode == null) {
                activityNode = this.toNode((MethodElement)object);
                arrayList2.add(activityNode);
            } else {
                string = BridgeHelper.getNodeName((MethodElement)object);
                if (!string.equals(activityNode.getName())) {
                    activityNode.setName(string);
                }
                this.addNodeAdapterTo(activityNode);
            }
            arrayList.add(activityNode);
            if (!(e instanceof BreakdownElementWrapperItemProvider) || this.isTargetReadOnly() || !(string = (BreakdownElementWrapperItemProvider)e).isReadOnly()) continue;
            NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityNode);
            nodeAdapter.wrapper = string;
            nodeAdapter.basicSetTargetReadOnly(true);
        }
        this.getNodes().addAll(arrayList2);
        return arrayList;
    }

    private ITreeItemContentProvider getAdapter() {
        Object object = null;
        object = this.wrapper != null ? this.wrapper : (ITreeItemContentProvider)this.getAdapterFactory().adapt((Notifier)this.getElement(), ITreeItemContentProvider.class);
        return object;
    }

    public Collection getChildren() {
        ITreeItemContentProvider iTreeItemContentProvider = this.getAdapter();
        if (iTreeItemContentProvider != null) {
            Object object = null;
            boolean bl = false;
            if (iTreeItemContentProvider instanceof ActivityWrapperItemProvider) {
                object = ((ActivityWrapperItemProvider)iTreeItemContentProvider).getDelegatingItemProvider();
            }
            if (iTreeItemContentProvider instanceof BSActivityItemProvider) {
                object = iTreeItemContentProvider;
            }
            if (object instanceof BSActivityItemProvider) {
                bl = ((BSActivityItemProvider)object).isEnableVariabilityInfo();
                ((BSActivityItemProvider)object).setEnableVariabilityInfo(false);
            }
            ArrayList arrayList = new ArrayList();
            this.extractChildren(iTreeItemContentProvider, this.getElement(), arrayList);
            if (object instanceof BSActivityItemProvider) {
                ((BSActivityItemProvider)object).setEnableVariabilityInfo(bl);
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    protected boolean removeNode(Object object) {
        org.eclipse.epf.uma.Activity activity;
        VariabilityElement variabilityElement;
        if (object instanceof org.eclipse.epf.uma.Activity && (variabilityElement = (activity = (org.eclipse.epf.uma.Activity)object).getVariabilityBasedOnElement()) != null) {
            Activity activity2 = this.getDiagram();
            ActivityNode activityNode = BridgeHelper.findNode(activity2, activity);
            if (activityNode == null) {
                activityNode = BridgeHelper.findNode(activity2, variabilityElement);
            }
            if (activityNode != null) {
                NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityNode);
                if (nodeAdapter != null) {
                    nodeAdapter.dispose();
                }
                if ((nodeAdapter = this.createNodeAdapter((MethodElement)variabilityElement)) != null) {
                    this.initializeNodeAdapter(nodeAdapter);
                    nodeAdapter.basicSetTargetReadOnly(true);
                    activityNode.eAdapters().add((Object)nodeAdapter);
                    nodeAdapter.updateView();
                    if (!BridgeHelper.isInherited((EModelElement)nodeAdapter.getView())) {
                        BridgeHelper.markInherited((EModelElement)nodeAdapter.getView());
                    }
                }
                return false;
            }
        }
        return super.removeNode(object);
    }

    @Override
    protected NodeAdapter addNodeAdapterTo(ActivityNode activityNode) {
        NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityNode);
        if (nodeAdapter != null) {
            return nodeAdapter;
        }
        if (activityNode instanceof ControlNode) {
            nodeAdapter = new ControlNodeAdapter();
        } else {
            Object object = BridgeHelper.getMethodElement((EModelElement)activityNode);
            if (object == null) {
                if (activityNode instanceof StructuredActivityNode) {
                    String string = BridgeHelper.getType((ActivityNode)((StructuredActivityNode)activityNode));
                    object = "Phase".equals(string) ? UmaFactory.eINSTANCE.createPhase() : ("Iteration".equals(string) ? UmaFactory.eINSTANCE.createIteration() : UmaFactory.eINSTANCE.createActivity());
                } else if (activityNode instanceof ActivityParameterNode) {
                    String string = BridgeHelper.getType((ActivityNode)((ActivityParameterNode)activityNode));
                    object = "Milestone".equals(string) ? UmaFactory.eINSTANCE.createMilestone() : UmaFactory.eINSTANCE.createTaskDescriptor();
                }
            }
            if (object != null) {
                nodeAdapter = new WorkBreakdownElementNodeAdapter((MethodElement)object);
            }
        }
        if (nodeAdapter != null) {
            this.initializeNodeAdapter(nodeAdapter);
            activityNode.eAdapters().add((Object)nodeAdapter);
            return nodeAdapter;
        }
        return null;
    }

    private ActivityNode reassociateBaseNode(org.eclipse.epf.uma.Activity activity) {
        VariabilityElement variabilityElement = activity.getVariabilityBasedOnElement();
        if (variabilityElement != null) {
            Activity activity2 = this.getDiagram();
            ActivityNode activityNode = BridgeHelper.findNode(activity2, variabilityElement);
            if (activityNode == null) {
                activityNode = BridgeHelper.findNode(activity2, activity);
            }
            if (activityNode != null) {
                NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityNode);
                if (nodeAdapter != null) {
                    nodeAdapter.dispose();
                }
                if ((nodeAdapter = this.createNodeAdapter((MethodElement)activity)) != null) {
                    this.initializeNodeAdapter(nodeAdapter);
                    activityNode.eAdapters().add((Object)nodeAdapter);
                    nodeAdapter.updateView();
                    BridgeHelper.associate((EModelElement)activityNode, (MethodElement)activity);
                    if (BridgeHelper.isInherited((EModelElement)nodeAdapter.getView())) {
                        BridgeHelper.unmarkInHerited((EModelElement)nodeAdapter.getView());
                    }
                    nodeAdapter.setTargetReadOnly(false);
                }
                return activityNode;
            }
        }
        return null;
    }

    @Override
    protected void replaceNode(Object object, Object object2) {
        Activity activity;
        ActivityNode activityNode;
        if (object2 instanceof MethodElement && (activityNode = BridgeHelper.findNode(activity = this.getDiagram(), object)) != null) {
            MethodElement methodElement;
            NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityNode);
            if (nodeAdapter != null) {
                nodeAdapter.dispose();
            }
            if ((nodeAdapter = this.createNodeAdapter(methodElement = (MethodElement)object2)) != null) {
                this.initializeNodeAdapter(nodeAdapter);
                activityNode.eAdapters().add((Object)nodeAdapter);
                nodeAdapter.updateView();
                BridgeHelper.associate((EModelElement)activityNode, methodElement);
            }
        }
    }
}

