/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.part;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.DiagramCoreResources;
import org.eclipse.epf.diagram.core.actions.AccessibilityMoveAction;
import org.eclipse.epf.diagram.core.actions.CreateElementAction;
import org.eclipse.epf.diagram.core.actions.DelegateAction;
import org.eclipse.epf.diagram.core.actions.DiagramActionsService;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.bridge.DiagramAdapter;
import org.eclipse.epf.diagram.core.part.DiagramEditorInput;
import org.eclipse.epf.diagram.core.part.DiagramEditorInputProxy;
import org.eclipse.epf.diagram.core.part.DiagramFileEditorInputProxy;
import org.eclipse.epf.diagram.core.part.IDiagramEditorInputProvider;
import org.eclipse.epf.diagram.core.part.IDiagramFileEditorInputProxy;
import org.eclipse.epf.diagram.core.part.util.DiagramEditorUtil;
import org.eclipse.epf.diagram.core.providers.DiagramContextMenuProvider;
import org.eclipse.epf.diagram.core.providers.SharedResourceDiagramDocumentProvider;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.core.services.DiagramService;
import org.eclipse.epf.diagram.core.util.DiagramConstants;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceListener;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.ProcessAuthoringConfigurator;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.ui.IMethodElementProvider;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.ui.editors.IMethodEditor;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.SelectAllAction;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.editor.FileDiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDiagramEditor
extends FileDiagramEditor
implements IGotoMarker,
IMethodEditor {
    private DiagramManager diagramMgr;
    private DiagramActionsService actionService = null;
    private long fModificationStamp;
    private org.eclipse.epf.uma.Activity activity;
    private AdapterImpl titleAdapter;
    private IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            IDocumentProvider iDocumentProvider;
            if (iResourceChangeEvent.getSource() == AbstractDiagramEditor.this.diagramMgr && (iDocumentProvider = AbstractDiagramEditor.this.getDocumentProvider()) instanceof SharedResourceDiagramDocumentProvider && !AbstractDiagramEditor.this.isDirty()) {
                ((SharedResourceDiagramDocumentProvider)iDocumentProvider).handleElementContentChanged(AbstractDiagramEditor.this.getEditorInput());
            }
        }
    };
    private ILibraryChangeListener libraryListener = new ILibraryChangeListener(){

        public void libraryChanged(int n, Collection collection) {
            switch (n) {
                case 8: {
                    if (collection == null || !collection.contains(AbstractDiagramEditor.this.currentConfig)) break;
                    MethodConfiguration methodConfiguration = ProcessAuthoringConfigurator.INSTANCE.getMethodConfiguration();
                    try {
                        ProcessAuthoringConfigurator.INSTANCE.setMethodConfiguration(AbstractDiagramEditor.this.currentConfig);
                        AbstractDiagramEditor.this.refresh();
                    }
                    finally {
                        ProcessAuthoringConfigurator.INSTANCE.setMethodConfiguration(methodConfiguration);
                    }
                }
            }
        }
    };
    private ILibraryServiceListener libSvcListener = new LibraryServiceListener(){

        public void configurationSet(MethodConfiguration methodConfiguration) {
            AbstractDiagramEditor.this.configChanged();
        }
    };
    private MethodConfiguration currentConfig;
    private boolean needRefresh;
    private DiagramService diagramSvc;

    public AbstractDiagramEditor() {
        super(true);
    }

    public AbstractDiagramEditor(boolean bl) {
        super(bl);
    }

    protected String getEditingDomainID() {
        return "org.eclipse.epf.diagram.EditingDomain";
    }

    protected DiagramManager getDiagramManager() {
        if (this.diagramMgr == null) {
            Process process = TngUtil.getOwningProcess((BreakdownElement)this.activity);
            this.diagramMgr = DiagramManager.getInstance(process, (Object)this);
            this.diagramMgr.addResourceChangeListener(this.resourceChangeListener);
        }
        return this.diagramMgr;
    }

    protected DiagramService getDiagramService() {
        if (this.diagramSvc == null) {
            this.diagramSvc = new DiagramService();
        }
        return this.diagramSvc;
    }

    protected TransactionalEditingDomain createEditingDomain() {
        InternalTransactionalEditingDomain internalTransactionalEditingDomain = this.getDiagramManager().getEditingDomain();
        internalTransactionalEditingDomain.setID(this.getEditingDomainID());
        return internalTransactionalEditingDomain;
    }

    protected void setDocumentProvider(IEditorInput iEditorInput) {
        this.setDocumentProvider((IDocumentProvider)new SharedResourceDiagramDocumentProvider(this.getDiagramManager()){

            protected void doSynchronize(Object object, IProgressMonitor iProgressMonitor) throws CoreException {
                DiagramManager diagramManager = AbstractDiagramEditor.this.getDiagramManager();
                try {
                    try {
                        diagramManager.removeResourceChangeListener(AbstractDiagramEditor.this.resourceChangeListener);
                        diagramManager.reload();
                    }
                    catch (IOException iOException) {
                        throw new CoreException((IStatus)new Status(4, DiagramCorePlugin.getPluginId(), 0, "Error reloading diagram", (Throwable)iOException));
                    }
                }
                finally {
                    diagramManager.addResourceChangeListener(AbstractDiagramEditor.this.resourceChangeListener);
                }
                super.doSynchronize(object, iProgressMonitor);
            }
        });
    }

    public void doSetInput(IEditorInput iEditorInput, boolean bl) throws CoreException {
        this.activity = (org.eclipse.epf.uma.Activity)AbstractDiagramEditor.getMethodElement(iEditorInput);
        DiagramEditorInputProxy diagramEditorInputProxy = null;
        if (iEditorInput instanceof DiagramEditorInputProxy) {
            diagramEditorInputProxy = (DiagramEditorInputProxy)iEditorInput;
            diagramEditorInputProxy.setTransactionalEditingDomain(this.createEditingDomain());
        }
        super.doSetInput(iEditorInput, bl);
        if (this.isEditable() && diagramEditorInputProxy != null && !diagramEditorInputProxy.isNewDiagram()) {
            this.getDiagramManager().backupDiagram(this.activity, this.getDiagram());
        }
        this.initializeTitle(iEditorInput);
    }

    private void initializeTitle(IEditorInput iEditorInput) {
        DiagramFileEditorInputProxy diagramFileEditorInputProxy;
        DiagramEditorInput diagramEditorInput;
        MethodElement methodElement;
        String string = "";
        if (iEditorInput != null && (methodElement = (diagramEditorInput = (diagramFileEditorInputProxy = (DiagramFileEditorInputProxy)iEditorInput).getDiagramEditorInput()).getMethodElement()) != null) {
            string = String.valueOf(this.getPartNamePrefix()) + methodElement.getName() + "," + " " + diagramEditorInput.getSuppression().getProcess().getName();
            Image image = this.getPartImage();
            this.setTitleImage(image);
        }
        this.setPartName(string);
        this.firePropertyChange(257);
    }

    protected void sanityCheckState(IEditorInput iEditorInput) {
        IDocumentProvider iDocumentProvider = this.getDocumentProvider();
        if (iDocumentProvider == null) {
            return;
        }
        long l = iDocumentProvider.getModificationStamp((Object)iEditorInput);
        if (l != this.fModificationStamp) {
            this.fModificationStamp = l;
            if (!iDocumentProvider.isSynchronized((Object)iEditorInput)) {
                this.handleEditorInputChanged();
                if (!iDocumentProvider.isSynchronized((Object)iEditorInput) && iDocumentProvider instanceof SharedResourceDiagramDocumentProvider) {
                    ((SharedResourceDiagramDocumentProvider)iDocumentProvider).allowEditing(iEditorInput);
                }
            }
        }
        this.updateState(this.getEditorInput());
    }

    public void dispose() {
        DiagramEditPart diagramEditPart;
        IEditorInput iEditorInput;
        MethodElement methodElement;
        Diagram diagram = this.getDiagram();
        if (this.isDirty()) {
            this.reverseToSaved();
        }
        if (this.titleAdapter != null) {
            methodElement = AbstractDiagramEditor.getMethodElement(this.getEditorInput());
            if (methodElement != null) {
                methodElement.eAdapters().remove((Object)this.titleAdapter);
            }
            this.titleAdapter = null;
        }
        if (this.diagramMgr != null) {
            if (this.activity != null && diagram != null) {
                this.diagramMgr.removeDiagramBackup(this.activity, diagram.getType());
            }
            this.diagramMgr.removeResourceChangeListener(this.resourceChangeListener);
            this.diagramMgr.removeConsumer((Object)this);
        }
        if (this.diagramSvc != null) {
            this.diagramSvc.dispose();
        }
        if ((methodElement = LibraryService.getInstance().getCurrentLibraryManager()) != null) {
            methodElement.removeListener(this.libraryListener);
        }
        LibraryService.getInstance().removeListener(this.libSvcListener);
        if (this.getDiagram().getElement() instanceof Activity && (iEditorInput = (Activity)this.getDiagram().getElement()) != null && this.getDiagramAdapter() != null) {
            iEditorInput.eAdapters().remove((Object)this.getDiagramAdapter());
        }
        if ((iEditorInput = this.getEditorInput()) instanceof IDisposable) {
            ((IDisposable)iEditorInput).dispose();
        }
        if ((diagramEditPart = this.getDiagramEditPart()) != null) {
            diagramEditPart.setModel(null);
        }
        super.dispose();
    }

    private DiagramAdapter getDiagramAdapter() {
        View view = (View)this.getDiagramEditPart().getModel();
        return view != null ? (DiagramAdapter)BridgeHelper.getNodeAdapter(view.getElement()) : null;
    }

    private void reverseToSaved() {
        block9: {
            try {
                MethodElement methodElement;
                boolean bl;
                DiagramAdapter diagramAdapter;
                IDocumentProvider iDocumentProvider = this.getDocumentProvider();
                if (iDocumentProvider instanceof SharedResourceDiagramDocumentProvider) {
                    ((SharedResourceDiagramDocumentProvider)iDocumentProvider).reverseToSaved(this.getEditorInput());
                }
                if ((diagramAdapter = this.getDiagramAdapter()) == null) {
                    return;
                }
                IActionManager iActionManager = diagramAdapter.getActionManager();
                boolean bl2 = iActionManager.isSaveNeeded();
                if (bl2) {
                    iActionManager.undoAll();
                }
                this.getActionManager().clear();
                boolean bl3 = bl = bl2 && this.getLastModified() > diagramAdapter.getUmaLastModified();
                if (!bl || (methodElement = this.getMethodElementFromInput()) == null) break block9;
                ILibraryPersister.FailSafeMethodLibraryPersister failSafeMethodLibraryPersister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
                try {
                    failSafeMethodLibraryPersister.save(methodElement.eResource());
                    failSafeMethodLibraryPersister.commit();
                }
                catch (Exception exception) {
                    CommonPlugin.getDefault().getLogger().logError((Throwable)exception);
                    try {
                        failSafeMethodLibraryPersister.rollback();
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                }
            }
            catch (Exception exception) {
                CommonPlugin.getDefault().getLogger().logError((Throwable)exception);
                exception.printStackTrace();
            }
        }
    }

    private Process getProcess() {
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof IDiagramFileEditorInputProxy) {
            return ((IDiagramFileEditorInputProxy)iEditorInput).getDiagramEditorInput().getSuppression().getProcess();
        }
        return null;
    }

    protected MethodElement getMethodElementFromInput() {
        return AbstractDiagramEditor.getMethodElement(this.getEditorInput());
    }

    private static MethodElement getMethodElement(IEditorInput iEditorInput) {
        if (iEditorInput instanceof DiagramFileEditorInputProxy) {
            return ((DiagramFileEditorInputProxy)iEditorInput).getDiagramEditorInput().getMethodElement();
        }
        return null;
    }

    private long getLastModified() {
        Resource resource = this.getMethodElementFromInput().eResource();
        if (resource != null && resource.getURI().isFile()) {
            File file = new File(resource.getURI().toFileString());
            return file.lastModified();
        }
        return -1L;
    }

    /*
     * Unable to fully structure code
     */
    public void doSave(IProgressMonitor var1_1) {
        var2_2 = this.getDiagramAdapter();
        if (var2_2 != null && (var3_3 = this.getDiagramAdapter().getActionManager()) != null && var3_3.isSaveNeeded()) {
            try {
                var1_1.beginTask("Saving", -1);
                var4_4 = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
                try {
                    for (Resource var6_7 : var3_3.getModifiedResources()) {
                        var1_1.setTaskName(NLS.bind((String)DiagramCoreResources.Progress_Saving_message, (Object)(var6_7.getURI().isFile() != false ? var6_7.getURI().toFileString() : "")));
                        var4_4.save(var6_7);
                    }
                    var4_4.commit();
                    var3_3.saveIsDone();
                }
                catch (Exception var5_6) {
                    CommonPlugin.getDefault().getLogger().logError((Throwable)var5_6);
                    try {
                        var4_4.rollback();
                    }
                    catch (Exception var6_8) {
                        CommonPlugin.getDefault().getLogger().logError((Throwable)var6_8);
lbl21:
                        // 2 sources

                        while (true) {
                            var1_1.done();
                            return;
                        }
                    }
                    CommonPlugin.getDefault().getMsgDialog().displayWarning(this.getSite().getShell().getText(), DiagramCoreResources.Warning_Saving_Diagram, var5_6.getMessage(), (Throwable)var5_6);
                    ** continue;
                }
            }
            finally {
                var1_1.done();
            }
        }
        super.doSave(var1_1);
    }

    protected ScrollingGraphicalViewer createScrollingGraphicalViewer() {
        return new DiagramGraphicalViewerEx();
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.currentConfig = LibraryService.getInstance().getCurrentMethodConfiguration();
        LibraryService.getInstance().addListener(this.libSvcListener);
        ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
        if (iLibraryManager != null) {
            iLibraryManager.addListener(this.libraryListener);
        }
        this.getGraphicalControl().addListener(8, new Listener(){

            public void handleEvent(Event event) {
                AbstractDiagramEditor.this.handleDoubleClick(event);
            }
        });
        IDiagramGraphicalViewer iDiagramGraphicalViewer = this.getDiagramGraphicalViewer();
        DiagramContextMenuProvider diagramContextMenuProvider = new DiagramContextMenuProvider((IWorkbenchPart)this, (EditPartViewer)this.getDiagramGraphicalViewer());
        iDiagramGraphicalViewer.setContextMenu((MenuManager)diagramContextMenuProvider);
        this.getSite().registerContextMenu("org.eclipse.gmf.runtime.diagram.ui.DiagramEditorContextMenu", (MenuManager)diagramContextMenuProvider, (ISelectionProvider)iDiagramGraphicalViewer);
        if (this.actionService != null) {
            this.actionService.setGraphicalViewer((GraphicalViewer)iDiagramGraphicalViewer);
        }
        this.titleAdapter = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                switch (notification.getFeatureID(MethodElement.class)) {
                    case 0: {
                        AbstractDiagramEditor.this.initializeTitle(AbstractDiagramEditor.this.getEditorInput());
                    }
                }
            }
        };
        MethodElement methodElement = AbstractDiagramEditor.getMethodElement(this.getEditorInput());
        if (methodElement != null && this.titleAdapter != null) {
            methodElement.eAdapters().add((Object)this.titleAdapter);
        }
    }

    private void configChanged() {
        MethodConfiguration methodConfiguration = LibraryService.getInstance().getCurrentMethodConfiguration();
        if (this.currentConfig != methodConfiguration) {
            MethodElement methodElement;
            IEditorInput iEditorInput;
            boolean bl;
            IWorkbenchPart iWorkbenchPart = this.getSite().getWorkbenchWindow().getPartService().getActivePart();
            boolean bl2 = bl = iWorkbenchPart == this;
            if (!bl && iWorkbenchPart instanceof IEditorPart && (iEditorInput = ((IEditorPart)iWorkbenchPart).getEditorInput()) instanceof IMethodElementProvider && (methodElement = ((IMethodElementProvider)iEditorInput).getMethodElement()) instanceof ProcessComponent) {
                boolean bl3 = bl = methodElement instanceof ProcessComponent && this.getProcess() == ((ProcessComponent)methodElement).getProcess();
            }
            if (bl) {
                this.currentConfig = methodConfiguration;
                this.refresh();
                this.needRefresh = false;
            } else {
                this.needRefresh = true;
            }
        }
    }

    public void refresh() {
        if (this.getDocumentProvider() instanceof SharedResourceDiagramDocumentProvider) {
            SharedResourceDiagramDocumentProvider sharedResourceDiagramDocumentProvider = (SharedResourceDiagramDocumentProvider)this.getDocumentProvider();
            DiagramEditPart diagramEditPart = this.getDiagramEditPart();
            boolean bl = this.isDirty();
            boolean bl2 = false;
            IEditorPart iEditorPart = null;
            boolean bl3 = DiagramEditorUtil.isInherited((EditPart)diagramEditPart);
            if (bl3) {
                MethodElement methodElement = BridgeHelper.getMethodElement((View)diagramEditPart.getDiagramView());
                String string = diagramEditPart.getDiagramView().getType();
                IEditorReference[] iEditorReferenceArray = this.getSite().getPage().getEditorReferences();
                int n = 0;
                while (n < iEditorReferenceArray.length) {
                    IEditorReference iEditorReference = iEditorReferenceArray[n];
                    try {
                        IEditorPart iEditorPart2;
                        DiagramEditorInput diagramEditorInput;
                        if (iEditorReference.getEditorInput() instanceof IDiagramFileEditorInputProxy && (diagramEditorInput = ((IDiagramFileEditorInputProxy)iEditorReference.getEditorInput()).getDiagramEditorInput()).getWrapper() == null && diagramEditorInput.getMethodElement() == methodElement && DiagramManager.getDiagramType(string) == diagramEditorInput.getDiagramType() && (iEditorPart2 = iEditorReference.getEditor(false)) != null) {
                            bl2 = iEditorPart2.isDirty();
                            iEditorPart = iEditorPart2;
                            break;
                        }
                    }
                    catch (PartInitException partInitException) {
                        DiagramCorePlugin.getDefault().getLogger().logError((Throwable)partInitException);
                    }
                    ++n;
                }
            }
            sharedResourceDiagramDocumentProvider.setContent(this.getEditorInput());
            if (bl) {
                sharedResourceDiagramDocumentProvider.setCanSaveDocument(this.getEditorInput());
            } else if (this.isDirty()) {
                ((SharedResourceDiagramDocumentProvider)this.getDocumentProvider()).markDocumentAsSaved((IFileEditorInput)this.getEditorInput());
            }
            if (iEditorPart != null && !bl2) {
                ((SharedResourceDiagramDocumentProvider)((DiagramDocumentEditor)iEditorPart).getDocumentProvider()).markDocumentAsSaved((IFileEditorInput)iEditorPart.getEditorInput());
            }
            this.updateState(this.getEditorInput());
        }
    }

    protected void handleDoubleClick(Event event) {
    }

    public boolean isDirty() {
        if (!DiagramEditorUtil.isModifiable(this.getEditorInput())) {
            return false;
        }
        return super.isDirty();
    }

    public boolean isEditable() {
        if (this.getDocumentProvider() instanceof SharedResourceDiagramDocumentProvider) {
            return !((SharedResourceDiagramDocumentProvider)this.getDocumentProvider()).getLockedState();
        }
        return true;
    }

    protected KeyHandler getKeyHandler() {
        KeyHandler keyHandler = super.getKeyHandler();
        if (keyHandler != null) {
            ActionRegistry actionRegistry = this.getActionRegistry();
            Object object = actionRegistry.getAction((Object)ActionFactory.DELETE.getId());
            if (object != null && !(object instanceof DelegateAction)) {
                this.getActionRegistry().removeAction(object);
                this.getSelectionActions().remove(object);
                object = new DelegateAction((IWorkbenchPart)this, ActionFactory.DELETE.getId());
                object.setId(ActionFactory.DELETE.getId());
                this.getActionRegistry().registerAction(object);
                this.getSelectionActions().add(object.getId());
            }
            keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            keyHandler.put(KeyStroke.getPressed((char)'\b', (int)8, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            keyHandler.put(KeyStroke.getPressed((char)'\u0004', (int)100, (int)262144), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.getActionRegistry().registerAction((IAction)new AccessibilityMoveAction((IWorkbenchPart)this, 4));
            AccessibilityMoveAction accessibilityMoveAction = (AccessibilityMoveAction)this.getActionRegistry().getAction((Object)"move_down_action");
            keyHandler.put(KeyStroke.getPressed((int)0x1000002, (int)262144), (IAction)accessibilityMoveAction);
            this.getActionRegistry().registerAction((IAction)new AccessibilityMoveAction((IWorkbenchPart)this, 1));
            accessibilityMoveAction = (AccessibilityMoveAction)this.getActionRegistry().getAction((Object)"move_up_action");
            keyHandler.put(KeyStroke.getPressed((int)0x1000001, (int)262144), (IAction)accessibilityMoveAction);
            this.getActionRegistry().registerAction((IAction)new AccessibilityMoveAction((IWorkbenchPart)this, 8));
            accessibilityMoveAction = (AccessibilityMoveAction)this.getActionRegistry().getAction((Object)"move_left_action");
            keyHandler.put(KeyStroke.getPressed((int)0x1000003, (int)262144), (IAction)accessibilityMoveAction);
            this.getActionRegistry().registerAction((IAction)new AccessibilityMoveAction((IWorkbenchPart)this, 16));
            accessibilityMoveAction = (AccessibilityMoveAction)this.getActionRegistry().getAction((Object)"move_right_action");
            keyHandler.put(KeyStroke.getPressed((int)0x1000004, (int)262144), (IAction)accessibilityMoveAction);
            object = SelectAllAction.createSelectAllAction((IWorkbenchPage)this.getEditorSite().getWorkbenchWindow().getActivePage());
            this.getActionRegistry().registerAction(object);
            this.getSelectionActions().add(object.getId());
            keyHandler.put(KeyStroke.getReleased((char)'\u0001', (int)97, (int)262144), object);
            keyHandler.put(KeyStroke.getReleased((char)'\u0001', (int)97, (int)262144), object);
        }
        return keyHandler;
    }

    protected void createActions() {
        super.createActions();
        this.createControlFlowAction();
        this.actionService = new DiagramActionsService(this.getDiagramManager().getEditingDomain(), this.getGraphicalViewer(), this.getEditDomain(), this.getActionRegistry());
        this.actionService.registerHorizontalAlignAverageAction();
        this.actionService.registerHorizontalAlignFirstSelectedAction();
        this.actionService.registerVerticalAlignAverageAction();
        this.actionService.registerVerticalAlignFirstSelectedAction();
    }

    protected IAction createAnAction(String string, List<IElementType> list, String string2, String string3, ImageDescriptor imageDescriptor) {
        CreateElementAction createElementAction = new CreateElementAction((IWorkbenchPart)this, string);
        createElementAction.setElementTypes(list);
        createElementAction.setPreferenceHint(this.getPreferencesHint());
        createElementAction.setImageDescriptor(imageDescriptor);
        createElementAction.setToolTipText(string3);
        createElementAction.setId(string2);
        return createElementAction;
    }

    public void contributeToContextMenu(IMenuManager iMenuManager) {
        if (this.actionService != null) {
            this.actionService.createAlignMenu(iMenuManager, this.isEditable());
        }
        this.addToMenu(iMenuManager, "create_diagram_link", "additions", true, true);
    }

    protected void addToMenu(IMenuManager iMenuManager, String string, String string2, boolean bl, boolean bl2) {
        boolean bl3 = this.isEditable();
        if (string != null) {
            IAction iAction = this.getActionRegistry().getAction((Object)string);
            if (iAction != null && iAction.isEnabled() && bl3) {
                if (bl2) {
                    iMenuManager.appendToGroup(string2, iAction);
                } else {
                    iMenuManager.prependToGroup(string2, iAction);
                }
                if (bl) {
                    iMenuManager.insertAfter(string, (IContributionItem)new Separator());
                }
            }
        } else if (bl && bl3) {
            if (bl2) {
                iMenuManager.appendToGroup(string2, (IContributionItem)new Separator());
            } else {
                iMenuManager.prependToGroup(string2, (IContributionItem)new Separator());
            }
        }
    }

    public void resetLayout() {
    }

    public void refreshDiagram() {
        this.refresh();
    }

    protected abstract String getPartNamePrefix();

    protected abstract Image getPartImage();

    private void createControlFlowAction() {
        Action action = new Action(DiagramCoreResources.ActivityDiagram_Palette_control_flow_create_text){

            public void run() {
                List list = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                if (list.size() == 2) {
                    EditPart editPart = (EditPart)list.get(0);
                    EditPart editPart2 = (EditPart)list.get(1);
                    View view = (View)editPart.getModel();
                    View view2 = (View)editPart2.getModel();
                    if (BridgeHelper.isReadOnly(view) || BridgeHelper.isReadOnly(view2)) {
                        return;
                    }
                    CreateUnspecifiedTypeConnectionRequest createUnspecifiedTypeConnectionRequest = AbstractDiagramEditor.this.getCreateControlFlowRequest();
                    if (createUnspecifiedTypeConnectionRequest != null) {
                        Command command;
                        createUnspecifiedTypeConnectionRequest.setSourceEditPart(null);
                        createUnspecifiedTypeConnectionRequest.setTargetEditPart(editPart2);
                        createUnspecifiedTypeConnectionRequest.setType((Object)"connection start");
                        createUnspecifiedTypeConnectionRequest.setLocation(new Point(0, 0));
                        editPart.getCommand((Request)createUnspecifiedTypeConnectionRequest);
                        createUnspecifiedTypeConnectionRequest.setSourceEditPart(editPart);
                        createUnspecifiedTypeConnectionRequest.setTargetEditPart(editPart2);
                        createUnspecifiedTypeConnectionRequest.setType((Object)"connection end");
                        createUnspecifiedTypeConnectionRequest.setLocation(new Point(0, 0));
                        DiagramEditPart diagramEditPart = AbstractDiagramEditor.this.getDiagramEditPart();
                        if (diagramEditPart.isEditModeEnabled() && (command = editPart2.getCommand((Request)createUnspecifiedTypeConnectionRequest)) != null && command.canExecute()) {
                            command.execute();
                        }
                    }
                }
            }

            public boolean isEnabled() {
                if (AbstractDiagramEditor.this.getCreateControlFlowRequest() == null) {
                    return false;
                }
                List list = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                if (list.size() == 2) {
                    EditPart editPart = (EditPart)list.get(0);
                    EditPart editPart2 = (EditPart)list.get(1);
                    View view = (View)editPart.getModel();
                    View view2 = (View)editPart2.getModel();
                    if (BridgeHelper.isReadOnly(view) || BridgeHelper.isReadOnly(view2)) {
                        return false;
                    }
                    for (Edge edge : AbstractDiagramEditor.this.getDiagram().getEdges()) {
                        if (edge.getSource() != view || edge.getTarget() != view2) continue;
                        return false;
                    }
                    if (view.getElement() instanceof ActivityNode | view.getElement() instanceof NamedNode || view2.getElement() instanceof ActivityNode || view2.getElement() instanceof NamedNode) {
                        return true;
                    }
                }
                return false;
            }

            public String getId() {
                return "create_diagram_link";
            }

            public ImageDescriptor getImageDescriptor() {
                return DiagramConstants.CONTROL_FLOW_IMAGE_DESCRIPTOR;
            }
        };
        this.getActionRegistry().registerAction((IAction)action);
    }

    protected CreateUnspecifiedTypeConnectionRequest getCreateControlFlowRequest() {
        return null;
    }

    protected Diagram getDiagram(org.eclipse.epf.uma.Activity activity, int n) {
        return this.getDiagramService().getDiagram(activity, n);
    }

    private class DiagramGraphicalViewerEx
    extends DiagramGraphicalViewer
    implements IDiagramEditorInputProvider {
        private DiagramGraphicalViewerEx() {
        }

        public DiagramEditorInput getDiagramEditorInput() {
            return ((IDiagramFileEditorInputProxy)AbstractDiagramEditor.this.getEditorInput()).getDiagramEditorInput();
        }

        public IEditorPart getEditor() {
            return AbstractDiagramEditor.this;
        }
    }
}

