/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.util;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.diagram.core.DiagramCoreResources;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.bridge.NodeAdapter;
import org.eclipse.epf.diagram.core.services.DiagramHelper;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.ActivityDiagram;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.RoleNode;
import org.eclipse.epf.diagram.model.TaskNode;
import org.eclipse.epf.diagram.model.TypedNode;
import org.eclipse.epf.diagram.model.WorkBreakdownElementNode;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ControlNode;
import org.eclipse.uml2.uml.FinalNode;
import org.eclipse.uml2.uml.ForkNode;
import org.eclipse.uml2.uml.InitialNode;
import org.eclipse.uml2.uml.JoinNode;

public class DiagramCoreValidation {
    private static final String errMsg_CanNotConnect = DiagramCoreResources.DiagramValidation_err_cannot_connect_text;
    private static final String errMsg_SamePredAndSucc = DiagramCoreResources.DiagramValidation_err_samepredandsuc_text;
    private static final String errMsg_CanNotDelete = DiagramCoreResources.DiagramValidation_err_cannot_delete_text;

    public static String isTargetReadonly(EditPart editPart) {
        View view = (View)editPart.getModel();
        if (BridgeHelper.isReadOnly(view)) {
            return errMsg_CanNotConnect;
        }
        return null;
    }

    public static String canConnect(EditPart editPart, EObject eObject, EObject eObject2) {
        if (editPart == null) {
            return errMsg_CanNotConnect;
        }
        EditPart editPart2 = editPart.getParent();
        Diagram diagram = null;
        while (editPart2 != null && !(editPart2 instanceof DiagramEditPart)) {
            editPart2 = editPart2.getParent();
        }
        if (editPart2 instanceof DiagramEditPart) {
            diagram = (Diagram)((DiagramEditPart)editPart2).getModel();
        }
        if (diagram == null) {
            return errMsg_CanNotConnect;
        }
        return DiagramCoreValidation.checkConnect(diagram, eObject, eObject2);
    }

    public static String checkConnect(Diagram diagram, EObject eObject, EObject eObject2) {
        switch (DiagramHelper.getDiagramType(diagram)) {
            case 0: {
                Object object;
                if (DiagramCoreValidation.alwaysAllowed(eObject, eObject2)) {
                    return null;
                }
                if (BridgeHelper.isReadOnly((View)diagram)) {
                    return errMsg_CanNotConnect;
                }
                NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter(eObject);
                NodeAdapter nodeAdapter2 = BridgeHelper.getNodeAdapter(eObject2);
                if (nodeAdapter == null || nodeAdapter2 == null) {
                    return errMsg_CanNotConnect;
                }
                Diagram diagram2 = nodeAdapter.getView().getDiagram();
                if (!diagram.equals(diagram2)) {
                    return errMsg_CanNotConnect;
                }
                ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
                Adapter adapter = composedAdapterFactory.adapt((Notifier)BridgeHelper.getMethodElement((View)diagram2), ITreeItemContentProvider.class);
                Object object2 = null;
                if (adapter instanceof IBSItemProvider) {
                    object2 = ((IBSItemProvider)adapter).getTopItem();
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                AdapterFactoryTreeIterator adapterFactoryTreeIterator = new AdapterFactoryTreeIterator((AdapterFactory)composedAdapterFactory, object2);
                while (adapterFactoryTreeIterator.hasNext()) {
                    object = adapterFactoryTreeIterator.next();
                    arrayList.add(TngUtil.unwrap(object));
                }
                if (object2 == null) break;
                adapterFactoryTreeIterator = nodeAdapter.getElement();
                object = null;
                if (nodeAdapter2 != null) {
                    object = nodeAdapter2.getElement();
                }
                if (adapterFactoryTreeIterator instanceof WorkBreakdownElement) {
                    if (object instanceof WorkBreakdownElement) {
                        if (ProcessUtil.checkCircular((WorkBreakdownElement)((WorkBreakdownElement)object), (WorkBreakdownElement)((WorkBreakdownElement)adapterFactoryTreeIterator), arrayList)) {
                            return errMsg_SamePredAndSucc;
                        }
                        if (!nodeAdapter2.isTargetReadOnly()) break;
                        return errMsg_CanNotConnect;
                    }
                    ArrayList<ActivityNode> arrayList2 = new ArrayList<ActivityNode>();
                    BridgeHelper.getSuccessorNodes(arrayList2, (ActivityNode)eObject2);
                    for (ActivityNode activityNode : arrayList2) {
                        if (BridgeHelper.getNodeAdapter((EObject)activityNode).isTargetReadOnly()) {
                            return errMsg_CanNotConnect;
                        }
                        if (!ProcessUtil.checkCircular((WorkBreakdownElement)((WorkBreakdownElement)BridgeHelper.getMethodElement((EModelElement)activityNode)), (WorkBreakdownElement)((WorkBreakdownElement)adapterFactoryTreeIterator), arrayList)) continue;
                        return errMsg_SamePredAndSucc;
                    }
                } else if (object instanceof WorkBreakdownElement) {
                    ArrayList<ActivityNode> arrayList3 = new ArrayList<ActivityNode>();
                    BridgeHelper.getPredecessorNodes(arrayList3, (ActivityNode)eObject);
                    if (arrayList3.isEmpty()) break;
                    if (nodeAdapter2.isTargetReadOnly()) {
                        return errMsg_CanNotConnect;
                    }
                    for (ActivityNode activityNode : arrayList3) {
                        MethodElement methodElement = BridgeHelper.getMethodElement((EModelElement)activityNode);
                        if (!ProcessUtil.checkCircular((WorkBreakdownElement)((WorkBreakdownElement)object), (WorkBreakdownElement)((WorkBreakdownElement)methodElement), arrayList)) continue;
                        return errMsg_SamePredAndSucc;
                    }
                } else {
                    if (DiagramCoreValidation.checkSyncBarCircularLooop((ActivityNode)eObject, (ActivityNode)eObject2) != null) {
                        return errMsg_CanNotConnect;
                    }
                    if (eObject2 instanceof InitialNode) {
                        return errMsg_CanNotConnect;
                    }
                    ArrayList<ActivityNode> arrayList4 = new ArrayList<ActivityNode>();
                    BridgeHelper.getPredecessorNodes(arrayList4, (ActivityNode)eObject);
                    if (arrayList4.isEmpty()) break;
                    ArrayList<ActivityNode> arrayList5 = new ArrayList<ActivityNode>();
                    BridgeHelper.getSuccessorNodes(arrayList5, (ActivityNode)object);
                    for (ActivityNode activityNode : arrayList5) {
                        NodeAdapter nodeAdapter3 = BridgeHelper.getNodeAdapter((EObject)activityNode);
                        if (nodeAdapter3.isTargetReadOnly()) {
                            return errMsg_CanNotConnect;
                        }
                        WorkBreakdownElement workBreakdownElement = (WorkBreakdownElement)nodeAdapter3.getElement();
                        for (ActivityNode activityNode2 : arrayList4) {
                            NodeAdapter nodeAdapter4 = BridgeHelper.getNodeAdapter((EObject)activityNode2);
                            WorkBreakdownElement workBreakdownElement2 = (WorkBreakdownElement)nodeAdapter4.getElement();
                            if (!ProcessUtil.checkCircular((WorkBreakdownElement)workBreakdownElement, (WorkBreakdownElement)workBreakdownElement2, arrayList)) continue;
                            return errMsg_SamePredAndSucc;
                        }
                    }
                }
                break;
            }
        }
        return null;
    }

    public static String checkSyncBarCircularLooop(ActivityNode activityNode, ActivityNode activityNode2) {
        EList eList = activityNode2.getOutgoings();
        if (!eList.isEmpty() && eList.size() > 0) {
            for (ActivityEdge activityEdge : eList) {
                ActivityNode activityNode3 = activityEdge.getTarget();
                if (activityNode.equals(activityNode3)) {
                    return errMsg_CanNotConnect;
                }
                if (!(activityNode3 instanceof ControlNode)) continue;
                return DiagramCoreValidation.checkSyncBarCircularLooop(activityNode, (ActivityNode)((ControlNode)activityNode3));
            }
        }
        return null;
    }

    public static String checkSyncBarIncomingLinks(ActivityNode activityNode) {
        for (ActivityEdge activityEdge : activityNode.getIncomings()) {
            ActivityNode activityNode2 = activityEdge.getSource();
            NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityNode2);
            if (nodeAdapter == null || !(nodeAdapter.getElement() instanceof WorkBreakdownElement ? nodeAdapter.isTargetReadOnly() : activityNode2 instanceof ControlNode && (activityNode2 instanceof ForkNode || activityNode2 instanceof JoinNode) && DiagramCoreValidation.checkSyncBarIncomingLinks(activityNode2) != null)) continue;
            return errMsg_CanNotDelete;
        }
        return null;
    }

    public static String checkSyncBarOutgoingLinks(ActivityNode activityNode) {
        for (ActivityEdge activityEdge : activityNode.getOutgoings()) {
            ActivityNode activityNode2 = activityEdge.getTarget();
            NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityNode2);
            if (nodeAdapter == null || !(nodeAdapter.getElement() instanceof WorkBreakdownElement ? nodeAdapter.isTargetReadOnly() : activityNode2 instanceof ControlNode && (activityNode2 instanceof ForkNode || activityNode2 instanceof JoinNode) && DiagramCoreValidation.checkSyncBarOutgoingLinks(activityNode2) != null)) continue;
            return errMsg_CanNotDelete;
        }
        return null;
    }

    public static String checkDelete(org.eclipse.gmf.runtime.notation.Node node) {
        if (BridgeHelper.isReadOnly((View)node)) {
            return errMsg_CanNotDelete;
        }
        Diagram diagram = node.getDiagram();
        if (diagram instanceof ActivityDiagram) {
            if (node.getElement() instanceof ControlNode) {
                ArrayList<ActivityNode> arrayList = new ArrayList<ActivityNode>();
                BridgeHelper.getSuccessorNodes(arrayList, (ActivityNode)node.getElement());
                for (ActivityNode activityNode : arrayList) {
                    NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityNode);
                    if (nodeAdapter == null || !nodeAdapter.isTargetReadOnly()) continue;
                    return errMsg_CanNotDelete;
                }
            }
        } else if (diagram instanceof ActivityDetailDiagram && node.getElement() instanceof RoleNode) {
            return errMsg_CanNotDelete;
        }
        return null;
    }

    public static String checkReconnect(org.eclipse.gmf.runtime.notation.Node node, org.eclipse.gmf.runtime.notation.Node node2, Edge edge) {
        if (node.getDiagram() instanceof ActivityDiagram && edge.getTarget() != null) {
            if (BridgeHelper.isReadOnly(edge.getTarget())) {
                return errMsg_CanNotConnect;
            }
            if (edge.getTarget() instanceof TypedNode) {
                Collection collection = GraphicalDataHelper.getTargetNodes((TypedNode)((TypedNode)edge.getTarget()), WorkBreakdownElementNode.class);
                for (org.eclipse.gmf.runtime.notation.Node node3 : collection) {
                    if (!BridgeHelper.isReadOnly((View)node3)) continue;
                    return errMsg_CanNotConnect;
                }
            }
        }
        return DiagramCoreValidation.checkConnect(node, node2, edge);
    }

    public static String checkConnect(org.eclipse.gmf.runtime.notation.Node node, org.eclipse.gmf.runtime.notation.Node node2, Edge edge) {
        if (node == node2 && !(BridgeHelper.getMethodElement((View)node) instanceof org.eclipse.epf.uma.Activity)) {
            return errMsg_CanNotConnect;
        }
        EList eList = node.getTargetEdges();
        if (eList != null) {
            if (eList.contains(edge) && edge.getTarget().equals(node2)) {
                return null;
            }
            for (Link link : eList) {
                Node node3 = link.getTarget();
                if (node3 == null || !node3.equals(node2)) continue;
                return errMsg_CanNotConnect;
            }
        }
        return DiagramCoreValidation.checkConnect(node.getDiagram(), node.getElement(), node2.getElement());
    }

    private static boolean alwaysAllowed(Object object, Object object2) {
        return object instanceof InitialNode || object2 instanceof FinalNode || object instanceof ControlNode && !BridgeHelper.isSynchBar((ActivityNode)((ControlNode)object)) || object2 instanceof ControlNode && !BridgeHelper.isSynchBar((ActivityNode)((ControlNode)object2));
    }

    public static String checkDelete(Edge edge) {
        View view = edge.getSource();
        View view2 = edge.getTarget();
        if (view2 != null) {
            Diagram diagram = view2.getDiagram();
            switch (DiagramHelper.getDiagramType(diagram)) {
                case 0: {
                    ArrayList<ActivityNode> arrayList;
                    EObject eObject = view.getElement();
                    EObject eObject2 = view2.getElement();
                    if (DiagramCoreValidation.alwaysAllowed(eObject, eObject2)) {
                        return null;
                    }
                    if (eObject instanceof ActivityNode && BridgeHelper.getMethodElement(eObject) == null) {
                        arrayList = new ArrayList<ActivityNode>();
                        BridgeHelper.getSourceNodes(arrayList, (ActivityNode)eObject, WorkBreakdownElement.class);
                        if (arrayList.isEmpty()) {
                            return null;
                        }
                    }
                    if (BridgeHelper.isReadOnly(view2)) {
                        return errMsg_CanNotDelete;
                    }
                    if (eObject2 instanceof ActivityNode) {
                        arrayList = new ArrayList();
                        BridgeHelper.getSuccessorNodes(arrayList, (ActivityNode)eObject2);
                        for (ActivityNode activityNode : arrayList) {
                            View view3 = BridgeHelper.getView((View)diagram, activityNode);
                            if (view3 == null || !BridgeHelper.isReadOnly(view3)) continue;
                            return errMsg_CanNotDelete;
                        }
                    }
                    if (eObject2 instanceof ActivityNode && BridgeHelper.isSynchBar((ActivityNode)eObject2)) {
                        return DiagramCoreValidation.checkSyncBarOutgoingLinks((ActivityNode)eObject2);
                    }
                    return null;
                }
                case 2: {
                    return errMsg_CanNotDelete;
                }
                case 1: {
                    if (BridgeHelper.isReadOnly(view2)) {
                        return errMsg_CanNotDelete;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public static boolean isReadOnly(Edge edge) {
        View view = edge.getTarget();
        View view2 = edge.getSource();
        if (view != null && view.getDiagram().getElement() instanceof ActivityDetailDiagram) {
            EObject eObject;
            if (view2 != null && (eObject = view2.getElement()) != null && eObject instanceof TaskNode && ((TaskNode)eObject).isReadOnly()) {
                return true;
            }
            return view != null && (eObject = view.getElement()) != null && eObject instanceof TaskNode && ((TaskNode)eObject).isReadOnly();
        }
        return DiagramCoreValidation.checkDelete(edge) != null;
    }

    public static boolean isDuplicateRelationship(EObject eObject, EObject eObject2) {
        EObject eObject3 = eObject.eContainer();
        if (eObject3 instanceof Activity) {
            Activity activity = (Activity)eObject3;
            EList eList = activity.getEdges();
            for (ActivityEdge activityEdge : eList) {
                if (activityEdge.getSource() != eObject || activityEdge.getTarget() != eObject2) continue;
                return true;
            }
        }
        return false;
    }
}

