/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.services.PublishHTMLOptions;
import org.eclipse.epf.publishing.services.PublishingContentValidator;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.Roadmap;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.TermDefinition;

public class ProcessPublishingContentValidator
extends PublishingContentValidator {
    protected static final String CLOSURE_LOG_FILENAME = "processClosure.html";
    List closureElements = null;
    private boolean isFinalClosure = false;
    private boolean debug = PublishingPlugin.getDefault().isDebugging();
    protected PrintStream closureLog = this.getStream("processClosure.html");

    public ProcessPublishingContentValidator(String string, PublishHTMLOptions publishHTMLOptions) {
        super(string, publishHTMLOptions);
        this.beginClosureLog();
    }

    public void addClosureElements(List list) {
        if (this.closureElements == null) {
            this.closureElements = new ArrayList();
        }
        this.closureElements.addAll(list);
    }

    public void makeElementClosure() {
        this.isFinalClosure = true;
        this.endClosureLog();
        if (this.debug) {
            System.out.println("====================== Closure elements =======================");
            Iterator iterator = this.closureElements.iterator();
            while (iterator.hasNext()) {
                System.out.println(LibraryUtil.getTypeName((MethodElement)((MethodElement)iterator.next())));
            }
            System.out.println("====================== Closure elements end =======================");
        }
    }

    public boolean hasClosure() {
        return this.closureElements != null && this.closureElements.size() > 0;
    }

    public boolean inClosure(MethodElement methodElement) {
        if (methodElement == null) {
            return false;
        }
        if (!this.hasClosure()) {
            return true;
        }
        if (methodElement instanceof ContentCategory) {
            return true;
        }
        if (ConfigurationHelper.isDescriptionElement((MethodElement)methodElement)) {
            return true;
        }
        if (this.closureElements.contains(methodElement)) {
            return true;
        }
        if (!(methodElement instanceof Guidance)) {
            return false;
        }
        return methodElement instanceof Practice || methodElement instanceof Roadmap || methodElement instanceof SupportingMaterial || methodElement instanceof TermDefinition;
    }

    public boolean isDiscarded(MethodElement methodElement, Object object, MethodElement methodElement2) {
        if (methodElement == null) {
            methodElement = this.defaultTarget;
        } else if (this.defaultTarget != null && methodElement != this.defaultTarget) {
            super.logWarning("Target mismatch" + LibraryUtil.getTypeName((MethodElement)methodElement) + "<--->" + LibraryUtil.getTypeName((MethodElement)this.defaultTarget));
        }
        if (super.isDiscarded(methodElement, object, methodElement2)) {
            return true;
        }
        boolean bl = this.inClosure(methodElement2);
        if (!bl && !this.isFinalClosure) {
            boolean bl2 = bl = this.inClosure(methodElement) && methodElement2 instanceof Guidance;
        }
        return !bl;
    }

    public void dispose() {
        if (this.closureElements != null) {
            this.closureElements.clear();
        }
        if (this.closureLog != null) {
            this.closureLog.close();
            this.closureLog = null;
        }
        super.dispose();
    }

    private void beginClosureLog() {
        this.closureLog.println("<table>");
        this.addLogEntry("<b>Element</b>", "<b>Referenced By</b>");
    }

    private void endClosureLog() {
        this.closureLog.println("</table>");
    }

    private void addLogEntry(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<tr><td>").append(string).append("</td><td>").append(string2).append("</td></tr>");
        this.closureLog.println(stringBuffer);
    }

    public void logReference(MethodElement methodElement, MethodElement methodElement2) {
        super.logReference(methodElement, methodElement2);
        if (methodElement2 instanceof Descriptor) {
            return;
        }
        if (!this.isFinalClosure && this.closureLog != null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (methodElement instanceof BreakdownElement) {
                stringBuffer.append(this.getBreakdownElementLabel((BreakdownElement)methodElement));
            } else if (methodElement != null) {
                stringBuffer.append(LibraryUtil.getTypeName((MethodElement)methodElement));
            }
            this.addLogEntry(LibraryUtil.getTypeName((MethodElement)methodElement2), stringBuffer.toString());
        }
    }

    private StringBuffer getBreakdownElementLabel(BreakdownElement breakdownElement) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LibraryUtil.getTypeName((MethodElement)breakdownElement));
        while ((breakdownElement = breakdownElement.getSuperActivities()) != null) {
            stringBuffer.insert(0, String.valueOf(LibraryUtil.getTypeName((MethodElement)breakdownElement)) + "/");
        }
        return stringBuffer;
    }
}

