/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.eclipse.epf.publishing.services.PublishOptions;

public class PublishHTMLOptions
extends PublishOptions {
    protected String title;
    protected String aboutHTML;
    protected String feedbackURL;
    protected boolean publishGlossary;
    protected boolean publishIndex;
    protected String bannerImage;
    protected int bannerImageHeight = 67;
    protected boolean checkExternalLinks;
    protected boolean convertBrokenLinks;
    protected boolean publishJavaScriptTree = true;
    protected boolean publishDynamicWebApp;
    protected String dynamicWebAppName;
    protected boolean includeServletSearch;
    protected String defaultActivityTab = "WBS";

    public PublishHTMLOptions() {
    }

    public PublishHTMLOptions(PublishOptions publishOptions) {
        this.publishDir = publishOptions.getPublishDir();
        this.processes = publishOptions.getProcesses();
        this.publishConfiguration = publishOptions.isPublishConfiguration();
        this.publishProcess = publishOptions.isPublishProcess();
        this.publishUnopenADD = publishOptions.isPublishUnopenADD();
        this.publishBaseAD = publishOptions.isPublishBaseAD();
        this.publishLightWeightTree = publishOptions.isPublishLightWeightTree();
        this.publishEmptyCategories = publishOptions.isPublishEmptyCategories();
        this.showMethodContentInDescriptors = publishOptions.isShowMethodContentInDescriptors();
        this.showRelatedDescriptors = publishOptions.isShowRelatedDescriptors();
        this.showDescriptorsInNavigationTree = publishOptions.isShowDescriptorsInNavigationTree();
        this.publishEmptyCategories = publishOptions.isPublishEmptyCategories();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getAboutHTML() {
        return this.aboutHTML;
    }

    public void setAboutHTML(String string) {
        this.aboutHTML = string;
    }

    public String getFeedbackURL() {
        return this.feedbackURL;
    }

    public void setFeedbackURL(String string) {
        this.feedbackURL = string;
    }

    public boolean isPublishGlossary() {
        return this.publishGlossary;
    }

    public void setPublishGlossary(boolean bl) {
        this.publishGlossary = bl;
    }

    public boolean isPublishIndex() {
        return this.publishIndex;
    }

    public void setPublishIndex(boolean bl) {
        this.publishIndex = bl;
    }

    public String getBannerImage() {
        return this.bannerImage;
    }

    public void setBannerImage(String string) {
        this.bannerImage = string;
        BufferedImage bufferedImage = null;
        File file = new File(this.bannerImage);
        if (file.exists()) {
            try {
                int n;
                bufferedImage = ImageIO.read(file);
                if (bufferedImage != null && (n = ((Image)bufferedImage).getHeight(null)) > 0) {
                    this.bannerImageHeight = n;
                }
            }
            catch (Exception exception) {}
        }
    }

    public int getBannerImageHeight() {
        return this.bannerImageHeight;
    }

    public void setBannerImageHeight(int n) {
        this.bannerImageHeight = n;
    }

    public boolean isCheckExternalLinks() {
        return this.checkExternalLinks;
    }

    public void setCheckExternalLinks(boolean bl) {
        this.checkExternalLinks = bl;
    }

    public boolean isConvertBrokenLinks() {
        return this.convertBrokenLinks;
    }

    public void setConvertBrokenLinks(boolean bl) {
        this.convertBrokenLinks = bl;
    }

    public boolean isPublishJavaScriptTree() {
        return this.publishJavaScriptTree;
    }

    public void setPublishJavaScriptTree(boolean bl) {
        this.publishJavaScriptTree = bl;
    }

    public boolean isPublishDynamicWebApp() {
        return this.publishDynamicWebApp && this.dynamicWebAppName != null && this.dynamicWebAppName.length() > 0;
    }

    public void setPublishDynamicWebApp(boolean bl) {
        this.publishDynamicWebApp = bl;
    }

    public String getDynamicWebAppName() {
        return this.dynamicWebAppName;
    }

    public void setDynamicWebAppName(String string) {
        this.dynamicWebAppName = string;
    }

    public boolean isIncludeServletSearch() {
        return this.includeServletSearch && this.isPublishDynamicWebApp();
    }

    public void setIncludeServletSearch(boolean bl) {
        this.includeServletSearch = bl;
    }

    public String getDefaultActivityTab() {
        return this.defaultActivityTab;
    }

    public void setDefaultActivityTab(String string) {
        this.defaultActivityTab = string;
    }

    public void validate() {
        super.validate();
    }
}

