/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.dialogs.FilteredPreferenceDialog;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceDialog;

public final class PreferencesUtil {
    private static void applyOptions(Object data, String[] displayedIds, FilteredPreferenceDialog dialog) {
        if (data != null) {
            dialog.setPageData(data);
            IPreferencePage page = dialog.getCurrentPage();
            if (page instanceof PreferencePage) {
                ((PreferencePage)page).applyData(data);
            }
        }
        if (displayedIds != null) {
            dialog.showOnly(displayedIds);
        }
    }

    public static final PreferenceDialog createPreferenceDialogOn(Shell shell, String preferencePageId, String[] displayedIds, Object data) {
        WorkbenchPreferenceDialog dialog = WorkbenchPreferenceDialog.createDialogOn(shell, preferencePageId);
        PreferencesUtil.applyOptions(data, displayedIds, dialog);
        return dialog;
    }

    public static final PreferenceDialog createPropertyDialogOn(Shell shell, IAdaptable element, String propertyPageId, String[] displayedIds, Object data) {
        PropertyDialog dialog = PropertyDialog.createDialogOn(shell, propertyPageId, element);
        if (dialog == null) {
            return null;
        }
        PreferencesUtil.applyOptions(data, displayedIds, dialog);
        return dialog;
    }
}

